/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rd.ide.document;

import com.intellij.openapi.editor.CaretModel;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.editor.ScrollingModel;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.VirtualFileSystem;
import com.intellij.util.PathUtil;
import com.jetbrains.rd.ide.model.DocumentExtension;
import com.jetbrains.rd.ide.model.RdAbstractDocumentId;
import com.jetbrains.rd.ide.model.RdDocumentId;
import com.jetbrains.rd.ide.model.RdDocumentIdWithFileId;
import com.jetbrains.rd.ide.model.RdDocumentModel;
import com.jetbrains.rd.ide.model.RdFileDocumentId;
import com.jetbrains.rd.ide.model.RdFileDocumentIdImpl;
import com.jetbrains.rd.ide.model.RdFileId;
import com.jetbrains.rd.ide.model.RdFileIdOld;
import com.jetbrains.rd.ide.vfs.IProtocolVirtualFile;
import java.awt.Rectangle;
import java.io.File;
import java.nio.file.Path;
import java.nio.file.Paths;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=2, d1={"\u0000J\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\u001a\u0013\u0010\u0000\u001a\u00020\u00012\u000b\u0010\u0002\u001a\u00070\u0003\u00a2\u0006\u0002\b\u0004\u001a\u001a\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\b\b\u0002\u0010\t\u001a\u00020\bH\u0007\u001a\f\u0010\u0005\u001a\u00020\u0006*\u00020\nH\u0007\u001a\u0016\u0010\u0005\u001a\u00020\u0006*\u00020\u000b2\b\b\u0002\u0010\t\u001a\u00020\bH\u0007\u001a\n\u0010\f\u001a\u00020\b*\u00020\r\u001a)\u0010\u000e\u001a\u0002H\u000f\"\n\b\u0000\u0010\u000f*\u0004\u0018\u00010\u0010*\u00020\u00112\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u0002H\u000f0\u0013\u00a2\u0006\u0002\u0010\u0014\u001a\n\u0010\u0015\u001a\u00020\u0016*\u00020\r\u001a\n\u0010\u0017\u001a\u00020\b*\u00020\r\u001a\u0011\u0010\u0018\u001a\u00070\b\u00a2\u0006\u0002\b\u0004*\u00020\u0006H\u0007\u00a8\u0006\u0019"}, d2={"adjustScrollPosition", "", "editor", "Lcom/intellij/openapi/editor/Editor;", "Lorg/jetbrains/annotations/NotNull;", "createDocumentId", "Lcom/jetbrains/rd/ide/model/RdFileDocumentId;", "path", "", "protocol", "Lcom/intellij/openapi/vfs/VirtualFile;", "Ljava/io/File;", "createLogCategory", "Lcom/jetbrains/rd/ide/model/RdDocumentId;", "getExtension", "T", "Lcom/jetbrains/rd/ide/model/DocumentExtension;", "Lcom/jetbrains/rd/ide/model/RdDocumentModel;", "key", "Lcom/intellij/openapi/util/Key;", "(Lcom/jetbrains/rd/ide/model/RdDocumentModel;Lcom/intellij/openapi/util/Key;)Lcom/jetbrains/rd/ide/model/DocumentExtension;", "isLocalFile", "", "toDebugString", "url", "intellij.rd.platform"})
public final class DocumentExKt {
    public static final <T extends DocumentExtension> T getExtension(@NotNull RdDocumentModel $this$getExtension, @NotNull Key<T> key) {
        Object v0;
        block1: {
            Intrinsics.checkNotNullParameter((Object)$this$getExtension, (String)"$this$getExtension");
            Intrinsics.checkNotNullParameter(key, (String)"key");
            Iterable $this$firstOrNull$iv = $this$getExtension.getExtensions();
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                DocumentExtension it = (DocumentExtension)element$iv;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getKey(), (Object)key.toString())) continue;
                v0 = element$iv;
                break block1;
            }
            v0 = null;
        }
        return (T)((DocumentExtension)v0);
    }

    @NotNull
    public static final String toDebugString(@NotNull RdDocumentId $this$toDebugString) {
        String string;
        Intrinsics.checkNotNullParameter((Object)$this$toDebugString, (String)"$this$toDebugString");
        RdDocumentId rdDocumentId = $this$toDebugString;
        if (rdDocumentId instanceof RdFileDocumentId) {
            StringBuilder stringBuilder = new StringBuilder().append(((RdFileDocumentId)$this$toDebugString).getProtocol()).append(", ");
            Path path = Paths.get(((RdFileDocumentId)$this$toDebugString).getFilePath(), new String[0]);
            Intrinsics.checkNotNullExpressionValue((Object)path, (String)"Paths.get(filePath)");
            string = stringBuilder.append(path.getFileName()).toString();
        } else {
            string = rdDocumentId instanceof RdAbstractDocumentId ? ((RdAbstractDocumentId)$this$toDebugString).getDescriptor() : $this$toDebugString.toString();
        }
        return string;
    }

    @Deprecated(message="Use RdFileId when using identity of files")
    @NotNull
    public static final String url(@NotNull RdFileDocumentId $this$url) {
        Intrinsics.checkNotNullParameter((Object)$this$url, (String)"$this$url");
        String string = VirtualFileManager.constructUrl((String)$this$url.getProtocol(), (String)$this$url.getFilePath());
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"VirtualFileManager.const\u2026ctUrl(protocol, filePath)");
        return string;
    }

    public static final boolean isLocalFile(@NotNull RdDocumentId $this$isLocalFile) {
        Intrinsics.checkNotNullParameter((Object)$this$isLocalFile, (String)"$this$isLocalFile");
        return $this$isLocalFile instanceof RdFileDocumentId && Intrinsics.areEqual((Object)((RdFileDocumentId)$this$isLocalFile).getProtocol(), (Object)"file") || $this$isLocalFile instanceof RdDocumentIdWithFileId;
    }

    @Deprecated(message="Use RdFileId when using identity of files")
    @NotNull
    public static final RdFileDocumentId createDocumentId(@NotNull VirtualFile $this$createDocumentId) {
        String string;
        Intrinsics.checkNotNullParameter((Object)$this$createDocumentId, (String)"$this$createDocumentId");
        if (!($this$createDocumentId instanceof IProtocolVirtualFile)) {
            string = VirtualFileManager.extractProtocol((String)$this$createDocumentId.getUrl());
            if (string == null) {
                VirtualFileSystem virtualFileSystem = $this$createDocumentId.getFileSystem();
                Intrinsics.checkNotNullExpressionValue((Object)virtualFileSystem, (String)"fileSystem");
                string = virtualFileSystem.getProtocol();
            }
        } else {
            RdFileId rdFileId = ((IProtocolVirtualFile)$this$createDocumentId).getFileId();
            if (rdFileId == null) {
                throw new NullPointerException("null cannot be cast to non-null type com.jetbrains.rd.ide.model.RdFileIdOld");
            }
            string = ((RdFileIdOld)rdFileId).getProtocol();
        }
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"if (this !is IProtocolVi\u2026RdFileIdOld).protocol\n  }");
        String protocol = string;
        String string2 = VirtualFileManager.extractPath((String)$this$createDocumentId.getUrl());
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"VirtualFileManager.extractPath(url)");
        String path = string2;
        return DocumentExKt.createDocumentId(path, protocol);
    }

    @Deprecated(message="Use RdFileId when using identity of files")
    @NotNull
    public static final RdFileDocumentId createDocumentId(@NotNull File $this$createDocumentId, @NotNull String protocol) {
        Intrinsics.checkNotNullParameter((Object)$this$createDocumentId, (String)"$this$createDocumentId");
        Intrinsics.checkNotNullParameter((Object)protocol, (String)"protocol");
        String string = $this$createDocumentId.getPath();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"path");
        return DocumentExKt.createDocumentId(string, protocol);
    }

    public static /* synthetic */ RdFileDocumentId createDocumentId$default(File file, String string, int n, Object object) {
        if ((n & 1) != 0) {
            string = "file";
        }
        return DocumentExKt.createDocumentId(file, string);
    }

    @Deprecated(message="Use RdFileId when using identity of files")
    @NotNull
    public static final RdFileDocumentId createDocumentId(@NotNull String path, @NotNull String protocol) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Intrinsics.checkNotNullParameter((Object)protocol, (String)"protocol");
        return (RdFileDocumentId)new RdFileDocumentIdImpl(path, protocol);
    }

    public static /* synthetic */ RdFileDocumentId createDocumentId$default(String string, String string2, int n, Object object) {
        if ((n & 2) != 0) {
            string2 = "file";
        }
        return DocumentExKt.createDocumentId(string, string2);
    }

    @NotNull
    public static final String createLogCategory(@NotNull RdDocumentId $this$createLogCategory) {
        String string;
        Intrinsics.checkNotNullParameter((Object)$this$createLogCategory, (String)"$this$createLogCategory");
        RdDocumentId rdDocumentId = $this$createLogCategory;
        if (rdDocumentId instanceof RdFileDocumentId) {
            String string2 = PathUtil.getFileName((String)((RdFileDocumentId)$this$createLogCategory).getFilePath());
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"PathUtil.getFileName(filePath)");
            string = StringsKt.replace$default((String)string2, (char)'.', (char)'\u00b7', (boolean)false, (int)4, null);
        } else {
            string = rdDocumentId instanceof RdAbstractDocumentId ? ((RdAbstractDocumentId)$this$createLogCategory).getDescriptor() : $this$createLogCategory.toString();
        }
        return string;
    }

    public static final void adjustScrollPosition(@NotNull Editor editor) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        ScrollingModel scrollingModel = editor.getScrollingModel();
        Intrinsics.checkNotNullExpressionValue((Object)scrollingModel, (String)"editor.scrollingModel");
        Rectangle rectangle = scrollingModel.getVisibleArea();
        Intrinsics.checkNotNullExpressionValue((Object)rectangle, (String)"editor.scrollingModel.visibleArea");
        Rectangle visibleArea = rectangle;
        CaretModel caretModel = editor.getCaretModel();
        Intrinsics.checkNotNullExpressionValue((Object)caretModel, (String)"editor.caretModel");
        int caretY = editor.visualLineToY(caretModel.getVisualPosition().line);
        if (visibleArea.height > 0 && (caretY + editor.getLineHeight() <= visibleArea.y || caretY >= visibleArea.y + visibleArea.height)) {
            editor.getScrollingModel().scrollToCaret(ScrollType.CENTER);
        }
    }
}

