/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rd.ide;

import com.intellij.openapi.diagnostic.Logger;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.markers.KMappedMarker;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000<\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000f\n\u0000\n\u0002\u0010\u001c\n\u0002\u0010&\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010(\n\u0000\n\u0002\u0010\u0002\n\u0002\b\n\u0018\u0000 #*\u000e\b\u0000\u0010\u0001*\b\u0012\u0004\u0012\u0002H\u00010\u0002*\u0004\b\u0001\u0010\u00032\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u0002H\u0001\u0012\u0004\u0012\u0002H\u00030\u00050\u0004:\u0001#B\u0015\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00028\u0000\u00a2\u0006\u0002\u0010\tJ\u0013\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00028\u0000\u00a2\u0006\u0002\u0010\u0014J\u0015\u0010\u0015\u001a\u0004\u0018\u00018\u00012\u0006\u0010\u0013\u001a\u00028\u0000\u00a2\u0006\u0002\u0010\u0016J\u001b\u0010\u0017\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u00050\u0018H\u0096\u0002J\u001b\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u0013\u001a\u00028\u00002\u0006\u0010\u001b\u001a\u00028\u0001\u00a2\u0006\u0002\u0010\u001cJ\u0013\u0010\u001d\u001a\u00020\u001a2\u0006\u0010\u001e\u001a\u00028\u0000\u00a2\u0006\u0002\u0010\u001fJ\u0015\u0010 \u001a\u00020\u001a2\u0006\u0010\r\u001a\u00028\u0000H\u0002\u00a2\u0006\u0002\u0010\u001fJ\u0013\u0010!\u001a\u00020\u001a2\u0006\u0010\"\u001a\u00028\u0000\u00a2\u0006\u0002\u0010\u001fR\u001a\u0010\n\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\r\u001a\u00028\u00002\u0006\u0010\f\u001a\u00028\u0000@BX\u0086\u000e\u00a2\u0006\n\n\u0002\u0010\u0010\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006$"}, d2={"Lcom/jetbrains/rd/ide/Log;", "TVersion", "", "TValue", "", "", "id", "", "initialLastVersion", "(Ljava/lang/String;Ljava/lang/Comparable;)V", "history", "Ljava/util/TreeMap;", "<set-?>", "lastKnownVersion", "getLastKnownVersion", "()Ljava/lang/Comparable;", "Ljava/lang/Comparable;", "contains", "", "version", "(Ljava/lang/Comparable;)Z", "getValue", "(Ljava/lang/Comparable;)Ljava/lang/Object;", "iterator", "", "put", "", "change", "(Ljava/lang/Comparable;Ljava/lang/Object;)V", "rollbackHistoryToVersion", "v", "(Ljava/lang/Comparable;)V", "shrinkHistory", "updateLastKnownVersion", "newVersion", "Companion", "intellij.rd.platform"})
public final class Log<TVersion extends Comparable<? super TVersion>, TValue>
implements Iterable<Map.Entry<? extends TVersion, ? extends TValue>>,
KMappedMarker {
    private final TreeMap<TVersion, TValue> history;
    @NotNull
    private TVersion lastKnownVersion;
    private final String id;
    private static final Logger logger;
    @NotNull
    public static final Companion Companion;

    @NotNull
    public final TVersion getLastKnownVersion() {
        return this.lastKnownVersion;
    }

    public final void updateLastKnownVersion(@NotNull TVersion newVersion) {
        Intrinsics.checkNotNullParameter(newVersion, (String)"newVersion");
        if (this.lastKnownVersion.compareTo(newVersion) < 0) {
            this.lastKnownVersion = newVersion;
            this.shrinkHistory(newVersion);
        }
    }

    public final boolean contains(@NotNull TVersion version) {
        Intrinsics.checkNotNullParameter(version, (String)"version");
        Map map = this.history;
        boolean bl = false;
        Map map2 = map;
        boolean bl2 = false;
        return map2.containsKey(version);
    }

    @Nullable
    public final TValue getValue(@NotNull TVersion version) {
        Intrinsics.checkNotNullParameter(version, (String)"version");
        return this.history.get(version);
    }

    public final void put(@NotNull TVersion version, TValue change) {
        Intrinsics.checkNotNullParameter(version, (String)"version");
        boolean bl = !this.history.containsKey(version);
        boolean bl2 = false;
        boolean bl3 = false;
        if (!bl) {
            boolean bl4 = false;
            String string = "Log " + this.id + " already contains change on " + version;
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        ((Map)this.history).put(version, change);
    }

    private final void shrinkHistory(TVersion lastKnownVersion) {
        Iterator<TVersion> it = this.history.keySet().iterator();
        int removedEntries = 0;
        while (it.hasNext()) {
            TVersion TVersion = it.next();
            Intrinsics.checkNotNullExpressionValue(TVersion, (String)"it.next()");
            Comparable version = (Comparable)TVersion;
            if (version.compareTo(lastKnownVersion) >= 0) break;
            it.remove();
            int n = removedEntries;
            removedEntries = n + 1;
        }
        Logger $this$trace$iv = logger;
        boolean $i$f$trace = false;
        if ($this$trace$iv.isTraceEnabled()) {
            Logger logger = $this$trace$iv;
            boolean bl = false;
            String string = "Log " + this.id + " was shrunk to " + lastKnownVersion + " version; removed entries: " + removedEntries + ", new size: " + this.history.size();
            logger.trace(string);
        }
    }

    public final void rollbackHistoryToVersion(@NotNull TVersion v) {
        Comparable version;
        Intrinsics.checkNotNullParameter(v, (String)"v");
        Iterator<TVersion> iterator = this.history.descendingKeySet().iterator();
        Intrinsics.checkNotNullExpressionValue(iterator, (String)"history.descendingKeySet().iterator()");
        Iterator<TVersion> it = iterator;
        int removedEntries = 0;
        while (it.hasNext() && (version = (Comparable)it.next()).compareTo(v) > 0) {
            it.remove();
            int n = removedEntries;
            removedEntries = n + 1;
        }
        Logger $this$trace$iv = logger;
        boolean $i$f$trace = false;
        if ($this$trace$iv.isTraceEnabled()) {
            Logger logger = $this$trace$iv;
            boolean bl = false;
            String string = "Log " + this.id + " rollback history to " + v + "; removed entries: " + removedEntries + ", new size: " + this.history.size();
            logger.trace(string);
        }
    }

    @Override
    @NotNull
    public Iterator<Map.Entry<TVersion, TValue>> iterator() {
        Map map = this.history;
        boolean bl = false;
        return map.entrySet().iterator();
    }

    public Log(@NotNull String id, @NotNull TVersion initialLastVersion) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Intrinsics.checkNotNullParameter(initialLastVersion, (String)"initialLastVersion");
        this.id = id;
        this.history = new TreeMap();
        this.lastKnownVersion = initialLastVersion;
    }

    static {
        Companion = new Companion(null);
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(Log.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"Logger.getInstance(T::class.java)");
        Log.logger = logger;
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0013\u0010\u0003\u001a\u00070\u0004\u00a2\u0006\u0002\b\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/jetbrains/rd/ide/Log$Companion;", "", "()V", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "intellij.rd.platform"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

