/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.wsl;

import com.intellij.execution.wsl.WSLUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.remote.CredentialsType;
import com.intellij.remote.ext.CredentialsEditor;
import com.intellij.remote.ext.CredentialsLanguageContribution;
import com.intellij.remote.ext.RemoteCredentialsHandler;
import com.intellij.remote.ui.BundleAccessor;
import com.intellij.remote.ui.CredentialsEditorProvider;
import com.intellij.remote.ui.RemoteSdkEditorForm;
import com.intellij.wsl.WSLCredentialsContribution;
import com.intellij.wsl.WSLCredentialsEditor;
import com.intellij.wsl.WSLCredentialsHandler;
import com.intellij.wsl.WSLCredentialsHolder;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class WSLCredentialsType
extends CredentialsType<WSLCredentialsHolder>
implements CredentialsEditorProvider {
    @NonNls
    public static final String WSL_CREDENTIALS_PREFIX = "wsl://";
    @NlsSafe
    static final String WSL_CREDENTIALS_NAME = "WSL";
    private static final Key<WSLCredentialsHolder> WSL_CREDENTIALS_KEY = Key.create((String)"WSL_CREDENTIALS_HOLDER");

    public WSLCredentialsType() {
        super(WSL_CREDENTIALS_NAME, WSL_CREDENTIALS_PREFIX);
    }

    public Key<WSLCredentialsHolder> getCredentialsKey() {
        return WSL_CREDENTIALS_KEY;
    }

    public RemoteCredentialsHandler getHandler(WSLCredentialsHolder credentials) {
        return new WSLCredentialsHandler(credentials);
    }

    public WSLCredentialsHolder createCredentials() {
        return new WSLCredentialsHolder();
    }

    public boolean isAvailable(CredentialsLanguageContribution languageContribution) {
        return languageContribution instanceof WSLCredentialsContribution && WSLUtil.isSystemCompatible();
    }

    public CredentialsEditor createEditor(@Nullable Project project, CredentialsLanguageContribution languageContribution, @NotNull RemoteSdkEditorForm parentForm) {
        if (parentForm == null) {
            WSLCredentialsType.$$$reportNull$$$0(0);
        }
        return new WSLCredentialsEditor();
    }

    public String getDefaultInterpreterPath(BundleAccessor bundleAccessor) {
        return bundleAccessor.message("remote.interpreter.wsl.default.interpreter.path", new Object[0]);
    }

    public int getWeight() {
        return 50;
    }

    public static WSLCredentialsType getInstance() {
        return (WSLCredentialsType)((Object)CredentialsType.EP_NAME.findExtension(WSLCredentialsType.class));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parentForm", "com/intellij/wsl/WSLCredentialsType", "createEditor"));
    }
}

