/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.wsl;

import com.intellij.execution.wsl.WSLDistribution;
import com.intellij.execution.wsl.ui.WslDistributionComboBox;
import com.intellij.ide.IdeBundle;
import com.intellij.openapi.ui.ValidationInfo;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.remote.RemoteSdkAdditionalData;
import com.intellij.remote.ext.CredentialsEditor;
import com.intellij.ui.PanelWithAnchor;
import com.intellij.ui.components.JBLabel;
import com.intellij.util.ui.FormBuilder;
import com.intellij.wsl.WSLBundle;
import com.intellij.wsl.WSLCredentialsHolder;
import java.awt.Component;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class WSLCredentialsEditor
implements CredentialsEditor<WSLCredentialsHolder>,
PanelWithAnchor {
    private final WslDistributionComboBox myComboBox = new WslDistributionComboBox(null, true);
    private final JPanel myPanel;
    private final JBLabel myLabel = new JBLabel(IdeBundle.message((String)"wsl.linux.distribution.label", (Object[])new Object[0]));
    @Nullable
    private JComponent myAnchor;

    public WSLCredentialsEditor() {
        this.myLabel.setLabelFor((Component)this.myComboBox);
        this.myPanel = FormBuilder.createFormBuilder().addLabeledComponent((JComponent)this.myLabel, (JComponent)this.myComboBox).getPanel();
    }

    @NotNull
    @NlsContexts.Label
    public String getName() {
        return "WSL";
    }

    public JPanel getMainPanel() {
        return this.myPanel;
    }

    public void onSelected() {
    }

    public ValidationInfo validate() {
        if (!this.myComboBox.isSelectedValid()) {
            return new ValidationInfo(WSLBundle.message("dialog.message.please.select.distribution", new Object[0]), (JComponent)this.myComboBox);
        }
        return null;
    }

    @NlsContexts.DialogMessage
    public String validateFinal(@NotNull Supplier<? extends RemoteSdkAdditionalData<?>> supplier, @NotNull Consumer<String> helpersPathUpdateCallback) {
        if (supplier == null) {
            WSLCredentialsEditor.$$$reportNull$$$0(0);
        }
        if (helpersPathUpdateCallback == null) {
            WSLCredentialsEditor.$$$reportNull$$$0(1);
        }
        return null;
    }

    public void saveCredentials(WSLCredentialsHolder credentials) {
        WSLDistribution selectedItem = this.getWslDistribution();
        if (selectedItem == null) {
            throw new RuntimeException("Saving invalid credentials");
        }
        credentials.setDistributionId(selectedItem.getMsId());
    }

    @Nullable
    public WSLDistribution getWslDistribution() {
        return this.myComboBox.getSelected();
    }

    public void init(WSLCredentialsHolder credentials) {
        this.myComboBox.setSelected(credentials.getDistribution());
    }

    @Nullable
    public JComponent getAnchor() {
        return this.myAnchor;
    }

    public void setAnchor(@Nullable JComponent anchor) {
        this.myAnchor = anchor;
        this.myLabel.setAnchor(anchor);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "supplier";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "helpersPathUpdateCallback";
                break;
            }
        }
        objectArray[1] = "com/intellij/wsl/WSLCredentialsEditor";
        objectArray[2] = "validateFinal";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

