/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.docker.remote.run.target.prepare;

import com.intellij.docker.agent.DockerAgentApplication;
import com.intellij.docker.agent.progress.DockerResponseItem;
import com.intellij.docker.agent.progress.TtySink;
import com.intellij.docker.i18n.DockerBundle;
import com.intellij.docker.pull.DockerRedirectToTerminal;
import com.intellij.docker.remote.run.target.configuration.wizard.DockerTargetIntrospectable;
import com.intellij.docker.remoteRunRuntime.RemoteDockerRuntime;
import com.intellij.execution.target.LanguageRuntimeConfiguration;
import com.intellij.execution.target.LanguageRuntimeConfigurationKt;
import com.intellij.execution.target.LanguageRuntimeType;
import com.intellij.remoteServer.util.ServerRuntimeException;
import java.util.List;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.function.BiConsumer;
import java.util.function.Function;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b \u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J$\u0010\t\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u000b0\n2\b\u0010\f\u001a\u0004\u0018\u00010\u000b2\b\u0010\r\u001a\u0004\u0018\u00010\u000eH\u0002J\u0018\u0010\u000f\u001a\u0004\u0018\u00010\u000b2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u0011H$J\u0018\u0010\u0013\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u000b0\n2\b\u0010\r\u001a\u0004\u0018\u00010\u000eJ\u0014\u0010\u0014\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00160\u00150\nH$J\u0012\u0010\u0017\u001a\u00020\u00182\b\b\u0001\u0010\u0019\u001a\u00020\u001aH\u0004R\u0014\u0010\u0002\u001a\u00020\u0003X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lcom/intellij/docker/remote/run/target/prepare/PrepareImageOperation;", "", "docker", "Lcom/intellij/docker/remoteRunRuntime/RemoteDockerRuntime;", "ttySink", "Lcom/intellij/docker/agent/progress/TtySink;", "(Lcom/intellij/docker/remoteRunRuntime/RemoteDockerRuntime;Lcom/intellij/docker/agent/progress/TtySink;)V", "getDocker", "()Lcom/intellij/docker/remoteRunRuntime/RemoteDockerRuntime;", "introspect", "Ljava/util/concurrent/CompletableFuture;", "Lcom/intellij/docker/agent/DockerAgentApplication;", "image", "languageRuntime", "Lcom/intellij/execution/target/LanguageRuntimeConfiguration;", "onChannelFinished", "auxDetails", "", "Lcom/intellij/docker/agent/progress/DockerResponseItem$AuxDetail;", "perform", "prepareChannel", "Ljava/util/concurrent/BlockingQueue;", "", "println", "", "text", "", "intellij.clouds.docker.remoteRun"})
public abstract class PrepareImageOperation {
    @NotNull
    private final RemoteDockerRuntime docker;
    private final TtySink ttySink;

    @NotNull
    public final CompletableFuture<DockerAgentApplication> perform(@Nullable LanguageRuntimeConfiguration languageRuntime) {
        CompletableFuture<BlockingQueue<byte[]>> channelPromise = this.prepareChannel();
        CompletableFuture auxDetailsPromise = new DockerRedirectToTerminal(this.ttySink).redirectToTerminalLater(channelPromise);
        CompletionStage completionStage = ((CompletableFuture)auxDetailsPromise.thenApply(new Function<List<? extends DockerResponseItem.AuxDetail>, DockerAgentApplication>(this){
            final /* synthetic */ PrepareImageOperation this$0;

            @Nullable
            public final DockerAgentApplication apply(List<? extends DockerResponseItem.AuxDetail> auxDetails) {
                try {
                    List<? extends DockerResponseItem.AuxDetail> list = auxDetails;
                    Intrinsics.checkNotNullExpressionValue(list, (String)"auxDetails");
                    DockerAgentApplication image = this.this$0.onChannelFinished(list);
                    if (image == null) {
                        String string = DockerBundle.message((String)"PrepareImageOperation.unable.to.find.an.image.for.introspection", (Object[])new Object[0]);
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"DockerBundle.message(\"Pr\u2026image.for.introspection\")");
                        this.this$0.println(string);
                    }
                    return image;
                }
                catch (ServerRuntimeException e) {
                    String string = DockerBundle.message((String)"PrepareImageOperation.failed.to.find.image.for.introspection", (Object[])new Object[]{e.getMessage()});
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"DockerBundle.message(\"Pr\u2026ntrospection\", e.message)");
                    this.this$0.println(string);
                    return null;
                }
            }
            {
                this.this$0 = prepareImageOperation;
            }
        })).thenCompose(new Function<DockerAgentApplication, CompletionStage<DockerAgentApplication>>(this, languageRuntime){
            final /* synthetic */ PrepareImageOperation this$0;
            final /* synthetic */ LanguageRuntimeConfiguration $languageRuntime;

            public final CompletionStage<DockerAgentApplication> apply(@Nullable DockerAgentApplication image) {
                return PrepareImageOperation.access$introspect(this.this$0, image, this.$languageRuntime);
            }
            {
                this.this$0 = prepareImageOperation;
                this.$languageRuntime = languageRuntimeConfiguration;
            }
        });
        Intrinsics.checkNotNullExpressionValue((Object)completionStage, (String)"auxDetailsPromise\n      \u2026image, languageRuntime) }");
        return completionStage;
    }

    protected final void println(@Nls @NotNull String text) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        this.ttySink.ttyPrintln(text);
    }

    private final CompletableFuture<DockerAgentApplication> introspect(DockerAgentApplication image, LanguageRuntimeConfiguration languageRuntime) {
        CompletableFuture<DockerAgentApplication> withoutIntrospection = CompletableFuture.completedFuture(image);
        if (image == null) {
            CompletableFuture<DockerAgentApplication> completableFuture = withoutIntrospection;
            Intrinsics.checkNotNullExpressionValue(completableFuture, (String)"withoutIntrospection");
            return completableFuture;
        }
        LanguageRuntimeConfiguration languageRuntimeConfiguration = languageRuntime;
        if (languageRuntimeConfiguration == null || (languageRuntimeConfiguration = LanguageRuntimeConfigurationKt.getRuntimeType((LanguageRuntimeConfiguration)languageRuntimeConfiguration)) == null || (languageRuntimeConfiguration = languageRuntimeConfiguration.createIntrospector(languageRuntime)) == null) {
            CompletableFuture<DockerAgentApplication> completableFuture = withoutIntrospection;
            Intrinsics.checkNotNullExpressionValue(completableFuture, (String)"withoutIntrospection");
            return completableFuture;
        }
        LanguageRuntimeConfiguration introspector = languageRuntimeConfiguration;
        DockerTargetIntrospectable introspectable = new DockerTargetIntrospectable(this.docker, image, this.ttySink);
        CompletionStage completionStage = ((CompletableFuture)introspector.introspect((LanguageRuntimeType.Introspectable)introspectable).thenApply(new Function<LanguageRuntimeConfiguration, DockerAgentApplication>(image){
            final /* synthetic */ DockerAgentApplication $image;

            public final DockerAgentApplication apply(LanguageRuntimeConfiguration it) {
                return this.$image;
            }
            {
                this.$image = dockerAgentApplication;
            }
        })).whenComplete(new BiConsumer<DockerAgentApplication, Throwable>(this, introspectable){
            final /* synthetic */ PrepareImageOperation this$0;
            final /* synthetic */ DockerTargetIntrospectable $introspectable;

            public final void accept(@Nullable Object $noName_0, @Nullable Throwable err) {
                if (err == null) {
                    String string = DockerBundle.message((String)"PrepareImageOperation.introspection.completed", (Object[])new Object[0]);
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"DockerBundle.message(\"Pr\u2026introspection.completed\")");
                    this.this$0.println(string);
                } else {
                    String string = DockerBundle.message((String)"PrepareImageOperation.introspection.completed.with.error", (Object[])new Object[]{err.getMessage()});
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"DockerBundle.message(\"Pr\u2026with.error\", err.message)");
                    this.this$0.println(string);
                }
                this.$introspectable.shutdown();
            }
            {
                this.this$0 = prepareImageOperation;
                this.$introspectable = dockerTargetIntrospectable;
            }
        });
        Intrinsics.checkNotNullExpressionValue((Object)completionStage, (String)"introspector.introspect(\u2026ctable.shutdown()\n      }");
        return completionStage;
    }

    @NotNull
    protected abstract CompletableFuture<BlockingQueue<byte[]>> prepareChannel();

    @Nullable
    protected abstract DockerAgentApplication onChannelFinished(@NotNull List<? extends DockerResponseItem.AuxDetail> var1) throws ServerRuntimeException;

    @NotNull
    protected final RemoteDockerRuntime getDocker() {
        return this.docker;
    }

    public PrepareImageOperation(@NotNull RemoteDockerRuntime docker, @NotNull TtySink ttySink) {
        Intrinsics.checkNotNullParameter((Object)docker, (String)"docker");
        Intrinsics.checkNotNullParameter((Object)ttySink, (String)"ttySink");
        this.docker = docker;
        this.ttySink = ttySink;
    }

    public static final /* synthetic */ CompletableFuture access$introspect(PrepareImageOperation $this, DockerAgentApplication image, LanguageRuntimeConfiguration languageRuntime) {
        return $this.introspect(image, languageRuntime);
    }
}

