/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.docker.remote.run.target;

import com.intellij.docker.agent.settings.DockerPortBinding;
import com.intellij.docker.agent.settings.DockerPortBindingImpl;
import com.intellij.docker.agent.settings.DockerVolumeBinding;
import com.intellij.docker.agent.settings.DockerVolumeBindingImpl;
import com.intellij.docker.i18n.DockerBundle;
import com.intellij.docker.remote.run.runtime.UnixPathUtil;
import com.intellij.docker.remote.run.target.configuration.DockerTargetEnvironmentConfiguration;
import com.intellij.execution.Platform;
import com.intellij.execution.target.BaseTargetEnvironmentRequest;
import com.intellij.execution.target.HostPort;
import com.intellij.execution.target.TargetEnvironment;
import com.intellij.execution.target.TargetEnvironmentAwareRunProfileState;
import com.intellij.execution.target.TargetEnvironmentRequest;
import com.intellij.execution.target.TargetPlatform;
import com.intellij.execution.target.value.DeferredLocalTargetValue;
import com.intellij.execution.target.value.DeferredTargetValue;
import com.intellij.execution.target.value.TargetValue;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.UUID;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeoutException;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.AsyncPromise;
import org.jetbrains.concurrency.Promise;

public final class DockerRemoteRequest
extends BaseTargetEnvironmentRequest {
    private final DockerTargetEnvironmentConfiguration myTargetConfiguration;
    private final TargetPlatform myTargetPlatform;
    private final Map<Integer, BoundPortValue> myPortsMap;
    private final Map<Integer, LocalPortTargetValue> myLocalPortsMap;
    private final Map<String, DockerTargetVolume> myVolumes;
    private String myVolumesRoot;
    private TargetEnvironmentRequest.Volume myDefaultVolume;

    public DockerRemoteRequest(DockerTargetEnvironmentConfiguration config, TargetPlatform platform) {
        this.myPortsMap = new TreeMap<Integer, BoundPortValue>();
        this.myLocalPortsMap = new HashMap<Integer, LocalPortTargetValue>();
        this.myVolumes = new HashMap<String, DockerTargetVolume>();
        this.myTargetConfiguration = config;
        this.myTargetPlatform = platform;
    }

    private DockerRemoteRequest(DockerTargetEnvironmentConfiguration config, TargetPlatform platform, @NotNull Set<TargetEnvironment.UploadRoot> uploadVolumes, @NotNull Set<TargetEnvironment.DownloadRoot> downloadVolumes, @NotNull Set<TargetEnvironment.TargetPortBinding> targetPortBindings, @NotNull Set<TargetEnvironment.LocalPortBinding> localPortBindings) {
        if (uploadVolumes == null) {
            DockerRemoteRequest.$$$reportNull$$$0(0);
        }
        if (downloadVolumes == null) {
            DockerRemoteRequest.$$$reportNull$$$0(1);
        }
        if (targetPortBindings == null) {
            DockerRemoteRequest.$$$reportNull$$$0(2);
        }
        if (localPortBindings == null) {
            DockerRemoteRequest.$$$reportNull$$$0(3);
        }
        super(uploadVolumes, downloadVolumes, targetPortBindings, localPortBindings);
        this.myPortsMap = new TreeMap<Integer, BoundPortValue>();
        this.myLocalPortsMap = new HashMap<Integer, LocalPortTargetValue>();
        this.myVolumes = new HashMap<String, DockerTargetVolume>();
        this.myTargetConfiguration = config;
        this.myTargetPlatform = platform;
    }

    @NotNull
    public TargetEnvironmentRequest duplicate() {
        return new DockerRemoteRequest(this.myTargetConfiguration, this.myTargetPlatform, new HashSet<TargetEnvironment.UploadRoot>(this.getUploadVolumes()), new HashSet<TargetEnvironment.DownloadRoot>(this.getDownloadVolumes()), new HashSet<TargetEnvironment.TargetPortBinding>(this.getTargetPortBindings()), new HashSet<TargetEnvironment.LocalPortBinding>(this.getLocalPortBindings()));
    }

    List<DockerVolumeBinding> prepareAgentVolumes(TargetEnvironmentAwareRunProfileState.TargetProgressIndicator indicator) throws IOException {
        indicator.addSystemLine(DockerBundle.message((String)"progress.text.preparing.volumes", (Object[])new Object[0]));
        LinkedList<DockerVolumeBinding> result = new LinkedList<DockerVolumeBinding>();
        for (DockerTargetVolume next : this.myVolumes.values()) {
            result.addAll(next.setupVolumes(indicator));
        }
        return result;
    }

    @NotNull
    public TargetPlatform getTargetPlatform() {
        TargetPlatform targetPlatform = this.myTargetPlatform;
        if (targetPlatform == null) {
            DockerRemoteRequest.$$$reportNull$$$0(4);
        }
        return targetPlatform;
    }

    public DockerTargetEnvironmentConfiguration getTargetConfiguration() {
        return this.myTargetConfiguration;
    }

    @NotNull
    public TargetEnvironmentRequest.Volume createUploadRoot(@Nullable String remoteRootPath, boolean temporary) {
        String safeRemoteRootPath = this.safeRemotePath(remoteRootPath);
        DockerTargetVolume dockerTargetVolume = this.doCreateVolumeImpl(safeRemoteRootPath, temporary);
        if (dockerTargetVolume == null) {
            DockerRemoteRequest.$$$reportNull$$$0(5);
        }
        return dockerTargetVolume;
    }

    @NotNull
    public TargetEnvironmentRequest.DownloadableVolume createDownloadRoot(@Nullable String remoteRootPath) {
        DockerTargetVolume dockerTargetVolume = this.doCreateVolumeImpl(this.safeRemotePath(remoteRootPath), false);
        if (dockerTargetVolume == null) {
            DockerRemoteRequest.$$$reportNull$$$0(6);
        }
        return dockerTargetVolume;
    }

    @NotNull
    public TargetEnvironmentRequest.Volume getDefaultVolume() {
        if (this.myDefaultVolume == null) {
            this.myDefaultVolume = this.createTempVolume();
        }
        TargetEnvironmentRequest.Volume volume = this.myDefaultVolume;
        if (volume == null) {
            DockerRemoteRequest.$$$reportNull$$$0(7);
        }
        return volume;
    }

    private DockerTargetVolume doCreateVolumeImpl(@NotNull String safeRootPath, boolean temporary) {
        if (safeRootPath == null) {
            DockerRemoteRequest.$$$reportNull$$$0(8);
        }
        return this.myVolumes.computeIfAbsent(safeRootPath, root -> new DockerTargetVolume(this, (String)root, temporary));
    }

    @NotNull
    private String safeRemotePath(@Nullable String remotePath) {
        Object object = remotePath != null ? remotePath : this.getRemoteAllVolumesRoot() + "/" + (this.myVolumes.size() + 1) + "/";
        if (object == null) {
            DockerRemoteRequest.$$$reportNull$$$0(9);
        }
        return object;
    }

    @NotNull
    public TargetValue<Integer> bindTargetPort(int targetPort) {
        TargetValue targetValue = (TargetValue)this.myPortsMap.computeIfAbsent(targetPort, BoundPortValue::new);
        if (targetValue == null) {
            DockerRemoteRequest.$$$reportNull$$$0(10);
        }
        return targetValue;
    }

    @NotNull
    public TargetValue<HostPort> bindLocalPort(int localPort) {
        TargetValue targetValue = this.myLocalPortsMap.computeIfAbsent(localPort, port -> new LocalPortTargetValue((int)port));
        if (targetValue == null) {
            DockerRemoteRequest.$$$reportNull$$$0(11);
        }
        return targetValue;
    }

    public List<BoundPortValue> getRemotePortsToBind() {
        return new ArrayList<BoundPortValue>(this.myPortsMap.values());
    }

    @NotNull
    public List<LocalPortTargetValue> getLocalPortsToAccess() {
        return new ArrayList<LocalPortTargetValue>(this.myLocalPortsMap.values());
    }

    private String getRemoteAllVolumesRoot() {
        if (this.myVolumesRoot == null) {
            this.myVolumesRoot = "/tmp/" + UUID.randomUUID().toString();
        }
        return this.myVolumesRoot;
    }

    private static String resolveRemotePath(@NotNull TargetEnvironmentRequest.Volume volume, @NotNull String absolutePathToRoot, @NotNull String pathFromRoot) {
        if (volume == null) {
            DockerRemoteRequest.$$$reportNull$$$0(12);
        }
        if (absolutePathToRoot == null) {
            DockerRemoteRequest.$$$reportNull$$$0(13);
        }
        if (pathFromRoot == null) {
            DockerRemoteRequest.$$$reportNull$$$0(14);
        }
        char separator = volume.getPlatform().fileSeparator;
        return StringUtil.trimTrailing((String)absolutePathToRoot, (char)separator) + separator + pathFromRoot;
    }

    static DockerVolumeBinding safeVolumeBinding(String containerPath, String localPath) {
        return new DockerVolumeBindingImpl(containerPath, UnixPathUtil.toUnixPath(localPath), false);
    }

    private static Logger getLogger() {
        return Logger.getInstance(DockerRemoteRequest.class);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 10: 
            case 11: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 10: 
            case 11: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "uploadVolumes";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "downloadVolumes";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetPortBindings";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "localPortBindings";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 10: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/docker/remote/run/target/DockerRemoteRequest";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "safeRootPath";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "volume";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "absolutePathToRoot";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pathFromRoot";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/docker/remote/run/target/DockerRemoteRequest";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getTargetPlatform";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "createUploadRoot";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "createDownloadRoot";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultVolume";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "safeRemotePath";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "bindTargetPort";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "bindLocalPort";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 10: 
            case 11: {
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "doCreateVolumeImpl";
                break;
            }
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "resolveRemotePath";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 10: 
            case 11: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class DockerTargetVolume
    implements TargetEnvironmentRequest.DownloadableVolume {
        private final DockerRemoteRequest myMainRequest;
        private final String myRemoteRoot;
        private final String myVolumeId;
        private final boolean myIsTemporary;
        private final Map<String, UploadToTargetValue> myUploads;
        private final Map<String, DownloadFromTargetValue> myDownloads;

        DockerTargetVolume(@NotNull DockerRemoteRequest request, @NotNull String remoteRoot, boolean temporary) {
            if (request == null) {
                DockerTargetVolume.$$$reportNull$$$0(0);
            }
            if (remoteRoot == null) {
                DockerTargetVolume.$$$reportNull$$$0(1);
            }
            this.myUploads = new LinkedHashMap<String, UploadToTargetValue>();
            this.myDownloads = new LinkedHashMap<String, DownloadFromTargetValue>();
            this.myMainRequest = request;
            this.myRemoteRoot = remoteRoot;
            this.myVolumeId = remoteRoot + "@" + Integer.toHexString(System.identityHashCode(this));
            this.myIsTemporary = temporary;
        }

        boolean isTemporary() {
            return this.myIsTemporary;
        }

        @NotNull
        public String getRemoteRoot() {
            String string = this.myRemoteRoot;
            if (string == null) {
                DockerTargetVolume.$$$reportNull$$$0(2);
            }
            return string;
        }

        @NotNull
        public String getVolumeId() {
            String string = this.myVolumeId;
            if (string == null) {
                DockerTargetVolume.$$$reportNull$$$0(3);
            }
            return string;
        }

        @NotNull
        public Platform getPlatform() {
            Platform platform = this.myMainRequest.getTargetPlatform().getPlatform();
            if (platform == null) {
                DockerTargetVolume.$$$reportNull$$$0(4);
            }
            return platform;
        }

        @NotNull
        public TargetValue<String> createUpload(@NotNull String localPath) {
            if (localPath == null) {
                DockerTargetVolume.$$$reportNull$$$0(5);
            }
            TargetValue targetValue = (TargetValue)this.myUploads.computeIfAbsent(localPath, p -> UploadToTargetValue.forLocalPath((TargetEnvironmentRequest.Volume)this, p));
            if (targetValue == null) {
                DockerTargetVolume.$$$reportNull$$$0(6);
            }
            return targetValue;
        }

        @NotNull
        public TargetValue<String> createDownload(@NotNull String rootRelativePath) {
            if (rootRelativePath == null) {
                DockerTargetVolume.$$$reportNull$$$0(7);
            }
            TargetValue targetValue = (TargetValue)this.myDownloads.computeIfAbsent(rootRelativePath, p -> new DownloadFromTargetValue(this, rootRelativePath));
            if (targetValue == null) {
                DockerTargetVolume.$$$reportNull$$$0(8);
            }
            return targetValue;
        }

        public List<DockerVolumeBinding> setupVolumes(TargetEnvironmentAwareRunProfileState.TargetProgressIndicator indicator) throws IOException {
            LinkedList<DockerVolumeBinding> result = new LinkedList<DockerVolumeBinding>();
            result.addAll(this.setupUploadVolumes(indicator));
            result.addAll(this.setupDownloadVolume(indicator));
            return result;
        }

        private List<DockerVolumeBinding> setupUploadVolumes(TargetEnvironmentAwareRunProfileState.TargetProgressIndicator indicator) {
            LinkedList<DockerVolumeBinding> result = new LinkedList<DockerVolumeBinding>();
            Map<File, List<UploadToTargetValue>> groupedByContainerPoint = this.myUploads.values().stream().collect(Collectors.groupingBy(UploadToTargetValue::getContainerFolder));
            int idx = 0;
            for (Map.Entry<File, List<UploadToTargetValue>> nextEntry : groupedByContainerPoint.entrySet()) {
                String nextContainerPath;
                if (groupedByContainerPoint.size() == 1) {
                    nextContainerPath = this.myRemoteRoot;
                } else {
                    String groupRoot = DockerRemoteRequest.resolveRemotePath((TargetEnvironmentRequest.Volume)this, this.myRemoteRoot, String.valueOf(idx));
                    nextContainerPath = DockerRemoteRequest.resolveRemotePath((TargetEnvironmentRequest.Volume)this, groupRoot, nextEntry.getKey().getName());
                }
                DockerVolumeBinding agentVolume = DockerRemoteRequest.safeVolumeBinding(nextContainerPath, nextEntry.getKey().getPath());
                indicator.addSystemLine(DockerBundle.message((String)"progress.text.docker.upload.volume.progress.message", (Object[])new Object[]{agentVolume.getHostPath(), agentVolume.getContainerPath()}));
                result.add(agentVolume);
                for (UploadToTargetValue nextUpload : nextEntry.getValue()) {
                    nextUpload.agentVolumeAttached(agentVolume);
                }
                ++idx;
            }
            return result;
        }

        private List<DockerVolumeBinding> setupDownloadVolume(TargetEnvironmentAwareRunProfileState.TargetProgressIndicator indicator) throws IOException {
            Path tempLocalFolder;
            if (this.myDownloads.isEmpty()) {
                return Collections.emptyList();
            }
            try {
                tempLocalFolder = Files.createTempDirectory("dockerTargetDownload", new FileAttribute[0]);
                tempLocalFolder = tempLocalFolder.toRealPath(new LinkOption[0]);
            }
            catch (IOException e) {
                throw new IOException("Can't create temp local folder for download volume", e);
            }
            DockerVolumeBindingImpl agentVolume = new DockerVolumeBindingImpl(this.myRemoteRoot, tempLocalFolder.toString(), false);
            indicator.addSystemLine(DockerBundle.message((String)"progress.text.docker.download.volume.progress.message", (Object[])new Object[]{agentVolume.getHostPath(), agentVolume.getContainerPath()}));
            for (DownloadFromTargetValue nextDownload : this.myDownloads.values()) {
                nextDownload.agentVolumeAttached((DockerVolumeBinding)agentVolume);
            }
            return Collections.singletonList(agentVolume);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 6: 
                case 8: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 6: 
                case 8: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "request";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "remoteRoot";
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 6: 
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/docker/remote/run/target/DockerRemoteRequest$DockerTargetVolume";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "localPath";
                    break;
                }
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "rootRelativePath";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/docker/remote/run/target/DockerRemoteRequest$DockerTargetVolume";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getRemoteRoot";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getVolumeId";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getPlatform";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createUpload";
                    break;
                }
                case 8: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createDownload";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 6: 
                case 8: {
                    break;
                }
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "createUpload";
                    break;
                }
                case 7: {
                    objectArray = objectArray;
                    objectArray[2] = "createDownload";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 6: 
                case 8: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    static class LocalPortTargetValue
    implements TargetValue<HostPort> {
        private final AsyncPromise<HostPort> myPromise = new AsyncPromise();
        private final int myLocalPort;

        LocalPortTargetValue(int localPort) {
            this.myLocalPort = localPort;
        }

        int getLocalPort() {
            return this.myLocalPort;
        }

        public Promise<HostPort> getLocalValue() {
            return this.myPromise;
        }

        public Promise<HostPort> getTargetValue() {
            return this.myPromise;
        }

        void resolve(@NotNull String host) {
            if (host == null) {
                LocalPortTargetValue.$$$reportNull$$$0(0);
            }
            this.myPromise.setResult((Object)new HostPort(host, this.myLocalPort));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "host", "com/intellij/docker/remote/run/target/DockerRemoteRequest$LocalPortTargetValue", "resolve"));
        }
    }

    static class BoundPortValue
    extends DeferredLocalTargetValue<Integer> {
        private static final int NOT_BOUND = -1;

        BoundPortValue(int containerPort) {
            super((Object)containerPort);
        }

        int getContainerPort() {
            try {
                Integer port = (Integer)this.getTargetValue().blockingGet(0);
                return port != null ? port : -1;
            }
            catch (ExecutionException | TimeoutException e) {
                throw new IllegalStateException("Port has not been resolved yet", e);
            }
        }

        void localPortBound(@Nullable DockerPortBinding portBinding) {
            Integer resolvedValue;
            Integer n = resolvedValue = portBinding == null ? null : portBinding.getHostPort();
            if (resolvedValue != null) {
                super.resolve((Object)resolvedValue);
                return;
            }
            try {
                int remotePort = this.getContainerPort();
                DockerRemoteRequest.getLogger().error("Requested port " + remotePort + " is not bound by container: " + portBinding);
            }
            catch (RuntimeException e) {
                DockerRemoteRequest.getLogger().error("Remote port was not set, port binding can't be found", (Throwable)e);
            }
        }

        DockerPortBindingImpl asDockerPortBinding() {
            DockerPortBindingImpl result = new DockerPortBindingImpl();
            result.setContainerPort(this.getContainerPort());
            return result;
        }
    }

    private static class DownloadFromTargetValue
    extends DeferredLocalTargetValue<String> {
        private final String myPathFromVolume;

        DownloadFromTargetValue(@NotNull TargetEnvironmentRequest.DownloadableVolume volume, @NotNull String pathFromVolume) {
            if (volume == null) {
                DownloadFromTargetValue.$$$reportNull$$$0(0);
            }
            if (pathFromVolume == null) {
                DownloadFromTargetValue.$$$reportNull$$$0(1);
            }
            super((Object)DockerRemoteRequest.resolveRemotePath((TargetEnvironmentRequest.Volume)volume, volume.getRemoteRoot(), pathFromVolume));
            this.myPathFromVolume = pathFromVolume;
        }

        void agentVolumeAttached(@NotNull DockerVolumeBinding agentVolume) {
            if (agentVolume == null) {
                DownloadFromTargetValue.$$$reportNull$$$0(2);
            }
            String localPath = agentVolume.getHostPath() + Platform.current().fileSeparator + this.myPathFromVolume;
            super.resolve((Object)localPath);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "volume";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "pathFromVolume";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "agentVolume";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/docker/remote/run/target/DockerRemoteRequest$DownloadFromTargetValue";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "agentVolumeAttached";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static final class UploadToTargetValue
    extends DeferredTargetValue<String> {
        private final TargetEnvironmentRequest.Volume myVolume;
        private final File myLocalFile;

        static UploadToTargetValue forLocalPath(@NotNull TargetEnvironmentRequest.Volume volume, @NotNull String localPath) {
            if (volume == null) {
                UploadToTargetValue.$$$reportNull$$$0(0);
            }
            if (localPath == null) {
                UploadToTargetValue.$$$reportNull$$$0(1);
            }
            try {
                File canonicalFile = new File(FileUtil.toSystemDependentName((String)localPath)).getCanonicalFile();
                return new UploadToTargetValue(volume, canonicalFile);
            }
            catch (IOException e) {
                throw new RuntimeException("Can't resolve path: " + localPath, e);
            }
        }

        private UploadToTargetValue(@NotNull TargetEnvironmentRequest.Volume volume, @NotNull File localFile) {
            if (volume == null) {
                UploadToTargetValue.$$$reportNull$$$0(2);
            }
            if (localFile == null) {
                UploadToTargetValue.$$$reportNull$$$0(3);
            }
            super((Object)localFile.getAbsolutePath());
            this.myVolume = volume;
            this.myLocalFile = localFile;
        }

        void agentVolumeAttached(@NotNull DockerVolumeBinding agentVolume) {
            if (agentVolume == null) {
                UploadToTargetValue.$$$reportNull$$$0(4);
            }
            String pathInVolume = this.myLocalFile.isDirectory() ? "" : this.myLocalFile.getName();
            String remotePath = DockerRemoteRequest.resolveRemotePath(this.myVolume, agentVolume.getContainerPath(), pathInVolume);
            super.resolve((Object)remotePath);
        }

        @NotNull
        File getContainerFolder() {
            File file = this.myLocalFile.isDirectory() ? this.myLocalFile : this.myLocalFile.getParentFile();
            if (file == null) {
                UploadToTargetValue.$$$reportNull$$$0(5);
            }
            return file;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 5: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 5: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "volume";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "localPath";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "localFile";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "agentVolume";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/docker/remote/run/target/DockerRemoteRequest$UploadToTargetValue";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/docker/remote/run/target/DockerRemoteRequest$UploadToTargetValue";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getContainerFolder";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "forLocalPath";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "agentVolumeAttached";
                    break;
                }
                case 5: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 5: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

