/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.docker.remote.run.target;

import com.intellij.docker.DockerCloudConfiguration;
import com.intellij.docker.agent.DockerAgentApplication;
import com.intellij.docker.agent.progress.TtySink;
import com.intellij.docker.agent.settings.DockerVolumeBinding;
import com.intellij.docker.engine.DockerNetworkUtil;
import com.intellij.docker.i18n.DockerBundle;
import com.intellij.docker.remote.run.target.DockerEnvironment;
import com.intellij.docker.remote.run.target.DockerRemoteRequest;
import com.intellij.docker.remote.run.target.configuration.DockerTargetEnvironmentConfiguration;
import com.intellij.docker.remote.run.target.prepare.BuildImageOperation;
import com.intellij.docker.remote.run.target.prepare.PrepareImageOperation;
import com.intellij.docker.remote.run.target.prepare.PullImageOperation;
import com.intellij.docker.remoteRunRuntime.RemoteDockerApplicationRuntime;
import com.intellij.docker.remoteRunRuntime.RemoteDockerRuntime;
import com.intellij.execution.process.ProcessOutputType;
import com.intellij.execution.target.LanguageRuntimeConfiguration;
import com.intellij.execution.target.TargetEnvironment;
import com.intellij.execution.target.TargetEnvironmentAwareRunProfileState;
import com.intellij.execution.target.TargetEnvironmentConfiguration;
import com.intellij.execution.target.TargetEnvironmentFactory;
import com.intellij.execution.target.TargetEnvironmentRequest;
import com.intellij.execution.target.TargetPlatform;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.remoteServer.util.ServerRuntimeException;
import com.intellij.util.containers.ContainerUtil;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.Consumer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DockerEnvironmentFactory
implements TargetEnvironmentFactory {
    private final RemoteDockerRuntime myDocker;
    private final DockerTargetEnvironmentConfiguration.MyState myTargetConfiguration;
    private final DockerTargetEnvironmentConfiguration myCompleteTargetConfiguration;

    public DockerEnvironmentFactory(RemoteDockerRuntime docker, DockerTargetEnvironmentConfiguration targetConfiguration) {
        this.myDocker = docker;
        this.myCompleteTargetConfiguration = targetConfiguration;
        this.myTargetConfiguration = targetConfiguration.getValues();
    }

    public RemoteDockerRuntime getDocker() {
        return this.myDocker;
    }

    @NotNull
    public TargetEnvironment prepareRemoteEnvironment(@NotNull TargetEnvironmentRequest request, @NotNull TargetEnvironmentAwareRunProfileState.TargetProgressIndicator targetProgressIndicator) {
        DockerEnvironment dockerEnvironment;
        RemoteDockerApplicationRuntime imageRuntime;
        if (request == null) {
            DockerEnvironmentFactory.$$$reportNull$$$0(0);
        }
        if (targetProgressIndicator == null) {
            DockerEnvironmentFactory.$$$reportNull$$$0(1);
        }
        assert (request instanceof DockerRemoteRequest);
        targetProgressIndicator.addSystemLine(DockerBundle.message((String)"DockerEnvironmentFactory.progress.text.preparing.docker.target", (Object[])new Object[0]));
        WriteAction.runAndWait(() -> {
            Project project = this.myDocker.getProject();
            if (project != null) {
                PsiDocumentManager.getInstance((Project)project).commitAllDocuments();
            }
            FileDocumentManager.getInstance().saveAllDocuments();
        });
        try {
            imageRuntime = this.prepareImageRuntime(targetProgressIndicator);
        }
        catch (ServerRuntimeException e) {
            throw new RuntimeException(e);
        }
        DockerRemoteRequest requestImpl = (DockerRemoteRequest)request;
        List<DockerRemoteRequest.LocalPortTargetValue> localPorts = requestImpl.getLocalPortsToAccess();
        if (!localPorts.isEmpty()) {
            DockerCloudConfiguration dockerCloudConfiguration = imageRuntime.getDockerRuntime().getAccount();
            String hostAddress = DockerNetworkUtil.getHostAddress((DockerCloudConfiguration)dockerCloudConfiguration);
            localPorts.forEach(targetValue -> targetValue.resolve(hostAddress));
        }
        try {
            String runCliOptions = requestImpl.getTargetConfiguration().getValues().getContainerConfig().getRunCliOptions();
            List<DockerVolumeBinding> bindings = requestImpl.prepareAgentVolumes(targetProgressIndicator);
            List<DockerRemoteRequest.BoundPortValue> ports = requestImpl.getRemotePortsToBind();
            dockerEnvironment = DockerEnvironment.create(this, imageRuntime, requestImpl, runCliOptions, bindings, ports);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        if (dockerEnvironment == null) {
            DockerEnvironmentFactory.$$$reportNull$$$0(2);
        }
        return dockerEnvironment;
    }

    @NotNull
    private RemoteDockerApplicationRuntime prepareImageRuntime(@NotNull TargetEnvironmentAwareRunProfileState.TargetProgressIndicator indicator) throws ServerRuntimeException {
        String imageTagOrId;
        DockerAgentApplication agentApp;
        RemoteDockerApplicationRuntime result;
        if (indicator == null) {
            DockerEnvironmentFactory.$$$reportNull$$$0(3);
        }
        if ((result = (agentApp = this.myDocker.findImageByNameOrId(imageTagOrId = this.myTargetConfiguration.getBuildNotPull() ? this.myTargetConfiguration.getBuildImageConfig().getBuiltImageTag() : this.myTargetConfiguration.getPullImageConfig().getTagToPull())) == null || this.shouldRebuildEveryTime() ? this.forceRecreateImage(indicator) : RemoteDockerApplicationRuntime.create((RemoteDockerRuntime)this.myDocker, (DockerAgentApplication)agentApp)) == null) {
            throw new RuntimeException(DockerBundle.message((String)"DockerEnvironmentFactory.error.cant.find.image", (Object[])new Object[]{imageTagOrId}));
        }
        RemoteDockerApplicationRuntime remoteDockerApplicationRuntime = result;
        if (remoteDockerApplicationRuntime == null) {
            DockerEnvironmentFactory.$$$reportNull$$$0(4);
        }
        return remoteDockerApplicationRuntime;
    }

    @NotNull
    public TargetEnvironmentConfiguration getTargetConfiguration() {
        DockerTargetEnvironmentConfiguration dockerTargetEnvironmentConfiguration = this.myCompleteTargetConfiguration;
        if (dockerTargetEnvironmentConfiguration == null) {
            DockerEnvironmentFactory.$$$reportNull$$$0(5);
        }
        return dockerTargetEnvironmentConfiguration;
    }

    @NotNull
    public TargetPlatform getTargetPlatform() {
        TargetPlatform targetPlatform = this.myTargetConfiguration.getTargetPlatform();
        if (targetPlatform == null) {
            DockerEnvironmentFactory.$$$reportNull$$$0(6);
        }
        return targetPlatform;
    }

    @NotNull
    public TargetEnvironmentRequest createRequest() {
        return new DockerRemoteRequest(this.myCompleteTargetConfiguration, this.getTargetPlatform());
    }

    private boolean shouldRebuildEveryTime() {
        return this.myTargetConfiguration.getBuildNotPull() && this.myTargetConfiguration.getBuildImageConfig().getRebuildEveryTime();
    }

    @Nullable
    private RemoteDockerApplicationRuntime forceRecreateImage(final @NotNull TargetEnvironmentAwareRunProfileState.TargetProgressIndicator indicator) throws ServerRuntimeException {
        if (indicator == null) {
            DockerEnvironmentFactory.$$$reportNull$$$0(7);
        }
        class PrintToIndicator
        implements Consumer<String> {
            private volatile boolean myHadRecentOutput = true;

            PrintToIndicator() {
            }

            @Override
            public void accept(@NlsSafe String text) {
                text = StringUtil.trimEnd((String)text, (char)'\n');
                indicator.addText(text, (Key)ProcessOutputType.STDOUT);
                this.myHadRecentOutput = true;
            }

            public void reset() {
                this.myHadRecentOutput = false;
            }

            public boolean hasRecentOutput() {
                return this.myHadRecentOutput;
            }
        }
        PrintToIndicator printToIndicator = new PrintToIndicator();
        TtySink ttySink = TtySink.wrapNonTty((Consumer)printToIndicator);
        PrepareImageOperation preparation = this.myTargetConfiguration.getBuildNotPull() ? new BuildImageOperation(this.getProject(), this.myCompleteTargetConfiguration, this.myDocker, ttySink) : new PullImageOperation(this.myDocker, this.myTargetConfiguration.getPullImageConfig().getTagToPull(), ttySink);
        LanguageRuntimeConfiguration firstLanguage = (LanguageRuntimeConfiguration)ContainerUtil.getFirstItem((List)this.myCompleteTargetConfiguration.getRuntimes().resolvedConfigs());
        CompletableFuture<DockerAgentApplication> imagePromise = preparation.perform(firstLanguage);
        DockerAgentApplication image = null;
        while (true) {
            try {
                image = imagePromise.get(5000L, TimeUnit.SECONDS);
            }
            catch (InterruptedException | TimeoutException ignored) {
                if (!printToIndicator.hasRecentOutput()) break;
                printToIndicator.reset();
                continue;
            }
            catch (ExecutionException e) {
                throw new ServerRuntimeException((Throwable)e);
            }
            break;
        }
        return image == null ? null : RemoteDockerApplicationRuntime.create((RemoteDockerRuntime)this.myDocker, (DockerAgentApplication)image);
    }

    @NotNull
    private Project getProject() {
        Project result = this.myDocker.getProject();
        assert (result != null);
        Project project = result;
        if (project == null) {
            DockerEnvironmentFactory.$$$reportNull$$$0(8);
        }
        return project;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 8: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 8: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "request";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetProgressIndicator";
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/docker/remote/run/target/DockerEnvironmentFactory";
                break;
            }
            case 3: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indicator";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/docker/remote/run/target/DockerEnvironmentFactory";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "prepareRemoteEnvironment";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "prepareImageRuntime";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getTargetConfiguration";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getTargetPlatform";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getProject";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "prepareRemoteEnvironment";
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 8: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "prepareImageRuntime";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "forceRecreateImage";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 8: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

