/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.docker.remote.run.runtime;

import com.intellij.docker.agent.DockerAgentDeploymentConfig;
import com.intellij.docker.agent.DockerAgentSourceType;
import com.intellij.docker.agent.DockerUtil;
import com.intellij.docker.agent.settings.DockerEnvVar;
import com.intellij.docker.agent.settings.DockerEnvVarImpl;
import com.intellij.docker.agent.settings.DockerLabel;
import com.intellij.docker.agent.settings.DockerLink;
import com.intellij.docker.agent.settings.DockerPortBinding;
import com.intellij.docker.agent.settings.DockerVolumeBinding;
import com.intellij.docker.agent.settings.DockerVolumeBindingImpl;
import com.intellij.docker.agent.settings.DockerVolumesFrom;
import com.intellij.openapi.util.io.FileUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DockerAgentDeploymentConfigImpl
implements DockerAgentDeploymentConfig {
    private final String[] myImageTags;
    private DockerVolumeBinding[] myVolumesBinding;
    private String[] myCommand;
    private String myWorkingDir;
    private DockerVolumesFrom[] myVolumesFrom;
    private DockerEnvVar[] myEnvVars;
    private DockerEnvVar[] myBuildArgs;
    private String myContainerName;
    private Boolean myPublishAllPorts;
    private DockerPortBinding[] myPortBindings;
    private Integer[] myExposedPorts;
    private Boolean myNetworkDisabled;
    private String myNetworkMode;
    private DockerLink[] myLinks;
    private String[] myExtraHosts;
    private String myUser;
    private String[] myEntrypoint;
    private DockerLabel[] myLabels;
    private Boolean myStdinOnce;

    public DockerAgentDeploymentConfigImpl(@NotNull String image, DockerVolumeBinding @Nullable [] volumesBinding) {
        if (image == null) {
            DockerAgentDeploymentConfigImpl.$$$reportNull$$$0(0);
        }
        this.myImageTags = new String[]{image};
        this.withVolumeBindings(volumesBinding);
    }

    public String @NotNull [] getImageTags() {
        if (this.myImageTags == null) {
            DockerAgentDeploymentConfigImpl.$$$reportNull$$$0(1);
        }
        return this.myImageTags;
    }

    public String getContainerName() {
        return this.myContainerName;
    }

    public DockerAgentDeploymentConfigImpl withContainerName(String containerName) {
        this.myContainerName = containerName;
        return this;
    }

    public File getCustomContextFolder() {
        return null;
    }

    public String[] getCustomRunOptions() {
        return null;
    }

    public String[] getCustomBuildOptions() {
        return null;
    }

    public String sourceType() {
        return DockerAgentSourceType.IMAGE.name();
    }

    public boolean isBuildImageOnly() {
        return false;
    }

    public boolean isFileArchive() {
        return false;
    }

    public boolean isCreateContainerOnly() {
        return true;
    }

    public String getUser() {
        return this.myUser;
    }

    public DockerAgentDeploymentConfigImpl withUser(String user) {
        this.myUser = user;
        return this;
    }

    public DockerLabel[] getLabels() {
        return this.myLabels;
    }

    public DockerAgentDeploymentConfigImpl withLabels(DockerLabel[] labels) {
        this.myLabels = labels;
        return this;
    }

    public String getDeploymentName() {
        return null;
    }

    public File getFile() {
        return null;
    }

    public DockerPortBinding[] getPortBindings() {
        return this.myPortBindings;
    }

    public DockerAgentDeploymentConfigImpl withPortBindings(DockerPortBinding[] portBindings) {
        this.myPortBindings = portBindings;
        return this;
    }

    public Boolean getPublishAllPorts() {
        return this.myPublishAllPorts;
    }

    public DockerAgentDeploymentConfigImpl withPublishAllPorts(boolean publishAllPorts) {
        this.myPublishAllPorts = publishAllPorts;
        return this;
    }

    public boolean isPublishAllPorts() {
        return false;
    }

    public DockerAgentDeploymentConfigImpl withExposedPorts(Integer[] exposedPorts) {
        this.myExposedPorts = exposedPorts;
        return this;
    }

    public Integer[] getExposedPorts() {
        return this.myExposedPorts;
    }

    public DockerLink[] getLinks() {
        return this.myLinks;
    }

    public DockerAgentDeploymentConfigImpl withLinks(List<? extends DockerLink> links) {
        this.myLinks = links.toArray(new DockerLink[0]);
        return this;
    }

    public DockerVolumeBinding[] getVolumeBindings() {
        return this.myVolumesBinding;
    }

    public DockerAgentDeploymentConfigImpl withVolumeBindings(DockerVolumeBinding[] volumesBinding) {
        this.myVolumesBinding = (DockerVolumeBinding[])DockerUtil.mapArray((Object[])volumesBinding, DockerVolumeBinding.class, source -> {
            DockerVolumeBindingImpl result = new DockerVolumeBindingImpl(source);
            if (source.getHostPath() != null) {
                result.setHostPath(FileUtil.toSystemDependentName((String)source.getHostPath()));
            }
            return result;
        });
        return this;
    }

    public DockerEnvVar[] getEnvVars() {
        return this.myEnvVars;
    }

    public DockerEnvVar[] getBuildArgs() {
        return this.myBuildArgs;
    }

    private static DockerEnvVar @NotNull [] createEnvArray(@NotNull Map<String, String> env, boolean passParentEnvironment) {
        if (env == null) {
            DockerAgentDeploymentConfigImpl.$$$reportNull$$$0(2);
        }
        ArrayList<DockerEnvVarImpl> result = new ArrayList<DockerEnvVarImpl>();
        for (Map.Entry<String, String> entry : env.entrySet()) {
            Object value = entry.getValue();
            if (value == null) continue;
            String key = entry.getKey();
            if (passParentEnvironment && "PATH".equalsIgnoreCase(key)) {
                value = (String)value + ":$PATH";
            }
            DockerEnvVarImpl envVar = new DockerEnvVarImpl();
            envVar.setName(key);
            envVar.setValue((String)value);
            result.add(envVar);
        }
        DockerEnvVar[] dockerEnvVarArray = result.toArray(new DockerEnvVar[0]);
        if (dockerEnvVarArray == null) {
            DockerAgentDeploymentConfigImpl.$$$reportNull$$$0(3);
        }
        return dockerEnvVarArray;
    }

    public DockerAgentDeploymentConfigImpl withEnvs(Map<String, String> envs) {
        this.myEnvVars = DockerAgentDeploymentConfigImpl.createEnvArray(envs, true);
        return this;
    }

    public DockerAgentDeploymentConfigImpl withEnvs(DockerEnvVar @Nullable [] envVars) {
        this.myEnvVars = envVars;
        return this;
    }

    public DockerAgentDeploymentConfigImpl withBuildArgs(Map<String, String> buildArgs) {
        this.myBuildArgs = DockerAgentDeploymentConfigImpl.createEnvArray(buildArgs == null ? Collections.emptyMap() : buildArgs, false);
        return this;
    }

    public DockerAgentDeploymentConfigImpl withBuildArgs(DockerEnvVar @Nullable [] buildArgs) {
        this.myBuildArgs = buildArgs;
        return this;
    }

    public String[] getEntrypoint() {
        return this.myEntrypoint;
    }

    public DockerAgentDeploymentConfigImpl withEntrypoint(String ... entrypoint) {
        this.myEntrypoint = entrypoint;
        return this;
    }

    public String[] getCommand() {
        return this.myCommand;
    }

    public DockerAgentDeploymentConfigImpl withCommand(String ... command) {
        this.myCommand = command;
        return this;
    }

    public String getWorkingDir() {
        return this.myWorkingDir;
    }

    public DockerAgentDeploymentConfigImpl withWorkingDir(String workingDir) {
        this.myWorkingDir = workingDir;
        return this;
    }

    public DockerVolumesFrom[] getVolumesFrom() {
        return this.myVolumesFrom;
    }

    public DockerAgentDeploymentConfigImpl withVolumesFrom(DockerVolumesFrom ... volumesFrom) {
        this.myVolumesFrom = volumesFrom;
        return this;
    }

    public Boolean getNetworkDisabled() {
        return this.myNetworkDisabled;
    }

    public DockerAgentDeploymentConfigImpl withNetworkDisabled(boolean networkDisabled) {
        this.myNetworkDisabled = networkDisabled;
        return this;
    }

    public String getNetworkMode() {
        return this.myNetworkMode;
    }

    public DockerAgentDeploymentConfigImpl withNetworkMode(String networkMode) {
        this.myNetworkMode = networkMode;
        return this;
    }

    public String[] getExtraHosts() {
        return this.myExtraHosts;
    }

    public DockerAgentDeploymentConfigImpl withExtraHosts(String[] extraHosts) {
        this.myExtraHosts = extraHosts;
        return this;
    }

    public Boolean getStdinOnce() {
        return this.myStdinOnce;
    }

    public DockerAgentDeploymentConfigImpl withStdinOnce(Boolean stdinOnce) {
        this.myStdinOnce = stdinOnce;
        return this;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "image";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/docker/remote/run/runtime/DockerAgentDeploymentConfigImpl";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "env";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/docker/remote/run/runtime/DockerAgentDeploymentConfigImpl";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getImageTags";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "createEnvArray";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 3: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "createEnvArray";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

