/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.docker.remote.run.common;

import com.intellij.docker.agent.DockerUtil;
import com.intellij.docker.agent.settings.DockerEnvVar;
import com.intellij.docker.agent.settings.DockerEnvVarImpl;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

public final class EnvsBuilder {
    private static final String PATH_ENV = "PATH";
    @NotNull
    private final Map<String, String> myEnvsMap = new LinkedHashMap<String, String>();
    private boolean myPassParentEnvironment;

    private EnvsBuilder() {
    }

    @NotNull
    public static EnvsBuilder builder() {
        return new EnvsBuilder();
    }

    @NotNull
    public EnvsBuilder addEnvs(@NotNull List<DockerEnvVarImpl> vars) {
        if (vars == null) {
            EnvsBuilder.$$$reportNull$$$0(0);
        }
        for (DockerEnvVarImpl var : vars) {
            this.myEnvsMap.put(var.getName(), var.getValue());
        }
        EnvsBuilder envsBuilder = this;
        if (envsBuilder == null) {
            EnvsBuilder.$$$reportNull$$$0(1);
        }
        return envsBuilder;
    }

    @NotNull
    public EnvsBuilder addEnvs(@NotNull Map<String, String> env) {
        if (env == null) {
            EnvsBuilder.$$$reportNull$$$0(2);
        }
        this.myEnvsMap.putAll(env);
        EnvsBuilder envsBuilder = this;
        if (envsBuilder == null) {
            EnvsBuilder.$$$reportNull$$$0(3);
        }
        return envsBuilder;
    }

    @NotNull
    public EnvsBuilder addEnv(@NotNull String key, @NotNull String value) {
        if (key == null) {
            EnvsBuilder.$$$reportNull$$$0(4);
        }
        if (value == null) {
            EnvsBuilder.$$$reportNull$$$0(5);
        }
        this.myEnvsMap.put(key, value);
        EnvsBuilder envsBuilder = this;
        if (envsBuilder == null) {
            EnvsBuilder.$$$reportNull$$$0(6);
        }
        return envsBuilder;
    }

    private static void addEnv(@NotNull List<DockerEnvVar> envVars, @Nullable String name, @Nullable String value) {
        if (envVars == null) {
            EnvsBuilder.$$$reportNull$$$0(7);
        }
        if (name != null) {
            DockerEnvVarImpl envVar = new DockerEnvVarImpl();
            envVar.setName(name);
            envVar.setValue(value);
            envVars.add((DockerEnvVar)envVar);
        }
    }

    @NotNull
    public EnvsBuilder withPassParentEnvironment(boolean passParentEnvironment) {
        this.myPassParentEnvironment = passParentEnvironment;
        EnvsBuilder envsBuilder = this;
        if (envsBuilder == null) {
            EnvsBuilder.$$$reportNull$$$0(8);
        }
        return envsBuilder;
    }

    @TestOnly
    public String @NotNull [] build() {
        String[] stringArray = (String[])DockerUtil.mapArray((Object[])this.buildEnvs(), String.class, source -> source.getName() + "=" + source.getValue());
        if (stringArray == null) {
            EnvsBuilder.$$$reportNull$$$0(9);
        }
        return stringArray;
    }

    public DockerEnvVar[] buildEnvs() {
        ArrayList<DockerEnvVar> result = new ArrayList<DockerEnvVar>();
        for (Map.Entry<String, String> entry : this.myEnvsMap.entrySet()) {
            if (this.myPassParentEnvironment && PATH_ENV.equalsIgnoreCase(entry.getKey())) {
                if (entry.getValue() == null) continue;
                EnvsBuilder.addEnv(result, entry.getKey(), entry.getValue() + ":$PATH");
                continue;
            }
            EnvsBuilder.addEnv(result, entry.getKey(), entry.getValue());
        }
        return result.toArray(new DockerEnvVar[0]);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 3: 
            case 6: 
            case 8: 
            case 9: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 3: 
            case 6: 
            case 8: 
            case 9: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "vars";
                break;
            }
            case 1: 
            case 3: 
            case 6: 
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/docker/remote/run/common/EnvsBuilder";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "env";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "envVars";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/docker/remote/run/common/EnvsBuilder";
                break;
            }
            case 1: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "addEnvs";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "addEnv";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "withPassParentEnvironment";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "build";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "addEnvs";
                break;
            }
            case 1: 
            case 3: 
            case 6: 
            case 8: 
            case 9: {
                break;
            }
            case 4: 
            case 5: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "addEnv";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 3: 
            case 6: 
            case 8: 
            case 9: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

