/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.docker.remote.compose.process;

import com.google.common.net.HostAndPort;
import com.intellij.docker.compose.cli.DockerComposeCliCmd;
import com.intellij.docker.compose.cli.DockerComposeCliCommands;
import com.intellij.docker.compose.cli.DockerComposeCliParser;
import com.intellij.docker.compose.cli.DockerComposeCliSubCmd;
import com.intellij.docker.compose.cli.DockerComposeExecCmd;
import com.intellij.docker.compose.cli.DockerComposeRunCmd;
import com.intellij.docker.compose.cli.DockerComposeUpCmd;
import com.intellij.docker.compose.configuration.beans.common.DockerComposePort;
import com.intellij.docker.compose.service.DockerComposeServiceClient;
import com.intellij.docker.compose.service.commands.AbstractServiceCmd;
import com.intellij.docker.compose.service.commands.ComposeServiceExecCmd;
import com.intellij.docker.compose.service.commands.ComposeServiceRunCmd;
import com.intellij.docker.i18n.DockerBundle;
import com.intellij.docker.remote.compose.run.configuration.DockerComposeSettings;
import com.intellij.docker.remoteRunRuntime.RemoteDockerApplicationRuntime;
import com.intellij.docker.remoteRunRuntime.RemoteDockerRuntime;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.remote.RemoteProcess;
import com.intellij.remote.RemoteSdkException;
import com.intellij.remoteServer.util.ServerRuntimeException;
import com.intellij.util.execution.ParametersListUtil;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.jvm.JvmName;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=2, d1={"\u0000T\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u000e\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005\u001a*\u0010\u0006\u001a\u0006\u0012\u0002\b\u00030\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u00052\u000e\u0010\u000b\u001a\n\u0012\u0004\u0012\u00020\r\u0018\u00010\f\u001a\u000e\u0010\u000e\u001a\u00020\u00052\u0006\u0010\u000f\u001a\u00020\u0010\u001a\u0016\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016\u001a\u0010\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0007\u001a\u0016\u0010\u001b\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"CONTAINER_CHECK_INTERVAL_IN_MILLIS", "", "assertDebugIsAvailable", "", "dockerComposeCliCmd", "Lcom/intellij/docker/compose/cli/DockerComposeCliCmd;", "createComposeServiceCmd", "Lcom/intellij/docker/compose/service/commands/AbstractServiceCmd;", "serviceClient", "Lcom/intellij/docker/compose/service/DockerComposeServiceClient;", "command", "publishPorts", "", "Lcom/intellij/docker/compose/configuration/beans/common/DockerComposePort;", "getComposeCommandOptions", "commandLine", "Lcom/intellij/execution/configurations/GeneralCommandLine;", "getDockerComposeContainer", "Lcom/intellij/docker/remoteRunRuntime/RemoteDockerApplicationRuntime;", "dockerRuntime", "Lcom/intellij/docker/remoteRunRuntime/RemoteDockerRuntime;", "containerName", "", "toRemoteProcess", "Lcom/intellij/remote/RemoteProcess;", "process", "Ljava/lang/Process;", "waitForContainer", "intellij.clouds.docker.remoteRun"})
@JvmName(name="DockerComposeProcessUtil")
public final class DockerComposeProcessUtil {
    private static final long CONTAINER_CHECK_INTERVAL_IN_MILLIS = 500L;

    @Deprecated(message="Temporary transition method in supporting `docker-compose` local execution")
    @NotNull
    public static final RemoteProcess toRemoteProcess(@NotNull Process process2) {
        Intrinsics.checkNotNullParameter((Object)process2, (String)"process");
        return new RemoteProcess(process2){
            final /* synthetic */ Process $process;

            public void destroy() {
                this.$process.destroy();
            }

            public int exitValue() {
                return this.$process.exitValue();
            }

            public boolean isDisconnected() {
                return !this.$process.isAlive();
            }

            public int waitFor() {
                return this.$process.waitFor();
            }

            @Nullable
            public HostAndPort getLocalTunnel(int remotePort) {
                return HostAndPort.fromParts((String)"localhost", (int)remotePort);
            }

            @NotNull
            public OutputStream getOutputStream() {
                OutputStream outputStream = this.$process.getOutputStream();
                Intrinsics.checkNotNullExpressionValue((Object)outputStream, (String)"process.outputStream");
                return outputStream;
            }

            @NotNull
            public InputStream getErrorStream() {
                InputStream inputStream = this.$process.getErrorStream();
                Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)"process.errorStream");
                return inputStream;
            }

            @NotNull
            public InputStream getInputStream() {
                InputStream inputStream = this.$process.getInputStream();
                Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)"process.inputStream");
                return inputStream;
            }

            public boolean killProcessTree() {
                this.$process.destroy();
                return true;
            }
            {
                this.$process = $captured_local_variable$0;
            }
        };
    }

    @NotNull
    public static final RemoteDockerApplicationRuntime getDockerComposeContainer(@NotNull RemoteDockerRuntime dockerRuntime2, @NotNull String containerName) throws ServerRuntimeException, RemoteSdkException {
        Intrinsics.checkNotNullParameter((Object)dockerRuntime2, (String)"dockerRuntime");
        Intrinsics.checkNotNullParameter((Object)containerName, (String)"containerName");
        RemoteDockerApplicationRuntime serviceApplicationRuntime = dockerRuntime2.findContainerByName(containerName);
        if (serviceApplicationRuntime == null) {
            throw (Throwable)new RemoteSdkException(DockerBundle.message((String)"DockerComposeProcessUtil.error.container.not.found", (Object[])new Object[]{containerName}));
        }
        return serviceApplicationRuntime;
    }

    @NotNull
    public static final RemoteDockerApplicationRuntime waitForContainer(@NotNull RemoteDockerRuntime dockerRuntime2, @NotNull String containerName) throws ServerRuntimeException, InterruptedException {
        Intrinsics.checkNotNullParameter((Object)dockerRuntime2, (String)"dockerRuntime");
        Intrinsics.checkNotNullParameter((Object)containerName, (String)"containerName");
        RemoteDockerApplicationRuntime container;
        while ((container = dockerRuntime2.findContainerByName(containerName)) == null) {
            Thread.sleep(500L);
        }
        return container;
    }

    @NotNull
    public static final AbstractServiceCmd<?> createComposeServiceCmd(@NotNull DockerComposeServiceClient serviceClient, @NotNull DockerComposeCliCmd command, @Nullable List<DockerComposePort> publishPorts) {
        Intrinsics.checkNotNullParameter((Object)serviceClient, (String)"serviceClient");
        Intrinsics.checkNotNullParameter((Object)command, (String)"command");
        DockerComposeCliSubCmd dockerComposeCliSubCmd = command.getSubCmd();
        if (dockerComposeCliSubCmd == null) {
            AbstractServiceCmd abstractServiceCmd = serviceClient.upServicesCmd().withPorts(publishPorts);
            Intrinsics.checkNotNullExpressionValue((Object)abstractServiceCmd, (String)"serviceClient.upServices\u2026).withPorts(publishPorts)");
            return abstractServiceCmd;
        }
        DockerComposeCliSubCmd subCmd = dockerComposeCliSubCmd;
        AbstractServiceCmd abstractServiceCmd = ((AbstractServiceCmd)subCmd.accept(new DockerComposeCliSubCmd.Visitor<AbstractServiceCmd<?>>(serviceClient, publishPorts){
            final /* synthetic */ DockerComposeServiceClient $serviceClient;
            final /* synthetic */ List $publishPorts;

            @NotNull
            public AbstractServiceCmd<?> visit(@NotNull DockerComposeUpCmd upCmd) {
                Intrinsics.checkNotNullParameter((Object)upCmd, (String)"upCmd");
                AbstractServiceCmd abstractServiceCmd = this.$serviceClient.upServicesCmd().withServiceNames(upCmd.getServiceList()).withPorts(this.$publishPorts);
                Intrinsics.checkNotNullExpressionValue((Object)abstractServiceCmd, (String)"serviceClient.upServices\u2026 .withPorts(publishPorts)");
                return abstractServiceCmd;
            }

            @NotNull
            public AbstractServiceCmd<?> visit(@NotNull DockerComposeRunCmd runCmd) {
                Intrinsics.checkNotNullParameter((Object)runCmd, (String)"runCmd");
                ComposeServiceRunCmd composeServiceRunCmd = this.$serviceClient.runServiceCmd().withPublishPorts(this.$publishPorts);
                Intrinsics.checkNotNullExpressionValue((Object)composeServiceRunCmd, (String)"serviceClient.runService\u2026ublishPorts(publishPorts)");
                return (AbstractServiceCmd)composeServiceRunCmd;
            }

            @NotNull
            public AbstractServiceCmd<?> visit(@NotNull DockerComposeExecCmd execCmd) {
                Intrinsics.checkNotNullParameter((Object)execCmd, (String)"execCmd");
                ComposeServiceExecCmd composeServiceExecCmd = this.$serviceClient.execServiceCmd();
                Intrinsics.checkNotNullExpressionValue((Object)composeServiceExecCmd, (String)"serviceClient.execServiceCmd()");
                return (AbstractServiceCmd)composeServiceExecCmd;
            }
            {
                this.$serviceClient = $captured_local_variable$0;
                this.$publishPorts = $captured_local_variable$1;
            }
        })).withSubcommandOptions(DockerComposeCliCommands.getSubcommandLineOptions((DockerComposeCliSubCmd)subCmd));
        Intrinsics.checkNotNullExpressionValue((Object)abstractServiceCmd, (String)"subCmd.accept(object : D\u2026tSubcommandLineOptions())");
        return abstractServiceCmd;
    }

    @NotNull
    public static final DockerComposeCliCmd getComposeCommandOptions(@NotNull GeneralCommandLine commandLine) {
        Intrinsics.checkNotNullParameter((Object)commandLine, (String)"commandLine");
        DockerComposeSettings dockerComposeSettings = (DockerComposeSettings)commandLine.getUserData(DockerComposeSettings.KEY);
        if (dockerComposeSettings == null) {
            dockerComposeSettings = new DockerComposeSettings();
        }
        Intrinsics.checkNotNullExpressionValue((Object)dockerComposeSettings, (String)"commandLine.getUserData(\u2026: DockerComposeSettings()");
        DockerComposeSettings dockerComposeSettings2 = dockerComposeSettings;
        DockerComposeCliParser dockerComposeCliParser = new DockerComposeCliParser();
        String[] stringArray = ParametersListUtil.parseToArray((String)dockerComposeSettings2.getCommandLine());
        Intrinsics.checkNotNullExpressionValue((Object)stringArray, (String)"ParametersListUtil.parse\u2026poseSettings.commandLine)");
        return dockerComposeCliParser.parse(stringArray);
    }

    public static final void assertDebugIsAvailable(@NotNull DockerComposeCliCmd dockerComposeCliCmd) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)dockerComposeCliCmd, (String)"dockerComposeCliCmd");
            DockerComposeCliSubCmd dockerComposeCliSubCmd = dockerComposeCliCmd.getSubCmd();
            if (dockerComposeCliSubCmd == null) break block0;
            dockerComposeCliSubCmd.accept((DockerComposeCliSubCmd.Visitor)new DockerComposeCliSubCmd.Visitor<Object>(){

                @Nullable
                public Object visit(@NotNull DockerComposeUpCmd upCmd) {
                    Intrinsics.checkNotNullParameter((Object)upCmd, (String)"upCmd");
                    return null;
                }

                @Nullable
                public Object visit(@NotNull DockerComposeRunCmd runCmd) {
                    Intrinsics.checkNotNullParameter((Object)runCmd, (String)"runCmd");
                    return null;
                }

                @Nullable
                public Object visit(@NotNull DockerComposeExecCmd execCmd) {
                    Intrinsics.checkNotNullParameter((Object)execCmd, (String)"execCmd");
                    throw (Throwable)new RuntimeException("Debug is not available for Docker Compose `exec` command");
                }
            });
        }
    }
}

