/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.docker.remote.compose;

import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.LoadingCache;
import com.intellij.docker.DockerCloudConfiguration;
import com.intellij.docker.DockerSettings;
import com.intellij.docker.compose.cli.DockerComposeCli;
import com.intellij.docker.compose.configuration.util.DockerComposeConfigurationUtil;
import com.intellij.docker.remoteRunRuntime.RemoteDockerApplicationRuntime;
import com.intellij.execution.process.ProcessOutput;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.progress.util.AbstractProgressIndicatorExBase;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.wm.ex.ProgressIndicatorEx;
import com.intellij.remoteServer.util.ServerRuntimeException;
import com.intellij.util.concurrency.BlockingSet;
import java.io.IOException;
import java.nio.file.Path;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.NotNull;

@Service(value={Service.Level.APP})
public final class DockerComposeProjectService {
    private static final Logger LOG = Logger.getInstance(DockerComposeProjectService.class);
    private static final String DEFAULT_DOCKER_COMPOSE_VERSION = "1.11.2";
    private final BlockingSet<String> myBusyDockerComposeProjects = BlockingSet.newInstance();
    private final LoadingCache<String, String> myDockerComposeVersionsCache = Caffeine.newBuilder().refreshAfterWrite(30L, TimeUnit.SECONDS).build(key -> {
        ProgressIndicator indicator = ProgressManager.getInstance().getProgressIndicator();
        try {
            return DockerComposeCli.INSTANCE.getVersion(key, indicator);
        }
        catch (Exception e) {
            DockerComposeProjectService.logDockerComposeVersionException(key, e);
            return DEFAULT_DOCKER_COMPOSE_VERSION;
        }
    });

    @NotNull
    public ProcessOutput runDockerComposeContainer(final @NotNull Path configurationPath, final @NotNull RemoteDockerApplicationRuntime applicationRuntime, @NotNull @NlsContexts.DialogTitle String taskTitle) throws InterruptedException, ServerRuntimeException, IOException {
        if (configurationPath == null) {
            DockerComposeProjectService.$$$reportNull$$$0(0);
        }
        if (applicationRuntime == null) {
            DockerComposeProjectService.$$$reportNull$$$0(1);
        }
        if (taskTitle == null) {
            DockerComposeProjectService.$$$reportNull$$$0(2);
        }
        final Ref dockerComposeProcessOutputRef = Ref.create();
        final Ref exceptionRef = Ref.create();
        Task.Modal task = new Task.Modal(null, taskTitle, true){

            public void run(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    1.$$$reportNull$$$0(0);
                }
                final Thread currentThread = Thread.currentThread();
                if (indicator instanceof ProgressIndicatorEx) {
                    ((ProgressIndicatorEx)indicator).addStateDelegate((ProgressIndicatorEx)new AbstractProgressIndicatorExBase(){

                        public void cancel() {
                            currentThread.interrupt();
                        }
                    });
                }
                try {
                    dockerComposeProcessOutputRef.set((Object)DockerComposeProjectService.this.runDockerComposeContainer(configurationPath, applicationRuntime));
                }
                catch (ServerRuntimeException | IOException | InterruptedException e) {
                    exceptionRef.set((Object)e);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/docker/remote/compose/DockerComposeProjectService$1", "run"));
            }
        };
        if (ProgressManager.getInstance().hasProgressIndicator()) {
            task.run(ProgressManager.getInstance().getProgressIndicator());
        } else {
            ApplicationManager.getApplication().invokeAndWait(() -> ProgressManager.getInstance().run((Task)task), ModalityState.any());
        }
        if (!exceptionRef.isNull()) {
            Exception exception = (Exception)exceptionRef.get();
            if (exception instanceof InterruptedException) {
                throw (InterruptedException)exception;
            }
            if (exception instanceof ServerRuntimeException) {
                throw (ServerRuntimeException)((Object)exception);
            }
            if (exception instanceof IOException) {
                throw (IOException)exception;
            }
        }
        ProcessOutput processOutput = (ProcessOutput)dockerComposeProcessOutputRef.get();
        if (processOutput == null) {
            DockerComposeProjectService.$$$reportNull$$$0(3);
        }
        return processOutput;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    private ProcessOutput runDockerComposeContainer(@NotNull Path configurationPath, RemoteDockerApplicationRuntime applicationRuntime) throws InterruptedException, ServerRuntimeException, IOException {
        if (configurationPath == null) {
            DockerComposeProjectService.$$$reportNull$$$0(4);
        }
        String projectName = DockerComposeConfigurationUtil.getDockerComposeProjectName((Path)configurationPath);
        this.myBusyDockerComposeProjects.put((Object)projectName);
        ProcessOutput processOutput = applicationRuntime.startAndGetOutput();
        ProcessOutput processOutput2 = processOutput;
        if (processOutput2 == null) {
            DockerComposeProjectService.$$$reportNull$$$0(5);
        }
        return processOutput2;
        finally {
            this.myBusyDockerComposeProjects.remove((Object)projectName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runDockerComposeContainer(@NotNull Path configurationPath, @NotNull Runnable runnable) {
        if (configurationPath == null) {
            DockerComposeProjectService.$$$reportNull$$$0(6);
        }
        if (runnable == null) {
            DockerComposeProjectService.$$$reportNull$$$0(7);
        }
        String projectName = DockerComposeConfigurationUtil.getDockerComposeProjectName((Path)configurationPath);
        this.myBusyDockerComposeProjects.put((Object)projectName);
        try {
            runnable.run();
        }
        finally {
            this.myBusyDockerComposeProjects.remove((Object)projectName);
        }
    }

    @NotNull
    public String getDockerComposeVersion(@NotNull DockerCloudConfiguration dockerCloudConfiguration) {
        String dockerComposeExePath;
        if (dockerCloudConfiguration == null) {
            DockerComposeProjectService.$$$reportNull$$$0(8);
        }
        if (!StringUtil.isEmpty((String)(dockerComposeExePath = DockerSettings.getInstance().getDockerComposePath()))) {
            String string;
            try {
                string = (String)this.myDockerComposeVersionsCache.get((Object)dockerComposeExePath);
            }
            catch (Exception e) {
                DockerComposeProjectService.logDockerComposeVersionException(dockerComposeExePath, e);
            }
            if (string == null) {
                DockerComposeProjectService.$$$reportNull$$$0(9);
            }
            return string;
        }
        return DEFAULT_DOCKER_COMPOSE_VERSION;
    }

    private static void logDockerComposeVersionException(@NotNull String executable, @NotNull Exception e) {
        if (executable == null) {
            DockerComposeProjectService.$$$reportNull$$$0(10);
        }
        if (e == null) {
            DockerComposeProjectService.$$$reportNull$$$0(11);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Unable to get Docker Compose version using \"" + executable + "\" executable", (Throwable)e);
        } else {
            LOG.info("Unable to get Docker Compose version using \"" + executable + "\" executable. " + e.getMessage());
        }
    }

    @NotNull
    public static DockerComposeProjectService getInstance() {
        DockerComposeProjectService dockerComposeProjectService = (DockerComposeProjectService)ApplicationManager.getApplication().getService(DockerComposeProjectService.class);
        if (dockerComposeProjectService == null) {
            DockerComposeProjectService.$$$reportNull$$$0(12);
        }
        return dockerComposeProjectService;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 5: 
            case 9: 
            case 12: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 5: 
            case 9: 
            case 12: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configurationPath";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "applicationRuntime";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "taskTitle";
                break;
            }
            case 3: 
            case 5: 
            case 9: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/docker/remote/compose/DockerComposeProjectService";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runnable";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dockerCloudConfiguration";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "executable";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/docker/remote/compose/DockerComposeProjectService";
                break;
            }
            case 3: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "runDockerComposeContainer";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getDockerComposeVersion";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstance";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "runDockerComposeContainer";
                break;
            }
            case 3: 
            case 5: 
            case 9: 
            case 12: {
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getDockerComposeVersion";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "logDockerComposeVersionException";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 5: 
            case 9: 
            case 12: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

