/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.docker.remote;

import com.google.common.collect.Iterables;
import com.intellij.DynamicBundle;
import com.intellij.docker.agent.cli.CliParserBase;
import com.intellij.docker.deployment.ui.DockerContainerSettingsUI;
import com.intellij.docker.i18n.DockerBundle;
import com.intellij.docker.remote.DockerContainerSettings;
import com.intellij.docker.remote.settings.DockerExtraHostsEditor;
import com.intellij.docker.settings.DockerEnvVarsEditor;
import com.intellij.docker.settings.DockerLinksEditor;
import com.intellij.docker.settings.DockerPortBindingsEditor;
import com.intellij.docker.settings.DockerVolumeBindingsEditor;
import com.intellij.docker.settings.TableWithCardEditor;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.options.SettingsEditor;
import com.intellij.openapi.ui.ValidationInfo;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.remoteServer.configuration.RemoteServer;
import com.intellij.ui.HideableDecorator;
import com.intellij.ui.UserActivityProviderComponent;
import com.intellij.ui.components.JBLabel;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.util.EventDispatcher;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Arrays;
import java.util.EventListener;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.apache.commons.cli.ParseException;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DockerInterpreterContainerSettingsEditor
extends SettingsEditor<DockerContainerSettings> {
    private static final int COLLAPSED_SIZE_POLICY = 3;
    private static final int EXPANDED_SIZE_POLICY = 7;
    private JPanel myMainPanel;
    private JPanel myPortBindingsPanelPlaceHolder;
    private JCheckBox myPublishAllPortsCheckBox;
    private JPanel myLinksPanelPlaceHolder;
    private JPanel myVolumeBindingsPanelPlaceHolder;
    private JPanel myEnvVarsPanelPlaceHolder;
    private JPanel myNotificationPanel;
    private JLabel myNetworkModeLabel;
    private JTextField myNetworkModeField;
    private JCheckBox myDisableNetworkingCheckBox;
    private JPanel myExtraHostsPlaceHolder;
    private JBLabel myRunCliOptionsLabel;
    private DockerContainerSettingsUI.DockerRunOptionsField myRunCliOptionsField;
    private JPanel myVerticalSpacerPanel;
    private final DockerPortBindingsEditor myPortBindingsEditor;
    private final DockerLinksEditor myLinksEditor;
    private final DockerExtraHostsEditor myExtraHostsEditor;
    private final DockerVolumeBindingsEditor myVolumeBindingsEditor;
    private final DockerEnvVarsEditor myEnvVarsEditor;
    private final HideableDecorator myPortBindingsDecorator;
    private final HideableDecorator myLinksDecorator;
    private final HideableDecorator myExtraHostsDecorator;
    private final HideableDecorator myVolumeBindingsDecorator;
    private final HideableDecorator myEnvVarsDecorator;
    private int mySettingsVersion;

    public DockerInterpreterContainerSettingsEditor(@Nullable RemoteServer server) {
        this.$$$setupUI$$$();
        this.myPublishAllPortsCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DockerInterpreterContainerSettingsEditor.this.updatePortBindingsAvailability();
            }
        });
        this.myDisableNetworkingCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DockerInterpreterContainerSettingsEditor.this.updateNetworkModeAvailability();
            }
        });
        this.myPortBindingsEditor = new DockerPortBindingsEditor();
        this.myPortBindingsDecorator = this.decorateEditor(this.myPortBindingsPanelPlaceHolder, DockerBundle.message((String)"DockerInterpreterContainerSettingsEditor.port.bindings", (Object[])new Object[0]), (TableWithCardEditor<?, ?>)this.myPortBindingsEditor);
        this.myLinksEditor = new DockerLinksEditor(server);
        this.myLinksDecorator = this.decorateEditor(this.myLinksPanelPlaceHolder, DockerBundle.message((String)"DockerInterpreterContainerSettingsEditor.links", (Object[])new Object[0]), (TableWithCardEditor<?, ?>)this.myLinksEditor);
        this.myExtraHostsEditor = new DockerExtraHostsEditor();
        this.myExtraHostsDecorator = this.decorateEditor(this.myExtraHostsPlaceHolder, DockerBundle.message((String)"DockerInterpreterContainerSettingsEditor.extra.hosts", (Object[])new Object[0]), this.myExtraHostsEditor);
        this.myVolumeBindingsEditor = new DockerVolumeBindingsEditor(server);
        this.myVolumeBindingsDecorator = this.decorateEditor(this.myVolumeBindingsPanelPlaceHolder, DockerBundle.message((String)"DockerInterpreterContainerSettingsEditor.volume.bindings", (Object[])new Object[0]), (TableWithCardEditor<?, ?>)this.myVolumeBindingsEditor);
        this.myEnvVarsEditor = new DockerEnvVarsEditor();
        this.myEnvVarsDecorator = this.decorateEditor(this.myEnvVarsPanelPlaceHolder, DockerBundle.message((String)"DockerInterpreterContainerSettingsEditor.environment.variables", (Object[])new Object[0]), (TableWithCardEditor<?, ?>)this.myEnvVarsEditor);
    }

    private HideableDecorator decorateEditor(@NotNull JPanel panel2, @NotNull @Nls String title, @NotNull TableWithCardEditor<?, ?> editor) {
        if (panel2 == null) {
            DockerInterpreterContainerSettingsEditor.$$$reportNull$$$0(0);
        }
        if (title == null) {
            DockerInterpreterContainerSettingsEditor.$$$reportNull$$$0(1);
        }
        if (editor == null) {
            DockerInterpreterContainerSettingsEditor.$$$reportNull$$$0(2);
        }
        editor.getPanel().setPreferredSize(new Dimension(500, 100));
        return new HideableDecoratorEx(panel2, title, editor);
    }

    private void updatePortBindingsAvailability() {
        boolean enablePortBindings = !this.myPublishAllPortsCheckBox.isSelected();
        this.myPortBindingsEditor.setEnabled(enablePortBindings);
    }

    private void updateNetworkModeAvailability() {
        this.myNetworkModeField.setEnabled(!this.myDisableNetworkingCheckBox.isSelected());
    }

    protected void resetEditorFrom(@NotNull DockerContainerSettings settings) {
        if (settings == null) {
            DockerInterpreterContainerSettingsEditor.$$$reportNull$$$0(3);
        }
        this.myPortBindingsEditor.setItems(settings.getPortBindings());
        this.myLinksEditor.setItems(settings.getLinks());
        this.myExtraHostsEditor.setItems(settings.getExtraHosts());
        this.myVolumeBindingsEditor.setItems(settings.getVolumeBindings());
        this.myEnvVarsEditor.setItems(settings.getEnvVars());
        this.myPortBindingsDecorator.setOn(!settings.getPortBindings().isEmpty());
        this.myLinksDecorator.setOn(!settings.getPortBindings().isEmpty());
        this.myExtraHostsDecorator.setOn(!settings.getExtraHosts().isEmpty());
        this.myVolumeBindingsDecorator.setOn(!settings.getVolumeBindings().isEmpty());
        this.myEnvVarsDecorator.setOn(!settings.getEnvVars().isEmpty());
        this.myPublishAllPortsCheckBox.setSelected(settings.isPublishAllPorts());
        this.myDisableNetworkingCheckBox.setSelected(settings.isNetworkDisabled());
        this.myNetworkModeField.setText(settings.getNetworkMode());
        this.myRunCliOptionsField.setText(StringUtil.notNullize((String)settings.getRunCliOptions()));
        this.mySettingsVersion = settings.getVersion();
        this.updatePortBindingsAvailability();
        this.updateNetworkModeAvailability();
        this.updateUI();
    }

    protected void applyEditorTo(@NotNull DockerContainerSettings settings) throws ConfigurationException {
        if (settings == null) {
            DockerInterpreterContainerSettingsEditor.$$$reportNull$$$0(4);
        }
        settings.setPublishAllPorts(this.myPublishAllPortsCheckBox.isSelected());
        settings.setPortBindings(this.myPortBindingsEditor.getItems());
        settings.setLinks(this.myLinksEditor.getItems());
        settings.setExtraHosts(this.myExtraHostsEditor.getItems());
        settings.setVolumeBindings(this.myVolumeBindingsEditor.getItems());
        settings.setEnvVars(this.myEnvVarsEditor.getItems());
        settings.setNetworkDisabled(this.myDisableNetworkingCheckBox.isSelected());
        settings.setNetworkMode(this.myNetworkModeField.getText());
        settings.setVersion(this.mySettingsVersion);
        settings.setRunCliOptions(this.myRunCliOptionsField.getText());
    }

    @Nullable
    public ValidationInfo doValidate() {
        try {
            this.myRunCliOptionsField.getParsedOptions();
        }
        catch (CliParserBase.IllegalOptionException | ParseException e) {
            return new ValidationInfo(e.getLocalizedMessage(), (JComponent)this.myRunCliOptionsField);
        }
        return null;
    }

    private void updateUI() {
        boolean isVersionTwoOrAbove = this.mySettingsVersion >= 2;
        this.myDisableNetworkingCheckBox.setVisible(!isVersionTwoOrAbove);
        this.myNetworkModeLabel.setVisible(!isVersionTwoOrAbove);
        this.myNetworkModeField.setVisible(!isVersionTwoOrAbove);
        this.myLinksPanelPlaceHolder.setVisible(!isVersionTwoOrAbove);
        this.myExtraHostsPlaceHolder.setVisible(!isVersionTwoOrAbove);
        this.myRunCliOptionsLabel.setVisible(isVersionTwoOrAbove);
        this.myRunCliOptionsField.setVisible(isVersionTwoOrAbove);
    }

    @NotNull
    protected JComponent createEditor() {
        JPanel jPanel = this.myMainPanel;
        if (jPanel == null) {
            DockerInterpreterContainerSettingsEditor.$$$reportNull$$$0(5);
        }
        return jPanel;
    }

    private void createUIComponents() {
        this.myRunCliOptionsField = new DockerContainerSettingsUI.DockerRunOptionsField(null);
        this.myNotificationPanel = new NotificationPanel();
    }

    private boolean areAllEditorsCollapsed() {
        return Iterables.all(this.getAllDecorators(), input -> input != null && !input.isExpanded());
    }

    @NotNull
    private Iterable<HideableDecorator> getAllDecorators() {
        List<HideableDecorator> list = Arrays.asList(this.myPortBindingsDecorator, this.myLinksDecorator, this.myExtraHostsDecorator, this.myVolumeBindingsDecorator, this.myEnvVarsDecorator);
        if (list == null) {
            DockerInterpreterContainerSettingsEditor.$$$reportNull$$$0(6);
        }
        return list;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: 
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: 
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "panel";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "title";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/docker/remote/DockerInterpreterContainerSettingsEditor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/docker/remote/DockerInterpreterContainerSettingsEditor";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "createEditor";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllDecorators";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "decorateEditor";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "resetEditorFrom";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "applyEditorTo";
                break;
            }
            case 5: 
            case 6: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: 
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JBLabel jBLabel;
        JPanel jPanel;
        JPanel jPanel2;
        JCheckBox jCheckBox;
        JTextField jTextField;
        JLabel jLabel;
        JCheckBox jCheckBox2;
        JPanel jPanel3;
        JPanel jPanel4;
        JPanel jPanel5;
        JPanel jPanel6;
        JPanel jPanel7;
        this.createUIComponents();
        this.myMainPanel = jPanel7 = new JPanel();
        jPanel7.setLayout((LayoutManager)new GridLayoutManager(11, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        this.myLinksPanelPlaceHolder = jPanel6 = new JPanel();
        jPanel6.setLayout(new BorderLayout(0, 0));
        jPanel7.add((Component)jPanel6, new GridConstraints(4, 0, 1, 2, 0, 3, 3, 3, null, null, null));
        this.myVolumeBindingsPanelPlaceHolder = jPanel5 = new JPanel();
        jPanel5.setLayout(new BorderLayout(0, 0));
        jPanel7.add((Component)jPanel5, new GridConstraints(6, 0, 1, 2, 0, 3, 3, 3, null, null, null));
        this.myEnvVarsPanelPlaceHolder = jPanel4 = new JPanel();
        jPanel4.setLayout(new BorderLayout(0, 0));
        jPanel7.add((Component)jPanel4, new GridConstraints(7, 0, 1, 2, 0, 3, 3, 3, null, null, null));
        this.myPortBindingsPanelPlaceHolder = jPanel3 = new JPanel();
        jPanel3.setLayout(new BorderLayout(0, 0));
        jPanel7.add((Component)jPanel3, new GridConstraints(3, 0, 1, 2, 0, 3, 3, 3, null, null, null));
        this.myPublishAllPortsCheckBox = jCheckBox2 = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox2, DynamicBundle.getBundle((String)"messages/DockerBundle", DockerInterpreterContainerSettingsEditor.class).getString("DockerInterpreterContainerSettingsEditor.publish.all.ports.text"));
        jPanel7.add((Component)jCheckBox2, new GridConstraints(2, 0, 1, 2, 8, 0, 3, 0, null, null, null));
        JPanel jPanel8 = this.myNotificationPanel;
        jPanel7.add((Component)jPanel8, new GridConstraints(9, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        this.myNetworkModeLabel = jLabel = new JLabel();
        this.$$$loadLabelText$$$(jLabel, DynamicBundle.getBundle((String)"messages/DockerBundle", DockerInterpreterContainerSettingsEditor.class).getString("DockerInterpreterContainerSettingsEditor.network.mode.text"));
        jPanel7.add((Component)jLabel, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myNetworkModeField = jTextField = new JTextField();
        jPanel7.add((Component)jTextField, new GridConstraints(1, 1, 1, 1, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        this.myDisableNetworkingCheckBox = jCheckBox = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox, DynamicBundle.getBundle((String)"messages/DockerBundle", DockerInterpreterContainerSettingsEditor.class).getString("DockerInterpreterContainerSettingsEditor.disable.networking.text"));
        jPanel7.add((Component)jCheckBox, new GridConstraints(0, 0, 1, 2, 8, 0, 3, 0, null, null, null));
        this.myExtraHostsPlaceHolder = jPanel2 = new JPanel();
        jPanel2.setLayout(new BorderLayout(0, 0));
        jPanel7.add((Component)jPanel2, new GridConstraints(5, 0, 1, 2, 0, 3, 3, 3, null, null, null));
        this.myVerticalSpacerPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel7.add((Component)jPanel, new GridConstraints(10, 0, 1, 1, 0, 3, 0, 7, null, null, null));
        this.myRunCliOptionsLabel = jBLabel = new JBLabel();
        this.$$$loadLabelText$$$((JLabel)jBLabel, DynamicBundle.getBundle((String)"messages/DockerBundle", DockerInterpreterContainerSettingsEditor.class).getString("DockerInterpreterContainerSettingsEditor.run.options.text"));
        jPanel7.add((Component)jBLabel, new GridConstraints(8, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        DockerContainerSettingsUI.DockerRunOptionsField dockerRunOptionsField = this.myRunCliOptionsField;
        jPanel7.add((Component)dockerRunOptionsField, new GridConstraints(8, 1, 1, 1, 0, 1, 6, 0, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myMainPanel;
    }

    private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }

    private /* synthetic */ void $$$loadButtonText$$$(AbstractButton abstractButton, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        abstractButton.setText(stringBuffer.toString());
        if (bl) {
            abstractButton.setMnemonic(c);
            abstractButton.setDisplayedMnemonicIndex(n);
        }
    }

    private class NotificationPanel
    extends JPanel
    implements UserActivityProviderComponent {
        private final EventDispatcher<ChangeListener> myEventDispatcher = EventDispatcher.create(ChangeListener.class);

        private NotificationPanel() {
        }

        public void addChangeListener(@NotNull ChangeListener changeListener) {
            if (changeListener == null) {
                NotificationPanel.$$$reportNull$$$0(0);
            }
            this.myEventDispatcher.addListener((EventListener)changeListener, (Disposable)DockerInterpreterContainerSettingsEditor.this);
        }

        public void removeChangeListener(@NotNull ChangeListener changeListener) {
            if (changeListener == null) {
                NotificationPanel.$$$reportNull$$$0(1);
            }
            this.myEventDispatcher.removeListener((EventListener)changeListener);
        }

        public void stateChanged() {
            ((ChangeListener)this.myEventDispatcher.getMulticaster()).stateChanged(new ChangeEvent(this));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "changeListener";
            objectArray2[1] = "com/intellij/docker/remote/DockerInterpreterContainerSettingsEditor$NotificationPanel";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "addChangeListener";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "removeChangeListener";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private class HideableDecoratorEx
    extends HideableDecorator {
        private final JPanel myPanel;

        HideableDecoratorEx(@Nls JPanel panel2, String title, TableWithCardEditor editor) {
            super(panel2, title, true);
            this.myPanel = panel2;
            this.setContentComponent(editor.getPanel());
        }

        protected void on() {
            super.on();
            ((NotificationPanel)DockerInterpreterContainerSettingsEditor.this.myNotificationPanel).stateChanged();
            GridLayoutManager layout = (GridLayoutManager)DockerInterpreterContainerSettingsEditor.this.myMainPanel.getLayout();
            layout.getConstraintsForComponent((Component)this.myPanel).setVSizePolicy(7);
            layout.getConstraintsForComponent((Component)DockerInterpreterContainerSettingsEditor.this.myVerticalSpacerPanel).setVSizePolicy(3);
        }

        protected void off() {
            super.off();
            ((NotificationPanel)DockerInterpreterContainerSettingsEditor.this.myNotificationPanel).stateChanged();
            GridLayoutManager layout = (GridLayoutManager)DockerInterpreterContainerSettingsEditor.this.myMainPanel.getLayout();
            layout.getConstraintsForComponent((Component)this.myPanel).setVSizePolicy(3);
            if (DockerInterpreterContainerSettingsEditor.this.areAllEditorsCollapsed()) {
                layout.getConstraintsForComponent((Component)DockerInterpreterContainerSettingsEditor.this.myVerticalSpacerPanel).setVSizePolicy(7);
            }
        }
    }
}

