/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.docker.remote;

import com.intellij.docker.compose.configuration.beans.DockerComposeConfigurationParser;
import com.intellij.docker.compose.configuration.beans.common.DockerComposeConfiguration;
import com.intellij.docker.compose.configuration.beans.common.DockerComposeServiceBase;
import com.intellij.docker.compose.configuration.beans.common.ServiceVolume;
import com.intellij.docker.compose.configuration.beans.parse.DockerComposeConfigurationParserUtil;
import com.intellij.docker.compose.configuration.beans.v1.DockerComposeConfigurationV1;
import com.intellij.docker.compose.configuration.beans.v1.DockerComposeServiceV1;
import com.intellij.docker.compose.configuration.beans.v2.DockerComposeConfigurationV2;
import com.intellij.docker.compose.configuration.beans.v2.DockerComposeExtendsV2;
import com.intellij.docker.compose.configuration.beans.v2.DockerComposeServiceV2;
import com.intellij.docker.compose.configuration.beans.v2.DockerComposeVolumesFromV2;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.PathMappingSettings;
import com.intellij.util.PathUtil;
import com.intellij.util.SmartList;
import java.io.IOException;
import java.util.ArrayDeque;
import java.util.Collections;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class DockerComposeMappingsCollector
implements DockerComposeConfiguration.Visitor<Boolean> {
    private static final Logger LOG = Logger.getInstance(DockerComposeMappingsCollector.class);
    private final Map<String, PathMappingSettings> myServiceMappings;
    private final Map<String, List<String>> myDependencies;
    @NotNull
    private String myDockerComposeBaseDirectory;
    @Nullable
    private Deque<String> myAdditionalFiles;

    public DockerComposeMappingsCollector(@NotNull String dockerComposeBaseFile) {
        if (dockerComposeBaseFile == null) {
            DockerComposeMappingsCollector.$$$reportNull$$$0(0);
        }
        this.myServiceMappings = new HashMap<String, PathMappingSettings>();
        this.myDependencies = new HashMap<String, List<String>>();
        this.myDockerComposeBaseDirectory = PathUtil.toSystemIndependentName((String)PathUtil.getParentPath((String)dockerComposeBaseFile));
        this.myAdditionalFiles = null;
    }

    public Boolean visit(@NotNull DockerComposeConfigurationV1 configuration) {
        if (configuration == null) {
            DockerComposeMappingsCollector.$$$reportNull$$$0(1);
        }
        for (Map.Entry entry : configuration.getServices().entrySet()) {
            List dependencies;
            String serviceName = (String)entry.getKey();
            DockerComposeServiceV1 service = (DockerComposeServiceV1)entry.getValue();
            if (service == null || !StringUtil.isNotEmpty((String)serviceName)) continue;
            this.collectVolumes(serviceName, (DockerComposeServiceBase)service);
            List volumesFrom = service.getVolumesFrom();
            if (volumesFrom == null || (dependencies = volumesFrom.stream().filter(from -> from != null).map(from -> from.getName()).collect(Collectors.toList())).isEmpty()) continue;
            this.myDependencies.put(serviceName, dependencies);
        }
        return true;
    }

    public Boolean visit(@NotNull DockerComposeConfigurationV2 configuration) {
        if (configuration == null) {
            DockerComposeMappingsCollector.$$$reportNull$$$0(2);
        }
        for (Map.Entry entry : configuration.getServices().entrySet()) {
            DockerComposeExtendsV2 parent;
            List dependencies;
            String serviceName = (String)entry.getKey();
            DockerComposeServiceV2 service = (DockerComposeServiceV2)entry.getValue();
            if (service == null || !StringUtil.isNotEmpty((String)serviceName)) continue;
            this.collectVolumes(serviceName, (DockerComposeServiceBase)service);
            List volumesFrom = service.getVolumesFrom();
            if (volumesFrom != null && !(dependencies = volumesFrom.stream().filter(from -> from != null && from.getType() == DockerComposeVolumesFromV2.Type.SERVICE).map(from -> from.getName()).collect(Collectors.toList())).isEmpty()) {
                this.myDependencies.put(serviceName, dependencies);
            }
            if ((parent = service.getExtends()) == null) continue;
            String parentFile = parent.getFile();
            String parentService = parent.getService();
            if (!StringUtil.isNotEmpty((String)parentFile) || !StringUtil.isNotEmpty((String)parentService)) continue;
            String absolute = PathUtil.toSystemDependentName((String)(FileUtil.isAbsolutePlatformIndependent((String)parentFile) ? parentFile : this.myDockerComposeBaseDirectory + "/" + parentFile));
            this.addAdditionalFile(FileUtil.toCanonicalPath((String)absolute));
            if (this.myDependencies.containsKey(serviceName)) {
                this.myDependencies.get(serviceName).add(parentService);
                continue;
            }
            this.myDependencies.put(serviceName, (List<String>)new SmartList((Object)parentService));
        }
        return true;
    }

    private void addAdditionalFile(@NotNull String configurationFile) {
        if (configurationFile == null) {
            DockerComposeMappingsCollector.$$$reportNull$$$0(3);
        }
        if (this.myAdditionalFiles == null) {
            this.myAdditionalFiles = new ArrayDeque<String>(5);
        }
        this.myAdditionalFiles.addLast(configurationFile);
    }

    private void collectVolumes(@NotNull String serviceName, @NotNull DockerComposeServiceBase service) {
        List volumes;
        if (serviceName == null) {
            DockerComposeMappingsCollector.$$$reportNull$$$0(4);
        }
        if (service == null) {
            DockerComposeMappingsCollector.$$$reportNull$$$0(5);
        }
        if ((volumes = service.getVolumes()) == null || volumes.isEmpty()) {
            return;
        }
        PathMappingSettings mappings = this.myServiceMappings.containsKey(serviceName) ? this.myServiceMappings.get(serviceName) : new PathMappingSettings();
        for (ServiceVolume volume : volumes) {
            boolean isAbsolutePath;
            if (!volume.isBind()) continue;
            String sourcePath = volume.getSource();
            String targetPath = volume.getTarget();
            if (sourcePath == null || targetPath == null || !(isAbsolutePath = FileUtil.isAbsolutePlatformIndependent((String)sourcePath)) && !StringUtil.startsWith((CharSequence)sourcePath, (CharSequence)".")) continue;
            String unifiedLocal = PathUtil.toSystemIndependentName((String)sourcePath);
            String absolute = isAbsolutePath ? unifiedLocal : this.myDockerComposeBaseDirectory + "/" + unifiedLocal;
            mappings.addMapping(FileUtil.toCanonicalPath((String)absolute, (char)'/'), targetPath);
        }
        if (!mappings.isEmpty()) {
            this.myServiceMappings.put(serviceName, mappings);
        }
    }

    @NotNull
    public PathMappingSettings collect(@NotNull String serviceName, @NotNull List<String> configurationFiles) {
        if (serviceName == null) {
            DockerComposeMappingsCollector.$$$reportNull$$$0(6);
        }
        if (configurationFiles == null) {
            DockerComposeMappingsCollector.$$$reportNull$$$0(7);
        }
        HashSet<String> visitedFiles = new HashSet<String>();
        for (String dockerComposeFile : configurationFiles) {
            if (visitedFiles.contains(dockerComposeFile)) continue;
            visitedFiles.add(dockerComposeFile);
            this.parse(dockerComposeFile);
        }
        while (this.myAdditionalFiles != null && !this.myAdditionalFiles.isEmpty()) {
            String configFile = this.myAdditionalFiles.removeFirst();
            if (visitedFiles.contains(configFile)) continue;
            visitedFiles.add(configFile);
            this.myDockerComposeBaseDirectory = PathUtil.toSystemIndependentName((String)PathUtil.getParentPath((String)configFile));
            this.parse(configFile);
        }
        PathMappingSettings result = new PathMappingSettings();
        HashSet<String> visited = new HashSet<String>();
        ArrayDeque<String> toVisit = new ArrayDeque<String>(this.myServiceMappings.size() / 2);
        toVisit.addLast(serviceName);
        while (!toVisit.isEmpty()) {
            String next = (String)toVisit.removeFirst();
            if (visited.contains(next)) continue;
            visited.add(next);
            if (this.myServiceMappings.containsKey(next)) {
                result.addAll(this.myServiceMappings.get(next));
            }
            if (!this.myDependencies.containsKey(next)) continue;
            for (String dependency : this.myDependencies.get(next)) {
                toVisit.addLast(dependency);
            }
        }
        PathMappingSettings pathMappingSettings = result;
        if (pathMappingSettings == null) {
            DockerComposeMappingsCollector.$$$reportNull$$$0(8);
        }
        return pathMappingSettings;
    }

    private void parse(@NotNull String configFile) {
        block4: {
            if (configFile == null) {
                DockerComposeMappingsCollector.$$$reportNull$$$0(9);
            }
            try {
                if (ApplicationManager.getApplication().isWriteAccessAllowed()) {
                    DockerComposeConfigurationParserUtil.saveDockerComposeFiles(Collections.singletonList(configFile));
                }
                DockerComposeConfigurationParser.newPureInstance().parseBean(configFile).accept((DockerComposeConfiguration.Visitor)this);
            }
            catch (IOException e) {
                if (ApplicationManager.getApplication().isUnitTestMode()) break block4;
                LOG.warn("Cannot read docker-compose file: " + configFile, (Throwable)e);
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 8: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 8: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dockerComposeBaseFile";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configuration";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configurationFile";
                break;
            }
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "serviceName";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "service";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configurationFiles";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/docker/remote/DockerComposeMappingsCollector";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configFile";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/docker/remote/DockerComposeMappingsCollector";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "collect";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "visit";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "addAdditionalFile";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "collectVolumes";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "collect";
                break;
            }
            case 8: {
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "parse";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 8: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

