/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.docker.remote;

import com.intellij.DynamicBundle;
import com.intellij.docker.DockerCloudType;
import com.intellij.docker.compose.configuration.beans.parse.DockerComposeConfigurationParserUtil;
import com.intellij.docker.deployment.ui.DockerComposePaths;
import com.intellij.docker.deployment.ui.compose.DockerComposeFilesTextField;
import com.intellij.docker.i18n.DockerBundle;
import com.intellij.docker.remote.DockerComposeCredentialsEditorLanguageContribution;
import com.intellij.docker.remote.DockerComposeCredentialsHolder;
import com.intellij.docker.remote.DockerComposeCredentialsType;
import com.intellij.execution.configuration.EnvironmentVariablesComponent;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.progress.impl.BackgroundableProcessIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.ui.ValidationInfo;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.remote.RemoteSdkAdditionalData;
import com.intellij.remote.ext.CredentialsEditor;
import com.intellij.remote.ext.CredentialsLanguageContribution;
import com.intellij.remote.ext.FormWithAlignableLabelsColumn;
import com.intellij.remoteServer.configuration.RemoteServer;
import com.intellij.remoteServer.util.CloudAccountSelectionEditor;
import com.intellij.ui.AnimatedIcon;
import com.intellij.ui.CollectionComboBoxModel;
import com.intellij.ui.ComponentUtil;
import com.intellij.ui.ListCellRendererWithRightAlignedComponent;
import com.intellij.ui.PanelWithAnchor;
import com.intellij.ui.StatusPanel;
import com.intellij.ui.components.JBLabel;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.ObjectUtils;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.io.IOException;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DockerComposeCredentialsEditor
implements CredentialsEditor<DockerComposeCredentialsHolder>,
PanelWithAnchor,
FormWithAlignableLabelsColumn {
    private static final ExtensionPointName<DockerComposeCredentialsEditorLanguageContribution<?>> EP_NAME = new ExtensionPointName("com.intellij.docker.remote.dockerComposeCredentialsEditorLanguageContribution");
    private static final Logger LOG = Logger.getInstance(DockerComposeCredentialsEditor.class);
    private JPanel myMainPanel;
    private JBLabel myServerLabel;
    private JPanel myDockerAccountSelectionPlaceHolder;
    private JBLabel myServiceLabel;
    private ComboBox<String> myDockerComposeServiceNameComboBox;
    private EnvironmentVariablesComponent myEnvsComponent;
    private JBLabel myConfigurationFilesLabel;
    private DockerComposeFilesTextField myConfigurationFilesTextField;
    @Nullable
    private final Project myProject;
    @Nullable
    private final Module myModule;
    @NotNull
    private final StatusPanel myStatusPanel;
    @Nullable
    private final DockerComposeCredentialsEditorLanguageContribution<?> myEditorLanguageContribution;
    private final CloudAccountSelectionEditor myDockerAccountSelectionEditor;
    private boolean myConfigurationPathShouldBeInitialized;
    private @NlsContexts.DialogMessage String myConfigurationError;
    private boolean myValidationPhase;
    private volatile boolean waitingForDockerComposeServiceName;
    private volatile String myServiceNameToSelectAfterRefresh;
    @Nullable
    private JComponent myAnchor;

    public DockerComposeCredentialsEditor(@Nullable Project project, @Nullable Module module, @NotNull CredentialsLanguageContribution<?> languageContribution, @NotNull StatusPanel statusPanel) {
        if (languageContribution == null) {
            DockerComposeCredentialsEditor.$$$reportNull$$$0(0);
        }
        if (statusPanel == null) {
            DockerComposeCredentialsEditor.$$$reportNull$$$0(1);
        }
        this.myConfigurationPathShouldBeInitialized = true;
        this.myProject = project;
        this.myModule = module;
        this.myStatusPanel = statusPanel;
        this.$$$setupUI$$$();
        this.myEditorLanguageContribution = DockerComposeCredentialsEditor.findEditorContribution(languageContribution);
        this.myDockerAccountSelectionEditor = new CloudAccountSelectionEditor(Collections.singletonList(DockerCloudType.getInstance()));
        this.myDockerAccountSelectionPlaceHolder.add(this.myDockerAccountSelectionEditor.getMainPanel());
        this.myConfigurationFilesLabel.setLabelFor((Component)this.myConfigurationFilesTextField);
        ComponentUtil.putClientProperty(this.myDockerComposeServiceNameComboBox, (Key)AnimatedIcon.ANIMATION_IN_RENDERER_ALLOWED, (Object)true);
        this.myDockerComposeServiceNameComboBox.setRenderer((ListCellRenderer)new ListCellRendererWithRightAlignedComponent<String>(){

            protected void customize(@NlsSafe String value) {
                this.setLeftText(value);
                this.setRightIcon((Icon)(DockerComposeCredentialsEditor.this.waitingForDockerComposeServiceName ? AnimatedIcon.Default.INSTANCE : null));
            }
        });
    }

    private void updateServiceNameComboBox() {
        StatusPanel.Action action = this.myStatusPanel.progress(DockerBundle.message((String)"DockerComposeCredentialsEditor.processing", (Object[])new Object[0]), false);
        this.myConfigurationError = null;
        this.waitingForDockerComposeServiceName = true;
        if (this.myEditorLanguageContribution != null) {
            if (this.myDockerComposeServiceNameComboBox.getModel().getSize() > 0) {
                this.myServiceNameToSelectAfterRefresh = this.getNormalizedSelectedServiceName();
            }
            ArrayList<String> configurationFilePaths = new ArrayList<String>();
            List files = this.myConfigurationFilesTextField.getConfigurationFiles();
            for (int i = 0; i < files.size(); ++i) {
                String configurationFile = (String)files.get(i);
                if (Paths.get(configurationFile, new String[0]).toFile().exists()) {
                    configurationFilePaths.add(configurationFile);
                    continue;
                }
                if (i != 0) continue;
                this.handleComposeServiceNamesError(action, DockerBundle.message((String)"DockerComposeCredentialsEditor.error.base.configuration.file.does.not.exist", (Object[])new Object[]{configurationFile}));
                return;
            }
            DockerComposeConfigurationParserUtil.saveDockerComposeFiles(configurationFilePaths);
            final Runnable getServices = () -> {
                try {
                    DockerComposeCredentialsEditorLanguageContribution.DockerComposeConfigurationInfo info = this.myEditorLanguageContribution.getDockerComposeConfigurationInfo(configurationFilePaths);
                    ArrayList<String> services = new ArrayList<String>(info.getServices());
                    services.sort(String.CASE_INSENSITIVE_ORDER);
                    ApplicationManager.getApplication().invokeAndWait(() -> this.handleComposeServiceNamesSuccess(action, services), ModalityState.any());
                }
                catch (IOException | RuntimeException e) {
                    LOG.info((Throwable)e);
                    ApplicationManager.getApplication().invokeAndWait(() -> this.handleComposeServiceNamesError(action, e.getMessage()), ModalityState.any());
                }
            };
            if (ApplicationManager.getApplication().isUnitTestMode()) {
                this.selectTestService(getServices);
            } else {
                Task.Backgroundable task = new Task.Backgroundable(this.myProject, DockerBundle.message((String)"DockerComposeCredentialsEditor.getting.services.from.compose.configuration", (Object[])new Object[0])){

                    public void run(@NotNull ProgressIndicator indicator) {
                        if (indicator == null) {
                            2.$$$reportNull$$$0(0);
                        }
                        getServices.run();
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/docker/remote/DockerComposeCredentialsEditor$2", "run"));
                    }
                };
                BackgroundableProcessIndicator progressIndicator = new BackgroundableProcessIndicator(task);
                ProgressManager.getInstance().runProcessWithProgressAsynchronously(task, (ProgressIndicator)progressIndicator);
            }
        }
    }

    @Nullable
    private String getNormalizedSelectedServiceName() {
        String service = (String)ObjectUtils.tryCast((Object)this.myDockerComposeServiceNameComboBox.getSelectedItem(), String.class);
        return DockerBundle.message((String)"DockerComposeCredentialsEditor.no.service.placeholder", (Object[])new Object[0]) == service ? null : service;
    }

    private void selectTestService(Runnable getServices) {
        getServices.run();
        this.myDockerComposeServiceNameComboBox.setSelectedIndex(1);
    }

    private void handleComposeServiceNamesSuccess(StatusPanel.Action action, List<String> services) {
        String selectedItem = this.myServiceNameToSelectAfterRefresh != null ? this.myServiceNameToSelectAfterRefresh : this.getNormalizedSelectedServiceName();
        final String noServicePlaceholder = DockerBundle.message((String)"DockerComposeCredentialsEditor.no.service.placeholder", (Object[])new Object[0]);
        if (selectedItem == null && !services.isEmpty()) {
            services.add(0, noServicePlaceholder);
            selectedItem = noServicePlaceholder;
        }
        this.myDockerComposeServiceNameComboBox.setModel((ComboBoxModel)new CollectionComboBoxModel<String>(services, selectedItem){

            public void setSelectedItem(@Nullable Object item) {
                if (item != noServicePlaceholder) {
                    super.setSelectedItem(item);
                }
            }
        });
        this.myServiceNameToSelectAfterRefresh = null;
        this.waitingForDockerComposeServiceName = false;
        action.done();
    }

    private void handleComposeServiceNamesError(StatusPanel.Action action, @NlsContexts.DialogMessage String message) {
        this.myConfigurationError = message;
        if (!this.myValidationPhase) {
            action.failed(this.myConfigurationError);
        }
        this.myDockerComposeServiceNameComboBox.setModel((ComboBoxModel)new CollectionComboBoxModel());
        this.waitingForDockerComposeServiceName = false;
    }

    @NotNull
    @Nls
    public String getName() {
        String string = DockerComposeCredentialsType.getInstance().getName();
        if (string == null) {
            DockerComposeCredentialsEditor.$$$reportNull$$$0(2);
        }
        return string;
    }

    public JPanel getMainPanel() {
        return this.myMainPanel;
    }

    public void onSelected() {
        if (this.myConfigurationPathShouldBeInitialized) {
            try {
                VirtualFile baseDir = DockerComposePaths.guessBaseDir((Project)this.myProject, (Module)this.myModule);
                if (baseDir != null) {
                    this.myConfigurationFilesTextField.initComposeFilePaths(baseDir.getPath());
                }
            }
            finally {
                this.myConfigurationPathShouldBeInitialized = false;
            }
        }
    }

    public ValidationInfo validate() {
        this.myValidationPhase = !this.waitingForDockerComposeServiceName;
        RemoteServer selectedAccount = this.myDockerAccountSelectionEditor.getSelectedAccount();
        if (selectedAccount == null) {
            return new ValidationInfo(DockerBundle.message((String)"DockerComposeCredentialsEditor.validate.server.not.selected", (Object[])new Object[0]), this.myDockerAccountSelectionEditor.getMainPanel());
        }
        if (this.myConfigurationFilesTextField.getConfigurationFiles().isEmpty()) {
            return new ValidationInfo(DockerBundle.message((String)"DockerComposeCredentialsEditor.validate.files.not.chosen", (Object[])new Object[0]), (JComponent)this.myConfigurationFilesTextField);
        }
        if (StringUtil.isNotEmpty((String)this.myConfigurationError)) {
            return new ValidationInfo(this.myConfigurationError, (JComponent)this.myConfigurationFilesTextField);
        }
        if (!this.waitingForDockerComposeServiceName) {
            if (this.myDockerComposeServiceNameComboBox.getItemCount() == 0) {
                return new ValidationInfo(DockerBundle.message((String)"DockerComposeCredentialsEditor.validate.no.services.defined", (Object[])new Object[0]), this.myDockerComposeServiceNameComboBox);
            }
            String serviceName = this.getNormalizedSelectedServiceName();
            if (StringUtil.isEmpty((String)serviceName)) {
                return new ValidationInfo(DockerBundle.message((String)"DockerComposeCredentialsEditor.validate.service.name.not.selected", (Object[])new Object[0]), this.myDockerComposeServiceNameComboBox);
            }
            this.myStatusPanel.resetState();
        }
        return null;
    }

    @NlsContexts.DialogMessage
    public String validateFinal(@NotNull Supplier<? extends RemoteSdkAdditionalData<?>> supplier, @NotNull Consumer<String> helpersPathUpdateCallback) {
        if (supplier == null) {
            DockerComposeCredentialsEditor.$$$reportNull$$$0(3);
        }
        if (helpersPathUpdateCallback == null) {
            DockerComposeCredentialsEditor.$$$reportNull$$$0(4);
        }
        if (this.myEditorLanguageContribution != null) {
            helpersPathUpdateCallback.accept(this.myEditorLanguageContribution.getDefaultHelpersPath());
        }
        return null;
    }

    private void createUIComponents() {
        this.myConfigurationFilesTextField = new DockerComposeFilesTextField(this.myProject, this.myModule);
        this.myConfigurationFilesTextField.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent event) {
                DockerComposeCredentialsEditor.this.updateServiceNameComboBox();
            }
        });
    }

    @Nullable
    public JComponent getAnchor() {
        return this.myAnchor;
    }

    public void setAnchor(@Nullable JComponent anchor) {
        this.myAnchor = anchor;
        this.myConfigurationFilesLabel.setAnchor(anchor);
        this.myEnvsComponent.setAnchor(anchor);
        this.myEnvsComponent.invalidate();
    }

    @NotNull
    public List<JBLabel> getLabelsColumn() {
        List<JBLabel> list = List.of(this.myServerLabel, this.myServiceLabel, this.myConfigurationFilesLabel, this.myEnvsComponent.getLabel());
        if (list == null) {
            DockerComposeCredentialsEditor.$$$reportNull$$$0(5);
        }
        return list;
    }

    @Nullable
    private static DockerComposeCredentialsEditorLanguageContribution<?> findEditorContribution(@NotNull CredentialsLanguageContribution<?> languageContribution) {
        if (languageContribution == null) {
            DockerComposeCredentialsEditor.$$$reportNull$$$0(6);
        }
        return (DockerComposeCredentialsEditorLanguageContribution)EP_NAME.findFirstSafe(next -> next.getLanguageContribution() == languageContribution);
    }

    public void saveCredentials(DockerComposeCredentialsHolder credentials) {
        RemoteServer account = this.myDockerAccountSelectionEditor.getSelectedAccount();
        String accountName = account == null ? null : account.getName();
        credentials.setAccountName(accountName);
        credentials.setComposeFilePaths(new ArrayList<String>(this.myConfigurationFilesTextField.getConfigurationFiles()));
        credentials.setComposeServiceName(this.getNormalizedSelectedServiceName());
        credentials.setRemoteProjectPath("/opt/project");
        credentials.setEnvs(this.myEnvsComponent.getEnvData());
    }

    public void init(DockerComposeCredentialsHolder credentials) {
        this.myConfigurationPathShouldBeInitialized = false;
        this.myDockerAccountSelectionEditor.setSelectedAccount(credentials.getAccountName());
        this.myConfigurationFilesTextField.initComposeFilePaths(credentials.getComposeFilePaths());
        this.myDockerComposeServiceNameComboBox.setSelectedItem((Object)credentials.getComposeServiceName());
        if (this.waitingForDockerComposeServiceName) {
            this.myServiceNameToSelectAfterRefresh = credentials.getComposeServiceName();
        }
        this.myEnvsComponent.setEnvData(credentials.getEnvs());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "languageContribution";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "statusPanel";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/docker/remote/DockerComposeCredentialsEditor";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "supplier";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "helpersPathUpdateCallback";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/docker/remote/DockerComposeCredentialsEditor";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getLabelsColumn";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 5: {
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "validateFinal";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "findEditorContribution";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JBLabel jBLabel;
        EnvironmentVariablesComponent environmentVariablesComponent;
        ComboBox comboBox;
        JBLabel jBLabel2;
        JPanel jPanel;
        JBLabel jBLabel3;
        JPanel jPanel2;
        this.createUIComponents();
        this.myMainPanel = jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(5, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        this.myServerLabel = jBLabel3 = new JBLabel();
        this.$$$loadLabelText$$$((JLabel)jBLabel3, DynamicBundle.getBundle((String)"messages/DockerBundle", DockerComposeCredentialsEditor.class).getString("DockerComposeCredentialsEditor.server.text"));
        jPanel2.add((Component)jBLabel3, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        Spacer spacer = new Spacer();
        jPanel2.add((Component)spacer, new GridConstraints(4, 0, 1, 2, 0, 2, 1, 6, null, null, null));
        this.myDockerAccountSelectionPlaceHolder = jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout(0, 0));
        jPanel2.add((Component)jPanel, new GridConstraints(0, 1, 1, 1, 0, 3, 3, 3, null, null, null));
        this.myServiceLabel = jBLabel2 = new JBLabel();
        this.$$$loadLabelText$$$((JLabel)jBLabel2, DynamicBundle.getBundle((String)"messages/DockerBundle", DockerComposeCredentialsEditor.class).getString("DockerComposeCredentialsEditor.service.text"));
        jPanel2.add((Component)jBLabel2, new GridConstraints(2, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myDockerComposeServiceNameComboBox = comboBox = new ComboBox();
        DefaultComboBoxModel defaultComboBoxModel = new DefaultComboBoxModel();
        comboBox.setModel(defaultComboBoxModel);
        jPanel2.add((Component)comboBox, new GridConstraints(2, 1, 1, 1, 0, 1, 2, 0, null, null, null));
        this.myEnvsComponent = environmentVariablesComponent = new EnvironmentVariablesComponent();
        environmentVariablesComponent.setLabelLocation("West");
        environmentVariablesComponent.setText(DynamicBundle.getBundle((String)"messages/DockerBundle", DockerComposeCredentialsEditor.class).getString("DockerComposeCredentialsEditor.environment.variables.text"));
        jPanel2.add((Component)environmentVariablesComponent, new GridConstraints(3, 0, 1, 2, 0, 1, 3, 3, null, null, null));
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel2.add((Component)jPanel3, new GridConstraints(1, 1, 1, 1, 0, 3, 3, 3, null, null, null));
        DockerComposeFilesTextField dockerComposeFilesTextField = this.myConfigurationFilesTextField;
        jPanel3.add((Component)dockerComposeFilesTextField, new GridConstraints(0, 0, 1, 1, 0, 1, 3, 3, null, null, null));
        this.myConfigurationFilesLabel = jBLabel = new JBLabel();
        this.$$$loadLabelText$$$((JLabel)jBLabel, DynamicBundle.getBundle((String)"messages/DockerBundle", DockerComposeCredentialsEditor.class).getString("DockerComposeCredentialsEditor.configuration.files.text"));
        jPanel2.add((Component)jBLabel, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myMainPanel;
    }

    private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }
}

