/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.intelliLang.inject;

import com.intellij.lang.Language;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogBuilder;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Factory;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.ui.SimpleColoredText;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.util.Consumer;
import javax.swing.Icon;
import javax.swing.JComponent;
import org.intellij.plugins.intelliLang.Configuration;
import org.intellij.plugins.intelliLang.IntelliLangBundle;
import org.intellij.plugins.intelliLang.inject.InjectorUtils;
import org.intellij.plugins.intelliLang.inject.LanguageInjectionSupport;
import org.intellij.plugins.intelliLang.inject.config.BaseInjection;
import org.intellij.plugins.intelliLang.inject.config.ui.AbstractInjectionPanel;
import org.intellij.plugins.intelliLang.inject.config.ui.BaseInjectionPanel;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractLanguageInjectionSupport
extends LanguageInjectionSupport {
    @Override
    public boolean isApplicableTo(PsiLanguageInjectionHost host) {
        return false;
    }

    @Override
    public boolean useDefaultInjector(PsiLanguageInjectionHost host) {
        return false;
    }

    @Override
    @Deprecated
    public boolean useDefaultCommentInjector() {
        return true;
    }

    @Override
    @Deprecated
    @Nullable
    public BaseInjection findCommentInjection(@NotNull PsiElement host, @Nullable Ref<? super PsiElement> commentRef) {
        if (host == null) {
            AbstractLanguageInjectionSupport.$$$reportNull$$$0(0);
        }
        return InjectorUtils.findCommentInjection(host, "comment", commentRef);
    }

    @Override
    public boolean addInjectionInPlace(Language language, PsiLanguageInjectionHost psiElement) {
        return false;
    }

    @Override
    public boolean removeInjectionInPlace(PsiLanguageInjectionHost psiElement) {
        return false;
    }

    @Override
    public boolean editInjectionInPlace(PsiLanguageInjectionHost psiElement) {
        return false;
    }

    @Override
    public BaseInjection createInjection(Element element) {
        return new BaseInjection(this.getId());
    }

    @Override
    public void setupPresentation(BaseInjection injection, SimpleColoredText presentation, boolean isSelected) {
        presentation.append(injection.getDisplayName(), SimpleTextAttributes.REGULAR_ATTRIBUTES);
    }

    @Override
    public Configurable[] createSettings(Project project, Configuration configuration) {
        return new Configurable[0];
    }

    @Override
    public AnAction[] createAddActions(Project project, Consumer<? super BaseInjection> consumer) {
        return new AnAction[]{AbstractLanguageInjectionSupport.createDefaultAddAction(project, consumer, this)};
    }

    @Override
    public AnAction createEditAction(Project project, Factory<? extends BaseInjection> producer) {
        return AbstractLanguageInjectionSupport.createDefaultEditAction(project, producer);
    }

    public static AnAction createDefaultEditAction(Project project, Factory<? extends BaseInjection> producer) {
        return DumbAwareAction.create(e -> AbstractLanguageInjectionSupport.perform(project, producer));
    }

    protected static void perform(Project project, Factory<? extends BaseInjection> producer) {
        BaseInjection originalInjection = (BaseInjection)producer.create();
        BaseInjection newInjection = AbstractLanguageInjectionSupport.showDefaultInjectionUI(project, originalInjection.copy());
        if (newInjection != null) {
            originalInjection.copyFrom(newInjection);
        }
    }

    public static AnAction createDefaultAddAction(Project project, Consumer<? super BaseInjection> consumer, AbstractLanguageInjectionSupport support) {
        String supportTitle = StringUtil.capitalize((String)support.getId());
        Icon icon = FileTypeManager.getInstance().getFileTypeByExtension(support.getId()).getIcon();
        DumbAwareAction action = DumbAwareAction.create(e -> {
            BaseInjection injection = new BaseInjection(support.getId());
            injection.setDisplayName(IntelliLangBundle.message("new.language.name.injection", supportTitle));
            BaseInjection newInjection = AbstractLanguageInjectionSupport.showDefaultInjectionUI(project, injection);
            if (newInjection != null) {
                consumer.consume((Object)injection);
            }
        });
        action.getTemplatePresentation().setText(IntelliLangBundle.message("action.text.generic.0", supportTitle));
        action.getTemplatePresentation().setIcon(icon);
        return action;
    }

    @Nullable
    protected static BaseInjection showDefaultInjectionUI(Project project, BaseInjection injection) {
        BaseInjectionPanel panel = new BaseInjectionPanel(injection, project);
        panel.reset();
        String dimensionServiceKey = "#org.intellij.plugins.intelliLang.inject.config.ui.BaseInjectionDialog";
        LanguageInjectionSupport support = InjectorUtils.findInjectionSupport(injection.getSupportId());
        String helpId = support instanceof AbstractLanguageInjectionSupport ? ((AbstractLanguageInjectionSupport)support).getHelpId() : null;
        return AbstractLanguageInjectionSupport.showEditInjectionDialog(project, panel, dimensionServiceKey, helpId) ? injection : null;
    }

    protected static boolean showEditInjectionDialog(@NotNull Project project, @NotNull AbstractInjectionPanel panel, @Nullable String dimensionServiceKey, @Nullable String helpId) {
        if (project == null) {
            AbstractLanguageInjectionSupport.$$$reportNull$$$0(1);
        }
        if (panel == null) {
            AbstractLanguageInjectionSupport.$$$reportNull$$$0(2);
        }
        DialogBuilder builder = new DialogBuilder(project);
        builder.setHelpId(helpId);
        builder.addOkAction();
        builder.addCancelAction();
        builder.setDimensionServiceKey(dimensionServiceKey);
        builder.setCenterPanel((JComponent)panel.getComponent());
        builder.setTitle(IntelliLangBundle.message("language.injection.settings.title", new Object[0]));
        builder.setOkOperation(() -> {
            try {
                panel.apply();
                builder.getDialogWrapper().close(0);
            }
            catch (Exception e) {
                Throwable cause = e.getCause();
                String message = e.getMessage() + (String)(cause != null ? "\n  " + cause.getMessage() : "");
                Messages.showErrorDialog((Project)project, (String)message, (String)IntelliLangBundle.message("dialog.title.unable.to.save", new Object[0]));
            }
        });
        return builder.show() == 0;
    }

    public int hashCode() {
        return this.getId().hashCode();
    }

    public boolean equals(Object obj) {
        return obj instanceof LanguageInjectionSupport && this.getId().equals(((LanguageInjectionSupport)obj).getId());
    }

    @Nullable
    public String getHelpId() {
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "host";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "panel";
                break;
            }
        }
        objectArray2[1] = "org/intellij/plugins/intelliLang/inject/AbstractLanguageInjectionSupport";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "findCommentInjection";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "showEditInjectionDialog";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

