/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.tools.quality.psalm.remote;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.NullableFunction;
import com.intellij.util.PathMappingSettings;
import com.intellij.util.xmlb.XmlSerializer;
import com.jetbrains.php.config.interpreters.PhpInterpreter;
import com.jetbrains.php.config.interpreters.PhpInterpretersManagerImpl;
import com.jetbrains.php.config.interpreters.PhpSdkAdditionalData;
import com.jetbrains.php.remote.tools.quality.QualityToolByInterpreterConfigurableForm;
import com.jetbrains.php.remote.tools.quality.QualityToolByInterpreterDialog;
import com.jetbrains.php.run.remote.PhpRemoteInterpreterManager;
import com.jetbrains.php.tools.quality.QualityToolConfigurableForm;
import com.jetbrains.php.tools.quality.QualityToolConfiguration;
import com.jetbrains.php.tools.quality.psalm.PsalmConfigurableForm;
import com.jetbrains.php.tools.quality.psalm.PsalmConfiguration;
import com.jetbrains.php.tools.quality.psalm.PsalmConfigurationManager;
import com.jetbrains.php.tools.quality.psalm.PsalmConfigurationProvider;
import com.jetbrains.php.tools.quality.psalm.remote.PsalmRemoteConfiguration;
import java.util.List;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PsalmRemoteConfigurationProvider
extends PsalmConfigurationProvider {
    @NonNls
    private static final String PSALM_BY_INTERPRETER = "psalm_fixer_by_interpreter";

    public boolean canLoad(@NotNull String tagName) {
        if (tagName == null) {
            PsalmRemoteConfigurationProvider.$$$reportNull$$$0(0);
        }
        return StringUtil.equals((CharSequence)tagName, (CharSequence)PSALM_BY_INTERPRETER);
    }

    @Nullable
    public PsalmConfiguration load(@NotNull Element element) {
        if (element == null) {
            PsalmRemoteConfigurationProvider.$$$reportNull$$$0(1);
        }
        return (PsalmConfiguration)XmlSerializer.deserialize((Element)element, PsalmRemoteConfiguration.class);
    }

    @Nullable
    public QualityToolConfigurableForm<PsalmRemoteConfiguration> createConfigurationForm(@NotNull Project project, @NotNull PsalmConfiguration settings) {
        if (project == null) {
            PsalmRemoteConfigurationProvider.$$$reportNull$$$0(2);
        }
        if (settings == null) {
            PsalmRemoteConfigurationProvider.$$$reportNull$$$0(3);
        }
        if (settings instanceof PsalmRemoteConfiguration) {
            PsalmRemoteConfiguration remoteConfiguration = (PsalmRemoteConfiguration)settings;
            PsalmConfigurableForm<PsalmRemoteConfiguration> delegate = new PsalmConfigurableForm<PsalmRemoteConfiguration>(project, remoteConfiguration);
            return new QualityToolByInterpreterConfigurableForm<PsalmRemoteConfiguration>(project, remoteConfiguration, delegate){

                protected boolean validateWithNoAnsi() {
                    return false;
                }
            };
        }
        return null;
    }

    public PsalmConfiguration createNewInstance(@Nullable Project project, @NotNull List<PsalmConfiguration> existingSettings) {
        String id;
        QualityToolByInterpreterDialog dialog;
        if (existingSettings == null) {
            PsalmRemoteConfigurationProvider.$$$reportNull$$$0(4);
        }
        if ((dialog = new QualityToolByInterpreterDialog(project, existingSettings, "Psalm", PsalmRemoteConfiguration.class)).showAndGet() && StringUtil.isNotEmpty((String)(id = PhpInterpretersManagerImpl.getInstance((Project)project).findInterpreterId(dialog.getSelectedInterpreterName())))) {
            PsalmRemoteConfiguration settings = new PsalmRemoteConfiguration();
            settings.setInterpreterId(id);
            PhpSdkAdditionalData data = PhpInterpretersManagerImpl.getInstance((Project)project).findInterpreterDataById(id);
            PhpRemoteInterpreterManager manager = PhpRemoteInterpreterManager.getInstance();
            if (manager != null && data != null && project != null) {
                PathMappingSettings mappings = manager.createPathMappings(project, data);
                this.fillSettingsByDefaultValue(settings, (PsalmConfiguration)PsalmConfigurationManager.getInstance(project).getLocalSettings(), (NullableFunction<String, String>)((NullableFunction)localPath -> localPath == null ? null : mappings.convertToRemote(localPath)));
            }
            return settings;
        }
        return null;
    }

    public PsalmConfiguration createConfigurationByInterpreter(@NotNull PhpInterpreter interpreter) {
        if (interpreter == null) {
            PsalmRemoteConfigurationProvider.$$$reportNull$$$0(5);
        }
        PsalmRemoteConfiguration settings = new PsalmRemoteConfiguration();
        settings.setInterpreterId(interpreter.getId());
        return settings;
    }

    protected void fillSettingsByDefaultValue(@NotNull PsalmConfiguration settings, @NotNull PsalmConfiguration localConfiguration, @NotNull NullableFunction<String, String> preparePath) {
        if (settings == null) {
            PsalmRemoteConfigurationProvider.$$$reportNull$$$0(6);
        }
        if (localConfiguration == null) {
            PsalmRemoteConfigurationProvider.$$$reportNull$$$0(7);
        }
        if (preparePath == null) {
            PsalmRemoteConfigurationProvider.$$$reportNull$$$0(8);
        }
        super.fillSettingsByDefaultValue((QualityToolConfiguration)settings, (QualityToolConfiguration)localConfiguration, preparePath);
        settings.setTimeout(60000);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tagName";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "existingSettings";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "interpreter";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "localConfiguration";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "preparePath";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/php/tools/quality/psalm/remote/PsalmRemoteConfigurationProvider";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "canLoad";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "load";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "createConfigurationForm";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "createNewInstance";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "createConfigurationByInterpreter";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "fillSettingsByDefaultValue";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

