/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.tools.quality.psalm;

import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.ex.EditInspectionToolsSettingsAction;
import com.intellij.codeInspection.ex.InspectionProfileImpl;
import com.intellij.execution.ExecutionException;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationType;
import com.intellij.notification.Notifications;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.text.StringUtilRt;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.profile.codeInspection.InspectionProfileManager;
import com.intellij.profile.codeInspection.ProjectInspectionProfileManager;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiManager;
import com.jetbrains.php.tools.quality.QualityToolAnnotator;
import com.jetbrains.php.tools.quality.QualityToolProcessCreator;
import com.jetbrains.php.tools.quality.QualityToolType;
import com.jetbrains.php.tools.quality.QualityToolValidationException;
import com.jetbrains.php.tools.quality.QualityToolValidationGlobalInspection;
import com.jetbrains.php.tools.quality.QualityToolXmlMessageProcessor;
import com.jetbrains.php.tools.quality.psalm.PsalmAnnotatorProxy;
import com.jetbrains.php.tools.quality.psalm.PsalmBundle;
import com.jetbrains.php.tools.quality.psalm.PsalmConfiguration;
import com.jetbrains.php.tools.quality.psalm.PsalmOptionsPanel;
import com.jetbrains.php.tools.quality.psalm.PsalmProjectConfiguration;
import com.jetbrains.php.tools.quality.psalm.PsalmQualityToolType;
import com.jetbrains.php.tools.quality.psalm.PsalmValidationInspection;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PsalmGlobalInspection
extends QualityToolValidationGlobalInspection {
    @NlsSafe
    public String config = "";
    public boolean showInfo = false;
    public boolean findUnusedCode = false;
    public boolean findUnusedSuppress = false;
    public static final Key<List<QualityToolXmlMessageProcessor.ProblemDescription>> PSALM_ANNOTATOR_INFO = Key.create((String)"ANNOTATOR_INFO_PSALM");

    public JComponent createOptionsPanel() {
        PsalmOptionsPanel optionsPanel = new PsalmOptionsPanel(this);
        optionsPanel.init();
        return optionsPanel.getOptionsPanel();
    }

    protected void checkCmdOptions(@NotNull Project project) {
        if (project == null) {
            PsalmGlobalInspection.$$$reportNull$$$0(0);
        }
        List<String> options = this.getCommandLineOptions(null, project);
        Path path = Paths.get(project.getBasePath(), "psalm.xml");
        if (!options.contains("-c") && !Files.exists(path, new LinkOption[0])) {
            PsalmGlobalInspection.notifyAboutMissingConfig(project, path.toString());
        } else {
            path = Paths.get(options.get(options.indexOf("-c") + 1), new String[0]);
            path = Path.of(QualityToolAnnotator.updateToLocalIfRemote((String)path.toString(), (Project)project, (QualityToolType)PsalmQualityToolType.INSTANCE), new String[0]);
            if (options.contains("-c") && !Files.exists(path, new LinkOption[0])) {
                PsalmGlobalInspection.notifyAboutMissingConfig(project, path.toString());
            }
        }
    }

    public static void notifyAboutMissingConfig(final @NotNull Project project, @NotNull String path) {
        if (project == null) {
            PsalmGlobalInspection.$$$reportNull$$$0(1);
        }
        if (path == null) {
            PsalmGlobalInspection.$$$reportNull$$$0(2);
        }
        final Notification notification = new Notification("PHP External Quality Tools", PsalmQualityToolType.INSTANCE.getDisplayName(), PsalmBundle.message("psalm.config.not.found", path), NotificationType.WARNING);
        notification.addAction(new AnAction(PsalmBundle.message("action.show.inspection.settings.text", new Object[0])){

            public void actionPerformed(@NotNull AnActionEvent e) {
                if (e == null) {
                    1.$$$reportNull$$$0(0);
                }
                EditInspectionToolsSettingsAction.editToolSettings((Project)project, (InspectionProfileImpl)ProjectInspectionProfileManager.getInstance((Project)project).getCurrentProfile(), (String)PsalmQualityToolType.INSTANCE.getInspectionShortName(project));
                notification.expire();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/jetbrains/php/tools/quality/psalm/PsalmGlobalInspection$1", "actionPerformed"));
            }
        });
        notification.addAction(new AnAction(PsalmBundle.message("action.generate.psalm.xml.in.project.root.text", new Object[0])){

            public void actionPerformed(@NotNull AnActionEvent e) {
                if (e == null) {
                    2.$$$reportNull$$$0(0);
                }
                try {
                    PsalmConfiguration configuration = (PsalmConfiguration)PsalmProjectConfiguration.getInstance(project).findSelectedConfiguration(project, false);
                    if (configuration == null) {
                        return;
                    }
                    QualityToolProcessCreator.getToolOutput((Project)project, (String)configuration.getInterpreterId(), (String)configuration.getToolPath(), (int)configuration.getTimeout(), (String)PsalmBundle.message("action.generate.psalm.xml.in.project.root", new Object[0]), null, (String[])new String[]{"--init", ".", "3"});
                    Path configPath = Paths.get(project.getBasePath(), "psalm.xml");
                    VfsUtil.markDirtyAndRefresh((boolean)true, (boolean)false, (boolean)false, (File[])new File[]{new File(configPath.toString())});
                    this.updateInspectionSettings(configPath);
                    notification.expire();
                }
                catch (ExecutionException | QualityToolValidationException exception) {
                    Notifications.Bus.notify((Notification)new Notification("PHP External Quality Tools", PsalmQualityToolType.INSTANCE.getDisplayName(), PsalmBundle.message("psalm.config.not.generated", new Object[0]), NotificationType.WARNING));
                }
            }

            private void updateInspectionSettings(Path configPath) {
                VirtualFile projectDir = project.getBaseDir();
                if (projectDir == null) {
                    return;
                }
                PsiDirectory file = PsiManager.getInstance((Project)project).findDirectory(projectDir);
                if (file == null) {
                    return;
                }
                InspectionProfileManager.getInstance((Project)project).getCurrentProfile().modifyToolSettings(Key.create((String)PsalmQualityToolType.INSTANCE.getInspectionId()), (PsiElement)file, inspection -> {
                    inspection.config = configPath.toString();
                });
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/jetbrains/php/tools/quality/psalm/PsalmGlobalInspection$2", "actionPerformed"));
            }
        });
        Notifications.Bus.notify((Notification)notification);
    }

    @Nullable
    public LocalInspectionTool getSharedLocalInspectionTool() {
        return new PsalmValidationInspection();
    }

    @NotNull
    protected QualityToolAnnotator getAnnotator() {
        PsalmAnnotatorProxy psalmAnnotatorProxy = PsalmAnnotatorProxy.INSTANCE;
        if (psalmAnnotatorProxy == null) {
            PsalmGlobalInspection.$$$reportNull$$$0(3);
        }
        return psalmAnnotatorProxy;
    }

    protected Key<List<QualityToolXmlMessageProcessor.ProblemDescription>> getKey() {
        return PSALM_ANNOTATOR_INFO;
    }

    public List<String> getCommandLineOptions(@Nullable String filePath, Project project) {
        @NonNls ArrayList<String> options = new ArrayList<String>();
        options.add("--output-format=checkstyle");
        if (!StringUtilRt.isEmpty((CharSequence)this.config)) {
            options.add("-c");
            options.add(QualityToolAnnotator.updateIfRemote((String)this.config, (Project)project, (QualityToolType)PsalmQualityToolType.INSTANCE));
        }
        if (this.showInfo) {
            options.add("--show-info");
        }
        if (this.findUnusedCode) {
            options.add("--find-unused-code");
        }
        if (this.findUnusedSuppress) {
            options.add("--find-unused-psalm-suppress");
        }
        options.add("--monochrome");
        if (filePath != null) {
            options.add(filePath);
        }
        return options;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/tools/quality/psalm/PsalmGlobalInspection";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/tools/quality/psalm/PsalmGlobalInspection";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getAnnotator";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "checkCmdOptions";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "notifyAboutMissingConfig";
                break;
            }
            case 3: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

