/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.psalm.types;

import com.intellij.psi.PsiElement;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.indexing.DataIndexer;
import com.intellij.util.indexing.FileBasedIndex;
import com.intellij.util.indexing.FileBasedIndexExtension;
import com.intellij.util.indexing.FileContent;
import com.intellij.util.indexing.ID;
import com.intellij.util.io.DataExternalizer;
import com.intellij.util.io.EnumeratorStringDescriptor;
import com.intellij.util.io.KeyDescriptor;
import com.jetbrains.php.lang.PhpLangUtil;
import com.jetbrains.php.lang.documentation.phpdoc.psi.PhpDocComment;
import com.jetbrains.php.lang.documentation.phpdoc.psi.PhpDocType;
import com.jetbrains.php.lang.documentation.phpdoc.psi.tags.PhpDocParamTag;
import com.jetbrains.php.lang.documentation.phpdoc.psi.tags.PhpDocTag;
import com.jetbrains.php.lang.inspections.parameterCountMismatch.PhpFuncGetArgUsageProvider;
import com.jetbrains.php.lang.psi.PhpFile;
import com.jetbrains.php.lang.psi.elements.Function;
import com.jetbrains.php.lang.psi.elements.Parameter;
import com.jetbrains.php.lang.psi.elements.PhpPsiElement;
import com.jetbrains.php.lang.psi.resolve.types.PhpMetaTypeMappingsTable;
import com.jetbrains.php.lang.psi.resolve.types.PhpTypeSignatureKey;
import com.jetbrains.php.lang.psi.stubs.indexes.PhpConstantNameIndex;
import com.jetbrains.php.psalm.types.PsalmExtendedTypeProvider;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Stream;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PsalmTemplateIndex
extends FileBasedIndexExtension<String, PhpMetaTypeMappingsTable> {
    @NonNls
    public static final ID<String, PhpMetaTypeMappingsTable> KEY = ID.create((String)"php.psalm.template.index");

    @NotNull
    public ID<String, PhpMetaTypeMappingsTable> getName() {
        ID<String, PhpMetaTypeMappingsTable> iD = KEY;
        if (iD == null) {
            PsalmTemplateIndex.$$$reportNull$$$0(0);
        }
        return iD;
    }

    @NotNull
    public DataIndexer<String, PhpMetaTypeMappingsTable, FileContent> getIndexer() {
        DataIndexer dataIndexer = inputData -> {
            PhpFile file = (PhpFile)ObjectUtils.tryCast((Object)inputData.getPsiFile(), PhpFile.class);
            if (file == null) {
                return Collections.emptyMap();
            }
            return file.getTopLevelDefs().values().stream().flatMap(PhpFuncGetArgUsageProvider::getFunctions).map(PsalmTemplateIndex::getMap).reduce(new HashMap(), ContainerUtil::union);
        };
        if (dataIndexer == null) {
            PsalmTemplateIndex.$$$reportNull$$$0(1);
        }
        return dataIndexer;
    }

    private static Map<String, PhpMetaTypeMappingsTable> getMap(Function f) {
        PhpDocComment comment = f.getDocComment();
        if (comment == null) {
            return Collections.emptyMap();
        }
        Collection<String> templates = PsalmExtendedTypeProvider.getTemplates(comment);
        if (templates.isEmpty()) {
            return Collections.emptyMap();
        }
        Collection<PhpDocTag> returnTags = PsalmTemplateIndex.getReturnTags(comment);
        if (returnTags.isEmpty()) {
            return Collections.emptyMap();
        }
        List<PhpDocParamTag> paramTags = PsalmTemplateIndex.getParamTags(comment);
        List<Parameter> parameters = Arrays.asList(f.getParameters());
        int[] parametersIndicesToReturn = returnTags.stream().flatMap(returnTag -> PsalmTemplateIndex.getDocTypesWithText(returnTag, templates).stream()).map(PsiElement::getText).distinct().flatMap(returnTemplate -> PsalmTemplateIndex.paramNamesWithSameReturnTemplate(paramTags, returnTemplate)).distinct().mapToInt(name -> ContainerUtil.indexOf((List)parameters, p -> PhpLangUtil.equalsParameterNames((CharSequence)name, (CharSequence)p.getName()))).filter(i -> i >= 0).toArray();
        if (parametersIndicesToReturn.length == 0) {
            return Collections.emptyMap();
        }
        PhpMetaTypeMappingsTable table = new PhpMetaTypeMappingsTable();
        for (int parameterIndexToReturn : parametersIndicesToReturn) {
            table.put("\u03c0\u2020", String.valueOf(parameterIndexToReturn));
        }
        return Map.of(PhpTypeSignatureKey.getSignature((Function)f), table);
    }

    private static Collection<PhpDocTag> getReturnTags(PhpDocComment comment) {
        ArrayList<PhpDocTag> res = new ArrayList<PhpDocTag>();
        ContainerUtil.addIfNotNull(res, (Object)comment.getReturnTag());
        res.addAll(Arrays.asList(comment.getTagElementsByName("@psalm-return")));
        return res;
    }

    @NotNull
    private static List<PhpDocParamTag> getParamTags(PhpDocComment comment) {
        ArrayList<PhpDocParamTag> res = new ArrayList<PhpDocParamTag>(comment.getParamTags());
        for (PhpDocTag tag : comment.getTagElementsByName("@psalm-param")) {
            res.add((PhpDocParamTag)tag);
        }
        ArrayList<PhpDocParamTag> arrayList = res;
        if (arrayList == null) {
            PsalmTemplateIndex.$$$reportNull$$$0(2);
        }
        return arrayList;
    }

    @NotNull
    private static Stream<String> paramNamesWithSameReturnTemplate(List<PhpDocParamTag> paramTags, String returnTemplate) {
        Stream<String> stream = paramTags.stream().filter(tag -> !PsalmTemplateIndex.getDocTypesWithText((PhpDocTag)tag, Collections.singleton(returnTemplate)).isEmpty()).map(PhpDocParamTag::getVarName).filter(Objects::nonNull);
        if (stream == null) {
            PsalmTemplateIndex.$$$reportNull$$$0(3);
        }
        return stream;
    }

    private static Collection<PhpDocType> getDocTypesWithText(@Nullable PhpDocTag tag, Collection<String> texts) {
        if (tag == null) {
            return Collections.emptyList();
        }
        ArrayList<PhpDocType> res = new ArrayList<PhpDocType>();
        for (PhpPsiElement child = tag.getFirstPsiChild(); child != null; child = child.getNextPsiSibling()) {
            if (!(child instanceof PhpDocType) || !texts.contains(child.getText())) continue;
            res.add((PhpDocType)child);
        }
        return res;
    }

    @NotNull
    public KeyDescriptor<String> getKeyDescriptor() {
        EnumeratorStringDescriptor enumeratorStringDescriptor = EnumeratorStringDescriptor.INSTANCE;
        if (enumeratorStringDescriptor == null) {
            PsalmTemplateIndex.$$$reportNull$$$0(4);
        }
        return enumeratorStringDescriptor;
    }

    @NotNull
    public DataExternalizer<PhpMetaTypeMappingsTable> getValueExternalizer() {
        DataExternalizer dataExternalizer = PhpMetaTypeMappingsTable.EXTERNALIZER;
        if (dataExternalizer == null) {
            PsalmTemplateIndex.$$$reportNull$$$0(5);
        }
        return dataExternalizer;
    }

    public int getVersion() {
        return 2;
    }

    public // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull FileBasedIndex.InputFilter getInputFilter() {
        FileBasedIndex.InputFilter inputFilter = PhpConstantNameIndex.PHP_INPUT_FILTER;
        if (inputFilter == null) {
            PsalmTemplateIndex.$$$reportNull$$$0(6);
        }
        return inputFilter;
    }

    public boolean dependsOnFileContent() {
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/jetbrains/php/psalm/types/PsalmTemplateIndex";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getIndexer";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getParamTags";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "paramNamesWithSameReturnTemplate";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getKeyDescriptor";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getValueExternalizer";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getInputFilter";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }
}

