/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.psalm.types;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.php.lang.documentation.phpdoc.PhpDocUtil;
import com.jetbrains.php.lang.documentation.phpdoc.lexer.PhpDocTokenTypes;
import com.jetbrains.php.lang.documentation.phpdoc.psi.PhpDocComment;
import com.jetbrains.php.lang.documentation.phpdoc.psi.PhpDocType;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.PhpClass;
import com.jetbrains.php.lang.psi.elements.PhpNamedElement;
import com.jetbrains.php.lang.psi.elements.PhpPsiElement;
import com.jetbrains.php.lang.psi.resolve.types.PhpCharBasedTypeKey;
import com.jetbrains.php.lang.psi.resolve.types.PhpType;
import com.jetbrains.php.lang.psi.resolve.types.PhpTypeProvider4;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PsalmExtendedTypeProvider
implements PhpTypeProvider4 {
    private static final PhpCharBasedTypeKey KEY = new PhpCharBasedTypeKey(){

        public char getKey() {
            return '\u1890';
        }
    };

    public char getKey() {
        return KEY.getKey();
    }

    @Nullable
    public PhpType getType(PsiElement element) {
        String name;
        PhpDocComment docComment;
        if (element instanceof PhpDocType && PsalmExtendedTypeProvider.declaredInCustomTypeDocTag(docComment = (PhpDocComment)PhpPsiUtil.getParentByCondition((PsiElement)element, (Condition)PhpDocComment.INSTANCEOF), name = ((PhpDocType)element).getName())) {
            return new PhpType().add(KEY.sign((CharSequence)name));
        }
        return null;
    }

    private static boolean declaredInCustomTypeDocTag(@Nullable PhpDocComment docComment, String name) {
        return PsalmExtendedTypeProvider.getTemplates(docComment).contains(name) || PsalmExtendedTypeProvider.getCustomTypes(docComment).contains(name);
    }

    public static Collection<String> getCustomTypes(PhpDocComment docComment) {
        return ContainerUtil.union(PsalmExtendedTypeProvider.getTypeNames(docComment, "@psalm-type"), PsalmExtendedTypeProvider.getImportedTypeNames(docComment));
    }

    @NotNull
    public static Collection<String> getTemplates(@Nullable PhpDocComment docComment) {
        Collection<String> collection = PsalmExtendedTypeProvider.getTypeNames(docComment, "@template", "@psalm-template", "@template-covariant");
        if (collection == null) {
            PsalmExtendedTypeProvider.$$$reportNull$$$0(0);
        }
        return collection;
    }

    private static Collection<String> getTypeNames(@Nullable PhpDocComment docComment, String ... tagNames) {
        return PsalmExtendedTypeProvider.getNamesInCurrentCommentOrClass(docComment, c -> PsalmExtendedTypeProvider.tagValues(c, tagNames).map(value -> PhpPsiUtil.getChildOfType((PsiElement)value, (IElementType)PhpDocTokenTypes.DOC_IDENTIFIER)).filter(Objects::nonNull).map(PsiElement::getText).collect(Collectors.toSet()));
    }

    private static Collection<String> getNamesInCurrentCommentOrClass(PhpDocComment docComment, Function<@Nullable PhpDocComment, Collection<String>> f) {
        if (docComment == null) {
            return Collections.emptySet();
        }
        Set names = Collections.emptySet();
        for (PsiElement owner = docComment.getOwner(); owner != null; owner = owner.getParent()) {
            if (!(owner instanceof PhpPsiElement)) continue;
            PhpDocComment comment = owner instanceof PhpNamedElement ? ((PhpNamedElement)owner).getDocComment() : PhpPsiUtil.getDocCommentFor((PhpPsiElement)((PhpPsiElement)owner));
            names = ContainerUtil.union(f.apply(comment), names);
            if (owner instanceof PhpClass && !((PhpClass)owner).isAnonymous()) break;
        }
        return names;
    }

    @NotNull
    private static Stream<PhpPsiElement> tagValues(@Nullable PhpDocComment docComment, String ... tagNames) {
        if (docComment == null) {
            Stream<PhpPsiElement> stream = Stream.empty();
            if (stream == null) {
                PsalmExtendedTypeProvider.$$$reportNull$$$0(1);
            }
            return stream;
        }
        ArrayList docTags = new ArrayList();
        PhpDocUtil.processTagElementsByNames((PhpDocComment)docComment, tag -> {
            docTags.add(tag);
            return true;
        }, (String[])tagNames);
        Stream<PhpPsiElement> stream = docTags.stream().map(PhpPsiElement::getFirstPsiChild).filter(Objects::nonNull);
        if (stream == null) {
            PsalmExtendedTypeProvider.$$$reportNull$$$0(2);
        }
        return stream;
    }

    private static Collection<String> getImportedTypeNames(@Nullable PhpDocComment docComment) {
        return PsalmExtendedTypeProvider.getNamesInCurrentCommentOrClass(docComment, c -> PsalmExtendedTypeProvider.tagValues(c, "@psalm-import-type").map(PsalmExtendedTypeProvider::getImportedName).filter(Objects::nonNull).map(PsiElement::getText).collect(Collectors.toSet()));
    }

    private static PsiElement getImportedName(PhpPsiElement value) {
        List<PsiElement> docIdentifiers = PsalmExtendedTypeProvider.getDocIdentifiers(value);
        return docIdentifiers.size() >= 5 ? (PsiElement)ContainerUtil.getLastItem(docIdentifiers) : (PsiElement)ContainerUtil.getFirstItem(docIdentifiers);
    }

    @NotNull
    private static List<PsiElement> getDocIdentifiers(PhpPsiElement value) {
        ArrayList<PsiElement> docIdentifiers = new ArrayList<PsiElement>();
        for (PsiElement child = value.getFirstChild(); child != null; child = child.getNextSibling()) {
            if (!PhpPsiUtil.isOfType((PsiElement)child, (IElementType)PhpDocTokenTypes.DOC_IDENTIFIER)) continue;
            docIdentifiers.add(child);
        }
        ArrayList<PsiElement> arrayList = docIdentifiers;
        if (arrayList == null) {
            PsalmExtendedTypeProvider.$$$reportNull$$$0(3);
        }
        return arrayList;
    }

    @Nullable
    public PhpType complete(String expression, Project project) {
        return PhpType.isPluralType((String)expression) ? PhpType.ARRAY : PhpType.MIXED;
    }

    public Collection<? extends PhpNamedElement> getBySignature(String expression, Set<String> visited, int depth, Project project) {
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/jetbrains/php/psalm/types/PsalmExtendedTypeProvider";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getTemplates";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "tagValues";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getDocIdentifiers";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }
}

