/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.psalm.types;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.php.lang.documentation.phpdoc.parser.PhpDocElementTypes;
import com.jetbrains.php.lang.documentation.phpdoc.psi.PhpDocType;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.PhpNamedElement;
import com.jetbrains.php.lang.psi.resolve.types.PhpCharBasedTypeKey;
import com.jetbrains.php.lang.psi.resolve.types.PhpType;
import com.jetbrains.php.lang.psi.resolve.types.PhpTypeProvider4;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PsalmExtendedStringDocTypeProvider
implements PhpTypeProvider4 {
    private static final Collection<String> EXTENDED_STRINGS = List.of("class-string", "callable-string", "numeric-string", "non-empty-string", "trait-string");
    @NotNull
    private static final PhpType NUMERIC_TYPE = PhpType.builder().add(PhpType.STRING).add(PhpType.INT).add(PhpType.FLOAT).build();
    public static final Map<String, PhpType> NO_RETURN_TYPES = Map.of("never-return", PhpType.VOID, "never-returns", PhpType.VOID, "no-return", PhpType.VOID);
    private static final Map<String, PhpType> ALTERNATIVE_SCALAR_TYPES = ContainerUtil.union(Map.of("scalar", PhpType.SCALAR, "numeric", NUMERIC_TYPE, "array-key", PhpType.NUMERIC, "empty", PhpType.MIXED, "positive-int", PhpType.INT, "closed-resource", PhpType.RESOURCE), NO_RETURN_TYPES);
    public static final Collection<String> EXTENDED_SCALAR_TYPES = ContainerUtil.union(EXTENDED_STRINGS, ALTERNATIVE_SCALAR_TYPES.keySet());
    private static final PhpCharBasedTypeKey KEY = new PhpCharBasedTypeKey(){

        public char getKey() {
            return '\u1894';
        }
    };

    public char getKey() {
        return KEY.getKey();
    }

    @Nullable
    public PhpType getType(PsiElement element) {
        PhpType type;
        if (element instanceof PhpDocType && !(type = this.getScalarType((PhpDocType)element)).isEmpty()) {
            PsiElement attributes = PhpPsiUtil.getChildOfType((PsiElement)element, (IElementType)PhpDocElementTypes.phpDocAttributeList);
            String attributesText = attributes != null ? attributes.getText() : null;
            return type.map(name -> KEY.sign((CharSequence)(attributesText != null ? name + "." + attributesText : name)));
        }
        return null;
    }

    @NotNull
    public PhpType getScalarType(PhpDocType element) {
        String name = StringUtil.toLowerCase((String)element.getName());
        if (ALTERNATIVE_SCALAR_TYPES.containsKey(name)) {
            PhpType phpType = ALTERNATIVE_SCALAR_TYPES.get(name);
            if (phpType == null) {
                PsalmExtendedStringDocTypeProvider.$$$reportNull$$$0(0);
            }
            return phpType;
        }
        if (EXTENDED_STRINGS.contains(name)) {
            PhpType phpType = PhpType.STRING;
            if (phpType == null) {
                PsalmExtendedStringDocTypeProvider.$$$reportNull$$$0(1);
            }
            return phpType;
        }
        PhpType phpType = PhpType.EMPTY;
        if (phpType == null) {
            PsalmExtendedStringDocTypeProvider.$$$reportNull$$$0(2);
        }
        return phpType;
    }

    @Nullable
    public PhpType complete(String expression, Project project) {
        String expr = expression.substring(2);
        int dimension = PhpType.getPluralDimension((String)expression);
        expr = PhpType.unpluralize((String)expr, (int)dimension);
        int lastDot = expr.lastIndexOf(46);
        return new PhpType().add(lastDot > 0 ? expr.substring(0, lastDot) : expr).pluralise(dimension);
    }

    public Collection<? extends PhpNamedElement> getBySignature(String expression, Set<String> visited, int depth, Project project) {
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/php/psalm/types/PsalmExtendedStringDocTypeProvider", "getScalarType"));
    }
}

