/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.psalm.types;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.jetbrains.php.PhpIndex;
import com.jetbrains.php.lang.PhpLangUtil;
import com.jetbrains.php.lang.documentation.phpdoc.lexer.PhpDocTokenTypes;
import com.jetbrains.php.lang.documentation.phpdoc.psi.PhpDocRef;
import com.jetbrains.php.lang.documentation.phpdoc.psi.PhpDocType;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.Field;
import com.jetbrains.php.lang.psi.elements.PhpClass;
import com.jetbrains.php.lang.psi.elements.PhpNamedElement;
import com.jetbrains.php.lang.psi.elements.PhpNamespaceReference;
import com.jetbrains.php.lang.psi.elements.PhpPsiElement;
import com.jetbrains.php.lang.psi.elements.impl.PhpReferenceImpl;
import com.jetbrains.php.lang.psi.resolve.types.PhpType;
import com.jetbrains.php.lang.psi.resolve.types.PhpTypeProvider4;
import com.jetbrains.php.lang.psi.resolve.types.PhpTypeSignatureKey;
import java.util.Collection;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PsalmExtendedClassConstantReferenceTypeProvider
implements PhpTypeProvider4 {
    private static final Condition<PsiElement> IS_DOC_IDENTIFIER = e -> PhpPsiUtil.isOfType((PsiElement)e, (IElementType)PhpDocTokenTypes.DOC_IDENTIFIER);
    private static final char KEY = '\u1895';

    public char getKey() {
        return '\u1895';
    }

    @Nullable
    public PhpType getType(PsiElement element) {
        if (element instanceof PhpDocType) {
            PhpPsiElement child = ((PhpDocType)element).getFirstPsiChild();
            if (child instanceof PhpDocRef) {
                return this.getType((PhpDocRef)child);
            }
        } else if (element instanceof PhpDocRef) {
            return this.getType((PhpDocRef)element);
        }
        return null;
    }

    private PhpType getType(PhpDocRef docRef) {
        PhpNamespaceReference reference = (PhpNamespaceReference)PhpPsiUtil.getChildByCondition((PsiElement)docRef, (Condition)PhpNamespaceReference.INSTANCEOF);
        String immediateNamespaceName = reference != null ? reference.getFullName() : "";
        String namespaceName = PhpReferenceImpl.findNamespaceName((String)immediateNamespaceName, (PsiElement)docRef);
        PsiElement docStatic = PhpPsiUtil.getChildOfType((PsiElement)docRef, (IElementType)PhpDocTokenTypes.DOC_STATIC);
        if (docStatic == null) {
            return null;
        }
        PsiElement className = PhpPsiUtil.getPrevSiblingByCondition((PsiElement)docStatic, IS_DOC_IDENTIFIER);
        PsiElement constantName = PhpPsiUtil.getNextSiblingByCondition((PsiElement)docStatic, IS_DOC_IDENTIFIER);
        if (className == null || constantName == null) {
            return null;
        }
        String constantFQN = PhpTypeSignatureKey.CLASS.sign((CharSequence)PhpLangUtil.concat((String)namespaceName, (String)className.getText())) + "." + constantName.getText();
        return new PhpType().add(PsalmExtendedClassConstantReferenceTypeProvider.isWildcard(constantName) ? this.sign(constantFQN) : PhpTypeSignatureKey.CLASS_CONSTANT.sign((CharSequence)constantFQN));
    }

    private static boolean isWildcard(PsiElement constantName) {
        PsiElement sibling = constantName.getNextSibling();
        return PhpPsiUtil.isOfType((PsiElement)sibling, (IElementType)PhpDocTokenTypes.DOC_TEXT) && sibling.textMatches((CharSequence)"*");
    }

    @NotNull
    private String sign(String name) {
        String string = "#" + this.getKey() + name;
        if (string == null) {
            PsalmExtendedClassConstantReferenceTypeProvider.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Nullable
    public PhpType complete(String expression, Project project) {
        return null;
    }

    public Collection<? extends PhpNamedElement> getBySignature(String expression, Set<String> visited, int depth, Project project) {
        int separatorIndex = expression.lastIndexOf(46);
        String pattern = expression.substring(separatorIndex + 1);
        return PhpIndex.getInstance((Project)project).getBySignature(expression.substring(0, separatorIndex)).stream().map(e -> e instanceof PhpClass ? (PhpClass)e : null).filter(Objects::nonNull).flatMap(c -> c.getFields().stream()).filter(Field::isConstant).filter(e -> StringUtil.startsWith((CharSequence)e.getName(), (CharSequence)pattern)).collect(Collectors.toSet());
    }

    public static boolean isSigned(String type) {
        return StringUtil.startsWith((CharSequence)type, (CharSequence)"#\u1895");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/php/psalm/types/PsalmExtendedClassConstantReferenceTypeProvider", "sign"));
    }
}

