/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.psalm.types;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.php.lang.PhpLangUtil;
import com.jetbrains.php.lang.documentation.phpdoc.lexer.PhpDocTokenTypes;
import com.jetbrains.php.lang.documentation.phpdoc.parser.PhpDocElementTypes;
import com.jetbrains.php.lang.documentation.phpdoc.psi.PhpDocType;
import com.jetbrains.php.lang.documentation.phpdoc.psi.tags.PhpDocParamTag;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.PhpNamedElement;
import com.jetbrains.php.lang.psi.elements.PhpUse;
import com.jetbrains.php.lang.psi.resolve.types.PhpCharBasedTypeKey;
import com.jetbrains.php.lang.psi.resolve.types.PhpType;
import com.jetbrains.php.lang.psi.resolve.types.PhpTypeProvider4;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PsalmAdvancedCallableTypeProvider
extends PhpCharBasedTypeKey
implements PhpTypeProvider4 {
    static final char KEY = '\u1913';
    private static final String TYPES_SEPARATOR = String.valueOf('\u1913');
    private static final String PARAMETERS_RETURN_SEPARATOR = ".";
    private static final String PARAMETERS_SEPARATOR = ",";
    private static final String CALLABLE_SEPARATOR = ".";
    private static final Collection<String> ADVANCED_CALLABLES = Set.of("\\Closure", "\\callable");

    @Nullable
    public PhpType getType(PsiElement element) {
        if (element instanceof PhpDocType && PsalmAdvancedCallableTypeProvider.isAdvancedCallable(element)) {
            String fqn = PsalmAdvancedCallableTypeProvider.resolveFQN((PhpDocType)element);
            if (!ADVANCED_CALLABLES.contains(fqn)) {
                return null;
            }
            String returnType = PsalmAdvancedCallableTypeProvider.getSerializedDocTypes(element);
            String parameterTypes = PhpPsiUtil.getChildren((PsiElement)element, PhpDocParamTag.class::isInstance).stream().map(PsalmAdvancedCallableTypeProvider::getSerializedDocTypes).collect(Collectors.joining(PARAMETERS_SEPARATOR));
            return new PhpType().add(this.sign(fqn + "." + parameterTypes + "." + returnType));
        }
        return null;
    }

    private static String getSerializedDocTypes(PsiElement element) {
        return Arrays.stream(element.getNode().getChildren(TokenSet.create((IElementType[])new IElementType[]{PhpDocElementTypes.phpDocType}))).map(ASTNode::getPsi).filter(Objects::nonNull).flatMap(e -> new PhpType().add(e).getTypes().stream()).collect(Collectors.joining(TYPES_SEPARATOR));
    }

    @Nullable
    public PhpType complete(String expression, Project project) {
        return new PhpType().add(expression.substring(2, expression.indexOf(".")));
    }

    public Collection<? extends PhpNamedElement> getBySignature(String expression, Set<String> visited, int depth, Project project) {
        return null;
    }

    public char getKey() {
        return '\u1913';
    }

    private static boolean isAdvancedCallable(PsiElement element) {
        return ContainerUtil.exists((Object[])element.getNode().getChildren(TokenSet.create((IElementType[])new IElementType[]{PhpDocTokenTypes.DOC_TEXT})), e -> e.getText().equals(":"));
    }

    @NotNull
    private static String resolveFQN(@NotNull PhpDocType element) {
        String name;
        if (element == null) {
            PsalmAdvancedCallableTypeProvider.$$$reportNull$$$0(0);
        }
        if ((name = element.getName()) != null && ADVANCED_CALLABLES.contains(PhpLangUtil.toFQN((String)name))) {
            String string = PhpLangUtil.toFQN((String)name);
            if (string == null) {
                PsalmAdvancedCallableTypeProvider.$$$reportNull$$$0(1);
            }
            return string;
        }
        PhpNamedElement useElement = (PhpNamedElement)ContainerUtil.getOnlyItem((Collection)element.resolveLocal());
        String string = useElement instanceof PhpUse ? useElement.getFQN() : element.getFQN();
        if (string == null) {
            PsalmAdvancedCallableTypeProvider.$$$reportNull$$$0(2);
        }
        return string;
    }

    public static boolean isSigned(String s) {
        return s.charAt(1) == '\u1913';
    }

    @NotNull
    public static PhpType getReturnType(String incompleteAdvancedCallableType) {
        return PsalmAdvancedCallableTypeProvider.getType(incompleteAdvancedCallableType.substring(incompleteAdvancedCallableType.lastIndexOf(".") + 1));
    }

    @NotNull
    public static List<PhpType> getParametersTypes(String incompleteAdvancedCallableType) {
        String signature = incompleteAdvancedCallableType.substring(incompleteAdvancedCallableType.indexOf(".") + 1, incompleteAdvancedCallableType.lastIndexOf("."));
        List list = ContainerUtil.map((Collection)StringUtil.split((String)signature, (String)PARAMETERS_SEPARATOR), PsalmAdvancedCallableTypeProvider::getType);
        if (list == null) {
            PsalmAdvancedCallableTypeProvider.$$$reportNull$$$0(3);
        }
        return list;
    }

    @NotNull
    private static PhpType getType(String serializedType) {
        PhpType type = new PhpType();
        StringUtil.split((String)serializedType, (String)TYPES_SEPARATOR).forEach(arg_0 -> ((PhpType)type).add(arg_0));
        PhpType phpType = type;
        if (phpType == null) {
            PsalmAdvancedCallableTypeProvider.$$$reportNull$$$0(4);
        }
        return phpType;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/psalm/types/PsalmAdvancedCallableTypeProvider";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/psalm/types/PsalmAdvancedCallableTypeProvider";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "resolveFQN";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getParametersTypes";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "resolveFQN";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

