/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.psalm.lang.inspections;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.jetbrains.php.PhpIndex;
import com.jetbrains.php.PhpIndexImpl;
import com.jetbrains.php.lang.inspections.PhpInspection;
import com.jetbrains.php.lang.inspections.type.PhpParamsInspection;
import com.jetbrains.php.lang.psi.elements.FunctionReference;
import com.jetbrains.php.lang.psi.resolve.types.PhpType;
import com.jetbrains.php.lang.psi.visitors.PhpElementVisitor;
import com.jetbrains.php.psalm.types.PsalmAdvancedCallableTypeProvider;
import com.jetbrains.php.tools.quality.psalm.PsalmBundle;
import java.util.HashSet;
import java.util.List;
import java.util.function.Function;
import org.jetbrains.annotations.NotNull;

public class PsalmAdvanceCallableParamsInspection
extends PhpInspection {
    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            PsalmAdvanceCallableParamsInspection.$$$reportNull$$$0(0);
        }
        return new PhpElementVisitor(){

            public void visitPhpFunctionCall(FunctionReference reference) {
                if (StringUtil.isEmpty((String)reference.getName())) {
                    PsiElement[] parameters = reference.getParameters();
                    if (parameters.length == 0) {
                        return;
                    }
                    List<PhpType> parameterTypes = this.getAdvancedCallableParametersTypes(reference);
                    if (parameterTypes != null) {
                        for (int i = 0; i < Math.min(parameters.length, parameterTypes.size()); ++i) {
                            PhpType callType = new PhpType().add(parameters[i]);
                            if (PhpParamsInspection.isCallTypeConvertibleFromDeclaredType((PhpType)callType, (PhpType)parameterTypes.get(i), (PhpIndex)PhpIndex.getInstance((Project)holder.getProject()))) continue;
                            String message = PsalmBundle.message("parameter.type.is.not.compatible.with.declaration", callType.toStringResolved(), parameterTypes.get(i).toStringResolved());
                            holder.registerProblem(parameters[i], message, new LocalQuickFix[0]);
                        }
                    }
                }
            }

            private List<PhpType> getAdvancedCallableParametersTypes(FunctionReference reference) {
                Ref paramTypes = new Ref();
                Function<String, PhpType> paramsTypeSearcher = s -> {
                    if (PsalmAdvancedCallableTypeProvider.isSigned(s)) {
                        paramTypes.set(PsalmAdvancedCallableTypeProvider.getParametersTypes(s));
                    }
                    return null;
                };
                ((PhpIndexImpl)PhpIndex.getInstance((Project)holder.getProject())).completeType(holder.getProject(), new PhpType().add((PsiElement)reference.getFirstPsiChild()), new HashSet(), paramsTypeSearcher);
                return (List)paramTypes.get();
            }
        };
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/jetbrains/php/psalm/lang/inspections/PsalmAdvanceCallableParamsInspection", "buildVisitor"));
    }
}

