/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.cucumber.psi.annotator;

import com.intellij.lang.ASTNode;
import com.intellij.lang.annotation.AnnotationHolder;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtilCore;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.cucumber.CucumberBundle;
import org.jetbrains.plugins.cucumber.psi.GherkinElementVisitor;
import org.jetbrains.plugins.cucumber.psi.GherkinExamplesBlock;
import org.jetbrains.plugins.cucumber.psi.GherkinHighlighter;
import org.jetbrains.plugins.cucumber.psi.GherkinPsiUtil;
import org.jetbrains.plugins.cucumber.psi.GherkinPystring;
import org.jetbrains.plugins.cucumber.psi.GherkinScenarioOutline;
import org.jetbrains.plugins.cucumber.psi.GherkinStep;
import org.jetbrains.plugins.cucumber.psi.GherkinStepParameter;
import org.jetbrains.plugins.cucumber.psi.GherkinStepsHolder;
import org.jetbrains.plugins.cucumber.psi.GherkinTable;
import org.jetbrains.plugins.cucumber.psi.GherkinTableCell;
import org.jetbrains.plugins.cucumber.psi.GherkinTableRow;
import org.jetbrains.plugins.cucumber.psi.GherkinTokenTypes;
import org.jetbrains.plugins.cucumber.psi.impl.GherkinExamplesBlockImpl;
import org.jetbrains.plugins.cucumber.psi.impl.GherkinExamplesNavigator;
import org.jetbrains.plugins.cucumber.psi.impl.GherkinScenarioOutlineImpl;
import org.jetbrains.plugins.cucumber.psi.impl.GherkinTableHeaderRowImpl;
import org.jetbrains.plugins.cucumber.psi.impl.GherkinTableImpl;
import org.jetbrains.plugins.cucumber.psi.impl.GherkinTableNavigator;
import org.jetbrains.plugins.cucumber.steps.AbstractStepDefinition;
import org.jetbrains.plugins.cucumber.steps.reference.CucumberStepReference;

public class GherkinAnnotatorVisitor
extends GherkinElementVisitor {
    private final AnnotationHolder myHolder;

    public GherkinAnnotatorVisitor(@NotNull AnnotationHolder holder) {
        if (holder == null) {
            GherkinAnnotatorVisitor.$$$reportNull$$$0(0);
        }
        this.myHolder = holder;
    }

    private void highlight(PsiElement element, TextAttributesKey colorKey) {
        this.myHolder.newSilentAnnotation(HighlightSeverity.INFORMATION).range(element).textAttributes(colorKey).create();
    }

    private void highlight(PsiElement element, TextRange range, TextAttributesKey colorKey) {
        range = range.shiftRight(element.getTextOffset());
        this.myHolder.newSilentAnnotation(HighlightSeverity.INFORMATION).range(range).textAttributes(colorKey).create();
    }

    public void visitElement(@NotNull PsiElement element) {
        boolean textInsideScenario;
        if (element == null) {
            GherkinAnnotatorVisitor.$$$reportNull$$$0(1);
        }
        ProgressManager.checkCanceled();
        super.visitElement(element);
        boolean bl = textInsideScenario = PsiUtilCore.getElementType((PsiElement)element) == GherkinTokenTypes.TEXT && element.getParent() instanceof GherkinStepsHolder;
        if (textInsideScenario && GherkinAnnotatorVisitor.hasStepsBefore(element)) {
            this.myHolder.newAnnotation(HighlightSeverity.ERROR, CucumberBundle.message("gherkin.lexer.unexpected.element", new Object[0])).create();
        }
    }

    private static boolean hasStepsBefore(@NotNull PsiElement element) {
        if (element == null) {
            GherkinAnnotatorVisitor.$$$reportNull$$$0(2);
        }
        for (element = element.getPrevSibling(); element != null && !(element instanceof GherkinStep); element = element.getPrevSibling()) {
        }
        return element != null;
    }

    @Override
    public void visitStep(GherkinStep step) {
        PsiReference[] references = step.getReferences();
        if (references.length != 1 || !(references[0] instanceof CucumberStepReference)) {
            return;
        }
        CucumberStepReference reference = (CucumberStepReference)references[0];
        AbstractStepDefinition definition = reference.resolveToDefinition();
        if (definition != null) {
            List<TextRange> parameterRanges = GherkinPsiUtil.buildParameterRanges(step, definition, reference.getRangeInElement().getStartOffset());
            if (parameterRanges == null) {
                return;
            }
            for (TextRange range : parameterRanges) {
                if (range.getLength() <= 0) continue;
                this.highlight(step, range, GherkinHighlighter.REGEXP_PARAMETER);
            }
            this.highlightOutlineParams(step, reference);
        }
    }

    @Override
    public void visitScenarioOutline(GherkinScenarioOutline outline) {
        ASTNode[] braces;
        super.visitScenarioOutline(outline);
        GherkinStepParameter[] params = (GherkinStepParameter[])PsiTreeUtil.getChildrenOfType((PsiElement)outline, GherkinStepParameter.class);
        if (params != null) {
            for (GherkinStepParameter param : params) {
                this.highlight(param, GherkinHighlighter.OUTLINE_PARAMETER_SUBSTITUTION);
            }
        }
        for (ASTNode brace : braces = outline.getNode().getChildren(TokenSet.create((IElementType[])new IElementType[]{GherkinTokenTypes.STEP_PARAMETER_BRACE}))) {
            this.highlight(brace.getPsi(), GherkinHighlighter.REGEXP_PARAMETER);
        }
    }

    @Override
    public void visitTableHeaderRow(GherkinTableHeaderRowImpl row) {
        GherkinExamplesBlockImpl examplesSection;
        super.visitTableRow(row);
        ProgressManager.checkCanceled();
        GherkinTableImpl table = GherkinTableNavigator.getTableByRow(row);
        GherkinExamplesBlockImpl gherkinExamplesBlockImpl = examplesSection = table != null ? GherkinExamplesNavigator.getExamplesByTable(table) : null;
        if (examplesSection == null) {
            return;
        }
        List<GherkinTableCell> cells = row.getPsiCells();
        for (PsiElement psiElement : cells) {
            this.highlight(psiElement, GherkinHighlighter.TABLE_HEADER_CELL);
        }
    }

    private void highlightOutlineParams(@NotNull GherkinStep step, @NotNull CucumberStepReference reference) {
        List<String> realSubstitutions;
        if (step == null) {
            GherkinAnnotatorVisitor.$$$reportNull$$$0(3);
        }
        if (reference == null) {
            GherkinAnnotatorVisitor.$$$reportNull$$$0(4);
        }
        if ((realSubstitutions = GherkinAnnotatorVisitor.getRealSubstitutions(step)) != null && !realSubstitutions.isEmpty()) {
            GherkinTable table;
            StringBuilder regexp = new StringBuilder();
            regexp.append("<(");
            for (String substitution : realSubstitutions) {
                if (regexp.length() > 2) {
                    regexp.append("|");
                }
                regexp.append(Pattern.quote(substitution));
            }
            regexp.append(")>");
            Pattern pattern = Pattern.compile(regexp.toString());
            int textStartOffset = reference.getRangeInElement().getStartOffset();
            this.highlightOutlineParamsForText(step.getName(), textStartOffset, pattern, step);
            GherkinPystring pystring = step.getPystring();
            if (pystring != null) {
                int textOffset = pystring.getTextOffset() - step.getTextOffset();
                this.highlightOutlineParamsForText(pystring.getText(), textOffset, pattern, step);
            }
            if ((table = step.getTable()) != null) {
                int textOffset = table.getTextOffset() - step.getTextOffset();
                this.highlightOutlineParamsForText(table.getText(), textOffset, pattern, step);
            }
        }
    }

    private void highlightOutlineParamsForText(String text, int textStartInElementOffset, Pattern pattern, GherkinStep step) {
        if (StringUtil.isEmpty((String)text)) {
            return;
        }
        Matcher matcher = pattern.matcher(text);
        boolean result = matcher.find();
        if (result) {
            do {
                String substitution;
                if (StringUtil.isEmpty((String)(substitution = matcher.group(1)))) continue;
                int start = matcher.start(1);
                int end = matcher.end(1);
                TextRange range = new TextRange(start, end).shiftRight(textStartInElementOffset);
                this.highlight(step, range, GherkinHighlighter.OUTLINE_PARAMETER_SUBSTITUTION);
            } while (result = matcher.find());
        }
    }

    @Nullable
    private static List<String> getRealSubstitutions(@NotNull GherkinStep step) {
        GherkinStepsHolder holder;
        List<String> possibleSubstitutions;
        if (step == null) {
            GherkinAnnotatorVisitor.$$$reportNull$$$0(5);
        }
        if (!(possibleSubstitutions = step.getParamsSubstitutions()).isEmpty() && (holder = step.getStepHolder()) instanceof GherkinScenarioOutlineImpl) {
            GherkinScenarioOutlineImpl outline = (GherkinScenarioOutlineImpl)holder;
            List<GherkinExamplesBlock> examplesBlocks = outline.getExamplesBlocks();
            if (examplesBlocks.isEmpty()) {
                return null;
            }
            GherkinTable table = examplesBlocks.get(0).getTable();
            if (table == null) {
                return null;
            }
            GherkinTableRow header = table.getHeaderRow();
            assert (header != null);
            List<GherkinTableCell> headerCells = header.getPsiCells();
            ArrayList<String> headers = new ArrayList<String>(headerCells.size() + 1);
            for (PsiElement psiElement : headerCells) {
                headers.add(psiElement.getText().trim());
            }
            ArrayList<String> realSubstitutions = new ArrayList<String>(possibleSubstitutions.size() + 1);
            for (String substitution : possibleSubstitutions) {
                if (!headers.contains(substitution)) continue;
                realSubstitutions.add(substitution);
            }
            return realSubstitutions.isEmpty() ? null : realSubstitutions;
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "step";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reference";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/plugins/cucumber/psi/annotator/GherkinAnnotatorVisitor";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "visitElement";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "hasStepsBefore";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "highlightOutlineParams";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "getRealSubstitutions";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

