/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.cucumber.psi;

import com.intellij.lang.ASTNode;
import com.intellij.lang.ParserDefinition;
import com.intellij.lang.PsiParser;
import com.intellij.lexer.Lexer;
import com.intellij.openapi.project.Project;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.TokenType;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.IFileElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.psi.util.PsiUtilCore;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.cucumber.psi.GherkinElementTypes;
import org.jetbrains.plugins.cucumber.psi.GherkinLexer;
import org.jetbrains.plugins.cucumber.psi.GherkinParser;
import org.jetbrains.plugins.cucumber.psi.GherkinTableCellImpl;
import org.jetbrains.plugins.cucumber.psi.GherkinTokenTypes;
import org.jetbrains.plugins.cucumber.psi.i18n.JsonGherkinKeywordProvider;
import org.jetbrains.plugins.cucumber.psi.impl.GherkinExamplesBlockImpl;
import org.jetbrains.plugins.cucumber.psi.impl.GherkinFeatureHeaderImpl;
import org.jetbrains.plugins.cucumber.psi.impl.GherkinFeatureImpl;
import org.jetbrains.plugins.cucumber.psi.impl.GherkinFileImpl;
import org.jetbrains.plugins.cucumber.psi.impl.GherkinPystringImpl;
import org.jetbrains.plugins.cucumber.psi.impl.GherkinRuleImpl;
import org.jetbrains.plugins.cucumber.psi.impl.GherkinScenarioImpl;
import org.jetbrains.plugins.cucumber.psi.impl.GherkinScenarioOutlineImpl;
import org.jetbrains.plugins.cucumber.psi.impl.GherkinStepImpl;
import org.jetbrains.plugins.cucumber.psi.impl.GherkinStepParameterImpl;
import org.jetbrains.plugins.cucumber.psi.impl.GherkinTableHeaderRowImpl;
import org.jetbrains.plugins.cucumber.psi.impl.GherkinTableImpl;
import org.jetbrains.plugins.cucumber.psi.impl.GherkinTableRowImpl;
import org.jetbrains.plugins.cucumber.psi.impl.GherkinTagImpl;

public class GherkinParserDefinition
implements ParserDefinition {
    private static final TokenSet WHITESPACE = TokenSet.create((IElementType[])new IElementType[]{TokenType.WHITE_SPACE});
    private static final TokenSet COMMENTS = TokenSet.create((IElementType[])new IElementType[]{GherkinTokenTypes.COMMENT});

    @NotNull
    public Lexer createLexer(Project project) {
        return new GherkinLexer(JsonGherkinKeywordProvider.getKeywordProvider(true));
    }

    @NotNull
    public PsiParser createParser(Project project) {
        return new GherkinParser();
    }

    @NotNull
    public IFileElementType getFileNodeType() {
        IFileElementType iFileElementType = GherkinElementTypes.GHERKIN_FILE;
        if (iFileElementType == null) {
            GherkinParserDefinition.$$$reportNull$$$0(0);
        }
        return iFileElementType;
    }

    @NotNull
    public TokenSet getWhitespaceTokens() {
        TokenSet tokenSet = WHITESPACE;
        if (tokenSet == null) {
            GherkinParserDefinition.$$$reportNull$$$0(1);
        }
        return tokenSet;
    }

    @NotNull
    public TokenSet getCommentTokens() {
        TokenSet tokenSet = COMMENTS;
        if (tokenSet == null) {
            GherkinParserDefinition.$$$reportNull$$$0(2);
        }
        return tokenSet;
    }

    @NotNull
    public TokenSet getStringLiteralElements() {
        TokenSet tokenSet = TokenSet.EMPTY;
        if (tokenSet == null) {
            GherkinParserDefinition.$$$reportNull$$$0(3);
        }
        return tokenSet;
    }

    @NotNull
    public PsiElement createElement(ASTNode node) {
        if (node.getElementType() == GherkinElementTypes.FEATURE) {
            return new GherkinFeatureImpl(node);
        }
        if (node.getElementType() == GherkinElementTypes.FEATURE_HEADER) {
            return new GherkinFeatureHeaderImpl(node);
        }
        if (node.getElementType() == GherkinElementTypes.SCENARIO) {
            return new GherkinScenarioImpl(node);
        }
        if (node.getElementType() == GherkinElementTypes.STEP) {
            return new GherkinStepImpl(node);
        }
        if (node.getElementType() == GherkinElementTypes.SCENARIO_OUTLINE) {
            return new GherkinScenarioOutlineImpl(node);
        }
        if (node.getElementType() == GherkinElementTypes.RULE) {
            return new GherkinRuleImpl(node);
        }
        if (node.getElementType() == GherkinElementTypes.EXAMPLES_BLOCK) {
            return new GherkinExamplesBlockImpl(node);
        }
        if (node.getElementType() == GherkinElementTypes.TABLE) {
            return new GherkinTableImpl(node);
        }
        if (node.getElementType() == GherkinElementTypes.TABLE_ROW) {
            return new GherkinTableRowImpl(node);
        }
        if (node.getElementType() == GherkinElementTypes.TABLE_CELL) {
            return new GherkinTableCellImpl(node);
        }
        if (node.getElementType() == GherkinElementTypes.TABLE_HEADER_ROW) {
            return new GherkinTableHeaderRowImpl(node);
        }
        if (node.getElementType() == GherkinElementTypes.TAG) {
            return new GherkinTagImpl(node);
        }
        if (node.getElementType() == GherkinElementTypes.STEP_PARAMETER) {
            return new GherkinStepParameterImpl(node);
        }
        if (node.getElementType() == GherkinElementTypes.PYSTRING) {
            return new GherkinPystringImpl(node);
        }
        PsiElement psiElement = PsiUtilCore.NULL_PSI_ELEMENT;
        if (psiElement == null) {
            GherkinParserDefinition.$$$reportNull$$$0(4);
        }
        return psiElement;
    }

    @NotNull
    public PsiFile createFile(@NotNull FileViewProvider viewProvider) {
        if (viewProvider == null) {
            GherkinParserDefinition.$$$reportNull$$$0(5);
        }
        return new GherkinFileImpl(viewProvider);
    }

    @NotNull
    public ParserDefinition.SpaceRequirements spaceExistenceTypeBetweenTokens(ASTNode left, ASTNode right) {
        IElementType leftElementType = left.getElementType();
        if (leftElementType == GherkinTokenTypes.COMMENT) {
            ParserDefinition.SpaceRequirements spaceRequirements = ParserDefinition.SpaceRequirements.MUST_LINE_BREAK;
            if (spaceRequirements == null) {
                GherkinParserDefinition.$$$reportNull$$$0(6);
            }
            return spaceRequirements;
        }
        if (right.getElementType() == GherkinTokenTypes.EXAMPLES_KEYWORD) {
            ParserDefinition.SpaceRequirements spaceRequirements = ParserDefinition.SpaceRequirements.MUST_LINE_BREAK;
            if (spaceRequirements == null) {
                GherkinParserDefinition.$$$reportNull$$$0(7);
            }
            return spaceRequirements;
        }
        ParserDefinition.SpaceRequirements spaceRequirements = ParserDefinition.SpaceRequirements.MAY;
        if (spaceRequirements == null) {
            GherkinParserDefinition.$$$reportNull$$$0(8);
        }
        return spaceRequirements;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 5: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 5: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/cucumber/psi/GherkinParserDefinition";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "viewProvider";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getFileNodeType";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getWhitespaceTokens";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getCommentTokens";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getStringLiteralElements";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "createElement";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/cucumber/psi/GherkinParserDefinition";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "spaceExistenceTypeBetweenTokens";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "createFile";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 5: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

