/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.cucumber.inspections;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.cucumber.CucumberBundle;
import org.jetbrains.plugins.cucumber.inspections.GherkinInspection;
import org.jetbrains.plugins.cucumber.inspections.RemoveTableColumnFix;
import org.jetbrains.plugins.cucumber.psi.GherkinElementVisitor;
import org.jetbrains.plugins.cucumber.psi.GherkinExamplesBlock;
import org.jetbrains.plugins.cucumber.psi.GherkinScenarioOutline;
import org.jetbrains.plugins.cucumber.psi.GherkinStep;
import org.jetbrains.plugins.cucumber.psi.GherkinTable;
import org.jetbrains.plugins.cucumber.psi.GherkinTableCell;
import org.jetbrains.plugins.cucumber.psi.GherkinTableRow;

public final class CucumberTableInspection
extends GherkinInspection {
    public boolean isEnabledByDefault() {
        return true;
    }

    @NotNull
    public String getShortName() {
        return "CucumberTableInspection";
    }

    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            CucumberTableInspection.$$$reportNull$$$0(0);
        }
        return new GherkinElementVisitor(){

            @Override
            public void visitScenarioOutline(GherkinScenarioOutline outline) {
                List<GherkinExamplesBlock> examples = outline.getExamplesBlocks();
                if (examples.size() > 0) {
                    Collection<String> columnNames = CucumberTableInspection.collectUsedColumnNames(outline);
                    for (GherkinExamplesBlock block : examples) {
                        CucumberTableInspection.checkTable(block.getTable(), columnNames, holder);
                    }
                }
            }
        };
    }

    private static void checkTable(GherkinTable table, Collection<String> columnNames, ProblemsHolder holder) {
        GherkinTableRow row;
        GherkinTableRow gherkinTableRow = row = table != null ? table.getHeaderRow() : null;
        if (row == null) {
            return;
        }
        List<GherkinTableCell> cells = row.getPsiCells();
        IntArrayList unusedIndices = new IntArrayList();
        int cellsSize = cells.size();
        for (int i = 0; i < cellsSize; ++i) {
            String columnName = cells.get(i).getText().trim();
            if (columnNames.contains(columnName)) continue;
            unusedIndices.add(i);
        }
        if (!unusedIndices.isEmpty()) {
            CucumberTableInspection.highlightUnusedColumns(row, (IntList)unusedIndices, holder);
            for (GherkinTableRow tableRow : table.getDataRows()) {
                CucumberTableInspection.highlightUnusedColumns(tableRow, (IntList)unusedIndices, holder);
            }
        }
    }

    private static void highlightUnusedColumns(GherkinTableRow row, IntList unusedIndices, ProblemsHolder holder) {
        List<GherkinTableCell> cells = row.getPsiCells();
        int cellsCount = cells.size();
        GherkinTable table = (GherkinTable)row.getParent();
        for (int i : unusedIndices.toIntArray()) {
            if (i >= cellsCount || cells.get(i).getTextLength() <= 0) continue;
            holder.registerProblem((PsiElement)cells.get(i), CucumberBundle.message("unused.table.column", new Object[0]), ProblemHighlightType.LIKE_UNUSED_SYMBOL, new LocalQuickFix[]{new RemoveTableColumnFix(table, i)});
        }
    }

    private static Collection<String> collectUsedColumnNames(GherkinScenarioOutline outline) {
        HashSet<String> result = new HashSet<String>();
        for (GherkinStep step : outline.getSteps()) {
            result.addAll(step.getParamsSubstitutions());
        }
        return result;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "org/jetbrains/plugins/cucumber/inspections/CucumberTableInspection", "buildVisitor"));
    }
}

