/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.localization.ref;

import com.google.common.collect.Lists;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementResolveResult;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiPolyVariantReference;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.search.FilenameIndex;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.IncorrectOperationException;
import com.jetbrains.localization.psi.impl.LocaleLocation;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class LocationReference
implements PsiPolyVariantReference {
    protected final PsiElement myElement;

    public LocationReference(PsiElement element) {
        this.myElement = element;
    }

    @NotNull
    public PsiElement getElement() {
        PsiElement psiElement = this.myElement;
        if (psiElement == null) {
            LocationReference.$$$reportNull$$$0(0);
        }
        return psiElement;
    }

    @NotNull
    public TextRange getRangeInElement() {
        return new TextRange(0, this.myElement.getTextLength());
    }

    @NotNull
    public String getCanonicalText() {
        String string = this.myElement.getText();
        if (string == null) {
            LocationReference.$$$reportNull$$$0(1);
        }
        return string;
    }

    public PsiElement resolve() {
        ResolveResult[] results = this.multiResolve(false);
        return results.length == 1 ? results[0].getElement() : null;
    }

    public PsiElement handleElementRename(@NotNull String newElementName) throws IncorrectOperationException {
        if (newElementName == null) {
            LocationReference.$$$reportNull$$$0(2);
        }
        throw new IncorrectOperationException();
    }

    public PsiElement bindToElement(@NotNull PsiElement element) throws IncorrectOperationException {
        if (element == null) {
            LocationReference.$$$reportNull$$$0(3);
        }
        return null;
    }

    public boolean isReferenceTo(@NotNull PsiElement element) {
        if (element == null) {
            LocationReference.$$$reportNull$$$0(4);
        }
        return this.resolve() == element;
    }

    public boolean isSoft() {
        return false;
    }

    public ResolveResult @NotNull [] multiResolve(boolean incompleteCode) {
        ArrayList<ResolveResult> result = new ArrayList<ResolveResult>();
        if (this.myElement instanceof LocaleLocation) {
            PsiFile[] files;
            String file = ((LocaleLocation)this.myElement).getFile();
            ArrayList fileParts = Lists.newArrayList((Iterable)StringUtil.split((String)file, (String)File.separator));
            Collections.reverse(fileParts);
            String fileName = (String)fileParts.get(0);
            for (PsiFile f : files = FilenameIndex.getFilesByName((Project)this.myElement.getProject(), (String)fileName, (GlobalSearchScope)GlobalSearchScope.projectScope((Project)this.myElement.getProject()))) {
                this.addResolveFromFile(f, fileParts, result);
            }
        }
        ResolveResult[] resolveResultArray = result.toArray(ResolveResult.EMPTY_ARRAY);
        if (resolveResultArray == null) {
            LocationReference.$$$reportNull$$$0(5);
        }
        return resolveResultArray;
    }

    private void addResolveFromFile(PsiFile f, List<String> fileParts, List<ResolveResult> result) {
        PsiDirectory psiDirectory = f.getContainingDirectory();
        for (String part : fileParts.subList(1, fileParts.size())) {
            if (psiDirectory == null || !psiDirectory.getName().equals(part)) {
                return;
            }
            psiDirectory = psiDirectory.getParent();
        }
        this.addResolveResult(f, result);
    }

    private void addResolveResult(PsiFile file, List<ResolveResult> result) {
        int lineNum = ((LocaleLocation)this.myElement).getLineNumber();
        Document d = file.getViewProvider().getDocument();
        if (d != null && lineNum < d.getLineCount()) {
            int offset = d.getLineStartOffset(lineNum);
            PsiElement resultElement = file.findElementAt(offset);
            if (resultElement != null) {
                result.add((ResolveResult)new PsiElementResolveResult(resultElement));
            } else {
                result.add((ResolveResult)new PsiElementResolveResult((PsiElement)file));
            }
        } else {
            result.add((ResolveResult)new PsiElementResolveResult((PsiElement)file));
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/localization/ref/LocationReference";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newElementName";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getElement";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getCanonicalText";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/localization/ref/LocationReference";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "multiResolve";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "handleElementRename";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "bindToElement";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "isReferenceTo";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

