/*
 * Decompiled with CFR 0.152.
 */
package kotlin.text;

import kotlin.ExperimentalStdlibApi;
import kotlin.Metadata;
import kotlin.SinceKotlin;
import kotlin.internal.InlineOnly;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.CharsKt;
import kotlin.text.CharsKt__CharJVMKt;
import kotlin.text._OneToManyTitlecaseMappingsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 0}, k=5, xi=3, d1={"\u0000\u001e\n\u0000\n\u0002\u0010\f\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0002\u001a\f\u0010\u0000\u001a\u00020\u0001*\u00020\u0002H\u0007\u001a\u0014\u0010\u0000\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u0002H\u0007\u001a\f\u0010\u0004\u001a\u00020\u0002*\u00020\u0001H\u0007\u001a\u0014\u0010\u0004\u001a\u00020\u0002*\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u0002H\u0007\u001a\u0013\u0010\u0005\u001a\u0004\u0018\u00010\u0002*\u00020\u0001H\u0007\u00a2\u0006\u0002\u0010\u0006\u001a\u001b\u0010\u0005\u001a\u0004\u0018\u00010\u0002*\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u0002H\u0007\u00a2\u0006\u0002\u0010\u0007\u001a\u001c\u0010\b\u001a\u00020\t*\u00020\u00012\u0006\u0010\n\u001a\u00020\u00012\b\b\u0002\u0010\u000b\u001a\u00020\t\u001a\n\u0010\f\u001a\u00020\t*\u00020\u0001\u001a\u0015\u0010\r\u001a\u00020\u000e*\u00020\u00012\u0006\u0010\n\u001a\u00020\u000eH\u0087\n\u001a\f\u0010\u000f\u001a\u00020\u000e*\u00020\u0001H\u0007\u00a8\u0006\u0010"}, d2={"digitToChar", "", "", "radix", "digitToInt", "digitToIntOrNull", "(C)Ljava/lang/Integer;", "(CI)Ljava/lang/Integer;", "equals", "", "other", "ignoreCase", "isSurrogate", "plus", "", "titlecase", "kotlin-stdlib"}, xs="kotlin/text/CharsKt")
class CharsKt__CharKt
extends CharsKt__CharJVMKt {
    @ExperimentalStdlibApi
    @SinceKotlin(version="1.4")
    public static final int digitToInt(char $this$digitToInt) {
        char c = $this$digitToInt;
        if ('0' <= c && '9' >= c) {
            return $this$digitToInt - 48;
        }
        throw (Throwable)new IllegalArgumentException("Char " + $this$digitToInt + " is not a decimal digit");
    }

    @ExperimentalStdlibApi
    @SinceKotlin(version="1.4")
    public static final int digitToInt(char $this$digitToInt, int radix) {
        Integer n = CharsKt.digitToIntOrNull($this$digitToInt, radix);
        if (n == null) {
            throw (Throwable)new IllegalArgumentException("Char " + $this$digitToInt + " is not a digit in the given radix=" + radix);
        }
        return n;
    }

    @ExperimentalStdlibApi
    @SinceKotlin(version="1.4")
    @Nullable
    public static final Integer digitToIntOrNull(char $this$digitToIntOrNull) {
        char c = $this$digitToIntOrNull;
        if ('0' <= c && '9' >= c) {
            return $this$digitToIntOrNull - 48;
        }
        return null;
    }

    @ExperimentalStdlibApi
    @SinceKotlin(version="1.4")
    @Nullable
    public static final Integer digitToIntOrNull(char $this$digitToIntOrNull, int radix) {
        int n = radix;
        if (2 > n || 36 < n) {
            throw (Throwable)new IllegalArgumentException("Invalid radix: " + radix + ". Valid radix values are in range 2..36");
        }
        n = $this$digitToIntOrNull;
        if (48 <= n && 57 >= n) {
            int digit = $this$digitToIntOrNull - 48;
            return digit < radix ? Integer.valueOf(digit) : null;
        }
        int a = Intrinsics.compare($this$digitToIntOrNull, 90) <= 0 ? 65 : 97;
        int digit = 10 + ($this$digitToIntOrNull - a);
        int n2 = digit;
        return 10 <= n2 && radix > n2 ? Integer.valueOf(digit) : null;
    }

    @ExperimentalStdlibApi
    @SinceKotlin(version="1.4")
    public static final char digitToChar(int $this$digitToChar) {
        int n = $this$digitToChar;
        if (0 <= n && 9 >= n) {
            return (char)(48 + $this$digitToChar);
        }
        throw (Throwable)new IllegalArgumentException("Int " + $this$digitToChar + " is not a decimal digit");
    }

    @ExperimentalStdlibApi
    @SinceKotlin(version="1.4")
    public static final char digitToChar(int $this$digitToChar, int radix) {
        int n = radix;
        if (2 > n || 36 < n) {
            throw (Throwable)new IllegalArgumentException("Invalid radix: " + radix + ". Valid radix values are in range 2..36");
        }
        if ($this$digitToChar < 0 || $this$digitToChar >= radix) {
            throw (Throwable)new IllegalArgumentException("Digit " + $this$digitToChar + " does not represent a valid digit in radix " + radix);
        }
        return $this$digitToChar < 10 ? (char)(48 + $this$digitToChar) : (char)((char)(65 + $this$digitToChar) - 10);
    }

    @SinceKotlin(version="1.5")
    @ExperimentalStdlibApi
    @NotNull
    public static final String titlecase(char $this$titlecase) {
        return _OneToManyTitlecaseMappingsKt.titlecaseImpl($this$titlecase);
    }

    @InlineOnly
    private static final String plus(char $this$plus, String other) {
        int $i$f$plus = 0;
        return String.valueOf($this$plus) + other;
    }

    public static final boolean equals(char $this$equals, char other, boolean ignoreCase) {
        if ($this$equals == other) {
            return true;
        }
        if (!ignoreCase) {
            return false;
        }
        char c = $this$equals;
        boolean bl = false;
        char c2 = Character.toUpperCase(c);
        c = other;
        bl = false;
        if (c2 == Character.toUpperCase(c)) {
            return true;
        }
        c = $this$equals;
        bl = false;
        char c3 = Character.toLowerCase(c);
        c = other;
        bl = false;
        return c3 == Character.toLowerCase(c);
    }

    public static /* synthetic */ boolean equals$default(char c, char c2, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        return CharsKt.equals(c, c2, bl);
    }

    public static final boolean isSurrogate(char $this$isSurrogate) {
        char c = $this$isSurrogate;
        return '\ud800' <= c && '\udfff' >= c;
    }
}

