/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.framework.ui;

import com.intellij.DynamicBundle;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.TextBrowseFolderListener;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.ui.ValidationInfo;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.JBRadioButton;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.ui.UIUtil;
import com.jetbrains.php.FrameworkBundle;
import com.jetbrains.php.config.PhpProjectConfigurationFacade;
import com.jetbrains.php.config.interpreters.PhpInterpreter;
import com.jetbrains.php.config.interpreters.PhpInterpreterComboBox;
import com.jetbrains.php.config.interpreters.PhpInterpretersManagerImpl;
import com.jetbrains.php.framework.ui.CommandLineToolsInterpreterCombo;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class FrameworkCompositePathDialog
extends DialogWrapper {
    public static final String EXECUTABLE = "EXECUTABLE";
    @Nullable
    protected final Project myProject;
    private JPanel myMainPanel;
    private JBRadioButton myScriptRadioButton;
    private JPanel myScriptPanel;
    private TextFieldWithBrowseButton myScriptPathField;
    private JLabel myScriptPathLabel;
    private JBRadioButton myExecutableRadioButton;
    private JPanel myExecutablePanel;
    private JLabel myExecutablePathLabel;
    private TextFieldWithBrowseButton myExecutablePathField;
    protected JTextField myAliasField;
    private JPanel myAliasPanel;
    protected JPanel myAdditionalPanel;
    private PhpInterpreterComboBox myPhpInterpreterComboBox1;
    private final TextsBuilder myTextsBuilder;

    protected FrameworkCompositePathDialog(@NotNull TextsBuilder textsBuilder, boolean withAlias) {
        if (textsBuilder == null) {
            FrameworkCompositePathDialog.$$$reportNull$$$0(0);
        }
        super(true);
        this.myTextsBuilder = textsBuilder;
        this.myProject = null;
        this.$$$setupUI$$$();
        this.initialize(withAlias);
    }

    protected FrameworkCompositePathDialog(@NotNull Project project, @NotNull TextsBuilder builder, boolean withAlias) {
        if (project == null) {
            FrameworkCompositePathDialog.$$$reportNull$$$0(1);
        }
        if (builder == null) {
            FrameworkCompositePathDialog.$$$reportNull$$$0(2);
        }
        super(project, false);
        this.myTextsBuilder = builder;
        this.myProject = project;
        this.$$$setupUI$$$();
        this.initialize(withAlias);
    }

    private void initialize(boolean withAlias) {
        boolean selectExecutable;
        this.setTitle(this.myTextsBuilder.myTitle);
        this.myAliasPanel.setVisible(withAlias);
        this.myScriptRadioButton.setText(this.myTextsBuilder.myScriptRadioButtonText);
        ActionListener actionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                boolean executableSelected = FrameworkCompositePathDialog.this.isExecutableSelected();
                UIUtil.setEnabled((Component)FrameworkCompositePathDialog.this.myExecutablePanel, (boolean)executableSelected, (boolean)true);
                UIUtil.setEnabled((Component)FrameworkCompositePathDialog.this.myScriptPanel, (!executableSelected ? 1 : 0) != 0, (boolean)true);
            }
        };
        this.myScriptRadioButton.addActionListener(actionListener);
        this.myScriptPathLabel.setText(this.myTextsBuilder.myScriptPathLabelText);
        this.initPathField(this.myScriptPathField, this.myTextsBuilder.myScriptFileDescriptorTitle, this.myTextsBuilder.myScriptFileDescriptorDescription, this.getInitialScriptPath());
        this.myExecutableRadioButton.setText(this.myTextsBuilder.myExecutableRadioButtonText);
        this.myExecutableRadioButton.addActionListener(actionListener);
        this.myExecutablePathLabel.setText(this.myTextsBuilder.myExecutablePathLabelText);
        this.initPathField(this.myExecutablePathField, this.myTextsBuilder.myExecutableFileDescriptorTitle, this.myTextsBuilder.myExecutableFileDescriptorDescription, this.getInitialExecutablePath());
        boolean bl = selectExecutable = this.getInitialExecutablePath() != null;
        if (selectExecutable) {
            this.myExecutableRadioButton.setSelected(true);
        } else {
            this.myScriptRadioButton.setSelected(true);
        }
        UIUtil.setEnabled((Component)this.myExecutablePanel, (boolean)selectExecutable, (boolean)true);
        UIUtil.setEnabled((Component)this.myScriptPanel, (!selectExecutable ? 1 : 0) != 0, (boolean)true);
        this.setModal(true);
        this.init();
        this.pack();
        this.initValidation();
    }

    protected boolean postponeValidation() {
        return false;
    }

    private void createUIComponents() {
        this.myPhpInterpreterComboBox1 = new CommandLineToolsInterpreterCombo(this.myProject);
        this.myPhpInterpreterComboBox1.reset();
        Disposer.register((Disposable)this.getDisposable(), (Disposable)this.myPhpInterpreterComboBox1);
    }

    private void initPathField(TextFieldWithBrowseButton pathField, @NlsContexts.DialogTitle String fileDescriptorTitle, @NlsContexts.Label String fileDescriptorDescription, final @Nullable String initialPath) {
        FileChooserDescriptor fileDescriptor = FileChooserDescriptorFactory.createSingleFileNoJarsDescriptor();
        fileDescriptor.setTitle(fileDescriptorTitle);
        fileDescriptor.setDescription(fileDescriptorDescription);
        TextBrowseFolderListener listener = new TextBrowseFolderListener(fileDescriptor){

            @Nullable
            protected VirtualFile getInitialFile() {
                VirtualFile file;
                if (initialPath != null && (file = LocalFileSystem.getInstance().findFileByPath(initialPath)) != null) {
                    return file;
                }
                return super.getInitialFile();
            }

            public void actionPerformed(ActionEvent e) {
                String interpreterName = FrameworkCompositePathDialog.this.myPhpInterpreterComboBox1.getSelectedItemName();
                if (interpreterName == null) {
                    super.actionPerformed(e);
                    return;
                }
                PhpInterpretersManagerImpl manager = PhpInterpretersManagerImpl.getInstance((Project)FrameworkCompositePathDialog.this.myProject);
                PhpInterpreter interpreter = manager.findInterpreter(interpreterName);
                if (interpreter == null || interpreter.isRemote()) {
                    return;
                }
                super.actionPerformed(e);
            }
        };
        pathField.addBrowseFolderListener(listener);
        if (initialPath != null) {
            pathField.setText(FileUtil.toSystemDependentName((String)initialPath));
        }
    }

    @Nullable
    protected ValidationInfo doValidate() {
        if (this.myAliasPanel.isVisible() && StringUtil.isEmpty((String)this.myAliasField.getText())) {
            return new ValidationInfo(FrameworkBundle.message("framework.0.not.provided", FrameworkBundle.message("framework.settings.table.alias.header", new Object[0])), (JComponent)this.myAliasField);
        }
        if (this.myExecutableRadioButton.isSelected()) {
            return this.createExecutableValidationInfo(this.myExecutablePathField);
        }
        ValidationInfo phpInfo = FrameworkCompositePathDialog.createStandardValidationInfo((JComponent)this.myPhpInterpreterComboBox1, this.getPhpExecutablePath(), PhpProjectConfigurationFacade.PHP_EXECUTABLE, this.myTextsBuilder.myPhpExecutablePresentableName, this.myProject);
        if (phpInfo != null) {
            return phpInfo;
        }
        String interpreterName = this.myPhpInterpreterComboBox1.getSelectedItemName();
        PhpInterpretersManagerImpl manager = PhpInterpretersManagerImpl.getInstance((Project)this.myProject);
        PhpInterpreter interpreter = manager.findInterpreter(interpreterName);
        if (interpreter == null || interpreter.isRemote()) {
            return null;
        }
        return this.createScriptValidationInfo(this.myScriptPathField);
    }

    @Nullable
    protected abstract ValidationInfo createExecutableValidationInfo(TextFieldWithBrowseButton var1);

    @Nullable
    protected abstract ValidationInfo createScriptValidationInfo(TextFieldWithBrowseButton var1);

    protected static ValidationInfo createStandardValidationInfo(JComponent pathField, String path, String fileName, String fileDescription, Project project) {
        return FrameworkCompositePathDialog.createValidationInfo(pathField, path, FrameworkBundle.message("framework.path.to.0.is.not.provided", fileName), FrameworkBundle.message("framework.0.1.is.not.chosen", fileDescription, fileName), project);
    }

    protected static ValidationInfo createValidationInfo(JComponent pathField, String path, @Nls String noPathMessage, @Nls String wrongPathMessage) {
        if (path == null) {
            return new ValidationInfo(wrongPathMessage, pathField);
        }
        if (path.isEmpty()) {
            return new ValidationInfo(noPathMessage, pathField);
        }
        return null;
    }

    protected static ValidationInfo createValidationInfo(JComponent pathField, String path, @Nls String noPathMessage, @Nls String wrongPathMessage, Project project) {
        if (path == null) {
            PhpProjectConfigurationFacade instance = PhpProjectConfigurationFacade.getInstance((Project)project);
            PhpInterpreter projectInterpreter = instance.getInterpreter();
            if (projectInterpreter == null) {
                return new ValidationInfo(wrongPathMessage, pathField);
            }
            return null;
        }
        if (path.isEmpty()) {
            return new ValidationInfo(noPathMessage, pathField);
        }
        return null;
    }

    @Nullable
    protected abstract String getInitialExecutablePath();

    @Nullable
    protected abstract String getInitialScriptPath();

    @NotNull
    private String getPhpExecutablePath() {
        PhpInterpreter interpreter;
        String interpreterName = this.myPhpInterpreterComboBox1.getSelectedItemName();
        if (interpreterName != null && (interpreter = PhpInterpretersManagerImpl.getInstance((Project)this.myProject).findInterpreter(interpreterName)) != null) {
            String string = interpreter.getId();
            if (string == null) {
                FrameworkCompositePathDialog.$$$reportNull$$$0(3);
            }
            return string;
        }
        return "PROJECT_DEFAULT_INTERPRETER";
    }

    private boolean isExecutableSelected() {
        return this.myExecutableRadioButton.isSelected();
    }

    protected String getScriptPath() {
        return this.getScriptPath(this.myScriptPathField.getText());
    }

    @Nullable
    protected String getScriptPath(String input) {
        return input;
    }

    @Nullable
    protected String getExecutablePath() {
        return this.getExecutablePath(this.myExecutablePathField.getText());
    }

    @Nullable
    protected abstract String getExecutablePath(String var1);

    public String @NotNull [] getUserData() {
        if (this.isExecutableSelected()) {
            String[] stringArray = new String[]{EXECUTABLE, this.getExecutablePath()};
            if (stringArray == null) {
                FrameworkCompositePathDialog.$$$reportNull$$$0(4);
            }
            return stringArray;
        }
        String[] stringArray = new String[]{this.getPhpExecutablePath(), this.getScriptPath()};
        if (stringArray == null) {
            FrameworkCompositePathDialog.$$$reportNull$$$0(5);
        }
        return stringArray;
    }

    @Nullable
    protected static String getPath(@Nullable String fieldText, @Nullable String fileName) {
        if (StringUtil.isEmpty((String)fieldText)) {
            return "";
        }
        File providedFile = new File(fieldText);
        if (providedFile.exists() && providedFile.isFile() && (fileName == null || fileName.equals(providedFile.getName()))) {
            return FileUtil.toSystemDependentName((String)providedFile.getPath());
        }
        return null;
    }

    protected static String getExistingFile(String providedPath) {
        if (StringUtil.isEmpty((String)providedPath)) {
            return "";
        }
        File providedFile = new File(providedPath);
        if (providedFile.exists() && !providedFile.isDirectory()) {
            return FileUtil.toSystemDependentName((String)providedFile.getPath());
        }
        return null;
    }

    protected JComponent createCenterPanel() {
        return this.myMainPanel;
    }

    public JComponent getPreferredFocusedComponent() {
        return this.isExecutableSelected() ? this.myExecutablePathField.getTextField() : this.myPhpInterpreterComboBox1.getChildComponent();
    }

    protected abstract String getDimensionServiceKey();

    @NonNls
    @Nullable
    protected abstract String getHelpId();

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "textsBuilder";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/framework/ui/FrameworkCompositePathDialog";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/framework/ui/FrameworkCompositePathDialog";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getPhpExecutablePath";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getUserData";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JPanel jPanel;
        JTextField jTextField;
        JPanel jPanel2;
        TextFieldWithBrowseButton textFieldWithBrowseButton;
        JLabel jLabel;
        JPanel jPanel3;
        TextFieldWithBrowseButton textFieldWithBrowseButton2;
        JLabel jLabel2;
        JPanel jPanel4;
        JBRadioButton jBRadioButton;
        JBRadioButton jBRadioButton2;
        JPanel jPanel5;
        this.createUIComponents();
        this.myMainPanel = jPanel5 = new JPanel();
        jPanel5.setLayout((LayoutManager)new GridLayoutManager(7, 3, new Insets(0, 0, 0, 0), -1, -1, false, false));
        Spacer spacer = new Spacer();
        jPanel5.add((Component)spacer, new GridConstraints(6, 2, 1, 1, 0, 2, 1, 6, null, null, null));
        this.myScriptRadioButton = jBRadioButton2 = new JBRadioButton();
        this.$$$loadButtonText$$$((AbstractButton)jBRadioButton2, DynamicBundle.getBundle((String)"messages/FrameworkBundle", FrameworkCompositePathDialog.class).getString("radio.button.php.code"));
        jPanel5.add((Component)jBRadioButton2, new GridConstraints(2, 0, 1, 3, 0, 1, 3, 0, null, null, null));
        this.myExecutableRadioButton = jBRadioButton = new JBRadioButton();
        this.$$$loadButtonText$$$((AbstractButton)jBRadioButton, DynamicBundle.getBundle((String)"messages/FrameworkBundle", FrameworkCompositePathDialog.class).getString("radio.button.executable"));
        jPanel5.add((Component)jBRadioButton, new GridConstraints(4, 0, 1, 3, 0, 1, 3, 0, null, null, null));
        this.myScriptPanel = jPanel4 = new JPanel();
        jPanel4.setLayout((LayoutManager)new GridLayoutManager(2, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel5.add((Component)jPanel4, new GridConstraints(3, 0, 1, 3, 0, 3, 3, 3, null, null, null, 1));
        this.myScriptPathLabel = jLabel2 = new JLabel();
        this.$$$loadLabelText$$$(jLabel2, DynamicBundle.getBundle((String)"messages/FrameworkBundle", FrameworkCompositePathDialog.class).getString("label.php.script.or.archive.path"));
        jPanel4.add((Component)jLabel2, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myScriptPathField = textFieldWithBrowseButton2 = new TextFieldWithBrowseButton();
        jPanel4.add((Component)textFieldWithBrowseButton2, new GridConstraints(1, 1, 1, 1, 0, 1, 6, 0, new Dimension(300, -1), null, null));
        JBLabel jBLabel = new JBLabel();
        this.$$$loadLabelText$$$((JLabel)jBLabel, DynamicBundle.getBundle((String)"messages/FrameworkBundle", FrameworkCompositePathDialog.class).getString("php.interpreter"));
        jPanel4.add((Component)jBLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        PhpInterpreterComboBox phpInterpreterComboBox = this.myPhpInterpreterComboBox1;
        jPanel4.add((Component)phpInterpreterComboBox, new GridConstraints(0, 1, 1, 1, 0, 0, 3, 3, null, null, null));
        this.myExecutablePanel = jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel5.add((Component)jPanel3, new GridConstraints(5, 0, 1, 3, 0, 3, 3, 3, null, null, null, 1));
        this.myExecutablePathLabel = jLabel = new JLabel();
        this.$$$loadLabelText$$$(jLabel, DynamicBundle.getBundle((String)"messages/FrameworkBundle", FrameworkCompositePathDialog.class).getString("label.executable.path"));
        jPanel3.add((Component)jLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myExecutablePathField = textFieldWithBrowseButton = new TextFieldWithBrowseButton();
        jPanel3.add((Component)textFieldWithBrowseButton, new GridConstraints(0, 1, 1, 1, 0, 1, 6, 0, new Dimension(300, -1), null, null));
        this.myAliasPanel = jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel5.add((Component)jPanel2, new GridConstraints(0, 0, 1, 2, 0, 3, 3, 3, null, null, null));
        JBLabel jBLabel2 = new JBLabel();
        this.$$$loadLabelText$$$((JLabel)jBLabel2, DynamicBundle.getBundle((String)"messages/FrameworkBundle", FrameworkCompositePathDialog.class).getString("label.alias"));
        jPanel2.add((Component)jBLabel2, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myAliasField = jTextField = new JTextField();
        jPanel2.add((Component)jTextField, new GridConstraints(0, 1, 1, 1, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        this.myAdditionalPanel = jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout(0, 0));
        jPanel5.add((Component)jPanel, new GridConstraints(1, 0, 1, 3, 0, 3, 3, 3, null, null, null));
        jLabel2.setLabelFor((Component)textFieldWithBrowseButton2);
        jLabel.setLabelFor((Component)textFieldWithBrowseButton);
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add((AbstractButton)jBRadioButton2);
        buttonGroup.add((AbstractButton)jBRadioButton);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myMainPanel;
    }

    private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }

    private /* synthetic */ void $$$loadButtonText$$$(AbstractButton abstractButton, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        abstractButton.setText(stringBuffer.toString());
        if (bl) {
            abstractButton.setMnemonic(c);
            abstractButton.setDisplayedMnemonicIndex(n);
        }
    }

    public static class TextsBuilder {
        @Nls
        protected String myTitle;
        @Nls
        protected String myScriptRadioButtonText;
        @Nls
        protected String myPhpExecutablePresentableName = FrameworkBundle.message("framework.php.executable", new Object[0]);
        @Nls
        protected String myScriptPathLabelText;
        @Nls
        protected String myScriptFileDescriptorTitle;
        @Nls
        protected String myScriptFileDescriptorDescription;
        @Nls
        protected String myExecutableRadioButtonText;
        @Nls
        protected String myExecutablePathLabelText;
        @Nls
        protected String myExecutableFileDescriptorTitle;
        @Nls
        protected String myExecutableFileDescriptorDescription;
    }
}

