/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.framework.ui;

import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.options.SearchableConfigurable;
import com.intellij.openapi.project.Project;
import com.jetbrains.php.FrameworkBundle;
import com.jetbrains.php.framework.data.FrameworkDataService;
import com.jetbrains.php.framework.ui.FrameworkCommandsForm;
import javax.swing.JComponent;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class FrameworkCommandsConfigurable
implements SearchableConfigurable,
Configurable.NoScroll {
    private final Project myProject;
    private FrameworkCommandsForm myForm;
    private final FrameworkDataService myConfig;

    public FrameworkCommandsConfigurable(Project project) {
        this.myProject = project;
        this.myConfig = FrameworkDataService.getInstance(this.myProject);
    }

    @Nls
    public String getDisplayName() {
        return FrameworkBundle.message("framework.configurable.title.command.line.tool.support", new Object[0]);
    }

    public String getHelpTopic() {
        return "reference.settings.command.line.tool.support";
    }

    public JComponent createComponent() {
        if (this.myForm == null) {
            this.myForm = new FrameworkCommandsForm(this.myProject);
        }
        return this.myForm.getContentPane();
    }

    public boolean isModified() {
        if (this.myForm == null) {
            return false;
        }
        return this.myForm.isModified(this.myConfig);
    }

    public void apply() throws ConfigurationException {
        this.myForm.apply(this.myConfig);
    }

    public void reset() {
        this.myForm.reset(this.myConfig);
    }

    public void disposeUIResources() {
        this.myForm = null;
    }

    @NotNull
    public String getId() {
        return "reference.webide.settings.project.settings.php.zend.framework.tool";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        return o != null && this.getClass() == o.getClass();
    }

    public int hashCode() {
        return 0;
    }
}

