/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.framework.runAnything;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.Executor;
import com.intellij.execution.configurations.ConfigurationFactory;
import com.intellij.execution.configurations.ConfigurationType;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.runners.ExecutionEnvironmentBuilder;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.actions.runAnything.RunAnythingAction;
import com.intellij.ide.actions.runAnything.RunAnythingCache;
import com.intellij.ide.actions.runAnything.RunAnythingUtil;
import com.intellij.ide.actions.runAnything.activity.RunAnythingCommandProvider;
import com.intellij.ide.actions.runAnything.commands.RunAnythingCommandCustomizer;
import com.intellij.ide.actions.runAnything.groups.RunAnythingGroup;
import com.intellij.ide.actions.runAnything.items.RunAnythingHelpItem;
import com.intellij.ide.actions.runAnything.items.RunAnythingItem;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationType;
import com.intellij.notification.Notifications;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.codeStyle.MinusculeMatcher;
import com.intellij.psi.codeStyle.NameUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.text.Matcher;
import com.jetbrains.php.FrameworkBundle;
import com.jetbrains.php.config.PhpProjectConfigurationFacade;
import com.jetbrains.php.config.interpreters.PhpInterpreter;
import com.jetbrains.php.config.interpreters.PhpInterpretersManagerImpl;
import com.jetbrains.php.framework.FrameworkCurrentInputData;
import com.jetbrains.php.framework.FrameworkUtils;
import com.jetbrains.php.framework.completion.FrameworkPathCompletionUtil;
import com.jetbrains.php.framework.data.FrameworkCommand;
import com.jetbrains.php.framework.data.FrameworkDataService;
import com.jetbrains.php.framework.data.FrameworkOption;
import com.jetbrains.php.framework.parsing.OptionPart;
import com.jetbrains.php.framework.parsing.ParamPart;
import com.jetbrains.php.framework.parsing.UserInputPart;
import com.jetbrains.php.framework.runAnything.FrameworkRunAnythingItem;
import com.jetbrains.php.framework.ui.FailedToParseDialog;
import com.jetbrains.php.run.PhpRunConfigurationFactoryBase;
import com.jetbrains.php.run.script.PhpScriptRunConfiguration;
import com.jetbrains.php.run.script.PhpScriptRunConfigurationType;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiFunction;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class FrameworkRunAnythingProvider
extends RunAnythingCommandProvider {
    private static final int ERROR_NOTIFICATION_LENGTH = 50;
    @NotNull
    private static final BiFunction<String, String, NameUtil.MatcherBuilder> FRAMEWORK_MATCHER_BUILDER = (pattern, alias) -> NameUtil.buildMatcher((String)FrameworkRunAnythingProvider.getAliasedPattern(pattern, alias));

    @NotNull
    public RunAnythingItem getMainListItem(@NotNull DataContext dataContext, @NotNull String value) {
        if (dataContext == null) {
            FrameworkRunAnythingProvider.$$$reportNull$$$0(0);
        }
        if (value == null) {
            FrameworkRunAnythingProvider.$$$reportNull$$$0(1);
        }
        return new FrameworkRunAnythingItem(RunAnythingUtil.fetchProject((DataContext)dataContext), this.getCommand(value), this.getIcon(value));
    }

    @Nullable
    public String findMatchingValue(@NotNull DataContext dataContext, @NotNull String pattern) {
        if (dataContext == null) {
            FrameworkRunAnythingProvider.$$$reportNull$$$0(2);
        }
        if (pattern == null) {
            FrameworkRunAnythingProvider.$$$reportNull$$$0(3);
        }
        FrameworkDataService frameworkDataService = FrameworkDataService.getInstance(RunAnythingUtil.fetchProject((DataContext)dataContext));
        Map<String, String> names = frameworkDataService.getAliasesAndNames();
        for (String alias : names.keySet()) {
            if (!pattern.equals(alias) && !pattern.startsWith(alias + " ")) continue;
            return this.getCommand(pattern);
        }
        return null;
    }

    @NotNull
    public Collection<String> getValues(@NotNull DataContext dataContext, @NotNull String pattern) {
        if (dataContext == null) {
            FrameworkRunAnythingProvider.$$$reportNull$$$0(4);
        }
        if (pattern == null) {
            FrameworkRunAnythingProvider.$$$reportNull$$$0(5);
        }
        VirtualFile virtualFile = (VirtualFile)CommonDataKeys.VIRTUAL_FILE.getData(dataContext);
        Project project = RunAnythingUtil.fetchProject((DataContext)dataContext);
        FrameworkDataService frameworkDataService = FrameworkDataService.getInstance(project);
        if (pattern.isEmpty() || virtualFile == null) {
            List list = ContainerUtil.emptyList();
            if (list == null) {
                FrameworkRunAnythingProvider.$$$reportNull$$$0(6);
            }
            return list;
        }
        if (!FrameworkRunAnythingProvider.isPatternContainsAlias(pattern, frameworkDataService)) {
            return FrameworkRunAnythingProvider.getMatchedCommands(project, pattern, frameworkDataService);
        }
        SmartList result = new SmartList();
        FrameworkRunAnythingProvider.addPartiallyMatchedCommandVariants(project, pattern, (List<String>)result, frameworkDataService);
        List<FrameworkCommand> frameworkCommands = frameworkDataService.getCommands();
        FrameworkCommand command = FrameworkCurrentInputData.countInputData(pattern, frameworkCommands).findCommand(true, true);
        if (command != null && pattern.startsWith(command.getAliasedBasicText() + " ")) {
            List<UserInputPart> userInputParts = FrameworkUtils.parseCurrentInput(pattern, command);
            UserInputPart lastPart = userInputParts.get(userInputParts.size() - 1);
            String normalizedPattern = StringUtil.substringBeforeLast((String)pattern, (String)lastPart.getText());
            FrameworkRunAnythingProvider.appendParamVariant(command, lastPart, (List<String>)result, normalizedPattern);
            FrameworkRunAnythingProvider.appendOptionVariants(command, lastPart, userInputParts, (List<String>)result, normalizedPattern);
        } else if (command == null) {
            FrameworkRunAnythingProvider.addAliasVariants(pattern, (List<String>)result, frameworkDataService);
        }
        boolean matched = ((StreamEx)StreamEx.of(frameworkCommands).filter(FrameworkCommand::isEnabled)).map(FrameworkCommand::getAliasedBasicText).anyMatch(aliasedCommand -> aliasedCommand.startsWith(pattern));
        if (!matched) {
            FrameworkPathCompletionUtil.addPathCompletionVariants(pattern, virtualFile, (List<String>)result);
        }
        SmartList smartList = result;
        if (smartList == null) {
            FrameworkRunAnythingProvider.$$$reportNull$$$0(7);
        }
        return smartList;
    }

    public void execute(@NotNull DataContext dataContext, @NotNull String value) {
        if (dataContext == null) {
            FrameworkRunAnythingProvider.$$$reportNull$$$0(8);
        }
        if (value == null) {
            FrameworkRunAnythingProvider.$$$reportNull$$$0(9);
        }
        Project project = RunAnythingUtil.fetchProject((DataContext)dataContext);
        FrameworkUtils.UserInputAnalyzer userInputAnalyzer = new FrameworkUtils.UserInputAnalyzer(value, dataContext, project);
        if (userInputAnalyzer.isExecutable && userInputAnalyzer.myCommandToExecute != null) {
            Object commandToExecute = userInputAnalyzer.myCommandToExecute;
            FrameworkUtils.logInvocation(project, userInputAnalyzer.myCommand);
            if ("EXECUTABLE".equals(StringUtil.split((String)commandToExecute, (String)" ").get(0))) {
                String command = StringUtil.substringAfter((String)commandToExecute, (String)"EXECUTABLE ");
                super.execute(dataContext, command == null ? "" : command);
            } else {
                PhpInterpreter interpreter;
                String interpreterName = (String)StringUtil.split((String)commandToExecute, (String)(((String)commandToExecute).contains("\"") ? "\"" : " ")).get(0);
                PhpInterpreter phpInterpreter = interpreter = "PROJECT_DEFAULT_INTERPRETER".equals(interpreterName) ? PhpProjectConfigurationFacade.getInstance((Project)project).getInterpreter() : PhpInterpretersManagerImpl.getInstance((Project)project).findInterpreterById(interpreterName);
                if (interpreter != null) {
                    if (interpreter.isRemote()) {
                        FrameworkRunAnythingProvider.runRemoteCommand(interpreter, (String)commandToExecute, dataContext, project);
                    } else {
                        String options = FrameworkRunAnythingProvider.getOptionString((String)commandToExecute, interpreterName);
                        commandToExecute = interpreter.getPathToPhpExecutable() + options;
                        super.execute(dataContext, (String)commandToExecute);
                    }
                } else {
                    super.execute(dataContext, (String)commandToExecute);
                }
            }
            FrameworkRunAnythingProvider.flushRedundantCommandFromCache(project, (String)commandToExecute);
        } else if (userInputAnalyzer.myErrorMessage != null) {
            FrameworkRunAnythingProvider.notifyErrorMessage(project, userInputAnalyzer);
        }
    }

    private static void runRemoteCommand(@NotNull PhpInterpreter interpreter, @NotNull String commandToExecute, @NotNull DataContext dataContext, @NotNull Project project) {
        if (interpreter == null) {
            FrameworkRunAnythingProvider.$$$reportNull$$$0(10);
        }
        if (commandToExecute == null) {
            FrameworkRunAnythingProvider.$$$reportNull$$$0(11);
        }
        if (dataContext == null) {
            FrameworkRunAnythingProvider.$$$reportNull$$$0(12);
        }
        if (project == null) {
            FrameworkRunAnythingProvider.$$$reportNull$$$0(13);
        }
        VirtualFile workDirectory = (VirtualFile)dataContext.getData(CommonDataKeys.VIRTUAL_FILE);
        Executor executor = (Executor)dataContext.getData(RunAnythingAction.EXECUTOR_KEY);
        assert (workDirectory != null);
        assert (executor != null);
        List commands = RunAnythingCache.getInstance((Project)project).getState().getCommands();
        commands.remove(commandToExecute);
        commands.add(commandToExecute);
        dataContext = RunAnythingCommandCustomizer.customizeContext((DataContext)dataContext);
        try {
            PhpRunConfigurationFactoryBase factory = new PhpRunConfigurationFactoryBase((ConfigurationType)PhpScriptRunConfigurationType.getInstance(), "PHP Console"){

                @NotNull
                public RunConfiguration createTemplateConfiguration(@NotNull Project project) {
                    if (project == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    return new PhpScriptRunConfiguration(project, (ConfigurationFactory)this, "");
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/php/framework/runAnything/FrameworkRunAnythingProvider$1", "createTemplateConfiguration"));
                }
            };
            PhpScriptRunConfiguration scriptRunConfiguration = new PhpScriptRunConfiguration(project, (ConfigurationFactory)factory, "PHP Console");
            String optionsString = FrameworkRunAnythingProvider.getOptionString(commandToExecute, commandToExecute.startsWith("PROJECT_DEFAULT_INTERPRETER") ? "PROJECT_DEFAULT_INTERPRETER" : interpreter.getId());
            List options = optionsString != null ? StringUtil.split((String)optionsString, (String)" ") : Collections.emptyList();
            ((PhpScriptRunConfiguration.Settings)scriptRunConfiguration.getSettings()).getCommandLineSettings().getInterpreterSettings().setInterpreterName(interpreter.getName());
            if (options.size() > 0) {
                ((PhpScriptRunConfiguration.Settings)scriptRunConfiguration.getSettings()).setPath((String)options.get(0));
                String scriptParameters = StringUtil.substringAfter((String)commandToExecute, (String)((String)options.get(0) + " "));
                if (scriptParameters != null) {
                    ((PhpScriptRunConfiguration.Settings)scriptRunConfiguration.getSettings()).setScriptParameters(scriptParameters);
                }
            }
            ExecutionEnvironmentBuilder.create((Executor)executor, (RunConfiguration)scriptRunConfiguration).dataContext(dataContext).buildAndExecute();
        }
        catch (ExecutionException e) {
            RunAnythingUtil.LOG.warn((Throwable)e);
            Messages.showInfoMessage((Project)project, (String)e.getMessage(), (String)IdeBundle.message((String)"run.anything.console.error.title", (Object[])new Object[0]));
        }
    }

    @Nullable
    public static String getOptionString(@NotNull String commandToExecute, String interpreterName) {
        if (commandToExecute == null) {
            FrameworkRunAnythingProvider.$$$reportNull$$$0(14);
        }
        return StringUtil.substringAfter((String)commandToExecute, (String)(commandToExecute.contains("\"") ? "\"" + interpreterName + "\"" : interpreterName));
    }

    private static void flushRedundantCommandFromCache(Project project, String commandToExecute) {
        List commands = RunAnythingCache.getInstance((Project)project).getState().getCommands();
        commands.remove(commandToExecute);
    }

    @NotNull
    public Matcher getMatcher(@NotNull DataContext dataContext, @NotNull String pattern) {
        if (dataContext == null) {
            FrameworkRunAnythingProvider.$$$reportNull$$$0(15);
        }
        if (pattern == null) {
            FrameworkRunAnythingProvider.$$$reportNull$$$0(16);
        }
        return FrameworkRunAnythingProvider.getMatcher(RunAnythingUtil.fetchProject((DataContext)dataContext), pattern);
    }

    @NotNull
    static Matcher getMatcher(@NotNull Project project, @Nullable String pattern) {
        if (project == null) {
            FrameworkRunAnythingProvider.$$$reportNull$$$0(17);
        }
        String alias = pattern != null ? FrameworkRunAnythingProvider.getAlias(project, pattern) : null;
        MinusculeMatcher minusculeMatcher = alias != null ? FRAMEWORK_MATCHER_BUILDER.apply(pattern, alias).build() : ((NameUtil.MatcherBuilder)RunAnythingGroup.RUN_ANYTHING_MATCHER_BUILDER.fun((Object)pattern)).build();
        if (minusculeMatcher == null) {
            FrameworkRunAnythingProvider.$$$reportNull$$$0(18);
        }
        return minusculeMatcher;
    }

    @Nullable
    private static String getAlias(@NotNull Project project, @NotNull String pattern) {
        if (project == null) {
            FrameworkRunAnythingProvider.$$$reportNull$$$0(19);
        }
        if (pattern == null) {
            FrameworkRunAnythingProvider.$$$reportNull$$$0(20);
        }
        FrameworkDataService frameworkDataService = FrameworkDataService.getInstance(project);
        for (String alias : frameworkDataService.getAliasesAndNames().keySet()) {
            if (!pattern.startsWith(alias + " ")) continue;
            return alias;
        }
        return null;
    }

    @NotNull
    private static String getAliasedPattern(@NotNull String pattern, @NotNull String alias) {
        if (pattern == null) {
            FrameworkRunAnythingProvider.$$$reportNull$$$0(21);
        }
        if (alias == null) {
            FrameworkRunAnythingProvider.$$$reportNull$$$0(22);
        }
        String patternWithoutAlias = (String)ObjectUtils.chooseNotNull((Object)StringUtil.substringAfter((String)pattern, (String)alias), (Object)pattern);
        String string = alias + "*" + StringUtil.trimTrailing((String)patternWithoutAlias);
        if (string == null) {
            FrameworkRunAnythingProvider.$$$reportNull$$$0(23);
        }
        return string;
    }

    @NotNull
    public String getCompletionGroupTitle() {
        String string = FrameworkBundle.message("framework.commands.form.messages.title.command.line.tools", new Object[0]);
        if (string == null) {
            FrameworkRunAnythingProvider.$$$reportNull$$$0(24);
        }
        return string;
    }

    @Nullable
    public RunAnythingHelpItem getHelpItem(@NotNull DataContext dataContext) {
        if (dataContext == null) {
            FrameworkRunAnythingProvider.$$$reportNull$$$0(25);
        }
        return null;
    }

    @NotNull
    public String getHelpCommand() {
        return "";
    }

    private static void notifyErrorMessage(final @NotNull Project project, final @NotNull FrameworkUtils.UserInputAnalyzer userInputAnalyzer) {
        if (project == null) {
            FrameworkRunAnythingProvider.$$$reportNull$$$0(26);
        }
        if (userInputAnalyzer == null) {
            FrameworkRunAnythingProvider.$$$reportNull$$$0(27);
        }
        String shortenError = StringUtil.shortenTextWithEllipsis((String)userInputAnalyzer.myErrorMessage, (int)50, (int)0);
        Notification info = new Notification("Command Line Tool", FrameworkBundle.message("framework.tool.window.message.title.command.line.tool", new Object[0]), shortenError, NotificationType.WARNING);
        info.addAction(new AnAction(){

            public void actionPerformed(@NotNull AnActionEvent e) {
                if (e == null) {
                    2.$$$reportNull$$$0(0);
                }
                new FailedToParseDialog(project, userInputAnalyzer.myErrorMessage).show();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/jetbrains/php/framework/runAnything/FrameworkRunAnythingProvider$2", "actionPerformed"));
            }
        });
        Notifications.Bus.notify((Notification)info, (Project)project);
    }

    private static boolean isPatternContainsAlias(@NotNull String pattern, @NotNull FrameworkDataService frameworkDataService) {
        if (pattern == null) {
            FrameworkRunAnythingProvider.$$$reportNull$$$0(28);
        }
        if (frameworkDataService == null) {
            FrameworkRunAnythingProvider.$$$reportNull$$$0(29);
        }
        return frameworkDataService.getAliasesAndNames().keySet().stream().anyMatch(alias -> alias.startsWith(pattern) || pattern.startsWith((String)alias));
    }

    private static void appendOptionVariants(@NotNull FrameworkCommand command, @NotNull UserInputPart lastPart, @NotNull List<UserInputPart> userInputParts, @NotNull List<String> result, @NotNull String toComplete) {
        if (command == null) {
            FrameworkRunAnythingProvider.$$$reportNull$$$0(30);
        }
        if (lastPart == null) {
            FrameworkRunAnythingProvider.$$$reportNull$$$0(31);
        }
        if (userInputParts == null) {
            FrameworkRunAnythingProvider.$$$reportNull$$$0(32);
        }
        if (result == null) {
            FrameworkRunAnythingProvider.$$$reportNull$$$0(33);
        }
        if (toComplete == null) {
            FrameworkRunAnythingProvider.$$$reportNull$$$0(34);
        }
        if (FrameworkRunAnythingProvider.isValidToCompleteOptionPart(command, lastPart)) {
            List<FrameworkOption> options = command.getOptionsBeforeParams();
            Set<FrameworkOption> matchedOptions = FrameworkRunAnythingProvider.getMatchedOptions(userInputParts, options);
            ((StreamEx)StreamEx.of(options).filter(option -> !matchedOptions.contains(option))).forEach(option -> FrameworkRunAnythingProvider.addOptionVariant(option, result, toComplete));
        }
    }

    private static void addOptionVariant(@NotNull FrameworkOption option, @NotNull List<String> result, @NotNull String inputWithCompletedOption) {
        if (option == null) {
            FrameworkRunAnythingProvider.$$$reportNull$$$0(35);
        }
        if (result == null) {
            FrameworkRunAnythingProvider.$$$reportNull$$$0(36);
        }
        if (inputWithCompletedOption == null) {
            FrameworkRunAnythingProvider.$$$reportNull$$$0(37);
        }
        result.add(inputWithCompletedOption + option.getName());
        if (option.hasShortcut()) {
            result.add(inputWithCompletedOption + option.getShortcut());
        }
    }

    static boolean isValidToCompleteOptionPart(@NotNull FrameworkCommand command, @NotNull UserInputPart lastPart) {
        if (command == null) {
            FrameworkRunAnythingProvider.$$$reportNull$$$0(38);
        }
        if (lastPart == null) {
            FrameworkRunAnythingProvider.$$$reportNull$$$0(39);
        }
        return !command.getOptionsBeforeParams().isEmpty() && lastPart instanceof OptionPart && (!((OptionPart)lastPart).hasValue() || ((OptionPart)lastPart).getValueText() == null);
    }

    private static Set<FrameworkOption> getMatchedOptions(@NotNull List<UserInputPart> userInputParts, @NotNull List<FrameworkOption> options) {
        if (userInputParts == null) {
            FrameworkRunAnythingProvider.$$$reportNull$$$0(40);
        }
        if (options == null) {
            FrameworkRunAnythingProvider.$$$reportNull$$$0(41);
        }
        return StreamEx.of(userInputParts).select(OptionPart.class).map(UserInputPart::getText).map(optionPart -> OptionPart.getMatchingOptionByName(optionPart, options)).nonNull().toSet();
    }

    private static void appendParamVariant(@NotNull FrameworkCommand command, @NotNull UserInputPart lastPart, @NotNull List<String> result, @NotNull String toComplete) {
        int currentParameterNumber;
        if (command == null) {
            FrameworkRunAnythingProvider.$$$reportNull$$$0(42);
        }
        if (lastPart == null) {
            FrameworkRunAnythingProvider.$$$reportNull$$$0(43);
        }
        if (result == null) {
            FrameworkRunAnythingProvider.$$$reportNull$$$0(44);
        }
        if (toComplete == null) {
            FrameworkRunAnythingProvider.$$$reportNull$$$0(45);
        }
        if ((currentParameterNumber = FrameworkRunAnythingProvider.getParamNumber(lastPart)) < command.getParameters().size()) {
            result.add(toComplete);
        }
    }

    static int getParamNumber(@NotNull UserInputPart lastPart) {
        if (lastPart == null) {
            FrameworkRunAnythingProvider.$$$reportNull$$$0(46);
        }
        return lastPart instanceof ParamPart ? ((ParamPart)lastPart).getNumber() + (lastPart.getText().isEmpty() ? 0 : 1) : 0;
    }

    private static void addAliasVariants(@NotNull String pattern, @NotNull List<String> result, @NotNull FrameworkDataService frameworkDataService) {
        if (pattern == null) {
            FrameworkRunAnythingProvider.$$$reportNull$$$0(47);
        }
        if (result == null) {
            FrameworkRunAnythingProvider.$$$reportNull$$$0(48);
        }
        if (frameworkDataService == null) {
            FrameworkRunAnythingProvider.$$$reportNull$$$0(49);
        }
        ((StreamEx)StreamEx.of(frameworkDataService.getAliasesAndNames().keySet()).filter(alias -> alias.startsWith(pattern))).forEach(result::add);
    }

    private static void addPartiallyMatchedCommandVariants(@NotNull Project project, @NotNull String pattern, @NotNull List<String> result, @NotNull FrameworkDataService frameworkDataService) {
        if (project == null) {
            FrameworkRunAnythingProvider.$$$reportNull$$$0(50);
        }
        if (pattern == null) {
            FrameworkRunAnythingProvider.$$$reportNull$$$0(51);
        }
        if (result == null) {
            FrameworkRunAnythingProvider.$$$reportNull$$$0(52);
        }
        if (frameworkDataService == null) {
            FrameworkRunAnythingProvider.$$$reportNull$$$0(53);
        }
        result.addAll(FrameworkRunAnythingProvider.getMatchedCommands(project, pattern, frameworkDataService));
    }

    @NotNull
    private static List<String> getMatchedCommands(@NotNull Project project, @NotNull String pattern, @NotNull FrameworkDataService frameworkDataService) {
        if (project == null) {
            FrameworkRunAnythingProvider.$$$reportNull$$$0(54);
        }
        if (pattern == null) {
            FrameworkRunAnythingProvider.$$$reportNull$$$0(55);
        }
        if (frameworkDataService == null) {
            FrameworkRunAnythingProvider.$$$reportNull$$$0(56);
        }
        Matcher matcher = FrameworkRunAnythingProvider.getMatcher(project, pattern);
        List list = ((StreamEx)((StreamEx)((StreamEx)StreamEx.of(frameworkDataService.getCommands()).filter(FrameworkCommand::isEnabled)).map(FrameworkCommand::getAliasedBasicText).filter(command -> !pattern.startsWith((String)command) || pattern.equals(command))).filter(arg_0 -> ((Matcher)matcher).matches(arg_0))).toList();
        if (list == null) {
            FrameworkRunAnythingProvider.$$$reportNull$$$0(57);
        }
        return list;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: 
            case 7: 
            case 18: 
            case 23: 
            case 24: 
            case 57: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: 
            case 7: 
            case 18: 
            case 23: 
            case 24: 
            case 57: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataContext";
                break;
            }
            case 1: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 3: 
            case 5: 
            case 16: 
            case 20: 
            case 21: 
            case 28: 
            case 47: 
            case 51: 
            case 55: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pattern";
                break;
            }
            case 6: 
            case 7: 
            case 18: 
            case 23: 
            case 24: 
            case 57: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/framework/runAnything/FrameworkRunAnythingProvider";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "interpreter";
                break;
            }
            case 11: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commandToExecute";
                break;
            }
            case 13: 
            case 17: 
            case 19: 
            case 26: 
            case 50: 
            case 54: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "alias";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "userInputAnalyzer";
                break;
            }
            case 29: 
            case 49: 
            case 53: 
            case 56: {
                objectArray2 = objectArray3;
                objectArray3[0] = "frameworkDataService";
                break;
            }
            case 30: 
            case 38: 
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = "command";
                break;
            }
            case 31: 
            case 39: 
            case 43: 
            case 46: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lastPart";
                break;
            }
            case 32: 
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "userInputParts";
                break;
            }
            case 33: 
            case 36: 
            case 44: 
            case 48: 
            case 52: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 34: 
            case 45: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toComplete";
                break;
            }
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "option";
                break;
            }
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "inputWithCompletedOption";
                break;
            }
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "options";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/framework/runAnything/FrameworkRunAnythingProvider";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getValues";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getMatcher";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "getAliasedPattern";
                break;
            }
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "getCompletionGroupTitle";
                break;
            }
            case 57: {
                objectArray = objectArray2;
                objectArray2[1] = "getMatchedCommands";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getMainListItem";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "findMatchingValue";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getValues";
                break;
            }
            case 6: 
            case 7: 
            case 18: 
            case 23: 
            case 24: 
            case 57: {
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "execute";
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "runRemoteCommand";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getOptionString";
                break;
            }
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "getMatcher";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "getAlias";
                break;
            }
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "getAliasedPattern";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "getHelpItem";
                break;
            }
            case 26: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "notifyErrorMessage";
                break;
            }
            case 28: 
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "isPatternContainsAlias";
                break;
            }
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "appendOptionVariants";
                break;
            }
            case 35: 
            case 36: 
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "addOptionVariant";
                break;
            }
            case 38: 
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "isValidToCompleteOptionPart";
                break;
            }
            case 40: 
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "getMatchedOptions";
                break;
            }
            case 42: 
            case 43: 
            case 44: 
            case 45: {
                objectArray = objectArray;
                objectArray[2] = "appendParamVariant";
                break;
            }
            case 46: {
                objectArray = objectArray;
                objectArray[2] = "getParamNumber";
                break;
            }
            case 47: 
            case 48: 
            case 49: {
                objectArray = objectArray;
                objectArray[2] = "addAliasVariants";
                break;
            }
            case 50: 
            case 51: 
            case 52: 
            case 53: {
                objectArray = objectArray;
                objectArray[2] = "addPartiallyMatchedCommandVariants";
                break;
            }
            case 54: 
            case 55: 
            case 56: {
                objectArray = objectArray;
                objectArray[2] = "getMatchedCommands";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: 
            case 7: 
            case 18: 
            case 23: 
            case 24: 
            case 57: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

