/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.framework.generators.symfonycomponent;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.RunCanceledByUserException;
import com.intellij.execution.process.ScriptRunnerUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.JDOMUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.jetbrains.php.FrameworkBundle;
import com.jetbrains.php.framework.FrameworkUtils;
import com.jetbrains.php.framework.data.FrameworkCommand;
import com.jetbrains.php.framework.data.FrameworkConfigurationDescription;
import com.jetbrains.php.framework.data.FrameworkDescription;
import com.jetbrains.php.framework.generators.FrameworkDescriptionProvider;
import com.jetbrains.php.framework.generators.symfony.SymfonyVersion;
import com.jetbrains.php.framework.generators.symfonycomponent.ComponentData;
import com.jetbrains.php.framework.generators.symfonycomponent.SymfonyComponentCommand;
import com.jetbrains.php.framework.generators.symfonycomponent.SymfonyComponentOption;
import com.jetbrains.php.framework.generators.symfonycomponent.SymfonyComponentParameter;
import com.jetbrains.php.framework.ui.FrameworkPathDialog;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class SymfonyComponentUtils {
    private static final Logger LOG = Logger.getInstance(SymfonyComponentUtils.class);
    @NonNls
    private static final String USAGE_PART_OF_HELP = "<p>Usage:<br>\n   [options] command [arguments]\n </p><br>\n";
    @NonNls
    private static final String VERSION_EXTRA_DATA = "version:";

    private SymfonyComponentUtils() {
    }

    @NonNls
    @NotNull
    public static FrameworkDescription getFrameworkDescription(FrameworkPathDialog.Data symfonyData, String alias, String frameworkName, @NonNls String frameworkId, @Nullable SymfonyVersion version) {
        String symfonyConsolePath = symfonyData.getPath(true);
        String phpCommand = symfonyData.getPhpPath(true);
        return new FrameworkDescription(frameworkName.replaceAll(" ", "_") + "_" + FrameworkUtils.getCurrentFormattedDate(), phpCommand + " " + symfonyConsolePath, alias, true, frameworkId, SymfonyComponentUtils.serializeToExtraData(version));
    }

    @NonNls
    public static FrameworkDescription getFrameworkDescription(String[] symfonyConsolePath, String alias, String frameworkName, @NonNls String frameworkId, @Nullable SymfonyVersion version) {
        Object invokeText = symfonyConsolePath[0];
        if (invokeText != null && ((String)invokeText).contains(" ")) {
            invokeText = "\"" + (String)invokeText + "\"";
        }
        if (symfonyConsolePath.length > 1) {
            Object scriptPath = symfonyConsolePath[1];
            if (scriptPath != null && ((String)scriptPath).contains(" ")) {
                scriptPath = "\"" + (String)scriptPath + "\"";
            }
            invokeText = (String)invokeText + " " + (String)scriptPath;
        }
        return new FrameworkDescription(frameworkName.replaceAll(" ", "_") + "_" + FrameworkUtils.getCurrentFormattedDate(), (String)invokeText, alias, true, frameworkId, SymfonyComponentUtils.serializeToExtraData(version));
    }

    @Nullable
    private static String serializeToExtraData(@Nullable SymfonyVersion version) {
        if (version == null) {
            return null;
        }
        return VERSION_EXTRA_DATA + version.getId();
    }

    @Nullable
    public static SymfonyVersion deserializeFromExtraData(@Nullable String data) {
        if (data == null) {
            return null;
        }
        if (!data.startsWith(VERSION_EXTRA_DATA)) {
            LOG.warn("Unexpected extra data for Symfony component: " + data + "_");
        }
        String version = data.substring(VERSION_EXTRA_DATA.length());
        for (SymfonyVersion symfonyVersion : SymfonyVersion.values()) {
            if (!symfonyVersion.getId().equals(version)) continue;
            return symfonyVersion;
        }
        LOG.warn("Unexpected extra data for Symfony component: " + data + "_");
        return null;
    }

    public static List<FrameworkCommand> getFrameworkCommands(String[] path, @Nullable Project project, @Nullable SymfonyVersion version, ProgressIndicator pi, FrameworkDescription frameworkDescription) throws ExecutionException, FrameworkDescriptionProvider.FrameworkParseException {
        if (version == null) {
            version = SymfonyComponentUtils.getVersion(path, project, null);
        }
        LOG.assertTrue(version.isSuitableForComponent(), (Object)version);
        return version.getCommands(path, project, frameworkDescription, pi);
    }

    public static List<FrameworkCommand> getFrameworkCommandsVersion2(String[] command, @Nullable Project project, ProgressIndicator pi, FrameworkDescription frameworkDescription) throws ExecutionException, FrameworkDescriptionProvider.FrameworkParseException {
        Element document;
        ScriptRunnerUtil.ScriptOutput listCommandsOutput = FrameworkUtils.executeCommandWithFullOutput(command, null, project, true, false);
        try {
            String output = listCommandsOutput.getFilteredOutput();
            int xmlIndex = output.indexOf(60);
            if (xmlIndex > 0) {
                output = output.substring(xmlIndex);
            }
            document = JDOMUtil.load((CharSequence)output);
        }
        catch (IOException e) {
            LOG.warn((Throwable)e);
            throw new ExecutionException(FrameworkBundle.message("framework.symfony.component.failed.to.parse.output", StringUtil.join((String[])command, (String)" "), e.getMessage()));
        }
        catch (JDOMException e) {
            LOG.warn((Throwable)e);
            throw new FrameworkDescriptionProvider.FrameworkParseException(command, listCommandsOutput.getDescriptiveOutput(), FrameworkBundle.message("framework.symfony.component.failed.to.parse.output.as.xml", e.getMessage()));
        }
        FrameworkUtils.checkProgress(pi);
        Element commandsElement = document.getChild("commands");
        if (commandsElement == null) {
            throw new FrameworkDescriptionProvider.FrameworkParseException(command, listCommandsOutput.getDescriptiveOutput(), FrameworkBundle.message("framework.symfony.component.failed.to.parse.command.output.0", FrameworkBundle.message("framework.symfony.component.commands.element.not.found", new Object[0])));
        }
        return SymfonyComponentUtils.getCommands(pi, frameworkDescription, commandsElement);
    }

    private static List<FrameworkCommand> getCommands(ProgressIndicator pi, FrameworkDescription frameworkDescription, Element commandsElement) throws RunCanceledByUserException {
        List commandElements = commandsElement.getChildren("command");
        ArrayList<SymfonyComponentCommand> symfonyComponentCommands = new ArrayList<SymfonyComponentCommand>(commandElements.size());
        for (Element element : commandElements) {
            symfonyComponentCommands.addAll(SymfonyComponentUtils.parseCommand(element));
            FrameworkUtils.checkProgress(pi);
        }
        ArrayList<FrameworkCommand> commands = new ArrayList<FrameworkCommand>(symfonyComponentCommands.size());
        for (SymfonyComponentCommand symfonyComponentCommand : symfonyComponentCommands) {
            commands.add(symfonyComponentCommand.standardize(frameworkDescription));
        }
        return commands;
    }

    static void appendOptions(@NonNls StringBuilder sb, Collection<? extends SymfonyComponentOption> symfonyComponentOptions) {
        sb.append("<table>\n<tr><td><strong>Options:</strong></td></tr>\n");
        for (SymfonyComponentOption symfonyComponentOption : symfonyComponentOptions) {
            sb.append("<tr><td>").append(symfonyComponentOption.getName()).append("</td><td>");
            if (!StringUtil.isEmpty((String)symfonyComponentOption.getShortcut())) {
                sb.append("(").append(symfonyComponentOption.getShortcut()).append(")");
            }
            sb.append("</td><td>");
            sb.append(symfonyComponentOption.getDescription()).append("</td></tr>\n");
        }
        sb.append("</table>\n<br/>\n");
    }

    private static List<SymfonyComponentCommand> parseCommand(Element element) {
        List aliasElements;
        Element aliasesElement;
        Element optionsElement;
        SymfonyComponentCommand command = new SymfonyComponentCommand();
        String name = element.getAttributeValue("name");
        command.setName(name);
        String usage = element.getChildText("usage");
        command.setUsageText(usage);
        String helpText = element.getChildText("help");
        command.setHelpText(SymfonyComponentUtils.htmlizeText(helpText));
        String description = element.getChildText("description");
        command.setDescription(description);
        Element argumentsElement = element.getChild("arguments");
        if (argumentsElement != null) {
            List argumentElements = argumentsElement.getChildren("argument");
            for (Element argumentElement : argumentElements) {
                String argName = argumentElement.getAttributeValue("name");
                boolean required = "1".equals(argumentElement.getAttributeValue("is_required"));
                String argDescription = SymfonyComponentUtils.htmlizeText(argumentElement.getChildText("description"));
                SymfonyComponentParameter param = new SymfonyComponentParameter();
                param.setName(argName);
                param.setDescription(argDescription);
                param.setDefaultValue(required ? null : "null");
                command.addParam(param);
            }
        }
        if ((optionsElement = element.getChild("options")) != null) {
            List optionElements = optionsElement.getChildren("option");
            for (Element optionElement : optionElements) {
                String optName = optionElement.getAttributeValue("name");
                String optShortcut = optionElement.getAttributeValue("shortcut");
                String optDescription = SymfonyComponentUtils.htmlizeText(optionElement.getChildText("description"));
                boolean valueAccepted = "1".equals(optionElement.getAttributeValue("accept_value"));
                SymfonyComponentOption option = new SymfonyComponentOption();
                option.setName(optName);
                option.setShortcut(optShortcut);
                option.setDescription(optDescription);
                option.setValueAccepted(valueAccepted);
                command.addOption(option);
            }
        }
        if ((aliasesElement = element.getChild("aliases")) != null && !(aliasElements = aliasesElement.getChildren("alias")).isEmpty()) {
            ArrayList<SymfonyComponentCommand> result = new ArrayList<SymfonyComponentCommand>(aliasElements.size() + 1);
            result.add(command);
            for (Element aliasElement : aliasElements) {
                String alias = aliasElement.getText();
                result.add(command.cloneWithAlias(alias));
            }
            return result;
        }
        return Collections.singletonList(command);
    }

    private static String htmlizeText(String usageText) {
        usageText = usageText.replaceAll("\n", "<br>");
        usageText = usageText.replaceAll("&lt;", "<");
        usageText = usageText.replaceAll("&gt;", ">");
        usageText = usageText.replaceAll("<info>", "<b>");
        usageText = usageText.replaceAll("</info>", "</b>");
        return usageText;
    }

    public static String @NotNull [] parseInvokeText(FrameworkConfigurationDescription framework) {
        String invokeText = framework.getInvokeText();
        if (invokeText == null) {
            String[] stringArray = new String[]{""};
            if (stringArray == null) {
                SymfonyComponentUtils.$$$reportNull$$$0(0);
            }
            return stringArray;
        }
        List elements = StringUtil.splitHonorQuotes((String)invokeText, (char)' ');
        switch (elements.size()) {
            case 0: {
                String[] stringArray = new String[]{""};
                if (stringArray == null) {
                    SymfonyComponentUtils.$$$reportNull$$$0(1);
                }
                return stringArray;
            }
            case 1: {
                String[] stringArray = new String[]{StringUtil.unquoteString((String)((String)elements.get(0)))};
                if (stringArray == null) {
                    SymfonyComponentUtils.$$$reportNull$$$0(2);
                }
                return stringArray;
            }
        }
        String[] stringArray = new String[]{StringUtil.unquoteString((String)((String)elements.get(0))), StringUtil.unquoteString((String)((String)elements.get(1)))};
        if (stringArray == null) {
            SymfonyComponentUtils.$$$reportNull$$$0(3);
        }
        return stringArray;
    }

    private static SymfonyVersion getVersion(String[] path, Project project, String workingFolder) throws ExecutionException, FrameworkDescriptionProvider.FrameworkParseException {
        ScriptRunnerUtil.ScriptOutput versionOutput;
        String[] command = ComponentData.createCommand(path, "-V");
        try {
            versionOutput = FrameworkUtils.executeCommandWithFullOutput(command, workingFolder, project, true, true);
        }
        catch (ExecutionException e) {
            LOG.warn((Throwable)e);
            throw new ExecutionException(FrameworkBundle.message("framework.symfony.failed.to.determine.version", new Object[0]));
        }
        return SymfonyVersion.getVersion(command, versionOutput);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/php/framework/generators/symfonycomponent/SymfonyComponentUtils", "parseInvokeText"));
    }
}

