/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.framework.generators.composer;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.RunCanceledByUserException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.jetbrains.php.FrameworkBundle;
import com.jetbrains.php.framework.data.FrameworkCommand;
import com.jetbrains.php.framework.data.FrameworkConfigurationDescription;
import com.jetbrains.php.framework.data.FrameworkDescription;
import com.jetbrains.php.framework.generators.AbstractFrameworkDescriptionProvider;
import com.jetbrains.php.framework.generators.FrameworkDescriptionProvider;
import com.jetbrains.php.framework.generators.composer.ComposerPathDialog;
import com.jetbrains.php.framework.generators.symfony.SymfonyVersion;
import com.jetbrains.php.framework.generators.symfonycomponent.SymfonyComponentUtils;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ComposerDescriptionProvider
extends AbstractFrameworkDescriptionProvider<String[]> {
    @NonNls
    public static final String COMPOSER_FRAMEWORK_ID = "org.getcomposer";

    @Override
    public FrameworkDescription getFrameworkDescription(String[] path) {
        return ComposerDescriptionProvider.getComposerFrameworkDescription(path);
    }

    @Override
    public List<FrameworkCommand> getFrameworkCommands(String[] path, @Nullable Project project, @NotNull ProgressIndicator progressIndicator) throws RunCanceledByUserException, FrameworkDescriptionProvider.FrameworkExecutionException, FrameworkDescriptionProvider.FrameworkParseException {
        if (progressIndicator == null) {
            ComposerDescriptionProvider.$$$reportNull$$$0(0);
        }
        try {
            FrameworkDescription description = this.getFrameworkDescription(path);
            return SymfonyVersion.VERSION_3.getCommands(path, project, description, progressIndicator);
        }
        catch (ExecutionException e) {
            throw new FrameworkDescriptionProvider.FrameworkExecutionException(e);
        }
    }

    @Override
    @NotNull
    public String getFrameworkName() {
        String string = ComposerDescriptionProvider.getFrameworkNameText();
        if (string == null) {
            ComposerDescriptionProvider.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Override
    public String @Nullable [] getFrameworkUserData(@Nullable Project project) throws RunCanceledByUserException {
        ComposerPathDialog dialog = ComposerPathDialog.getInstance(project);
        if (!dialog.showAndGet()) {
            throw new RunCanceledByUserException();
        }
        return dialog.getUserData();
    }

    @Override
    @Nullable
    public String getFrameworkId() {
        return COMPOSER_FRAMEWORK_ID;
    }

    @Override
    public String[] parseUserData(FrameworkConfigurationDescription framework) {
        return SymfonyComponentUtils.parseInvokeText(framework);
    }

    public static FrameworkDescription getComposerFrameworkDescription(String[] path) {
        return SymfonyComponentUtils.getFrameworkDescription(path, "c", ComposerDescriptionProvider.getFrameworkNameText(), COMPOSER_FRAMEWORK_ID, null);
    }

    public static String getFrameworkNameText() {
        return FrameworkBundle.message("framework.composer.name.composer", new Object[0]);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "progressIndicator";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/framework/generators/composer/ComposerDescriptionProvider";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/framework/generators/composer/ComposerDescriptionProvider";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getFrameworkName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getFrameworkCommands";
                break;
            }
            case 1: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

