/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.framework.data;

import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ultimate.PluginVerifier;
import com.jetbrains.php.framework.data.FrameworkApplicationDataService;
import com.jetbrains.php.framework.data.FrameworkCommand;
import com.jetbrains.php.framework.data.FrameworkConfigurationDescription;
import com.jetbrains.php.framework.data.FrameworkDataServiceBase;
import com.jetbrains.php.framework.data.FrameworkProjectDataService;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.xml.sax.SAXException;

public final class FrameworkDataService {
    @NonNls
    public static final String SCHEMA_DIRECTORY = "schemas";
    @NonNls
    public static final String SCHEMA_FILENAME = "frameworkDescriptionVersion1.1.4.xsd";
    private final FrameworkProjectDataService myProjectService;
    private final FrameworkApplicationDataService myApplicationService;

    public static FrameworkDataService getInstance(Project project) {
        return (FrameworkDataService)ServiceManager.getService((Project)project, FrameworkDataService.class);
    }

    public FrameworkDataService(Project project) {
        PluginVerifier.verifyUltimatePlugin();
        this.myProjectService = new FrameworkProjectDataService(project);
        this.myApplicationService = FrameworkApplicationDataService.getInstance();
    }

    public List<FrameworkFileData> cloneData() {
        ArrayList<FrameworkFileData> result = new ArrayList<FrameworkFileData>();
        result.addAll(this.myProjectService.cloneData());
        result.addAll(this.myApplicationService.cloneData());
        return result;
    }

    public void loadChanged(List<FrameworkFileData> items) {
        ArrayList<FrameworkFileData> projectLevelData = new ArrayList<FrameworkFileData>();
        ArrayList<FrameworkFileData> appLevelData = new ArrayList<FrameworkFileData>();
        for (FrameworkFileData item : items) {
            if (item.isProjectVisibility()) {
                projectLevelData.add(item);
                continue;
            }
            appLevelData.add(item);
        }
        this.myProjectService.loadChanged(projectLevelData);
        this.myApplicationService.loadChanged(appLevelData);
    }

    @NonNls
    public static String getFileName(String name) {
        return FileUtil.sanitizeFileName((String)name) + ".xml";
    }

    @NonNls
    public static String getFrameworkNameFromFileName(String name) {
        if (name.endsWith(".xml")) {
            return name.substring(0, name.length() - ".xml".length());
        }
        return name;
    }

    public List<FrameworkCommand> getCommands() {
        ArrayList<FrameworkCommand> commands = new ArrayList<FrameworkCommand>();
        commands.addAll(this.myProjectService.getCommands());
        commands.addAll(this.myApplicationService.getCommands());
        return commands;
    }

    public Map<String, String> getAliasesAndInvokeTexts() {
        HashMap<String, String> result = new HashMap<String, String>();
        result.putAll(this.myApplicationService.getAliasesAndInvokeTexts());
        result.putAll(this.myProjectService.getAliasesAndInvokeTexts());
        return result;
    }

    public Map<String, String> getAliasesAndNames() {
        HashMap<String, String> result = new HashMap<String, String>();
        result.putAll(this.myApplicationService.getAliasesAndNames());
        result.putAll(this.myProjectService.getAliasesAndNames());
        return result;
    }

    @NotNull
    public static FrameworkConfigurationDescription readFromElement(@NotNull Element element, String filename) throws SAXException {
        if (element == null) {
            FrameworkDataService.$$$reportNull$$$0(0);
        }
        FrameworkConfigurationDescription frameworkConfigurationDescription = FrameworkDataServiceBase.readFromDocument(element, filename);
        if (frameworkConfigurationDescription == null) {
            FrameworkDataService.$$$reportNull$$$0(1);
        }
        return frameworkConfigurationDescription;
    }

    @Nullable
    public VirtualFile getFile(FrameworkFileData data) {
        VirtualFile dir = data.isProjectVisibility() ? this.myProjectService.getDescriptionsDir(false) : this.myApplicationService.getDescriptionsDir(false);
        if (dir == null) {
            return null;
        }
        return dir.findChild(data.getFileName());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/framework/data/FrameworkDataService";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/framework/data/FrameworkDataService";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "readFromElement";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "readFromElement";
                break;
            }
            case 1: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class FrameworkFileData {
        private final FrameworkConfigurationDescription myFramework;
        private final String myErrorMessage;
        private final String myFileName;
        private boolean myProjectVisibility;

        public FrameworkFileData(FrameworkConfigurationDescription framework, String errorMessage, String fileName, boolean projectVisibility) {
            this.myFramework = framework;
            this.myErrorMessage = errorMessage;
            this.myFileName = fileName;
            this.myProjectVisibility = projectVisibility;
        }

        public FrameworkConfigurationDescription getFramework() {
            return this.myFramework;
        }

        public String getErrorMessage() {
            return this.myErrorMessage;
        }

        public String getFileName() {
            return this.myFileName;
        }

        public boolean isProjectVisibility() {
            return this.myProjectVisibility;
        }

        public void setProjectVisibility(boolean projectVisibility) {
            this.myProjectVisibility = projectVisibility;
        }
    }
}

