/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.framework.data;

import com.intellij.openapi.util.text.StringUtil;
import com.jetbrains.php.FrameworkBundle;
import com.jetbrains.php.framework.data.FrameworkDescription;
import com.jetbrains.php.framework.data.FrameworkOption;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jdom.CDATA;
import org.jdom.Content;
import org.jdom.Element;
import org.jdom.Text;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.xml.sax.SAXException;

public class FrameworkCommand {
    @NonNls
    public static final String COMMAND = "command";
    @NonNls
    private static final String NAME = "name";
    @NonNls
    private static final String PARAMS = "params";
    @NonNls
    private static final String BASIC_COMMAND = "basic";
    @NonNls
    private static final String PARAMETER = "parameter";
    @NonNls
    private static final String HELP = "help";
    @NonNls
    private static final String OPTIONS_BEFORE = "optionsBefore";
    private final List<Parameter> myParameters;
    private final boolean myInfiniteParameters;
    @NotNull
    private final String myBasicText;
    private String myHelp;
    private final int myMinAllowedParametersNumber;
    private final List<FrameworkOption> myOptionsBeforeParams;
    @NotNull
    private FrameworkDescription myFrameworkDescription;

    public FrameworkCommand(String name, List<Parameter> parameters, String help, @NotNull FrameworkDescription framework) {
        if (framework == null) {
            FrameworkCommand.$$$reportNull$$$0(0);
        }
        this(name, parameters, false, help, Collections.emptyList(), framework);
    }

    public FrameworkCommand(@NotNull String basicCommand, @NotNull List<Parameter> parameters, boolean infiniteParameters, @NotNull String help, @NotNull List<FrameworkOption> optionsBeforeParams, @NotNull FrameworkDescription framework) {
        if (basicCommand == null) {
            FrameworkCommand.$$$reportNull$$$0(1);
        }
        if (parameters == null) {
            FrameworkCommand.$$$reportNull$$$0(2);
        }
        if (help == null) {
            FrameworkCommand.$$$reportNull$$$0(3);
        }
        if (optionsBeforeParams == null) {
            FrameworkCommand.$$$reportNull$$$0(4);
        }
        if (framework == null) {
            FrameworkCommand.$$$reportNull$$$0(5);
        }
        if (basicCommand.endsWith(" ")) {
            basicCommand = basicCommand.trim();
        }
        this.myParameters = parameters;
        this.myInfiniteParameters = infiniteParameters;
        this.myBasicText = basicCommand;
        this.myFrameworkDescription = framework;
        this.myHelp = FrameworkDescription.normalizeHelp(help);
        this.myOptionsBeforeParams = optionsBeforeParams;
        int parametersWithoutDefaultValue = 0;
        for (Parameter parameter : this.myParameters) {
            if (parameter.hasDefaultValue()) continue;
            ++parametersWithoutDefaultValue;
        }
        this.myMinAllowedParametersNumber = parametersWithoutDefaultValue;
    }

    public boolean canBeUsedWithoutParameters() {
        return this.myParameters.isEmpty() || this.myMinAllowedParametersNumber == 0;
    }

    @NotNull
    public List<Parameter> getParameters() {
        List<Parameter> list = this.myParameters;
        if (list == null) {
            FrameworkCommand.$$$reportNull$$$0(6);
        }
        return list;
    }

    public boolean hasInfiniteParameters() {
        return this.myInfiniteParameters;
    }

    public int getMinAllowedParametersNumber() {
        return this.myMinAllowedParametersNumber;
    }

    @NotNull
    public FrameworkDescription getFrameworkDescription() {
        FrameworkDescription frameworkDescription = this.myFrameworkDescription;
        if (frameworkDescription == null) {
            FrameworkCommand.$$$reportNull$$$0(7);
        }
        return frameworkDescription;
    }

    public boolean belongsToFramework(FrameworkDescription frameworkDescription) {
        return this.myFrameworkDescription.getName().equals(frameworkDescription.getName());
    }

    public String getInvocationBasicText() {
        if (StringUtil.isEmpty((String)this.myBasicText)) {
            return this.myFrameworkDescription.getInvokeText();
        }
        return this.myFrameworkDescription.getInvokeText() + " " + this.myBasicText;
    }

    public String getAliasedBasicText() {
        if (StringUtil.isEmpty((String)this.myBasicText)) {
            return this.myFrameworkDescription.getAlias();
        }
        return this.myFrameworkDescription.getAlias() + " " + this.myBasicText;
    }

    public boolean isEnabled() {
        return this.myFrameworkDescription.isEnabled();
    }

    public void setFrameworkDescription(@NotNull FrameworkDescription frameworkDescription) {
        if (frameworkDescription == null) {
            FrameworkCommand.$$$reportNull$$$0(8);
        }
        this.myFrameworkDescription = frameworkDescription;
    }

    public String getHelp() {
        return this.myHelp;
    }

    public List<FrameworkOption> getOptionsBeforeParams() {
        return this.myOptionsBeforeParams;
    }

    public void setHelp(String help) {
        this.myHelp = FrameworkDescription.normalizeHelp(help);
    }

    public Element writeToElement() {
        Element element = new Element(COMMAND);
        Element nameChild = new Element(NAME);
        nameChild.addContent(this.myBasicText);
        element.addContent(nameChild);
        FrameworkCommand.writeHelp(element, this.myHelp);
        Element paramsChild = new Element(PARAMS);
        if (!this.myParameters.isEmpty()) {
            element.addContent(paramsChild);
            StringBuilder sb = new StringBuilder();
            for (Parameter parameter : this.myParameters) {
                sb.append(parameter.writeDescription()).append(" ");
            }
            if (this.myInfiniteParameters) {
                sb.append("... ");
            }
            paramsChild.addContent(sb.substring(0, sb.length() - 1));
        }
        if (!this.myOptionsBeforeParams.isEmpty()) {
            FrameworkCommand.writeOptions(element, this.myOptionsBeforeParams);
        }
        return element;
    }

    private static void writeOptions(Element options, List<FrameworkOption> frameworkOptions) {
        if (!frameworkOptions.isEmpty()) {
            Element before = new Element(OPTIONS_BEFORE);
            options.addContent(before);
            for (FrameworkOption param : frameworkOptions) {
                param.writeToElement(before);
            }
        }
    }

    static void writeHelp(Element element, @Nullable String help) {
        if (!StringUtil.isEmpty((String)help)) {
            Element helpChild = new Element(HELP);
            helpChild.setContent((Content)new CDATA(help));
            element.addContent(helpChild);
        }
    }

    @Nullable
    public static FrameworkCommand readFromElement(Element element, FrameworkDescription frameworkDescription, int version) throws SAXException {
        if (!COMMAND.equals(element.getName())) {
            throw new SAXException(FrameworkBundle.message("framework.0.element.should.contain.only.1.elements", "framework", COMMAND));
        }
        switch (version) {
            case 0: {
                String basicCommand = element.getAttributeValue(BASIC_COMMAND);
                if (StringUtil.isEmpty((String)basicCommand)) {
                    throw new SAXException(FrameworkBundle.message("framework.missing.required.non.empty.attribute.0.in.1.element", BASIC_COMMAND, COMMAND));
                }
                List parameterElements = element.getChildren(PARAMETER);
                ArrayList<Parameter> parameters = new ArrayList<Parameter>(parameterElements.size());
                boolean previousParameterHasDefaultValue = false;
                for (Element parameterElement : parameterElements) {
                    Parameter parameter = Parameter.readFromElement(parameterElement);
                    if (parameter == null) continue;
                    parameters.add(parameter);
                    if (parameter.getDefaultValue() != null) {
                        previousParameterHasDefaultValue = true;
                        continue;
                    }
                    if (!previousParameterHasDefaultValue) continue;
                    throw new SAXException(FrameworkBundle.message("framework.validation.parameter.0.should.have.default.value.because.previous.one.has.it", parameter.getName()));
                }
                return new FrameworkCommand(basicCommand, parameters, false, "", Collections.emptyList(), frameworkDescription);
            }
            case 1: 
            case 2: {
                List<Parameter> parameters;
                Element nameElement = element.getChild(NAME);
                if (nameElement == null) {
                    throw new SAXException(FrameworkBundle.message("framework.validation.element.0.should.contain.1.element", COMMAND, NAME));
                }
                String basicCommand = nameElement.getValue();
                if (basicCommand == null || StringUtil.isEmptyOrSpaces((String)basicCommand)) {
                    basicCommand = "";
                }
                basicCommand = StringUtil.convertLineSeparators((String)basicCommand, (String)" ");
                Element paramsElement = element.getChild(PARAMS);
                boolean infiniteParams = false;
                if (paramsElement == null) {
                    parameters = Collections.emptyList();
                } else {
                    String params = paramsElement.getValue();
                    if (params == null || StringUtil.isEmptyOrSpaces((String)params)) {
                        parameters = Collections.emptyList();
                    } else {
                        if (params.endsWith(" ...")) {
                            infiniteParams = true;
                            params = params.substring(0, params.length() - " ...".length());
                        }
                        params = StringUtil.convertLineSeparators((String)params, (String)" ");
                        parameters = Parameter.parse(params);
                    }
                }
                String help = FrameworkCommand.readHelp(element);
                List<FrameworkOption> beforeOptions = FrameworkCommand.getOptions(element);
                return new FrameworkCommand(basicCommand, parameters, infiniteParams, help, beforeOptions, frameworkDescription);
            }
        }
        throw new AssertionError((Object)("Unknown version: " + version));
    }

    private static List<FrameworkOption> getOptions(Element options) throws SAXException {
        Element before;
        List<FrameworkOption> beforeOptions = Collections.emptyList();
        if (options != null && (before = options.getChild(OPTIONS_BEFORE)) != null) {
            beforeOptions = new ArrayList<FrameworkOption>();
            for (Element o : before.getChildren("option")) {
                beforeOptions.add(FrameworkOption.readFromElement(o, OPTIONS_BEFORE));
            }
        }
        return beforeOptions;
    }

    static String readHelp(Element element) {
        List helpContent;
        String help = "";
        Element helpChild = element.getChild(HELP);
        if (helpChild != null && !(helpContent = helpChild.getContent()).isEmpty()) {
            Object content = helpContent.get(0);
            if (content instanceof CDATA) {
                help = ((CDATA)content).getText();
            } else if (content instanceof Text) {
                help = ((Text)content).getText();
            }
        }
        return help;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof FrameworkCommand)) {
            return false;
        }
        FrameworkCommand that = (FrameworkCommand)o;
        return this.myBasicText.equals(that.myBasicText);
    }

    public boolean equalsIgnoreFramework(FrameworkCommand that) {
        if (!this.myBasicText.equals(that.myBasicText)) {
            return false;
        }
        if (this.myHelp != null ? !this.myHelp.equals(that.myHelp) : that.myHelp != null) {
            return false;
        }
        if (this.myInfiniteParameters != that.myInfiniteParameters) {
            return false;
        }
        return FrameworkCommand.equalParameterLists(this.myParameters, that.myParameters);
    }

    private static boolean equalParameterLists(@NotNull List<Parameter> first, @NotNull List<Parameter> second) {
        if (first == null) {
            FrameworkCommand.$$$reportNull$$$0(9);
        }
        if (second == null) {
            FrameworkCommand.$$$reportNull$$$0(10);
        }
        if (first.size() != second.size()) {
            return false;
        }
        for (Parameter firstParameter : first) {
            boolean found = false;
            for (Parameter secondParameter : second) {
                if (!firstParameter.equals(secondParameter)) continue;
                found = true;
                break;
            }
            if (found) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        return this.myBasicText.hashCode();
    }

    public FrameworkCommand cloneCommand() {
        ArrayList<Parameter> parameters = new ArrayList<Parameter>(this.myParameters);
        ArrayList<FrameworkOption> optionsBefore = new ArrayList<FrameworkOption>(this.myOptionsBeforeParams);
        return new FrameworkCommand(this.myBasicText, parameters, this.myInfiniteParameters, this.myHelp, optionsBefore, this.myFrameworkDescription);
    }

    public String toString() {
        @NonNls StringBuilder sb = new StringBuilder("FrameworkCommand{");
        sb.append("myParameters=\n").append(this.myParameters);
        sb.append(",\n myInfiniteParameters=\n").append(this.myInfiniteParameters);
        sb.append(",\n myBasicText=\n'").append(this.myBasicText).append('\'');
        sb.append(",\n myHelp=\n'").append(this.myHelp).append('\'');
        sb.append(",\n myMinAllowedParametersNumber=\n").append(this.myMinAllowedParametersNumber);
        sb.append(",\n myOptionsBeforeParams=\n").append(this.myOptionsBeforeParams);
        sb.append('}');
        return sb.toString();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: 
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: 
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "framework";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "basicCommand";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameters";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = HELP;
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "optionsBeforeParams";
                break;
            }
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/framework/data/FrameworkCommand";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "frameworkDescription";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "first";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "second";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/framework/data/FrameworkCommand";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getParameters";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getFrameworkDescription";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 6: 
            case 7: {
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "setFrameworkDescription";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "equalParameterLists";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: 
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class Parameter {
        @NonNls
        private static final String NAME = "name";
        @NonNls
        private static final String VALUE = "value";
        private final String myName;
        private String myDefaultValue;

        public Parameter(@NotNull String name) {
            if (name == null) {
                Parameter.$$$reportNull$$$0(0);
            }
            this(name, null);
        }

        public Parameter(@NotNull String name, @NonNls @Nullable String defaultValue) {
            if (name == null) {
                Parameter.$$$reportNull$$$0(1);
            }
            this.myDefaultValue = defaultValue;
            this.myName = name;
        }

        @Nullable
        public String getDefaultValue() {
            return this.myDefaultValue;
        }

        public String getName() {
            return this.myName;
        }

        public void setDefaultValue(String defaultValue) {
            this.myDefaultValue = defaultValue;
        }

        public boolean hasDefaultValue() {
            return !StringUtil.isEmpty((String)this.myDefaultValue);
        }

        public String writeDescription() {
            if (this.myDefaultValue == null) {
                return this.myName;
            }
            return this.myName + "[=" + this.myDefaultValue + "]";
        }

        public static List<Parameter> parse(String params) throws SAXException {
            List parts = StringUtil.splitHonorQuotes((String)params, (char)' ');
            ArrayList<Parameter> result = new ArrayList<Parameter>(parts.size());
            boolean defaultValueFound = false;
            for (String part : parts) {
                int valueIndex;
                if (part.endsWith("]") && (valueIndex = part.indexOf("[=")) != -1) {
                    defaultValueFound = true;
                    result.add(new Parameter(part.substring(0, valueIndex), part.substring(valueIndex + 2, part.length() - 1)));
                    continue;
                }
                if (StringUtil.isEmptyOrSpaces((String)part)) continue;
                if (defaultValueFound) {
                    throw new SAXException(FrameworkBundle.message("framework.validation.parameter.0.should.have.default.value.because.previous.one.has.it", part));
                }
                result.add(new Parameter(part));
            }
            return result;
        }

        @Nullable
        public static Parameter readFromElement(Element element) throws SAXException {
            String name = element.getAttributeValue("name");
            if (StringUtil.isEmpty((String)name)) {
                throw new SAXException(FrameworkBundle.message("framework.missing.required.non.empty.attribute.0.in.1.element", "name", FrameworkCommand.PARAMETER));
            }
            Parameter parameter = new Parameter(name);
            parameter.setDefaultValue(element.getAttributeValue(VALUE));
            return parameter;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Parameter parameter = (Parameter)o;
            if (!this.myName.equals(parameter.myName)) {
                return false;
            }
            return !(this.myDefaultValue != null ? !this.myDefaultValue.equals(parameter.myDefaultValue) : parameter.myDefaultValue != null);
        }

        public int hashCode() {
            int result = this.myName.hashCode();
            result = 31 * result + (this.myDefaultValue != null ? this.myDefaultValue.hashCode() : 0);
            return result;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/jetbrains/php/framework/data/FrameworkCommand$Parameter", "<init>"));
        }
    }
}

