/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.io.geojson;

import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.json.simple.JSONAware;
import org.json.simple.JSONObject;
import org.locationtech.jts.geom.CoordinateSequence;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryCollection;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.MultiLineString;
import org.locationtech.jts.geom.MultiPoint;
import org.locationtech.jts.geom.MultiPolygon;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.geom.Polygon;
import org.locationtech.jts.util.Assert;

public class GeoJsonWriter {
    public static final String EPSG_PREFIX = "EPSG:";
    private double scale;
    private boolean isEncodeCRS = true;

    public GeoJsonWriter() {
        this(8);
    }

    public GeoJsonWriter(int decimals) {
        this.scale = Math.pow(10.0, decimals);
    }

    public void setEncodeCRS(boolean isEncodeCRS) {
        this.isEncodeCRS = isEncodeCRS;
    }

    public String write(Geometry geometry) {
        StringWriter writer = new StringWriter();
        try {
            this.write(geometry, writer);
        }
        catch (IOException ex) {
            Assert.shouldNeverReachHere();
        }
        return writer.toString();
    }

    public void write(Geometry geometry, Writer writer) throws IOException {
        Map<String, Object> map = this.create(geometry, this.isEncodeCRS);
        JSONObject.writeJSONString(map, writer);
        writer.flush();
    }

    private Map<String, Object> create(Geometry geometry, boolean encodeCRS) {
        LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>();
        result.put("type", geometry.getGeometryType());
        if (geometry instanceof Point) {
            Point point = (Point)geometry;
            final String jsonString = this.getJsonString(point.getCoordinateSequence());
            result.put("coordinates", new JSONAware(){

                @Override
                public String toJSONString() {
                    return jsonString;
                }
            });
        } else if (geometry instanceof LineString) {
            LineString lineString = (LineString)geometry;
            final String jsonString = this.getJsonString(lineString.getCoordinateSequence());
            result.put("coordinates", new JSONAware(){

                @Override
                public String toJSONString() {
                    return jsonString;
                }
            });
        } else if (geometry instanceof Polygon) {
            Polygon polygon = (Polygon)geometry;
            result.put("coordinates", this.makeJsonAware(polygon));
        } else if (geometry instanceof MultiPoint) {
            MultiPoint multiPoint = (MultiPoint)geometry;
            result.put("coordinates", this.makeJsonAware(multiPoint));
        } else if (geometry instanceof MultiLineString) {
            MultiLineString multiLineString = (MultiLineString)geometry;
            result.put("coordinates", this.makeJsonAware(multiLineString));
        } else if (geometry instanceof MultiPolygon) {
            MultiPolygon multiPolygon = (MultiPolygon)geometry;
            result.put("coordinates", this.makeJsonAware(multiPolygon));
        } else if (geometry instanceof GeometryCollection) {
            GeometryCollection geometryCollection = (GeometryCollection)geometry;
            ArrayList<Map<String, Object>> geometries = new ArrayList<Map<String, Object>>(geometryCollection.getNumGeometries());
            for (int i = 0; i < geometryCollection.getNumGeometries(); ++i) {
                geometries.add(this.create(geometryCollection.getGeometryN(i), false));
            }
            result.put("geometries", geometries);
        } else {
            throw new IllegalArgumentException("Unable to encode geometry " + geometry.getGeometryType());
        }
        if (encodeCRS) {
            result.put("crs", this.createCRS(geometry.getSRID()));
        }
        return result;
    }

    private Map<String, Object> createCRS(int srid) {
        LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>();
        result.put("type", "name");
        LinkedHashMap<String, String> props = new LinkedHashMap<String, String>();
        props.put("name", EPSG_PREFIX + srid);
        result.put("properties", props);
        return result;
    }

    private List<JSONAware> makeJsonAware(Polygon poly) {
        ArrayList<JSONAware> result = new ArrayList<JSONAware>();
        final String jsonString = this.getJsonString(poly.getExteriorRing().getCoordinateSequence());
        result.add(new JSONAware(){

            @Override
            public String toJSONString() {
                return jsonString;
            }
        });
        for (int i = 0; i < poly.getNumInteriorRing(); ++i) {
            final String jsonString2 = this.getJsonString(poly.getInteriorRingN(i).getCoordinateSequence());
            result.add(new JSONAware(){

                @Override
                public String toJSONString() {
                    return jsonString2;
                }
            });
        }
        return result;
    }

    private List<Object> makeJsonAware(GeometryCollection geometryCollection) {
        ArrayList<Object> list = new ArrayList<Object>(geometryCollection.getNumGeometries());
        for (int i = 0; i < geometryCollection.getNumGeometries(); ++i) {
            String jsonString;
            Geometry geometry = geometryCollection.getGeometryN(i);
            if (geometry instanceof Polygon) {
                Polygon polygon = (Polygon)geometry;
                list.add(this.makeJsonAware(polygon));
                continue;
            }
            if (geometry instanceof LineString) {
                LineString lineString = (LineString)geometry;
                jsonString = this.getJsonString(lineString.getCoordinateSequence());
                list.add(new JSONAware(){

                    @Override
                    public String toJSONString() {
                        return jsonString;
                    }
                });
                continue;
            }
            if (!(geometry instanceof Point)) continue;
            Point point = (Point)geometry;
            jsonString = this.getJsonString(point.getCoordinateSequence());
            list.add(new JSONAware(){

                @Override
                public String toJSONString() {
                    return jsonString;
                }
            });
        }
        return list;
    }

    private String getJsonString(CoordinateSequence coordinateSequence) {
        StringBuffer result = new StringBuffer();
        if (coordinateSequence.size() > 1) {
            result.append("[");
        }
        for (int i = 0; i < coordinateSequence.size(); ++i) {
            double z;
            if (i > 0) {
                result.append(",");
            }
            result.append("[");
            result.append(this.formatOrdinate(coordinateSequence.getOrdinate(i, 0)));
            result.append(",");
            result.append(this.formatOrdinate(coordinateSequence.getOrdinate(i, 1)));
            if (coordinateSequence.getDimension() > 2 && !Double.isNaN(z = coordinateSequence.getOrdinate(i, 2))) {
                result.append(",");
                result.append(this.formatOrdinate(z));
            }
            result.append("]");
        }
        if (coordinateSequence.size() > 1) {
            result.append("]");
        }
        return result.toString();
    }

    private String formatOrdinate(double x) {
        long lx;
        String result = null;
        result = Math.abs(x) >= Math.pow(10.0, -3.0) && x < Math.pow(10.0, 7.0) ? ((double)(lx = (long)(x = Math.floor(x * this.scale + 0.5) / this.scale)) == x ? Long.toString(lx) : Double.toString(x)) : Double.toString(x);
        return result;
    }
}

