/*
 * Decompiled with CFR 0.152.
 */
package com.mallowigi.idea.wizard.steps;

import com.intellij.ide.customize.AbstractCustomizeWizardStep;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.ui.components.JBScrollPane;
import com.mallowigi.idea.MTConfig;
import com.mallowigi.idea.MTLicenseChecker;
import com.mallowigi.idea.config.enums.IndicatorStyles;
import com.mallowigi.idea.messages.MTWizardBundle;
import com.mallowigi.idea.utils.MTUiUtils;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Font;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.util.ResourceBundle;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.JTextPane;
import javax.swing.SpinnerModel;
import javax.swing.SpinnerNumberModel;
import javax.swing.UIManager;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import net.miginfocom.swing.MigLayout;
import org.jetbrains.annotations.NotNull;

public final class MTWizardOtherOptionsPanel
extends AbstractCustomizeWizardStep {
    private SpinnerModel highlightSpinnerModel;
    private SpinnerModel tabsHeightSpinnerModel;
    private SpinnerModel customSidebarHeightModel;
    private final MTConfig config = MTConfig.getInstance();
    private JBScrollPane scrollPane;
    private JPanel content;
    private JPanel tabsPanel;
    private JSpinner tabHeightSpinner;
    private JTextPane tabHeightDesc;
    private JSpinner highlightSpinner;
    private JTextPane thicknessDesc;
    private JCheckBox uppercaseTabsCheckbox;
    private JTextPane uppercaseTabsDesc;
    private JPanel otherPanel;
    private JCheckBox fileColorsCheckbox;
    private JTextPane fileColorsDesc;
    private JCheckBox materialWallpapersCheckbox;
    private JTextPane materialWallpapersLabel;
    private JCheckBox projectFrameCheckbox;
    private JTextPane projectFrameLabel;
    private JPanel panelPanel;
    private JCheckBox compactStatusCheckbox;
    private JTextPane compactStatusDesc;
    private JCheckBox compactTableCheckbox;
    private JTextPane compactTableDesc;
    private JCheckBox compactDropdownCheckbox;
    private JTextPane compactStatusDesc2;
    private JCheckBox compactMenusCheckbox;
    private JTextPane compactMenusDesc3;
    private JLabel label1;
    private JPanel projectPanel;
    private JSpinner sidebarHeightSpinner;
    private JTextPane sidebarHeightDesc;
    private JLabel selectedIndicatorLabel;
    private ComboBox<IndicatorStyles> indicatorStyleComboBox;
    private JTextPane arrowsStyleDesc2;

    public MTWizardOtherOptionsPanel() {
        this.initComponents();
        this.init();
        this.setupComponents();
    }

    private void setupComponents() {
        boolean isFreeLicense;
        this.compactStatusCheckbox.setSelected(this.config.isCompactStatusBar());
        this.compactDropdownCheckbox.setSelected(this.config.isCompactDropdowns());
        this.compactTableCheckbox.setSelected(this.config.isCompactTables());
        this.fileColorsCheckbox.setSelected(this.config.isFileStatusColorsEnabled());
        this.indicatorStyleComboBox.setSelectedItem((Object)this.config.getIndicatorStyle());
        this.materialWallpapersCheckbox.setSelected(this.config.isUseMaterialWallpapers());
        this.projectFrameCheckbox.setSelected(this.config.isUseProjectFrame());
        boolean bl = isFreeLicense = !MTLicenseChecker.isLicensed();
        if (isFreeLicense) {
            MTUiUtils.disablePremium(this.tabHeightSpinner);
            MTUiUtils.disablePremium(this.tabHeightDesc);
            MTUiUtils.disablePremium(this.highlightSpinner);
            MTUiUtils.disablePremium(this.thicknessDesc);
            MTUiUtils.disablePremium(this.uppercaseTabsCheckbox);
            MTUiUtils.disablePremium(this.uppercaseTabsDesc);
            MTUiUtils.disablePremium(this.fileColorsCheckbox);
            MTUiUtils.disablePremium(this.fileColorsDesc);
            MTUiUtils.disablePremium(this.materialWallpapersCheckbox);
            MTUiUtils.disablePremium(this.materialWallpapersLabel);
            MTUiUtils.disablePremium(this.projectFrameCheckbox);
            MTUiUtils.disablePremium(this.projectFrameLabel);
            MTUiUtils.disablePremium(this.compactStatusCheckbox);
            MTUiUtils.disablePremium(this.compactStatusDesc);
            MTUiUtils.disablePremium(this.compactTableCheckbox);
            MTUiUtils.disablePremium(this.compactTableDesc);
            MTUiUtils.disablePremium(this.compactDropdownCheckbox);
            MTUiUtils.disablePremium(this.compactStatusDesc2);
            MTUiUtils.disablePremium(this.compactMenusCheckbox);
            MTUiUtils.disablePremium(this.compactMenusDesc3);
            MTUiUtils.disablePremium(this.sidebarHeightSpinner);
            MTUiUtils.disablePremium(this.sidebarHeightDesc);
            MTUiUtils.disablePremium(this.selectedIndicatorLabel);
            MTUiUtils.disablePremium(this.indicatorStyleComboBox);
        }
    }

    private void init() {
        int highlightThickness = MTWizardOtherOptionsPanel.valueInRange(this.config.getHighlightThickness(), 1, 5);
        int tabsHeight = MTWizardOtherOptionsPanel.valueInRange(this.config.getTabsHeight(), 10, 60);
        int customSidebarHeight = MTWizardOtherOptionsPanel.valueInRange(this.config.getCustomSidebarHeight(), 18, 36);
        this.highlightSpinnerModel = new SpinnerNumberModel(highlightThickness, 1, 5, 1);
        this.highlightSpinner.setModel(this.highlightSpinnerModel);
        this.tabsHeightSpinnerModel = new SpinnerNumberModel(tabsHeight, 10, 60, 1);
        this.tabHeightSpinner.setModel(this.tabsHeightSpinnerModel);
        this.customSidebarHeightModel = new SpinnerNumberModel(customSidebarHeight, 18, 36, 2);
        this.sidebarHeightSpinner.setModel(this.customSidebarHeightModel);
    }

    public String getTitle() {
        return MTWizardBundle.message("other.options.panel.title", new Object[0]);
    }

    public String getHTMLHeader() {
        return MTWizardBundle.message("other.options.panel.body", new Object[0]);
    }

    @NotNull
    public String getHTMLFooter() {
        String string = MTWizardBundle.message("other.options.panel.footer", new Object[0]);
        if (string == null) {
            MTWizardOtherOptionsPanel.$$$reportNull$$$0(0);
        }
        return string;
    }

    private void tabHeightSpinnerStateChanged(ChangeEvent e) {
        this.config.setTabsHeight((Integer)this.tabHeightSpinner.getModel().getValue());
    }

    private void highlightSpinnerStateChanged(ChangeEvent e) {
        this.config.setHighlightThickness((Integer)this.highlightSpinner.getModel().getValue());
    }

    private void compactStatusCheckboxActionPerformed(ActionEvent e) {
        this.config.setCompactStatusBar(this.compactStatusCheckbox.isSelected());
    }

    private void uppercaseTabsCheckboxActionPerformed(ActionEvent e) {
        this.config.setUpperCaseButtons(this.uppercaseTabsCheckbox.isSelected());
    }

    private void compactTableCheckboxActionPerformed(ActionEvent e) {
        this.config.setCompactTables(this.compactTableCheckbox.isSelected());
    }

    private void compactDropdownCheckboxActionPerformed(ActionEvent e) {
        this.config.setCompactDropdowns(this.compactDropdownCheckbox.isSelected());
    }

    private void sidebarHeightSpinnerStateChanged(ChangeEvent e) {
        this.config.setCompactSidebar(true);
        this.config.setCustomSidebarHeight((Integer)this.sidebarHeightSpinner.getModel().getValue());
    }

    private void indicatorStyleComboBoxActionPerformed(ActionEvent e) {
        this.config.setIndicatorStyle((IndicatorStyles)((Object)this.indicatorStyleComboBox.getSelectedItem()));
    }

    private void mtWallpapersCheckboxActionPerformed(ActionEvent e) {
        this.config.setUseMaterialWallpapers(this.materialWallpapersCheckbox.isSelected());
    }

    private void compactMenusCheckboxActionPerformed(ActionEvent e) {
        this.config.setCompactMenus(this.compactMenusCheckbox.isSelected());
    }

    private void fileColorsCheckboxActionPerformed(ActionEvent e) {
        this.config.setFileStatusColorsEnabled(this.fileColorsCheckbox.isSelected());
    }

    private void projectFrameCheckboxActionPerformed(ActionEvent e) {
        this.config.setUseProjectFrame(this.projectFrameCheckbox.isSelected());
    }

    private void initComponents() {
        ResourceBundle bundle = ResourceBundle.getBundle("messages.MTWizardBundle");
        this.scrollPane = new JBScrollPane();
        this.content = new JPanel();
        this.tabsPanel = new JPanel();
        JLabel tabHeight = new JLabel();
        this.tabHeightSpinner = new JSpinner();
        this.tabHeightDesc = new JTextPane();
        JLabel thicknessLabel = new JLabel();
        this.highlightSpinner = new JSpinner();
        this.thicknessDesc = new JTextPane();
        this.uppercaseTabsCheckbox = new JCheckBox();
        this.uppercaseTabsDesc = new JTextPane();
        this.otherPanel = new JPanel();
        this.fileColorsCheckbox = new JCheckBox();
        this.fileColorsDesc = new JTextPane();
        this.materialWallpapersCheckbox = new JCheckBox();
        this.materialWallpapersLabel = new JTextPane();
        this.projectFrameCheckbox = new JCheckBox();
        this.projectFrameLabel = new JTextPane();
        this.panelPanel = new JPanel();
        this.compactStatusCheckbox = new JCheckBox();
        this.compactStatusDesc = new JTextPane();
        this.compactTableCheckbox = new JCheckBox();
        this.compactTableDesc = new JTextPane();
        this.compactDropdownCheckbox = new JCheckBox();
        this.compactStatusDesc2 = new JTextPane();
        this.compactMenusCheckbox = new JCheckBox();
        this.compactMenusDesc3 = new JTextPane();
        this.label1 = new JLabel();
        this.projectPanel = new JPanel();
        JLabel sidebarHeight = new JLabel();
        this.sidebarHeightSpinner = new JSpinner();
        this.sidebarHeightDesc = new JTextPane();
        this.selectedIndicatorLabel = new JLabel();
        this.indicatorStyleComboBox = new ComboBox();
        this.arrowsStyleDesc2 = new JTextPane();
        this.setLayout(new BorderLayout());
        this.scrollPane.setBorder(null);
        this.content.setBorder(null);
        this.content.setLayout((LayoutManager)new MigLayout("fillx,novisualpadding,hidemode 3,align left top", "[325,grow,fill][grow,fill]", "[][][]"));
        this.tabsPanel.setBorder(new TitledBorder(bundle.getString("MTWizardOtherOptionsPanel.tabsPanel.border")));
        this.tabsPanel.setLayout((LayoutManager)new MigLayout("insets 0,hidemode 3", "[grow,left]", "[20,fill]0[][]0[][]0[]"));
        tabHeight.setHorizontalTextPosition(10);
        tabHeight.setText(bundle.getString("MTWizardOtherOptionsPanel.tabHeight.text"));
        tabHeight.setToolTipText(bundle.getString("MTWizardOtherOptionsPanel.tabHeight.toolTipText"));
        this.tabsPanel.add((Component)tabHeight, "pad 0 4 0 0,cell 0 0,aligny center,grow 100 0");
        this.tabHeightSpinner.addChangeListener(e -> this.tabHeightSpinnerStateChanged(e));
        this.tabsPanel.add((Component)this.tabHeightSpinner, "cell 0 0,wmax 60");
        this.tabHeightDesc.setText(bundle.getString("MTWizardOtherOptionsPanel.tabHeightDesc.text"));
        this.tabHeightDesc.setFont(UIManager.getFont("Label.font"));
        this.tabHeightDesc.setBackground(UIManager.getColor("Panel.background"));
        this.tabHeightDesc.setEnabled(false);
        this.tabsPanel.add((Component)this.tabHeightDesc, "pad 0 10 0 10,cell 0 1");
        thicknessLabel.setHorizontalTextPosition(10);
        thicknessLabel.setLabelFor(this.highlightSpinner);
        thicknessLabel.setText(bundle.getString("MTWizardOtherOptionsPanel.thicknessLabel.text"));
        thicknessLabel.setToolTipText(bundle.getString("MTWizardOtherOptionsPanel.thicknessLabel.toolTipText"));
        this.tabsPanel.add((Component)thicknessLabel, "pad 0 4 0 0,cell 0 2,aligny center,grow 100 0");
        this.highlightSpinner.addChangeListener(e -> this.highlightSpinnerStateChanged(e));
        this.tabsPanel.add((Component)this.highlightSpinner, "cell 0 2,wmax 60");
        this.thicknessDesc.setText(bundle.getString("MTWizardOtherOptionsPanel.thicknessDesc.text"));
        this.thicknessDesc.setFont(UIManager.getFont("Label.font"));
        this.thicknessDesc.setBackground(UIManager.getColor("Panel.background"));
        this.thicknessDesc.setEnabled(false);
        this.tabsPanel.add((Component)this.thicknessDesc, "pad 0 10 0 10,cell 0 3");
        this.uppercaseTabsCheckbox.setText(bundle.getString("MTWizardOtherOptionsPanel.uppercaseTabsCheckbox.text"));
        this.uppercaseTabsCheckbox.addActionListener(e -> this.uppercaseTabsCheckboxActionPerformed(e));
        this.tabsPanel.add((Component)this.uppercaseTabsCheckbox, "cell 0 4");
        this.uppercaseTabsDesc.setText(bundle.getString("MTWizardOtherOptionsPanel.uppercaseTabsDesc.text"));
        this.uppercaseTabsDesc.setFont(UIManager.getFont("Label.font"));
        this.uppercaseTabsDesc.setBackground(UIManager.getColor("Panel.background"));
        this.uppercaseTabsDesc.setEnabled(false);
        this.tabsPanel.add((Component)this.uppercaseTabsDesc, "pad 0 10 0 10,cell 0 5");
        this.content.add((Component)this.tabsPanel, "cell 0 0,aligny top,growy 0");
        this.otherPanel.setBorder(new TitledBorder(bundle.getString("MTWizardOtherOptionsPanel.otherPanel.border")));
        this.otherPanel.setLayout((LayoutManager)new MigLayout("insets 0,hidemode 3", "[grow,left]", "0[18,fill]0[][]0[]0[17]0[]"));
        this.fileColorsCheckbox.setText(bundle.getString("MTWizardOtherOptionsPanel.fileColorsCheckbox.text"));
        this.fileColorsCheckbox.addActionListener(e -> this.fileColorsCheckboxActionPerformed(e));
        this.otherPanel.add((Component)this.fileColorsCheckbox, "cell 0 0");
        this.fileColorsDesc.setText(bundle.getString("MTWizardOtherOptionsPanel.fileColorsDesc.text"));
        this.fileColorsDesc.setFont(UIManager.getFont("Label.font"));
        this.fileColorsDesc.setBackground(UIManager.getColor("Panel.background"));
        this.fileColorsDesc.setEnabled(false);
        this.otherPanel.add((Component)this.fileColorsDesc, "pad 0 10 0 10,cell 0 1");
        this.materialWallpapersCheckbox.setText(bundle.getString("MTWizardOtherOptionsPanel.materialWallpapersCheckbox.text"));
        this.materialWallpapersCheckbox.setToolTipText(bundle.getString("MTWizardOtherOptionsPanel.materialWallpapersCheckbox.toolTipText"));
        this.materialWallpapersCheckbox.addActionListener(e -> this.mtWallpapersCheckboxActionPerformed(e));
        this.otherPanel.add((Component)this.materialWallpapersCheckbox, "cell 0 2");
        this.materialWallpapersLabel.setText(bundle.getString("MTWizardOtherOptionsPanel.materialWallpapersLabel.text"));
        this.materialWallpapersLabel.setFont(UIManager.getFont("Label.font"));
        this.materialWallpapersLabel.setBackground(UIManager.getColor("Panel.background"));
        this.materialWallpapersLabel.setEnabled(false);
        this.otherPanel.add((Component)this.materialWallpapersLabel, "pad 0 10 0 10,cell 0 3");
        this.projectFrameCheckbox.setText(bundle.getString("MTWizardOtherOptionsPanel.projectFrameCheckbox.text"));
        this.projectFrameCheckbox.setToolTipText(bundle.getString("MTWizardOtherOptionsPanel.projectFrameCheckbox.toolTipText"));
        this.projectFrameCheckbox.addActionListener(e -> this.projectFrameCheckboxActionPerformed(e));
        this.otherPanel.add((Component)this.projectFrameCheckbox, "cell 0 4");
        this.projectFrameLabel.setText(bundle.getString("MTWizardOtherOptionsPanel.projectFrameLabel.text"));
        this.projectFrameLabel.setFont(UIManager.getFont("Label.font"));
        this.projectFrameLabel.setBackground(UIManager.getColor("Panel.background"));
        this.projectFrameLabel.setEnabled(false);
        this.otherPanel.add((Component)this.projectFrameLabel, "pad 0 10 0 10,cell 0 5");
        this.content.add((Component)this.otherPanel, "cell 1 0,aligny top,growy 0");
        this.panelPanel.setBorder(new TitledBorder(bundle.getString("MTWizardOtherOptionsPanel.panelPanel.border")));
        this.panelPanel.setLayout((LayoutManager)new MigLayout("insets 0,hidemode 3", "[grow,left]", "0[18,fill]0[][]0[][]0[][]0[]"));
        this.compactStatusCheckbox.setText(bundle.getString("MTWizardOtherOptionsPanel.compactStatusCheckbox.text"));
        this.compactStatusCheckbox.addActionListener(e -> this.compactStatusCheckboxActionPerformed(e));
        this.panelPanel.add((Component)this.compactStatusCheckbox, "cell 0 0");
        this.compactStatusDesc.setText(bundle.getString("MTWizardOtherOptionsPanel.compactStatusDesc.text"));
        this.compactStatusDesc.setFont(UIManager.getFont("Label.font"));
        this.compactStatusDesc.setBackground(UIManager.getColor("Panel.background"));
        this.compactStatusDesc.setEnabled(false);
        this.panelPanel.add((Component)this.compactStatusDesc, "pad 0 10 0 10,cell 0 1");
        this.compactTableCheckbox.setText(bundle.getString("MTWizardOtherOptionsPanel.compactTableCheckbox.text"));
        this.compactTableCheckbox.addActionListener(e -> this.compactTableCheckboxActionPerformed(e));
        this.panelPanel.add((Component)this.compactTableCheckbox, "cell 0 2");
        this.compactTableDesc.setText(bundle.getString("MTWizardOtherOptionsPanel.compactTableDesc.text"));
        this.compactTableDesc.setFont(UIManager.getFont("Label.font"));
        this.compactTableDesc.setBackground(UIManager.getColor("Panel.background"));
        this.compactTableDesc.setEnabled(false);
        this.panelPanel.add((Component)this.compactTableDesc, "pad 0 10 0 10,cell 0 3");
        this.compactDropdownCheckbox.setText(bundle.getString("MTWizardOtherOptionsPanel.compactDropdownCheckbox.text"));
        this.compactDropdownCheckbox.addActionListener(e -> this.compactDropdownCheckboxActionPerformed(e));
        this.panelPanel.add((Component)this.compactDropdownCheckbox, "cell 0 4");
        this.compactStatusDesc2.setText(bundle.getString("MTWizardOtherOptionsPanel.compactStatusDesc2.text"));
        this.compactStatusDesc2.setFont(UIManager.getFont("Label.font"));
        this.compactStatusDesc2.setBackground(UIManager.getColor("Panel.background"));
        this.compactStatusDesc2.setEnabled(false);
        this.panelPanel.add((Component)this.compactStatusDesc2, "pad 0 10 0 10,cell 0 5");
        this.compactMenusCheckbox.setText(bundle.getString("MTWizardOtherOptionsPanel.compactMenusCheckbox.text"));
        this.compactMenusCheckbox.addActionListener(e -> this.compactMenusCheckboxActionPerformed(e));
        this.panelPanel.add((Component)this.compactMenusCheckbox, "cell 0 6");
        this.compactMenusDesc3.setText(bundle.getString("MTWizardOtherOptionsPanel.compactMenusDesc3.text"));
        this.compactMenusDesc3.setFont(UIManager.getFont("Label.font"));
        this.compactMenusDesc3.setBackground(UIManager.getColor("Panel.background"));
        this.compactMenusDesc3.setEnabled(false);
        this.panelPanel.add((Component)this.compactMenusDesc3, "pad 0 10 0 10,cell 0 7");
        this.content.add((Component)this.panelPanel, "cell 0 1,aligny top,growy 0");
        this.label1.setText(bundle.getString("MTWizardOtherOptionsPanel.label1.text"));
        this.label1.setFont(new Font("Roboto", 0, 26));
        this.label1.setHorizontalAlignment(0);
        this.content.add((Component)this.label1, "cell 1 1");
        this.projectPanel.setBorder(new TitledBorder(bundle.getString("MTWizardOtherOptionsPanel.projectPanel.border")));
        this.projectPanel.setLayout((LayoutManager)new MigLayout("insets 0,hidemode 3", "[grow,left]", "[20,fill]0[]0[]0[]"));
        sidebarHeight.setHorizontalTextPosition(10);
        sidebarHeight.setText(bundle.getString("MTWizardOtherOptionsPanel.sidebarHeight.text"));
        sidebarHeight.setToolTipText(bundle.getString("MTWizardOtherOptionsPanel.sidebarHeight.toolTipText"));
        this.projectPanel.add((Component)sidebarHeight, "pad 0 4 0 0,cell 0 0,aligny center,grow 100 0");
        this.sidebarHeightSpinner.addChangeListener(e -> this.sidebarHeightSpinnerStateChanged(e));
        this.projectPanel.add((Component)this.sidebarHeightSpinner, "cell 0 0,wmax 60");
        this.sidebarHeightDesc.setText(bundle.getString("MTWizardOtherOptionsPanel.sidebarHeightDesc.text"));
        this.sidebarHeightDesc.setFont(UIManager.getFont("Label.font"));
        this.sidebarHeightDesc.setBackground(UIManager.getColor("Panel.background"));
        this.sidebarHeightDesc.setEnabled(false);
        this.projectPanel.add((Component)this.sidebarHeightDesc, "pad 0 10 0 10,cell 0 1");
        this.selectedIndicatorLabel.setText(bundle.getString("MTWizardOtherOptionsPanel.selectedIndicatorLabel.text"));
        this.selectedIndicatorLabel.setToolTipText(bundle.getString("MTWizardOtherOptionsPanel.selectedIndicatorLabel.toolTipText"));
        this.projectPanel.add((Component)this.selectedIndicatorLabel, "pad 0 4 0 0,cell 0 2,growx");
        this.indicatorStyleComboBox.setToolTipText(bundle.getString("MTWizardOtherOptionsPanel.indicatorStyleComboBox.toolTipText"));
        this.indicatorStyleComboBox.addActionListener(e -> this.indicatorStyleComboBoxActionPerformed(e));
        this.projectPanel.add((Component)this.indicatorStyleComboBox, "cell 0 2");
        this.arrowsStyleDesc2.setText(bundle.getString("MTWizardOtherOptionsPanel.arrowsStyleDesc2.text"));
        this.arrowsStyleDesc2.setFont(UIManager.getFont("Label.font"));
        this.arrowsStyleDesc2.setBackground(UIManager.getColor("Panel.background"));
        this.arrowsStyleDesc2.setEnabled(false);
        this.projectPanel.add((Component)this.arrowsStyleDesc2, "pad 0 10 0 10,cell 0 3");
        this.content.add((Component)this.projectPanel, "cell 0 2,aligny top,growy 0");
        this.scrollPane.setViewportView((Component)this.content);
        this.add((Component)this.scrollPane, "Center");
        this.indicatorStyleComboBox.setModel(new DefaultComboBoxModel<IndicatorStyles>(IndicatorStyles.values()));
    }

    private static int valueInRange(int value, int min, int max) {
        return Integer.min(max, Integer.max(value, min));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/mallowigi/idea/wizard/steps/MTWizardOtherOptionsPanel", "getHTMLFooter"));
    }
}

