/*
 * Decompiled with CFR 0.152.
 */
package com.mallowigi.idea.wizard.steps;

import com.intellij.ide.customize.AbstractCustomizeWizardStep;
import com.intellij.ui.components.JBScrollPane;
import com.mallowigi.idea.MTConfig;
import com.mallowigi.idea.MTLicenseChecker;
import com.mallowigi.idea.MTThemeManager;
import com.mallowigi.idea.messages.MTWizardBundle;
import com.mallowigi.idea.utils.MTUiUtils;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.util.ResourceBundle;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextPane;
import javax.swing.UIManager;
import net.miginfocom.swing.MigLayout;

public final class MTWizardContrastPanel
extends AbstractCustomizeWizardStep {
    private final MTConfig config = MTConfig.getInstance();
    private JBScrollPane scrollPane;
    private JPanel content;
    private JPanel contrastPanel;
    private JCheckBox contrastCheckbox;
    private JLabel contrastImage;
    private JPanel highContrastPanel;
    private JCheckBox highContrastCheckbox;
    private JLabel highContrastImage;
    private JTextPane contrastDesc;
    private JTextPane highContrastDesc;

    public MTWizardContrastPanel() {
        this.initComponents();
        this.setupComponents();
    }

    private void setupComponents() {
        boolean isFreeLicense;
        this.contrastCheckbox.setSelected(this.config.isContrastMode());
        this.highContrastCheckbox.setSelected(this.config.isHighContrast());
        boolean bl = isFreeLicense = !MTLicenseChecker.isLicensed();
        if (isFreeLicense) {
            MTUiUtils.disablePremium(this.highContrastCheckbox);
        }
    }

    public String getTitle() {
        return MTWizardBundle.message("contrast.panel.title", new Object[0]);
    }

    public String getHTMLHeader() {
        return MTWizardBundle.message("contrast.panel.body", new Object[0]);
    }

    private void contrastCheckboxActionPerformed(ActionEvent e) {
        MTThemeManager.toggleContrast();
        this.config.setContrastMode(this.contrastCheckbox.isSelected());
    }

    private void highContrastCheckboxActionPerformed(ActionEvent e) {
        MTThemeManager.toggleHighContrast();
        this.config.setHighContrast(this.highContrastCheckbox.isSelected());
    }

    private void initComponents() {
        ResourceBundle bundle = ResourceBundle.getBundle("messages.MTWizardBundle");
        this.scrollPane = new JBScrollPane();
        this.content = new JPanel();
        this.contrastPanel = new JPanel();
        this.contrastCheckbox = new JCheckBox();
        this.contrastImage = new JLabel();
        this.highContrastPanel = new JPanel();
        this.highContrastCheckbox = new JCheckBox();
        this.highContrastImage = new JLabel();
        this.contrastDesc = new JTextPane();
        this.highContrastDesc = new JTextPane();
        this.setLayout(new BorderLayout());
        this.scrollPane.setBorder(null);
        this.content.setLayout((LayoutManager)new MigLayout("fill,hidemode 3,align left top", "[fill][fill]", "[384,top][]"));
        this.contrastPanel.setLayout(new BoxLayout(this.contrastPanel, 1));
        this.contrastCheckbox.setText(bundle.getString("MTWizardContrastPanel.contrastCheckbox.text"));
        this.contrastCheckbox.addActionListener(e -> this.contrastCheckboxActionPerformed(e));
        this.contrastPanel.add(this.contrastCheckbox);
        this.contrastImage.setIcon(new ImageIcon(((Object)((Object)this)).getClass().getResource("/wizard/withContrast.png")));
        this.contrastPanel.add(this.contrastImage);
        this.content.add((Component)this.contrastPanel, "cell 0 0,align left top,grow 0 0");
        this.highContrastPanel.setLayout(new BoxLayout(this.highContrastPanel, 1));
        this.highContrastCheckbox.setText(bundle.getString("MTWizardContrastPanel.highContrastCheckbox.text"));
        this.highContrastCheckbox.addActionListener(e -> this.highContrastCheckboxActionPerformed(e));
        this.highContrastPanel.add(this.highContrastCheckbox);
        this.highContrastImage.setIcon(new ImageIcon(((Object)((Object)this)).getClass().getResource("/wizard/highContrast.png")));
        this.highContrastImage.setMaximumSize(new Dimension(561, 360));
        this.highContrastImage.setMinimumSize(new Dimension(561, 360));
        this.highContrastImage.setPreferredSize(new Dimension(561, 360));
        this.highContrastPanel.add(this.highContrastImage);
        this.content.add((Component)this.highContrastPanel, "cell 1 0,align left top,grow 0 0");
        this.contrastDesc.setText(bundle.getString("MTWizardContrastPanel.contrastDesc.text"));
        this.contrastDesc.setFont(UIManager.getFont("Label.font"));
        this.contrastDesc.setEditable(false);
        this.contrastDesc.setBackground(UIManager.getColor("Panel.background"));
        this.content.add((Component)this.contrastDesc, "cell 0 1,aligny top,growy 0");
        this.highContrastDesc.setText(bundle.getString("MTWizardContrastPanel.highContrastDesc.text"));
        this.highContrastDesc.setFont(UIManager.getFont("Label.font"));
        this.highContrastDesc.setEditable(false);
        this.highContrastDesc.setBackground(UIManager.getColor("Panel.background"));
        this.content.add((Component)this.highContrastDesc, "cell 1 1,aligny top,growy 0");
        this.scrollPane.setViewportView((Component)this.content);
        this.add((Component)this.scrollPane, "Center");
    }
}

