/*
 * Decompiled with CFR 0.152.
 */
package com.mallowigi.idea.wizard.steps;

import com.intellij.ide.customize.AbstractCustomizeWizardStep;
import com.intellij.ui.ColorPanel;
import com.intellij.ui.ColorUtil;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.ui.components.OnOffButton;
import com.mallowigi.idea.MTConfig;
import com.mallowigi.idea.MTLicenseChecker;
import com.mallowigi.idea.messages.MTWizardBundle;
import com.mallowigi.idea.utils.MTUiUtils;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.util.Objects;
import java.util.ResourceBundle;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JRadioButton;
import javax.swing.JSeparator;
import javax.swing.JSlider;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.JTextPane;
import javax.swing.UIManager;
import org.jdesktop.swingx.VerticalLayout;

public final class MTWizardAccentPanel
extends AbstractCustomizeWizardStep {
    private final MTConfig config = MTConfig.getInstance();
    private JBScrollPane scrollPane;
    private JPanel content;
    private JPanel accentColorPanel;
    private JLabel accentColorLabel;
    private ColorPanel accentColorChooser;
    private JPanel accentDescPanel;
    private JTextPane accentDesc;
    private JPanel accentOptionsPanel;
    private JCheckBox accentThemeCheckbox;
    private JCheckBox accentModeCheckbox;
    private JSeparator separator1;
    private JTextPane previewLabel;
    private JPanel previewPanel;
    private JTextField textField1;
    private JButton button1;
    private JComboBox comboBox1;
    private JSpinner spinner1;
    private JCheckBox checkBox1;
    private JRadioButton radioButton1;
    private OnOffButton onOffButton1;
    private JProgressBar progressBar1;
    private JSlider slider1;
    private JList list1;

    public MTWizardAccentPanel() {
        this.initComponents();
        this.setupComponents();
    }

    private void setupComponents() {
        boolean isFreeLicense;
        this.accentThemeCheckbox.setSelected(this.config.isOverrideAccentColor());
        this.accentColorChooser.setSelectedColor(ColorUtil.fromHex((String)this.config.getAccentColor()));
        this.accentModeCheckbox.setSelected(this.config.isAccentMode());
        boolean bl = isFreeLicense = !MTLicenseChecker.isLicensed();
        if (isFreeLicense) {
            MTUiUtils.disablePremium((JComponent)this.accentColorChooser);
            MTUiUtils.disablePremium(this.accentModeCheckbox);
            MTUiUtils.disablePremium(this.accentThemeCheckbox);
        }
    }

    public String getTitle() {
        return MTWizardBundle.message("accent.panel.title", new Object[0]);
    }

    public String getHTMLHeader() {
        return MTWizardBundle.message("accent.panel.body", new Object[0]);
    }

    private void accentThemeCheckboxActionPerformed(ActionEvent e) {
        this.config.setOverrideAccentColor(this.accentThemeCheckbox.isSelected());
        this.config.fireChanged();
    }

    private void accentColorChooserActionPerformed(ActionEvent e) {
        this.config.setAccentColor(ColorUtil.toHex((Color)Objects.requireNonNull(this.accentColorChooser.getSelectedColor())));
        this.config.fireChanged();
    }

    private void accentModeCheckboxActionPerformed(ActionEvent e) {
        this.config.setAccentMode(this.accentModeCheckbox.isSelected());
        this.config.fireChanged();
    }

    private void initComponents() {
        ResourceBundle bundle = ResourceBundle.getBundle("messages.MTWizardBundle");
        this.scrollPane = new JBScrollPane();
        this.content = new JPanel();
        this.accentColorPanel = new JPanel();
        this.accentColorLabel = new JLabel();
        this.accentColorChooser = new ColorPanel();
        this.accentDescPanel = new JPanel();
        this.accentDesc = new JTextPane();
        this.accentOptionsPanel = new JPanel();
        this.accentThemeCheckbox = new JCheckBox();
        this.accentModeCheckbox = new JCheckBox();
        this.separator1 = new JSeparator();
        this.previewLabel = new JTextPane();
        this.previewPanel = new JPanel();
        this.textField1 = new JTextField();
        this.button1 = new JButton();
        this.comboBox1 = new JComboBox();
        this.spinner1 = new JSpinner();
        this.checkBox1 = new JCheckBox();
        this.radioButton1 = new JRadioButton();
        this.onOffButton1 = new OnOffButton();
        this.progressBar1 = new JProgressBar();
        this.slider1 = new JSlider();
        this.list1 = new JList();
        this.setLayout(new BorderLayout());
        this.scrollPane.setBorder(null);
        this.content.setMinimumSize(null);
        this.content.setPreferredSize(null);
        this.content.setMaximumSize(new Dimension(600, Short.MAX_VALUE));
        this.content.setBorder(null);
        this.content.setLayout((LayoutManager)new VerticalLayout());
        this.accentColorPanel.setFont(this.accentColorPanel.getFont().deriveFont((float)this.accentColorPanel.getFont().getSize() + 3.0f));
        this.accentColorPanel.setPreferredSize(null);
        this.accentColorPanel.setMinimumSize(null);
        this.accentColorPanel.setLayout(new FlowLayout(0, 5, 10));
        this.accentColorLabel.setText(bundle.getString("MTWizardAccentPanel.accentColorLabel.text"));
        this.accentColorLabel.setLabelFor((Component)this.accentColorChooser);
        this.accentColorLabel.setIcon(new ImageIcon(((Object)((Object)this)).getClass().getResource("/icons/mt/customAccent.png")));
        this.accentColorLabel.setFont(this.accentColorLabel.getFont().deriveFont(this.accentColorLabel.getFont().getStyle() | 1, (float)this.accentColorLabel.getFont().getSize() + 2.0f));
        this.accentColorPanel.add(this.accentColorLabel);
        this.accentColorChooser.setToolTipText(bundle.getString("MTWizardAccentPanel.accentColorChooser.toolTipText"));
        this.accentColorChooser.addActionListener(e -> this.accentColorChooserActionPerformed(e));
        this.accentColorPanel.add((Component)this.accentColorChooser);
        this.content.add(this.accentColorPanel);
        this.accentDescPanel.setMinimumSize(null);
        this.accentDescPanel.setPreferredSize(null);
        this.accentDescPanel.setLayout(new FlowLayout(0));
        this.accentDesc.setText(bundle.getString("MTWizardAccentPanel.accentDesc.text"));
        this.accentDesc.setFont(UIManager.getFont("Label.font"));
        this.accentDesc.setBackground(UIManager.getColor("Panel.background"));
        this.accentDesc.setEditable(false);
        this.accentDesc.setBorder(null);
        this.accentDesc.setPreferredSize(new Dimension(500, 40));
        this.accentDesc.setMinimumSize(null);
        this.accentDescPanel.add(this.accentDesc);
        this.content.add(this.accentDescPanel);
        this.accentOptionsPanel.setFont(UIManager.getFont("Label.font"));
        this.accentOptionsPanel.setPreferredSize(null);
        this.accentOptionsPanel.setMinimumSize(null);
        this.accentOptionsPanel.setLayout(new FlowLayout(0));
        this.accentThemeCheckbox.setText(bundle.getString("MTWizardAccentPanel.accentThemeCheckbox.text"));
        this.accentThemeCheckbox.setFont(this.accentThemeCheckbox.getFont().deriveFont((float)this.accentThemeCheckbox.getFont().getSize() - 1.0f));
        this.accentThemeCheckbox.setToolTipText(bundle.getString("MTWizardAccentPanel.accentThemeCheckbox.toolTipText"));
        this.accentThemeCheckbox.addActionListener(e -> this.accentThemeCheckboxActionPerformed(e));
        this.accentOptionsPanel.add(this.accentThemeCheckbox);
        this.accentModeCheckbox.setText(bundle.getString("MTWizardAccentPanel.accentModeCheckbox.text"));
        this.accentModeCheckbox.setToolTipText(bundle.getString("MTWizardAccentPanel.accentModeCheckbox.toolTipText"));
        this.accentModeCheckbox.addActionListener(e -> this.accentModeCheckboxActionPerformed(e));
        this.accentOptionsPanel.add(this.accentModeCheckbox);
        this.content.add(this.accentOptionsPanel);
        this.separator1.setPreferredSize(null);
        this.separator1.setMinimumSize(null);
        this.content.add(this.separator1);
        this.previewLabel.setText(bundle.getString("MTWizardAccentPanel.previewLabel.text"));
        this.previewLabel.setAlignmentX(0.5f);
        this.previewLabel.setPreferredSize(null);
        this.previewLabel.setMinimumSize(null);
        this.content.add(this.previewLabel);
        this.previewPanel.setMinimumSize(null);
        this.previewPanel.setPreferredSize(null);
        this.previewPanel.setLayout(new FlowLayout());
        this.previewPanel.add(this.textField1);
        this.button1.setText(bundle.getString("MTWizardAccentPanel.button1.text"));
        this.previewPanel.add(this.button1);
        this.previewPanel.add(this.comboBox1);
        this.previewPanel.add(this.spinner1);
        this.checkBox1.setText("text");
        this.previewPanel.add(this.checkBox1);
        this.radioButton1.setText("text");
        this.previewPanel.add(this.radioButton1);
        this.onOffButton1.setText("text");
        this.onOffButton1.setMinimumSize(new Dimension(52, 20));
        this.onOffButton1.setPreferredSize(new Dimension(52, 20));
        this.previewPanel.add((Component)this.onOffButton1);
        this.previewPanel.add(this.progressBar1);
        this.content.add(this.previewPanel);
        this.slider1.setPreferredSize(null);
        this.slider1.setMinimumSize(null);
        this.content.add(this.slider1);
        this.content.add(this.list1);
        this.scrollPane.setViewportView((Component)this.content);
        this.add((Component)this.scrollPane, "Center");
    }
}

