/*
 * Decompiled with CFR 0.152.
 */
package com.mallowigi.idea.utils;

import com.intellij.codeInsight.hint.HintManager;
import com.intellij.codeInsight.hint.HintUtil;
import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.ide.plugins.PluginManager;
import com.intellij.ide.plugins.PluginManagerCore;
import com.intellij.ide.ui.LafManager;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationListener;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.ex.ApplicationEx;
import com.intellij.openapi.application.impl.ApplicationImpl;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.openapi.options.ShowSettingsUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.ColorUtil;
import com.intellij.ui.JBColor;
import com.intellij.ui.LightweightHint;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.util.ObjectUtils;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import com.mallowigi.idea.MTConfig;
import com.mallowigi.idea.messages.MaterialThemeBundle;
import com.mallowigi.idea.utils.MTUI;
import java.awt.Color;
import java.awt.Desktop;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GraphicsEnvironment;
import java.awt.RenderingHints;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.Random;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.swing.JComponent;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.event.HyperlinkEvent;
import javax.swing.plaf.ColorUIResource;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public enum MTUiUtils {
    DEFAULT;

    @NonNls
    public static final String MATERIAL_FONT = "Roboto";
    @NonNls
    public static final String HELP_PREFIX = "com.mallowigi.idea.help";
    @NonNls
    public static final String DOCS_URL = "https://www.material-theme.com/";
    @NonNls
    public static final String PLUGIN_ID = "com.mallowigi.idea.MaterialThemeUI";
    @NonNls
    public static final String APPEARANCE_SECTION = "Appearance";
    @NonNls
    public static final String DARCULA = "Darcula";
    @NonNls
    public static final String PLUGIN_NAME = "MaterialThemeUI";
    private static final RenderingHints RENDERING_HINTS;
    @NonNls
    public static final String NOTO_SANS = "Noto Sans";

    public static Map getHints() {
        return Collections.unmodifiableMap(RENDERING_HINTS);
    }

    @Nullable
    public static Font findFont(@NonNls String name) {
        for (Font font : GraphicsEnvironment.getLocalGraphicsEnvironment().getAllFonts()) {
            if (!font.getFamily().equals(name)) continue;
            return font;
        }
        return null;
    }

    public static Color lightOrDark(ColorUIResource darkColor, ColorUIResource lightColor) {
        return UIUtil.isUnderDarcula() ? darkColor : lightColor;
    }

    public static Color lightOrDark(Color darkColor, Color lightColor) {
        return UIUtil.isUnderDarcula() ? darkColor : lightColor;
    }

    public static Color brighter(Color color, int tones) {
        return UIUtil.isUnderDarcula() ? ColorUtil.brighter((Color)color, (int)tones) : ColorUtil.darker((Color)color, (int)tones);
    }

    public static Color darker(Color color, int tones) {
        return UIUtil.isUnderDarcula() ? ColorUtil.darker((Color)color, (int)tones) : ColorUtil.brighter((Color)color, (int)tones);
    }

    public static Color getColor(Color mtColor, @NotNull Color darkColor, @NotNull Color lightColor) {
        if (darkColor == null) {
            MTUiUtils.$$$reportNull$$$0(0);
        }
        if (lightColor == null) {
            MTUiUtils.$$$reportNull$$$0(1);
        }
        Color defaultColor = UIUtil.isUnderDarcula() ? darkColor : lightColor;
        return (Color)ObjectUtils.notNull((Object)mtColor, (Object)defaultColor);
    }

    public static boolean isDarcula() {
        return Objects.equals(Objects.requireNonNull(LafManager.getInstance().getCurrentLookAndFeel()).toString(), DARCULA);
    }

    public static void restartIde() {
        Application application = ApplicationManager.getApplication();
        if (application instanceof ApplicationImpl) {
            ((ApplicationEx)application).restart(true);
        } else {
            application.restart();
        }
    }

    public static String getVersion() {
        IdeaPluginDescriptor plugin = MTUiUtils.getPlugin();
        if (plugin != null) {
            return plugin.getVersion();
        }
        return MTConfig.getInstance().getVersion();
    }

    public static Object getPluginName() {
        return MaterialThemeBundle.message("plugin.name", new Object[0]);
    }

    private static IdeaPluginDescriptor getPlugin() {
        return PluginManagerCore.getPlugin((PluginId)PluginId.getId((String)PLUGIN_ID));
    }

    public static boolean hasAtomPluginInstalled() {
        return PluginManager.isPluginInstalled((PluginId)PluginId.getId((String)MaterialThemeBundle.message("atom.pluginid", new Object[0])));
    }

    public static int colorToDword(Color color) {
        Color result = new Color(color.getBlue(), color.getGreen(), color.getRed());
        return result.getRGB();
    }

    public static Color dwordToColor(int dword) {
        Color color = new Color(dword);
        return new Color(color.getBlue(), color.getGreen(), color.getRed());
    }

    public static NotificationListener.Adapter openAppearanceSettings(final Project project) {
        return new NotificationListener.Adapter(){

            protected void hyperlinkActivated(@NotNull Notification notification, @NotNull HyperlinkEvent e) {
                if (notification == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (e == null) {
                    1.$$$reportNull$$$0(1);
                }
                ApplicationManager.getApplication().invokeLater(() -> ShowSettingsUtil.getInstance().showSettingsDialog(project, MTUiUtils.APPEARANCE_SECTION), ModalityState.NON_MODAL);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "notification";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "e";
                        break;
                    }
                }
                objectArray[1] = "com/mallowigi/idea/utils/MTUiUtils$1";
                objectArray[2] = "hyperlinkActivated";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
    }

    public static void buildResources(Iterable<String> resources, Color color) {
        for (String resource : resources) {
            UIManager.getDefaults().put(resource, color);
        }
    }

    public static void buildAccentResources(Iterable<String> resources, Color color, boolean isAccentMode) {
        for (String resource : resources) {
            if (isAccentMode) {
                UIManager.put(resource, color);
                continue;
            }
            Color defaultColor = UIManager.getLookAndFeelDefaults().getColor(resource);
            if (defaultColor == null) continue;
            UIManager.put(resource, defaultColor);
        }
    }

    public static <T extends Enum<T>> String parseEnumValue(Object value, T defaultValue) {
        if (value instanceof String) {
            String name = StringUtil.toUpperCase((String)((String)value));
            for (Enum t : (Enum[])defaultValue.getClass().getEnumConstants()) {
                if (!t.name().equals(name)) continue;
                return StringUtil.toLowerCase((String)value.toString());
            }
        }
        return StringUtil.toLowerCase((String)defaultValue.name());
    }

    public static boolean hasFrameWallpaper() {
        return PropertiesComponent.getInstance().getValue("old.mt.idea.background.frame") != null || PropertiesComponent.getInstance().getValue("idea.background.frame") != null;
    }

    public static LightweightHint createHintTooltip(String message, Dimension preferredSize) {
        JComponent informationLabel = HintUtil.createInformationLabel((String)message);
        informationLabel.setBorder((Border)JBUI.Borders.empty((int)6, (int)6, (int)5, (int)6));
        informationLabel.setBackground(MTUI.Panel.getContrastBackground());
        informationLabel.setOpaque(true);
        informationLabel.setPreferredSize(preferredSize);
        return new LightweightHint(informationLabel);
    }

    public static LightweightHint createLinkHintTooltip(String message, String linkUrl, Dimension preferredSize) {
        JComponent informationLabel = HintUtil.createInformationLabel((String)message, e -> {
            try {
                if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                    Desktop.getDesktop().browse(new URI(linkUrl));
                }
            }
            catch (IOException | URISyntaxException exception) {
                // empty catch block
            }
        }, null, null);
        informationLabel.setBorder((Border)JBUI.Borders.empty((int)6, (int)6, (int)5, (int)6));
        informationLabel.setBackground(MTUI.Panel.getContrastBackground());
        informationLabel.setOpaque(true);
        informationLabel.setPreferredSize(preferredSize);
        return new LightweightHint(informationLabel);
    }

    public static void disablePremium(final JComponent component) {
        component.setEnabled(false);
        component.setToolTipText(null);
        final AtomicBoolean isHintHidden = new AtomicBoolean(false);
        final LightweightHint hint = MTUiUtils.createLinkHintTooltip(MaterialThemeBundle.message("plugin.premium", new Object[0]), MaterialThemeBundle.message("plugin.buyLink", new Object[0]), new Dimension(500, 32));
        component.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent e) {
                isHintHidden.set(MTUiUtils.showHint(component, hint, isHintHidden).get());
            }
        });
    }

    static AtomicBoolean showHint(JComponent component, LightweightHint hint, AtomicBoolean isHintHidden) {
        AtomicBoolean newIsHintHidden = new AtomicBoolean(isHintHidden.get());
        if (!isHintHidden.get()) {
            HintManager.getInstance().hideHints(2, true, false);
            newIsHintHidden.set(true);
            return MTUiUtils.showHint(component, hint, newIsHintHidden);
        }
        ApplicationManager.getApplication().invokeLater(() -> {
            HintManager.getInstance().hideAllHints();
            HintManager.getInstance().showHint(hint.getComponent(), RelativePoint.getSouthWestOf((JComponent)component), 34, 3000, () -> newIsHintHidden.set(true));
            newIsHintHidden.set(false);
        });
        return newIsHintHidden;
    }

    public static int valueInRange(int value, int min, int max) {
        return Integer.min(max, Integer.max(value, min));
    }

    public static JBColor toJBColor(Color color) {
        return new JBColor(color, color);
    }

    public static Color getRandomColor() {
        Random random = new Random();
        float hue = random.nextFloat();
        float saturation = (float)(random.nextInt(2000) + 1000) / 10000.0f;
        float luminance = 0.4f;
        return Color.getHSBColor(hue, saturation, 0.4f);
    }

    public static int stringToARGB(CharSequence charSequence) {
        return MTUiUtils.hashCode(charSequence);
    }

    private static int hashCode(CharSequence charSequence) {
        int hash = 0;
        int length = charSequence.length();
        for (int i = 0; i < length; ++i) {
            hash = charSequence.charAt(i) + ((hash << 5) - hash);
        }
        return hash;
    }

    static {
        RENDERING_HINTS = new RenderingHints(RenderingHints.KEY_ALPHA_INTERPOLATION, RenderingHints.VALUE_ALPHA_INTERPOLATION_SPEED);
        RENDERING_HINTS.put(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        RENDERING_HINTS.put(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_SPEED);
        RENDERING_HINTS.put(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        RENDERING_HINTS.put(RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_FRACTIONALMETRICS_ON);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "darkColor";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "lightColor";
                break;
            }
        }
        objectArray[1] = "com/mallowigi/idea/utils/MTUiUtils";
        objectArray[2] = "getColor";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

