/*
 * Decompiled with CFR 0.152.
 */
package com.mallowigi.idea.utils;

import com.intellij.ide.ui.laf.darcula.DarculaLaf;
import com.intellij.ide.ui.laf.darcula.DarculaUIUtil;
import com.intellij.ui.ColorUtil;
import com.intellij.ui.Gray;
import com.intellij.ui.JBColor;
import com.intellij.util.ui.JBInsets;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import com.mallowigi.idea.MTConfig;
import com.mallowigi.idea.utils.MTColorUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.Path2D;
import javax.swing.JLabel;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.plaf.ColorUIResource;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import sun.swing.SwingUtilities2;

public enum MTUI {
    SAYONARA;


    public static enum Tabs {
        BATS;

        @NonNls
        public static final String TAB_UNDERLINE = "TAB_UNDERLINE";
        @NonNls
        public static final String TAB_UNDERLINE_INACTIVE = "TAB_UNDERLINE_INACTIVE";
        @NonNls
        private static final String UNDERLINE_COLOR = "EditorTabs.underlineColor";
        @NonNls
        private static final String EDITOR_TABS_INACTIVE = "EditorTabs.inactiveColoredFileBackground";

        public static Color getUnderlineColor() {
            return JBColor.namedColor((String)UNDERLINE_COLOR, (Color)new Color(4431544));
        }

        public static Color getSelectionInactiveBackground() {
            return JBUI.CurrentTheme.EditorTabs.inactiveColoredFileBackground();
        }
    }

    public static enum Notification {
        WIZZ;

        @NonNls
        private static final String NOTIFICATION_BACKGROUND = "Notification.background";

        public static Color getBackgroundColor() {
            return JBColor.namedColor((String)NOTIFICATION_BACKGROUND, (Color)new JBColor((Color)Gray._242, new Color(5132370)));
        }
    }

    public static enum Panel {
        DE_PON;

        public static final String PANEL_BACKGROUND = "Panel.background";
        @NonNls
        public static final String PANEL_FOREGROUND = "Panel.foreground";
        @NonNls
        public static final String CONTRAST_BACKGROUND = "EditorPane.background";
        @NonNls
        public static final String SELECTION_BACKGROUND = "List.selectionBackground";
        @NonNls
        public static final String SELECTION_FOREGROUND = "List.selectionForeground";
        @NonNls
        public static final String SECONDARY_BACKGROUND = "List.background";
        @NonNls
        public static final String HIGHLIGHT_BACKGROUND = "Component.focusedBorderColor";
        @NonNls
        public static final String EXCLUDED_BACKGROUND = "FileColor.excluded";
        @NonNls
        public static final String PRIMARY_FOREGROUND = "Label.infoForeground";
        @NonNls
        public static final String LINK_FOREGROUND = "link.foreground";
        public static final Font FONT;
        @NonNls
        private static final String COUNTER_BACKGROUND = "Counter.background";

        public static Color getBackground() {
            return JBColor.namedColor((String)PANEL_BACKGROUND, (Color)UIUtil.getPanelBackground());
        }

        public static Color getForeground() {
            return JBColor.namedColor((String)PANEL_FOREGROUND, (Color)UIUtil.getLabelForeground());
        }

        public static Color getContrastBackground() {
            JBColor color = JBColor.namedColor((String)PANEL_BACKGROUND, (Color)UIUtil.getEditorPaneBackground());
            boolean isDark = ColorUtil.isDark((Color)color);
            return MTColorUtils.contrastifyBackground(isDark, new ColorUIResource((Color)color), false);
        }

        public static Color getSecondaryBackground() {
            return JBColor.namedColor((String)SECONDARY_BACKGROUND, (Color)UIUtil.getListBackground());
        }

        public static Color getHighlightBackground() {
            return JBColor.namedColor((String)HIGHLIGHT_BACKGROUND, (Color)DarculaUIUtil.getOutlineColor((boolean)true, (boolean)true));
        }

        public static Color getTransparentBackground() {
            return ColorUtil.withAlpha((Color)JBColor.namedColor((String)PANEL_BACKGROUND, (Color)UIUtil.getPanelBackground()), (double)0.3);
        }

        public static Color getExcludedBackground() {
            JBColor color = JBColor.namedColor((String)PANEL_BACKGROUND, (Color)UIUtil.getPanelBackground());
            boolean isLight = !ColorUtil.isDark((Color)color);
            return MTColorUtils.contrastifyBackground(isLight, new ColorUIResource((Color)color), false);
        }

        public static Color getPrimaryForeground() {
            return JBColor.namedColor((String)PRIMARY_FOREGROUND, (Color)UIUtil.getLabelForeground());
        }

        public static Color getSelectionBackground() {
            return JBColor.namedColor((String)SELECTION_BACKGROUND, (Color)UIUtil.getListSelectionBackground((boolean)true));
        }

        public static Color getSelectionForeground() {
            return JBColor.namedColor((String)SELECTION_FOREGROUND, (Color)UIUtil.getListSelectionForeground((boolean)true));
        }

        public static Color getLinkForeground() {
            return JBColor.namedColor((String)LINK_FOREGROUND, (Color)JBColor.blue);
        }

        public static Font getFont() {
            return FONT;
        }

        public static Color getAccentColor() {
            return JBColor.namedColor((String)COUNTER_BACKGROUND, (Color)UIUtil.getOptionPaneBackground());
        }

        static {
            FONT = UIManager.getFont("Panel.Font");
        }
    }

    public static enum Label {
        JOHNNY_WALKER;

        private static final String LABEL_DISABLED_FOREGROUND = "Label.disabledForeground";
        @NonNls
        private static final String LABEL_INFO_FOREGROUND = "Label.infoForeground";
        private static final String LABEL_SELECTED_FOREGROUND = "Label.selectedForeground";
        private static final String LABEL_FOREGROUND = "Label.foreground";

        public static Color getLabelInfoForeground() {
            return JBColor.namedColor((String)LABEL_INFO_FOREGROUND, (Color)new JBColor(0x777777, 0x787878));
        }

        public static Color getLabelDisabledForeground() {
            return JBColor.namedColor((String)LABEL_DISABLED_FOREGROUND, (Color)new JBColor(0x777777, 0x787878));
        }

        public static Color getLabelInfoForeground(JLabel label) {
            Color foreground = label.getForeground();
            if (foreground == Gray.x78 || foreground == Gray.x80) {
                foreground = JBColor.namedColor((String)LABEL_INFO_FOREGROUND, (Color)new JBColor(0x777777, 0x787878));
            }
            return foreground;
        }

        public static void paintText(JLabel label, Graphics g, String s, int textX, int textY) {
            int mnemIndex = DarculaLaf.isAltPressed() ? label.getDisplayedMnemonicIndex() : -1;
            SwingUtilities2.drawStringUnderlineCharAt(label, g, s, mnemIndex, textX, textY);
        }

        public static Color getSelectedForeground() {
            return JBColor.namedColor((String)LABEL_SELECTED_FOREGROUND, (Color)new JBColor(69905, 0xFFFFFF));
        }

        public static Color getLabelForeground() {
            return JBColor.namedColor((String)LABEL_FOREGROUND, (Color)UIUtil.getLabelForeground());
        }
    }

    public static enum CheckBox {
        CHECK1212;


        private static Color getColor(@NonNls String shortPropertyName, @NotNull Color defaultValue) {
            if (defaultValue == null) {
                CheckBox.$$$reportNull$$$0(0);
            }
            return JBColor.namedColor((String)("Checkbox." + shortPropertyName), (Color)defaultValue);
        }

        private static Color getColor(@NonNls String shortPropertyName, @NotNull Color defaultValue, boolean selected, boolean disabled) {
            if (defaultValue == null) {
                CheckBox.$$$reportNull$$$0(1);
            }
            if (selected) {
                return CheckBox.getColor(shortPropertyName + ".Selected", defaultValue);
            }
            if (disabled) {
                return CheckBox.getColor(shortPropertyName + ".Disabled", defaultValue);
            }
            return CheckBox.getColor(shortPropertyName + ".Default", defaultValue);
        }

        public static Color getInactiveFillColor() {
            return CheckBox.getColor("Background", (Color)new JBColor(Gray._240.withAlpha(180), Gray._110.withAlpha(180)), false, true);
        }

        public static Color getBorderColor(boolean enabled, boolean selected) {
            return enabled ? CheckBox.getColor("Border", Gray._120.withAlpha(90), selected, false) : CheckBox.getColor("Border", Gray._120.withAlpha(90), selected, true);
        }

        public static Color getBackgroundColor(boolean selected) {
            return CheckBox.getColor("Background", (Color)new JBColor((Color)Gray._240, (Color)Gray._110), selected, false);
        }

        public static Color getCheckSignColor(boolean enabled) {
            return enabled ? JBColor.namedColor((String)"CheckBox.checkSignColor", (Color)Gray._240) : JBColor.namedColor((String)"CheckBox.checkSignColorDisabled", (Color)Gray._120);
        }

        public static Color getShadowColor(boolean enabled) {
            return enabled ? JBColor.namedColor((String)"CheckBox.shadowColor", (Color)new JBColor((Color)Gray._240, (Color)Gray._170)) : JBColor.namedColor((String)"CheckBox.shadowColorDisabled", (Color)Gray._120);
        }

        public static Color getFocusedBackgroundColor(boolean armed, boolean selected) {
            return armed ? CheckBox.getColor("Focus.Wide", (Color)new JBColor((Color)Gray._240, (Color)Gray._170), selected, false) : CheckBox.getColor("Focus.Thin", (Color)new JBColor((Color)Gray._240, (Color)Gray._170), selected, false);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "defaultValue", "com/mallowigi/idea/utils/MTUI$CheckBox", "getColor"));
        }
    }

    public static enum ComboBox {
        CCCCOMBO;

        private static final String COMBO_BOX_ARROW_BUTTON_NON_EDITABLE_BACKGROUND = "ComboBox.ArrowButton.nonEditableBackground";
        private static final String COMBO_BOX_NON_EDITABLE_BACKGROUND = "ComboBox.nonEditableBackground";
        private static final String COMBO_BOX_DISABLED_FOREGROUND = "ComboBox.disabledForeground";
        private static final String TEXT_FIELD_BACKGROUND = "TextField.background";

        public static Shape getArrowShape(@NotNull Component button) {
            if (button == null) {
                ComboBox.$$$reportNull$$$0(0);
            }
            Rectangle r = new Rectangle(button.getSize());
            JBInsets.removeFrom((Rectangle)r, (Insets)JBUI.insets((int)1, (int)0, (int)1, (int)1));
            int tW = JBUI.scale((int)8);
            int tH = JBUI.scale((int)6);
            int xU = (r.width - tW) / 2 - JBUI.scale((int)1);
            int yU = (r.height - tH) / 2 + JBUI.scale((int)1);
            Path2D.Float path = new Path2D.Float();
            ((Path2D)path).moveTo(xU, yU);
            ((Path2D)path).lineTo(xU + tW, yU);
            ((Path2D)path).lineTo((float)xU + (float)tW / 2.0f, yU + tH);
            ((Path2D)path).lineTo(xU, yU);
            path.closePath();
            return path;
        }

        public static Color getArrowButtonBackgroundColor(boolean enabled) {
            JBColor color = JBColor.namedColor((String)COMBO_BOX_ARROW_BUTTON_NON_EDITABLE_BACKGROUND, (Color)new JBColor(0xFFFFFF, 3948353));
            return enabled ? color : UIUtil.getPanelBackground();
        }

        public static Color getNonEditableBackground() {
            return JBColor.namedColor((String)COMBO_BOX_NON_EDITABLE_BACKGROUND, (Color)new JBColor(0xFFFFFF, 3948353));
        }

        public static Color getDisabledForeground() {
            return JBColor.namedColor((String)COMBO_BOX_DISABLED_FOREGROUND, (Color)new JBColor(0xB1B1B1, 0xB1B1B1));
        }

        public static Color getFallbackBackground() {
            return JBColor.namedColor((String)"Button.background", (Color)new JBColor(0xF2F2F2, 3948353));
        }

        public static Color getDisabledBackground() {
            return JBColor.namedColor((String)"Button.background", (Color)new JBColor(0xF2F2F2, 3948353));
        }

        public static Color getEnabledBackground() {
            return JBColor.namedColor((String)TEXT_FIELD_BACKGROUND, (Color)new JBColor(0xFFFFFF, 4540746));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "button", "com/mallowigi/idea/utils/MTUI$ComboBox", "getArrowShape"));
        }
    }

    public static enum NavBar {
        ALLAH;

        @NonNls
        private static final String NAVBAR_ARROW_COLOR = "NavBar.arrowColor";
        @NonNls
        private static final String NAVBAR_HIGHLIGHT_COLOR = "NavBar.selectedColor";

        public static Color getArrowColor() {
            return JBColor.namedColor((String)NAVBAR_ARROW_COLOR, (Color)Gray._100);
        }

        public static Color getHighlightColor() {
            return ColorUtil.withAlpha((Color)JBColor.namedColor((String)NAVBAR_HIGHLIGHT_COLOR, (Color)UIUtil.getListSelectionBackground((boolean)true)), (double)0.5);
        }

        public static int getDecorationOffset() {
            return JBUI.scale((int)14);
        }

        public static int getDecorationHOffset() {
            return JBUI.scale((int)9);
        }

        public static int getFirstElementLeftOffset() {
            return JBUI.scale((int)6);
        }
    }

    public static enum Switch {
        NINTENDO;

        @NonNls
        private static final String OFF_THUMB_COLOR = "ToggleButton.offForeground";
        @NonNls
        private static final String ON_THUMB_COLOR = "ToggleButton.onForeground";
        @NonNls
        private static final String OFF_BACKGROUND_COLOR = "ToggleButton.offBackground";
        @NonNls
        private static final String ON_BACKGROUND_COLOR = "ToggleButton.onBackground";

        public static Color getOffThumbColor() {
            return JBColor.namedColor((String)OFF_THUMB_COLOR, (Color)Gray.x77).brighter().brighter();
        }

        public static Color getOnThumbColor() {
            return JBColor.namedColor((String)ON_THUMB_COLOR, (Color)Gray.xFF);
        }

        @NotNull
        public static Color getOffSwitchColor() {
            JBColor jBColor = JBColor.namedColor((String)OFF_BACKGROUND_COLOR, (Color)new JBColor(0xF2F2F2, 3948353));
            if (jBColor == null) {
                Switch.$$$reportNull$$$0(0);
            }
            return jBColor;
        }

        public static Color getOnSwitchColor() {
            return JBColor.namedColor((String)ON_BACKGROUND_COLOR, (Color)new JBColor(4887113, 5073228)).darker().darker();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/mallowigi/idea/utils/MTUI$Switch", "getOffSwitchColor"));
        }
    }

    public static enum ProgressBar {
        CHOCO;

        private static final String PROGRESS_BAR_TRACK_COLOR = "ProgressBar.trackColor";
        private static final String PROGRESS_BAR_PROGRESS_COLOR = "ProgressBar.progressColor";
        private static final String PROGRESS_BAR_INDETERMINATE_START_COLOR = "ProgressBar.indeterminateStartColor";
        private static final String PROGRESS_BAR_INDETERMINATE_END_COLOR = "ProgressBar.indeterminateEndColor";

        @NotNull
        public static JBColor getTrackColor() {
            JBColor jBColor = JBColor.namedColor((String)PROGRESS_BAR_TRACK_COLOR, (Color)new JBColor((Color)Gray.xC4, (Color)Gray.x55));
            if (jBColor == null) {
                ProgressBar.$$$reportNull$$$0(0);
            }
            return jBColor;
        }

        @NotNull
        public static JBColor getProgressColor() {
            JBColor jBColor = JBColor.namedColor((String)PROGRESS_BAR_PROGRESS_COLOR, (Color)new JBColor((Color)Gray.x80, (Color)Gray.xA0));
            if (jBColor == null) {
                ProgressBar.$$$reportNull$$$0(1);
            }
            return jBColor;
        }

        @NotNull
        public static Color getIndeterminateStartColor() {
            Color color = JBColor.namedColor((String)PROGRESS_BAR_INDETERMINATE_START_COLOR, (Color)new JBColor((Color)Gray.xC4, (Color)Gray.x69)).brighter().brighter();
            if (color == null) {
                ProgressBar.$$$reportNull$$$0(2);
            }
            return color;
        }

        @NotNull
        public static JBColor getIndeterminateEndColor() {
            JBColor jBColor = JBColor.namedColor((String)PROGRESS_BAR_INDETERMINATE_END_COLOR, (Color)new JBColor((Color)Gray.x80, (Color)Gray.x83));
            if (jBColor == null) {
                ProgressBar.$$$reportNull$$$0(3);
            }
            return jBColor;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[2];
            objectArray2[0] = "com/mallowigi/idea/utils/MTUI$ProgressBar";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getTrackColor";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getProgressColor";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getIndeterminateStartColor";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getIndeterminateEndColor";
                    break;
                }
            }
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
        }
    }

    public static enum Radio {
        GAGA;

        @NonNls
        private static final String RADIO_BUTTON_SELECTION_ENABLED_COLOR = "RadioButton.selectionEnabledShadowColor";
        @NonNls
        private static final String RADIO_BUTTON_SELECTION_DISABLED_COLOR = "RadioButton.selectionDisabledShadowColor";
        @NonNls
        private static final String RADIO_BUTTON_BORDER_COLOR = "RadioButton.darcula.borderColor1";
        @NonNls
        private static final String RADIO_BUTTON_FOCUS_COLOR = "RadioButton.focusColor";

        public static Color getSelectedColor(boolean enabled) {
            JBColor enabledColor = JBColor.namedColor((String)RADIO_BUTTON_SELECTION_ENABLED_COLOR, (Color)new JBColor(64, 0x1E1E1E));
            JBColor disabledColor = JBColor.namedColor((String)RADIO_BUTTON_SELECTION_DISABLED_COLOR, (Color)new JBColor(32, 0x3C3C3C));
            return enabled ? enabledColor : disabledColor;
        }

        public static Color getBorderColor() {
            return JBColor.namedColor((String)RADIO_BUTTON_BORDER_COLOR, (Color)new JBColor(0xCDCDCD, 0x515151));
        }

        public static Color getFocusColor() {
            JBColor color = JBColor.namedColor((String)RADIO_BUTTON_FOCUS_COLOR, (Color)new JBColor(0xCFCFCF, 0xAAAAAA));
            return ColorUtil.withAlpha((Color)color, (double)0.5);
        }
    }

    public static enum Separator {
        DEFAULT;

        @NonNls
        private static final String SEPARATOR_SEPARATOR_COLOR = "Separator.separatorColor";

        public static Color getSeparatorColor() {
            return JBColor.namedColor((String)SEPARATOR_SEPARATOR_COLOR, (Color)new JBColor(0xCDCDCD, 0x515151));
        }
    }

    public static enum MTColor {
        IROIRO;

        public static final Color PURPLE;
        public static final Color GREEN;
        public static final Color BLUE;
        public static final Color CYAN;
        public static final Color YELLOW;
        public static final Color RED;
        public static final Color ORANGE;
        public static final Color BROWN;
        public static final Color PINK;
        public static final Color DARK_PURPLE;
        public static final Color DARK_GREEN;
        public static final Color DARK_BLUE;
        public static final Color DARK_CYAN;
        public static final Color DARK_YELLOW;
        public static final Color DARK_RED;
        public static final Color DARK_ORANGE;
        public static final Color DARK_BROWN;
        public static final Color DARK_PINK;

        static {
            PURPLE = new ColorUIResource(13079274);
            GREEN = new ColorUIResource(12839053);
            BLUE = new ColorUIResource(8563455);
            CYAN = new ColorUIResource(9035255);
            YELLOW = new ColorUIResource(16763755);
            RED = new ColorUIResource(16733040);
            ORANGE = new ColorUIResource(16223340);
            BROWN = new ColorUIResource(11237735);
            PINK = new ColorUIResource(12288179);
            DARK_PURPLE = new ColorUIResource(1971517);
            DARK_GREEN = new ColorUIResource(13056);
            DARK_BLUE = new ColorUIResource(8561);
            DARK_CYAN = new ColorUIResource(24676);
            DARK_YELLOW = new ColorUIResource(8018176);
            DARK_RED = new ColorUIResource(0x7F0000);
            DARK_ORANGE = new ColorUIResource(8996096);
            DARK_BROWN = new ColorUIResource(3088408);
            DARK_PINK = new ColorUIResource(5636135);
        }
    }

    public static enum Spinner {
        FIDGET;

        @NonNls
        private static final String COMBO_BOX_EDITABLE_ARROW_BACKGROUND = "ComboBox.darcula.editable.arrowButtonBackground";
        @NonNls
        private static final String COMBO_BOX_ARROW_BACKGROUND = "ComboBox.darcula.arrowButtonBackground";
        @NonNls
        private static final String COMBO_BOX_DISABLED_ARROW_BACKGROUND = "ComboBox.darcula.disabledArrowButtonBackground";
        @NonNls
        private static final String COMBO_BOX_ARROW_FOREGROUND = "ComboBox.darcula.arrowButtonForeground";
        @NonNls
        private static final String COMBO_BOX_HOVERED_ARROW_FOREGROUND = "ComboBox.darcula.hoveredArrowButtonForeground";
        @NonNls
        private static final String COMBO_BOX_ARROW_DISABLED_FOREGROUND = "ComboBox.darcula.arrowButtonDisabledForeground";

        public static Color getArrowButtonBackgroundColor(boolean enabled, boolean editable) {
            return enabled ? (editable ? JBColor.namedColor((String)COMBO_BOX_EDITABLE_ARROW_BACKGROUND, (Color)Gray.xFC) : JBColor.namedColor((String)COMBO_BOX_ARROW_BACKGROUND, (Color)Gray.xFC)) : JBColor.namedColor((String)COMBO_BOX_DISABLED_ARROW_BACKGROUND, (Color)Gray.xFC);
        }

        public static Color getArrowButtonForegroundColor(boolean enabled, boolean hovered) {
            return enabled ? (hovered ? JBColor.namedColor((String)COMBO_BOX_HOVERED_ARROW_FOREGROUND, (Color)Gray.x66) : JBColor.namedColor((String)COMBO_BOX_ARROW_FOREGROUND, (Color)Gray.x66)) : JBColor.namedColor((String)COMBO_BOX_ARROW_DISABLED_FOREGROUND, (Color)Gray.xAB);
        }
    }

    public static enum Slider {
        PARALLEL_WORLDS;

        @NonNls
        private static final String SLIDER_THUMB = "Slider.thumb";
        @NonNls
        private static final String SLIDER_TRACK = "Slider.track";
        @NonNls
        private static final String SLIDER_TRACK_DISABLED = "Slider.trackDisabled";

        public static Color getThumbColor() {
            return JBColor.namedColor((String)SLIDER_THUMB, (Color)new JBColor(0xC4C4C4, 0x646464));
        }

        public static Color getTrackColor() {
            return JBColor.namedColor((String)SLIDER_TRACK, (Color)new JBColor(0xC4C4C4, 0x646464));
        }

        public static Color getTrackDisabledColor() {
            return JBColor.namedColor((String)SLIDER_TRACK_DISABLED, (Color)new JBColor(0xCFCFCF, 0x646464));
        }
    }

    public static enum TabbedPane {
        TABUU;

        @NonNls
        private static final String TABBED_PANE_SELECTED_FOREGROUND = "TabbedPane.selectedForeground";
        @NonNls
        private static final String TABBED_PANE_FOREGROUND = "TabbedPane.foreground";
        @NonNls
        private static final String TABBED_PANE_SELECTED = "TabbedPane.selectedColor";
        @NonNls
        private static final String HOVERED_TAB_BACKGROUND = "DefaultTabs.hoverBackground";
        @NonNls
        private static final String TAB_BACKGROUND = "DefaultTabs.background";
        @NonNls
        private static final String INACTIVE_TAB_BACKGROUND = "EditorTabs.inactiveColoredFileBackground";
        @NonNls
        private static final String INACTIVE_TAB_CONTRAST_BACKGROUND = "DefaultTabs.inactiveMaskColor";
        @NonNls
        private static final String TABBED_PANE_SHADOW = "TabbedPane.shadow";

        public static Color getForeground() {
            return JBColor.namedColor((String)TABBED_PANE_FOREGROUND, (Color)new JBColor(0, 0xBBBBBB));
        }

        public static Color getSelectedForeground() {
            return JBColor.namedColor((String)TABBED_PANE_SELECTED_FOREGROUND, (Color)new JBColor(0xFFFFFF, 0xFFFFFF));
        }

        public static Color getHighlightColor() {
            return JBColor.namedColor((String)TABBED_PANE_SELECTED, (Color)new JBColor(14345453, 4016988));
        }

        public static Color getHoveredBackground() {
            return JBColor.namedColor((String)HOVERED_TAB_BACKGROUND, (Color)new JBColor(14345453, 4016988));
        }

        public static Color getBackground() {
            return JBColor.namedColor((String)TAB_BACKGROUND, (Color)new JBColor(14345453, 4016988));
        }

        public static Color getInactiveBackground(boolean isContrast) {
            JBColor inactiveTabBG = JBColor.namedColor((String)INACTIVE_TAB_BACKGROUND, (Color)new JBColor(14345453, 4016988));
            JBColor inactiveContrastBG = JBColor.namedColor((String)INACTIVE_TAB_CONTRAST_BACKGROUND, (Color)new JBColor(14345453, 4016988));
            return isContrast ? inactiveContrastBG : inactiveTabBG;
        }

        public static Color getShadowColor() {
            return JBColor.namedColor((String)TABBED_PANE_SHADOW, (Color)new JBColor(14345453, 4016988));
        }
    }

    public static enum StatusBar {
        SB;

        @NonNls
        public static final String IDE_STATUS_BAR_BORDER = "IdeStatusBar.border";
    }

    public static enum Table {
        CHAIR;

        @NonNls
        private static final String TABLE_HIGHLIGHT_OUTER = "Table.highlightOuter";
        @NonNls
        private static final String TABLE_HEADER_BORDER_COLOR = "TableHeader.borderColor";

        public static Color getHighlightOuterColor() {
            return JBColor.namedColor((String)TABLE_HIGHLIGHT_OUTER, (Color)new JBColor(7979263, 7979263));
        }

        public static Color getBorderColor() {
            return JBColor.namedColor((String)TABLE_HEADER_BORDER_COLOR, (Color)new JBColor(0xDDDDDD, 0x2C2C2C));
        }

        @NotNull
        public static Border getCellBorder() {
            boolean compactTables = MTConfig.getInstance().isCompactTables();
            Border border = compactTables ? JBUI.Borders.empty((int)3) : JBUI.Borders.empty((int)10, (int)5);
            if (border == null) {
                Table.$$$reportNull$$$0(0);
            }
            return border;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/mallowigi/idea/utils/MTUI$Table", "getCellBorder"));
        }
    }

    public static enum List {
        ARRAY;

        @NonNls
        public static final String LIST_SELECTION_BACKGROUND_PAINTER = "List.sourceListSelectionBackgroundPainter";
        @NonNls
        public static final String LIST_FOCUSED_SELECTION_BACKGROUND_PAINTER = "List.sourceListFocusedSelectionBackgroundPainter";

        public static Border getListSelectionPainter() {
            return UIManager.getBorder(LIST_SELECTION_BACKGROUND_PAINTER);
        }

        public static Border getListFocusedSelectionPainter() {
            return UIManager.getBorder(LIST_FOCUSED_SELECTION_BACKGROUND_PAINTER);
        }
    }

    public static enum TextField {
        SEXTFIELD;

        @NonNls
        public static final String TEXT_FIELD_SEPARATOR_COLOR_DISABLED = "Component.disabledBorderColor";
        @NonNls
        private static final String TEXT_FIELD_SEPARATOR_COLOR = "Component.borderColor";
        @NonNls
        private static final String TEXT_FIELD_SELECTED_SEPARATOR_COLOR = "Component.focusedBorderColor";

        public static Color getBorderColor(boolean enabled) {
            JBColor borderColor = JBColor.namedColor((String)TEXT_FIELD_SEPARATOR_COLOR, (Color)new JBColor(0xC4C4C4, 0x646464));
            JBColor disabledColor = JBColor.namedColor((String)TEXT_FIELD_SEPARATOR_COLOR_DISABLED, (Color)new JBColor(0xCFCFCF, 0x646464));
            return enabled ? borderColor : disabledColor;
        }

        public static Color getSelectedBorderColor() {
            return JBColor.namedColor((String)TEXT_FIELD_SELECTED_SEPARATOR_COLOR, (Color)new JBColor(8892378, 4615572));
        }
    }

    public static enum Button {
        BOTON;

        @NonNls
        public static final String BUTTON_DISABLED_TEXT = "Button.disabledText";
        @NonNls
        static final String BUTTON_BACKGROUND = "Button.background";
        @NonNls
        private static final String BUTTON_FOREGROUND = "Button.foreground";
        @NonNls
        private static final String BUTTON_PRIMARY_BACKGROUND = "Button.default.startBackground";
        @NonNls
        private static final String BUTTON_PRIMARY_FOREGROUND = "Button.default.foreground";
        @NonNls
        private static final String BUTTON_SELECTED_BACKGROUND = "Button.focus";
        @NonNls
        private static final String BUTTON_SELECTED_FOREGROUND = "Button.default.foreground";
        @NonNls
        private static final String BUTTON_DISABLED_TEXT_SHADOW = "Button.default.shadowColor";
        @NonNls
        public static final String NO_BORDER = "MTButton.noBorder";

        public static Color getBackgroundColor() {
            return JBColor.namedColor((String)BUTTON_BACKGROUND, (Color)new JBColor(0xF2F2F2, 3948353));
        }

        public static Color getPrimaryBackgroundColor() {
            return JBColor.namedColor((String)BUTTON_PRIMARY_BACKGROUND, (Color)new JBColor(4884167, 3561600));
        }

        public static Color getPrimaryForegroundColor() {
            return JBColor.namedColor((String)"Button.default.foreground", (Color)new JBColor(0xF0F0F0, 0xBBBBBB));
        }

        public static Color getForegroundColor() {
            return JBColor.namedColor((String)BUTTON_FOREGROUND, (Color)new JBColor(0, 0xBBBBBB));
        }

        public static Color getSelectedBackgroundColor() {
            return JBColor.namedColor((String)BUTTON_SELECTED_BACKGROUND, (Color)new JBColor(9946099, 4417676));
        }

        public static Color getSelectedForegroundColor() {
            return JBColor.namedColor((String)"Button.default.foreground", (Color)new JBColor(0xF0F0F0, 0xBBBBBB));
        }

        public static Color getDisabledShadowColor() {
            return JBColor.namedColor((String)BUTTON_DISABLED_TEXT_SHADOW, (Color)new JBColor(-1499027840, 909522560));
        }

        public static Color getDisabledColor() {
            return JBColor.namedColor((String)BUTTON_DISABLED_TEXT, (Color)new JBColor(0x999999, 0x777777));
        }
    }

    public static enum ActionButton {
        FIGHT;

        @NonNls
        public static final String ACTION_BUTTON_HOVER_BACKGROUND = "ActionButton.hoverBackground";
        @NonNls
        public static final String ACTION_BUTTON_HOVER_BORDER_COLOR = "ActionButton.hoverBorderColor";

        @NotNull
        public static Color getHoverBackground() {
            JBColor jBColor = JBColor.namedColor((String)ACTION_BUTTON_HOVER_BACKGROUND, (Color)new JBColor(0xDFDFDF, 5001298));
            if (jBColor == null) {
                ActionButton.$$$reportNull$$$0(0);
            }
            return jBColor;
        }

        @NotNull
        public static Color getHoverBorderColor() {
            JBColor jBColor = JBColor.namedColor((String)ACTION_BUTTON_HOVER_BORDER_COLOR, (Color)new JBColor(0xDFDFDF, 5001298));
            if (jBColor == null) {
                ActionButton.$$$reportNull$$$0(1);
            }
            return jBColor;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[2];
            objectArray2[0] = "com/mallowigi/idea/utils/MTUI$ActionButton";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getHoverBackground";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getHoverBorderColor";
                    break;
                }
            }
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
        }
    }

    public static enum Tree {
        MARIJUANA;

        @NonNls
        private static final String TREE_SELECTION_BACKGROUND = "Tree.selectionBackground";

        @NotNull
        public static Color getSelectionBackground() {
            JBColor color = JBColor.namedColor((String)TREE_SELECTION_BACKGROUND, (Color)new JBColor(2570316, 862526));
            Color color2 = ColorUtil.withAlpha((Color)color, (double)0.25);
            if (color2 == null) {
                Tree.$$$reportNull$$$0(0);
            }
            return color2;
        }

        public static Color getSelectionInactiveBackground() {
            JBColor color = JBColor.namedColor((String)TREE_SELECTION_BACKGROUND, (Color)new JBColor(2570316, 862526));
            return ColorUtil.withAlpha((Color)color, (double)0.25);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/mallowigi/idea/utils/MTUI$Tree", "getSelectionBackground"));
        }
    }
}

