/*
 * Decompiled with CFR 0.152.
 */
package com.mallowigi.idea.utils;

import com.intellij.ui.ColorUtil;
import java.awt.Color;
import javax.swing.plaf.ColorUIResource;
import org.jetbrains.annotations.Nullable;

public enum MTColorUtils {
    DEFAULT;

    private static final int HC_FG_TONES = 4;
    private static final int HC_BG_TONES = 2;

    public static ColorUIResource parseColor(@Nullable String value) {
        if (value != null && value.length() == 8) {
            Color color = ColorUtil.fromHex((String)value.substring(0, 6));
            try {
                int alpha = Integer.parseInt(value.substring(6, 8), 16);
                return new ColorUIResource(new Color(color.getRed(), color.getGreen(), color.getBlue(), alpha));
            }
            catch (Exception exception) {
                return new ColorUIResource(new Color(color.getRed(), color.getGreen(), color.getBlue(), 1));
            }
        }
        Color color = ColorUtil.fromHex((String)value, (Color)Color.GRAY);
        return new ColorUIResource(new Color(color.getRed(), color.getGreen(), color.getBlue()));
    }

    private static String contrastifyForeground(boolean dark, String colorString, boolean isNotHighContrast) {
        if (isNotHighContrast) {
            return colorString;
        }
        return dark ? ColorUtil.toHex((Color)ColorUtil.brighter((Color)ColorUtil.fromHex((String)colorString), (int)4)) : ColorUtil.toHex((Color)ColorUtil.darker((Color)ColorUtil.fromHex((String)colorString), (int)4));
    }

    public static Color contrastifyForeground(boolean isDark, Color color, boolean isNotHighContrast) {
        if (isNotHighContrast) {
            return color;
        }
        int alpha = color.getAlpha() / 255;
        return ColorUtil.withAlpha((Color)new ColorUIResource(isDark ? ColorUtil.brighter((Color)color, (int)4) : ColorUtil.darker((Color)color, (int)4)), (double)alpha);
    }

    public static String contrastifyBackground(boolean isDark, String colorString, boolean isNotHighContrast) {
        if (isNotHighContrast) {
            return colorString;
        }
        return isDark ? ColorUtil.toHex((Color)ColorUtil.darker((Color)ColorUtil.fromHex((String)colorString), (int)2)) : ColorUtil.toHex((Color)ColorUtil.brighter((Color)ColorUtil.fromHex((String)colorString), (int)2));
    }

    public static Color contrastifyBackground(boolean isDark, ColorUIResource color, boolean isNotHighContrast) {
        if (isNotHighContrast) {
            return color;
        }
        int alpha = color.getAlpha() / 255;
        return ColorUtil.withAlpha((Color)new ColorUIResource(isDark ? ColorUtil.darker((Color)color, (int)2) : ColorUtil.brighter((Color)color, (int)2)), (double)alpha);
    }
}

