/*
 * Decompiled with CFR 0.152.
 */
package com.mallowigi.idea.utils;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.util.Disposer;
import com.intellij.util.ui.Animator;
import com.intellij.util.ui.GraphicsUtil;
import com.intellij.util.ui.ImageUtil;
import com.intellij.util.ui.StartupUiUtil;
import java.awt.AlphaComposite;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.image.BufferedImage;
import java.awt.image.ImageObserver;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.JLayeredPane;
import javax.swing.RootPaneContainer;

public final class MTChangeLAFAnimator {
    private static MTChangeLAFAnimator animator = null;
    private float myAlpha = 1.0f;
    private final Map<JLayeredPane, JComponent> myMap;
    private final Animator myAnimator = new Animator("MTChangeLAF", 60, 1200, false){

        public void resume() {
            MTChangeLAFAnimator.this.doPaint();
            super.resume();
        }

        public void paintNow(int frame, int totalFrames, int cycle) {
            MTChangeLAFAnimator.this.myAlpha = 1.0f - (float)(1.0 - StrictMath.cos(Math.PI * (double)frame / (double)totalFrames)) / 2.0f;
            MTChangeLAFAnimator.this.doPaint();
        }

        protected void paintCycleEnd() {
            if (!this.isDisposed()) {
                Disposer.dispose((Disposable)this);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void dispose() {
            try {
                super.dispose();
                for (Map.Entry entry : MTChangeLAFAnimator.this.myMap.entrySet()) {
                    JLayeredPane layeredPane = (JLayeredPane)entry.getKey();
                    layeredPane.remove((Component)entry.getValue());
                    layeredPane.revalidate();
                    layeredPane.repaint();
                }
            }
            finally {
                MTChangeLAFAnimator.this.myMap.clear();
            }
        }
    };

    public static void showSnapshot() {
        animator = new MTChangeLAFAnimator();
    }

    private MTChangeLAFAnimator() {
        Window[] windows = Window.getWindows();
        this.myMap = new LinkedHashMap<JLayeredPane, JComponent>(10);
        for (Window window : windows) {
            if (!(window instanceof RootPaneContainer) || !window.isShowing()) continue;
            Rectangle bounds = window.getBounds();
            RootPaneContainer rootPaneContainer = (RootPaneContainer)((Object)window);
            final JLayeredPane layeredPane = rootPaneContainer.getLayeredPane();
            final BufferedImage image = ImageUtil.createImage((GraphicsConfiguration)window.getGraphicsConfiguration(), (int)bounds.width, (int)bounds.height, (int)2);
            Graphics imageGraphics = image.getGraphics();
            GraphicsUtil.setupAntialiasing((Graphics)imageGraphics);
            ((RootPaneContainer)((Object)window)).getRootPane().paint(imageGraphics);
            JComponent imageLayer = new JComponent(){

                @Override
                public void updateUI() {
                }

                @Override
                public void paint(Graphics g) {
                    g = g.create();
                    ((Graphics2D)g).setComposite(AlphaComposite.getInstance(3, MTChangeLAFAnimator.this.myAlpha));
                    StartupUiUtil.drawImage((Graphics)g, (Image)image, (int)0, (int)0, (ImageObserver)this);
                }

                @Override
                public Rectangle getBounds() {
                    return layeredPane.getBounds();
                }
            };
            imageLayer.setSize(layeredPane.getSize());
            layeredPane.add((Component)imageLayer, JLayeredPane.DRAG_LAYER);
            this.myMap.put(layeredPane, imageLayer);
        }
        this.doPaint();
    }

    public static void hideSnapshotWithAnimation() {
        if (animator == null) {
            return;
        }
        MTChangeLAFAnimator.animator.myAnimator.resume();
    }

    private void doPaint() {
        for (Map.Entry<JLayeredPane, JComponent> entry : this.myMap.entrySet()) {
            if (!entry.getKey().isShowing()) continue;
            entry.getValue().revalidate();
            entry.getValue().repaint();
        }
    }
}

