/*
 * Decompiled with CFR 0.152.
 */
package com.mallowigi.idea.utils;

import java.awt.Color;
import javax.swing.JComponent;
import javax.swing.Timer;

public final class ColorCycle {
    private final Timer timer;
    private Color[] colors;
    private int index;
    private JComponent component;

    public ColorCycle(int steps, int fps) {
        this.timer = new Timer(1000 / fps, e -> {
            ++this.index;
            if (this.index > steps) {
                this.index = 0;
                this.stop();
            }
            if (this.index != 0) {
                this.component.setBackground(this.colors[this.index - 1]);
                this.component.repaint();
            }
        });
    }

    public JComponent getComponent() {
        return this.component;
    }

    public void setComponent(JComponent component) {
        this.component = component;
    }

    public void start(Color ... colors) {
        this.colors = colors;
        this.timer.start();
    }

    public void stop() {
        this.timer.stop();
    }
}

