/*
 * Decompiled with CFR 0.152.
 */
package com.mallowigi.idea.ui.indicators;

import com.intellij.util.ui.JBUI;
import com.mallowigi.idea.MTConfig;
import com.mallowigi.idea.config.enums.IndicatorStyles;
import com.mallowigi.idea.ui.indicators.MTBorderSelectedTreeIndicator;
import com.mallowigi.idea.ui.indicators.MTDotSelectedTreeIndicator;
import com.mallowigi.idea.ui.indicators.MTNoneSelectedTreeIndicator;
import com.mallowigi.idea.ui.indicators.MTSelectedTreeIndicator;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Insets;
import javax.swing.border.Border;

public class MTSelectedTreePainter
implements Border {
    private MTSelectedTreeIndicator painter = new MTBorderSelectedTreeIndicator();
    private IndicatorStyles indicatorStyle = IndicatorStyles.BORDER;

    public MTSelectedTreePainter() {
        this.setSelectedTreePainter();
    }

    @Override
    public final void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
        this.setSelectedTreePainter();
        this.painter.paintBorder(c, g, x, y, width, height);
    }

    private void setSelectedTreePainter() {
        IndicatorStyles style = MTConfig.getInstance().getIndicatorStyle();
        if (style != this.indicatorStyle) {
            this.indicatorStyle = style;
            switch (style) {
                case NONE: {
                    this.painter = new MTNoneSelectedTreeIndicator();
                    break;
                }
                case DOT: {
                    this.painter = new MTDotSelectedTreeIndicator();
                    break;
                }
                case BORDER: {
                    this.painter = new MTBorderSelectedTreeIndicator();
                }
            }
        }
    }

    @Override
    public final Insets getBorderInsets(Component c) {
        return JBUI.insets((int)0);
    }

    @Override
    public final boolean isBorderOpaque() {
        return false;
    }
}

