/*
 * Decompiled with CFR 0.152.
 */
package com.mallowigi.idea.ui;

import com.intellij.icons.AllIcons;
import com.intellij.ide.ui.laf.darcula.DarculaUIUtil;
import com.intellij.ide.ui.laf.darcula.ui.TextFieldWithPopupHandlerUI;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.util.ui.JBInsets;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.MacUIUtil;
import com.mallowigi.idea.ui.MTTextBorder;
import java.awt.Component;
import java.awt.Container;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.geom.RoundRectangle2D;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.border.Border;
import javax.swing.plaf.ComponentUI;
import javax.swing.text.JTextComponent;
import org.jetbrains.annotations.Nullable;

public final class MTTextFieldUI
extends TextFieldWithPopupHandlerUI {
    public static ComponentUI createUI(JComponent component) {
        return new MTTextFieldUI();
    }

    protected void paintBackground(Graphics g) {
        Graphics2D g2d = (Graphics2D)g;
        JTextComponent component = this.getComponent();
        if (component != null) {
            Border border;
            Container parent = component.getParent();
            if (component.isOpaque() && parent != null) {
                g2d.setColor(parent.getBackground());
                g2d.fillRect(0, 0, component.getWidth(), component.getHeight());
            }
            if ((border = component.getBorder()) instanceof MTTextBorder && !DarculaUIUtil.isTableCellEditor((Component)component)) {
                MTTextFieldUI.paintFieldBackground(g2d, component);
            } else {
                super.paintBackground((Graphics)g2d);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void paintFieldBackground(Graphics2D g, JTextComponent component) {
        Graphics2D g2 = (Graphics2D)g.create();
        Rectangle r = new Rectangle(component.getSize());
        JBInsets.removeFrom((Rectangle)r, (Insets)JBUI.insets((int)1));
        try {
            g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            g2.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, MacUIUtil.USE_QUARTZ ? RenderingHints.VALUE_STROKE_PURE : RenderingHints.VALUE_STROKE_NORMALIZE);
            g2.translate(r.x, r.y);
            if (component.isEnabled() && component.isEditable()) {
                float height = JBUI.scale((int)2);
                float arc = MTTextFieldUI.isSearchField((Component)component) ? JBUIScale.scale((float)6.0f) : 0.0f;
                g2.setColor(component.getBackground());
                g2.fill(new RoundRectangle2D.Float(0.0f, (float)(r.height * 2) - height, r.width * 2, height, arc, arc));
            }
        }
        finally {
            g2.dispose();
        }
    }

    protected Icon getSearchIcon(boolean hovered, boolean clickable) {
        return clickable ? AllIcons.Actions.SearchWithHistory : AllIcons.Actions.Search;
    }

    @Nullable
    protected Icon getClearIcon(boolean hovered, boolean clickable) {
        return !clickable ? null : (hovered ? AllIcons.Actions.CloseHovered : AllIcons.Actions.Close);
    }

    protected void paintSafely(Graphics g) {
        this.paintBackground(g);
        super.paintSafely(g);
    }

    protected Insets getDefaultMargins() {
        JTextComponent component = this.getComponent();
        return DarculaUIUtil.isCompact((Component)component) || DarculaUIUtil.isTableCellEditor((Component)component) ? JBUI.insets((int)0, (int)3) : JBUI.insets((int)2, (int)2);
    }
}

