/*
 * Decompiled with CFR 0.152.
 */
package com.mallowigi.idea.ui;

import com.intellij.openapi.ui.GraphicsConfig;
import com.mallowigi.idea.utils.MTUI;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicTableHeaderUI;
import javax.swing.table.DefaultTableCellRenderer;

public final class MTTableHeaderUI
extends BasicTableHeaderUI {
    public static ComponentUI createUI(JComponent component) {
        return new MTTableHeaderUI();
    }

    @Override
    public void paint(Graphics g, JComponent c) {
        Color borderColor = MTUI.Table.getBorderColor();
        Graphics2D g2d = (Graphics2D)g;
        GraphicsConfig config = new GraphicsConfig((Graphics)g2d);
        Color bg = c.getBackground();
        g2d.setColor(bg);
        int h = c.getHeight();
        int w = c.getWidth();
        g2d.fillRect(0, 0, w, h);
        g2d.setColor(borderColor);
        g2d.drawLine(0, h - 1, w, h - 1);
        config.restore();
        super.paint(g2d, c);
    }

    @Override
    protected void installDefaults() {
        super.installDefaults();
        if (this.header.getDefaultRenderer() instanceof DefaultTableCellRenderer) {
            this.header.setDefaultRenderer(new MTDefaultHeaderRenderer());
        }
        this.header.setFont(this.header.getFont().deriveFont(1));
    }

    private static final class MTDefaultHeaderRenderer
    extends DefaultTableCellRenderer {
        private MTDefaultHeaderRenderer() {
            this.setHorizontalAlignment(2);
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            this.setBorder(MTUI.Table.getCellBorder());
            this.setFont(this.getFont().deriveFont(1));
            return this;
        }
    }
}

