/*
 * Decompiled with CFR 0.152.
 */
package com.mallowigi.idea.ui;

import com.intellij.ide.ui.laf.darcula.ui.DarculaTabbedPaneUI;
import com.intellij.util.ui.JBUI;
import com.mallowigi.idea.MTConfig;
import com.mallowigi.idea.utils.MTUI;
import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.util.Locale;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.plaf.ComponentUI;

public final class MTTabbedPaneUI
extends DarculaTabbedPaneUI {
    private final MTConfig config = MTConfig.getInstance();

    public static ComponentUI createUI(JComponent component) {
        return new MTTabbedPaneUI();
    }

    private static Color getTabForeground(boolean isSelected) {
        return isSelected && MTConfig.getInstance().getSelectedTheme().isDark() ? MTUI.TabbedPane.getSelectedForeground() : MTUI.TabbedPane.getForeground();
    }

    protected void paintTabBorder(Graphics g, int tabPlacement, int tabIndex, int x, int y, int w, int h, boolean isSelected) {
        int highlightThickness = JBUI.scale((int)this.config.getHighlightThickness());
        if (isSelected) {
            g.setColor(this.getIndicatorColor());
            switch (tabPlacement) {
                case 2: {
                    int offset = highlightThickness;
                    g.fillRect(x + w - offset, y, highlightThickness, h);
                    break;
                }
                case 4: {
                    g.fillRect(x, y, highlightThickness, h);
                    break;
                }
                case 3: {
                    g.fillRect(x, y, w, highlightThickness);
                    break;
                }
                default: {
                    int offset = highlightThickness;
                    g.fillRect(x, y + h - offset, w, highlightThickness);
                }
            }
        }
    }

    protected void layoutLabel(int tabPlacement, FontMetrics metrics, int tabIndex, String title, Icon icon, Rectangle tabRect, Rectangle iconRect, Rectangle textRect, boolean isSelected) {
        super.layoutLabel(tabPlacement, metrics, tabIndex, title, icon, tabRect, iconRect, textRect, isSelected);
        try {
            JLabel tabLabel = (JLabel)this.tabPane.getTabComponentAt(tabIndex);
            if (tabLabel == null) {
                return;
            }
            tabLabel.setForeground(MTTabbedPaneUI.getTabForeground(isSelected));
            this.setTabTitle(tabLabel, title);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
    }

    private void setTabTitle(JLabel tabLabel, String title) {
        boolean upperCaseTabs = this.config.isUpperCaseTabs();
        if (upperCaseTabs) {
            String newTitle = title.toUpperCase(Locale.ENGLISH);
            tabLabel.setFont(tabLabel.getFont().deriveFont(1));
            tabLabel.setText(newTitle);
        }
    }

    private Color getIndicatorColor() {
        Color accentColor = MTUI.Panel.getLinkForeground();
        Color customColor = this.config.getHighlightColor();
        if (!this.tabPane.isEnabled()) {
            return JBUI.CurrentTheme.TabbedPane.DISABLED_SELECTED_COLOR;
        }
        return this.config.isHighlightColorEnabled() ? customColor : accentColor;
    }

    protected int calculateTabHeight(int tabPlacement, int tabIndex, int fontHeight) {
        int actualTabHeight = super.calculateTabHeight(tabPlacement, tabIndex, fontHeight);
        if (actualTabHeight == 31) {
            return 31;
        }
        return JBUI.scale((int)(this.config.getTabsHeight() + 6));
    }
}

