/*
 * Decompiled with CFR 0.152.
 */
package com.mallowigi.idea.ui;

import com.intellij.ide.ui.laf.darcula.ui.DarculaSpinnerUI;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.JBValue;
import com.intellij.util.ui.MacUIUtil;
import com.mallowigi.idea.utils.MTUI;
import java.awt.BasicStroke;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.geom.Path2D;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.border.Border;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicArrowButton;

public final class MTSpinnerUI
extends DarculaSpinnerUI {
    public static ComponentUI createUI(JComponent component) {
        return new MTSpinnerUI();
    }

    public void paint(Graphics g, JComponent c) {
        super.paint(g, c);
        Border border = this.spinner.getBorder();
        if (border != null) {
            border.paintBorder(c, g, 0, 0, this.spinner.getWidth(), this.spinner.getHeight());
        }
    }

    protected JButton createButton(int direction, String name) {
        JButton button = this.createArrow(direction);
        button.setName(name);
        button.setBorder(JBUI.Borders.empty((int)0));
        if (direction == 1) {
            this.installNextButtonListeners(button);
        } else {
            this.installPreviousButtonListeners(button);
        }
        return button;
    }

    protected void paintArrowButton(Graphics g, BasicArrowButton button, int direction) {
        int y = direction == 1 ? button.getHeight() - 4 : 4;
        button.paintTriangle(g, (button.getWidth() - 8) / 2 - 1, y, 0, direction, this.spinner.isEnabled());
    }

    private JButton createArrow(int direction) {
        MTSpinnerArrowButton arrowButton = new MTSpinnerArrowButton(direction);
        arrowButton.addMouseListener(new SpinnerButtonHighlightedAdapter(arrowButton));
        arrowButton.setInheritsPopupMenu(true);
        return arrowButton;
    }

    private final class MTSpinnerArrowButton
    extends BasicArrowButton {
        private boolean isHovered;

        MTSpinnerArrowButton(int direction) {
            super(direction);
            this.isHovered = false;
        }

        void setIsHovered(boolean hovered) {
            this.isHovered = hovered;
        }

        @Override
        public void paint(Graphics g) {
            MTSpinnerUI.this.paintArrowButton(g, this, this.direction);
        }

        @Override
        public boolean isOpaque() {
            return false;
        }

        private Shape getInnerShape(float bw) {
            Path2D.Float shape = new Path2D.Float();
            int w = this.getWidth() - JBUI.scale((int)1);
            int h = this.getHeight() - JBUI.scale((int)1);
            switch (this.direction) {
                case 5: {
                    ((Path2D)shape).moveTo(0.0, 0.0);
                    ((Path2D)shape).lineTo((float)w - bw, 0.0);
                    ((Path2D)shape).lineTo((float)w - bw, (float)h - bw);
                    ((Path2D)shape).lineTo(0.0, (float)h - bw);
                    shape.closePath();
                    break;
                }
                case 1: {
                    ((Path2D)shape).moveTo(0.0, bw);
                    ((Path2D)shape).lineTo((float)w - bw, bw);
                    ((Path2D)shape).lineTo((float)w - bw, h);
                    ((Path2D)shape).lineTo(0.0, h);
                    shape.closePath();
                    break;
                }
            }
            return shape;
        }

        private Shape getArrowShape() {
            Path2D.Float arrow = new Path2D.Float();
            int aw = new JBValue.Float(9.0f).get();
            int ah = new JBValue.Float(5.0f).get();
            int bw = JBUI.scale((int)2);
            switch (this.direction) {
                case 5: {
                    this.paintSouthArrow(arrow, aw, ah, bw);
                    break;
                }
                case 1: {
                    this.paintNorthArrow(arrow, aw, ah, bw);
                    break;
                }
            }
            return arrow;
        }

        private void paintNorthArrow(Path2D arrow, int aw, int ah, int bw) {
            arrow.moveTo(0.0, 0.0);
            arrow.lineTo((double)aw / 2.0, -ah);
            arrow.lineTo(aw, 0.0);
            arrow.quadTo(aw, 0.0, aw - bw, 0.0);
            arrow.lineTo((double)aw / 2.0, -ah + bw);
            arrow.lineTo(bw, 0.0);
            arrow.quadTo(bw, 0.0, 0.0, 0.0);
            arrow.closePath();
        }

        private void paintSouthArrow(Path2D arrow, int aw, int ah, int bw) {
            arrow.moveTo(0.0, 0.0);
            arrow.lineTo((double)aw / 2.0, ah);
            arrow.lineTo(aw, 0.0);
            arrow.quadTo(aw, 0.0, aw - bw, 0.0);
            arrow.lineTo((double)aw / 2.0, ah - bw);
            arrow.lineTo(bw, 0.0);
            arrow.quadTo(bw, 0.0, 0.0, 0.0);
            arrow.closePath();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void paintTriangle(Graphics g, int x, int y, int size, int direction, boolean isEnabled) {
            Graphics2D g2 = (Graphics2D)g.create();
            try {
                g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                g2.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, MacUIUtil.USE_QUARTZ ? RenderingHints.VALUE_STROKE_PURE : RenderingHints.VALUE_STROKE_NORMALIZE);
                int bw = JBUI.scale((int)2);
                g2.setColor(MTUI.Spinner.getArrowButtonBackgroundColor(isEnabled, true));
                g2.fill(this.getInnerShape(bw));
                g2.translate(x, y);
                g2.setStroke(new BasicStroke(1.0f, 0, 1));
                g2.setColor(MTUI.Spinner.getArrowButtonForegroundColor(isEnabled, this.isHovered));
                g2.fill(this.getArrowShape());
            }
            finally {
                g2.dispose();
            }
        }
    }

    private static final class SpinnerButtonHighlightedAdapter
    extends MouseAdapter {
        private final MTSpinnerArrowButton arrowButton;

        SpinnerButtonHighlightedAdapter(MTSpinnerArrowButton arrowButton) {
            this.arrowButton = arrowButton;
        }

        @Override
        public void mouseEntered(MouseEvent e) {
            this.arrowButton.setIsHovered(true);
        }

        @Override
        public void mouseExited(MouseEvent e) {
            this.arrowButton.setIsHovered(false);
        }
    }
}

