/*
 * Decompiled with CFR 0.152.
 */
package com.mallowigi.idea.ui;

import com.intellij.openapi.ui.GraphicsConfig;
import com.intellij.util.ui.GraphicsUtil;
import com.intellij.util.ui.JBUI;
import com.mallowigi.idea.utils.MTUI;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Rectangle;
import javax.swing.JComponent;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.metal.MetalLookAndFeel;
import javax.swing.plaf.metal.MetalSliderUI;

public final class MTSliderUI
extends MetalSliderUI {
    private int trackLeft = 0;
    private int trackTop = 0;
    private int trackRight;
    private int trackBottom;
    private int fillTop;
    private int fillLeft;
    private int fillBottom;
    private int fillRight;

    public static ComponentUI createUI(JComponent component) {
        return new MTSliderUI();
    }

    private static boolean isLeftToRight(Component component) {
        return component.getComponentOrientation().isLeftToRight();
    }

    private static void addSliderProperties() {
        UIManager.put("Slider.trackWidth", 7);
        UIManager.put("Slider.majorTickLength", 6);
        UIManager.put("Slider.horizontalThumbIcon", null);
        UIManager.put("Slider.verticalThumbIcon", null);
    }

    @Override
    public void installUI(JComponent c) {
        MTSliderUI.addSliderProperties();
        super.installUI(c);
        this.getTrackCoordinates();
        this.getThumbAndFillCoordinates();
        this.scrollListener.setScrollByBlock(false);
    }

    @Override
    public void paintThumb(Graphics g) {
        Rectangle knobBounds = this.thumbRect;
        GraphicsConfig config = GraphicsUtil.setupAAPainting((Graphics)g);
        g.setColor(MTUI.Slider.getThumbColor());
        g.translate(knobBounds.x, knobBounds.y);
        g.fillOval(0, 0, knobBounds.width, knobBounds.height);
        g.translate(-knobBounds.x, -knobBounds.y);
        config.restore();
    }

    @Override
    public void paintTrack(Graphics g) {
        g.translate(this.trackRect.x, this.trackRect.y);
        this.getTrackCoordinates();
        this.getThumbAndFillCoordinates();
        this.drawTrack(g);
        this.drawFill(g);
        g.translate(-this.trackRect.x, -this.trackRect.y);
    }

    @Override
    protected Dimension getThumbSize() {
        return new Dimension(JBUI.scale((int)16), JBUI.scale((int)16));
    }

    @Override
    public int getTickLength() {
        return 0;
    }

    private void drawFill(Graphics g) {
        if (this.slider.isEnabled()) {
            g.setColor(this.slider.getBackground());
            g.drawLine(this.fillLeft, this.fillTop, this.fillRight, this.fillTop);
            g.drawLine(this.fillLeft, this.fillTop, this.fillLeft, this.fillBottom);
            g.setColor(MTUI.Slider.getThumbColor());
        } else {
            g.setColor(MetalLookAndFeel.getControlShadow());
        }
        g.fillRect(this.fillLeft, this.fillTop, this.fillRight - this.fillLeft, this.fillBottom - this.fillTop);
    }

    private void drawTrack(Graphics g) {
        if (this.slider.isEnabled()) {
            g.setColor(MTUI.Slider.getTrackColor());
        } else {
            g.setColor(MTUI.Slider.getTrackDisabledColor());
        }
        g.fillRect(this.trackLeft, this.trackTop, this.trackRight - this.trackLeft - 1, this.trackBottom - this.trackTop - 1);
    }

    private void getThumbAndFillCoordinates() {
        if (this.slider.getOrientation() == 0) {
            int middleOfThumb = this.thumbRect.x + this.thumbRect.width / 2;
            middleOfThumb -= this.trackRect.x;
            this.fillTop = this.trackTop;
            this.fillBottom = this.trackBottom - 1;
            if (this.drawInverted()) {
                this.fillLeft = middleOfThumb;
                this.fillRight = this.trackRight - 1;
            } else {
                this.fillLeft = this.trackLeft;
                this.fillRight = middleOfThumb;
            }
        } else {
            int middleOfThumb = this.thumbRect.y + this.thumbRect.height / 2;
            middleOfThumb -= this.trackRect.y;
            this.fillLeft = this.trackLeft;
            this.fillRight = this.trackRight - 1;
            if (this.drawInverted()) {
                this.fillTop = this.trackTop;
                this.fillBottom = middleOfThumb;
            } else {
                this.fillTop = middleOfThumb;
                this.fillBottom = this.trackBottom - 1;
            }
        }
    }

    private void getTrackCoordinates() {
        boolean leftToRight = MTSliderUI.isLeftToRight(this.slider);
        if (this.slider.getOrientation() == 0) {
            this.trackBottom = this.trackRect.height - 1 - this.getThumbOverhang();
            this.trackTop = this.trackBottom - (this.getTrackWidth() - 1);
            this.trackRight = this.trackRect.width - 1;
        } else {
            if (leftToRight) {
                this.trackLeft = this.trackRect.width - this.getThumbOverhang() - this.getTrackWidth();
                this.trackRight = this.trackRect.width - this.getThumbOverhang() - 1;
            } else {
                this.trackLeft = this.getThumbOverhang();
                this.trackRight = this.getThumbOverhang() + this.getTrackWidth() - 1;
            }
            this.trackBottom = this.trackRect.height - 1;
        }
    }
}

